<?php
namespace App\Controllers\Admin;
use CodeIgniter\Controller;
use App\Models\BrokerModel;
class Broker extends BaseController
{
    protected $broker_model;
    public function __construct() {
        $this->broker_model = new BrokerModel();
    }
    public function index()
    {
        $data['extra_js'] = array(
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js"
        );
        $data['title'] = 'Broker';
        return $this->dt_ci_template->load("Admin","Broker/BrokerView",$data);
    }

    public function getBrokerListing($return = false ,$filterData = array())
    {
        if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }

        $societyId = $this->session->get('society_id');

        $this->datatables->table(MASTER_DB.".tbl_broker as tb");
        $this->datatables->select("tb.broker_id,tb.broker_address,tb.broker_phone_number,tb.broker_name,tb.is_active");
        $this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by,tb.updated_at");
        $this->datatables->join(MASTER_DB.".tbl_broker_society as tbs","tbs.broker_id = tb.broker_id","left");
        $this->datatables->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = tb.updated_by AND tupdate.society_id = tbs.society_id","left");
        accessFilter($this->datatables, array("society" => "tbs.society_id"));
        $this->datatables->groupBy("tb.broker_id");

        $dataReport =  $this->datatables->generate();
        $dataReport = json_decode($dataReport, true);
        $data       = $dataReport['data'];
        // printArray($data,1);
        if(count($data) > 0){
            foreach($data as $key => $displayData){
                $actionButtonFilter = array(
                    "broker_id" => isset($displayData['broker_id']) ? $displayData['broker_id'] : "",
                );
                $data[$key]['action_button'] = brokerActionButton($actionButtonFilter);
                $data[$key]['updated_at'] = isValidDate($displayData['updated_at']) ? siteDateFormat($displayData['updated_at'],true) : "";
            }
        }
        if($return){
            return $data;
        }else{
            $dataReport['data'] = $data;
            echo json_encode($dataReport);
            exit;
        }
    }

    public function manage($brokerId = '')
	{

		$data['extra_js'] = array(
            "js/jquery.form.min.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
			"js/validate.min.js",
			"js/additional_methods.min.js"
        );

        if ($brokerId != '') {
			$filterData = array(
				"broker_id" => $brokerId
			);
			$data['broker_data'] = $this->broker_model->getBrokerData($filterData);

            $brokerSocietyData = $this->broker_model->getBrokerSocietyData(array(
                'broker_id' => $brokerId,
                'is_multiple' => 1
            ));
            $data['broker_society_data'] = $brokerSocietyData;
		}
		if ($brokerId != '') {
			$data['title'] = 'Edit Broker';
		} else {
			$data['title'] = 'Add Broker';
		}
        if ((isset($data['broker_data']['society_id']) && $data['broker_data']['society_id'] != $this->session->get('society_id'))) {
            return redirect()->to('Admin/Broker');
        }
        $data['select2_ajax'] = view("Admin/CommonMaster/Select2View",  array());
		return $this->dt_ci_template->load("Admin","Broker/BrokerManageView",$data);
	}

    public function save()
	{
		//printArray($_POST,1);
        $this->centralDB->transStart();
        $validation = \Config\Services::validation();
        $brokerId = $this->request->getVar('broker_id');
		$brokerName = $this->request->getVar('broker_name');
		$brokerPhoneNumber = $this->request->getVar('broker_phone_number');
		$brokerAddress = $this->request->getVar('broker_address');
		// $brokerIfscCode = $this->request->getVar('ifsc_code');
		$isActive = $this->request->getVar('is_active');
        $isButtonClick = $this->request->getVar('is_button_click');

        if(empty($brokerId)){
            if($isButtonClick == 0){
                $response['success'] = false;
                $response['msg'] = 'First Click Broker Detail Button';
                echo json_encode($response);
                exit;
            }
        }
            
		if (isset($brokerId) && $brokerId == '') {
            $validation->setRule('broker_phone_number', lang('Broker.broker_phone_number'), 'required|is_unique[tbl_broker.broker_phone_number]',array('is_unique' => 'This {field} Already Exists'));
        } else {
            $validation->setRule('broker_phone_number', lang('Broker.broker_phone_number'), 'required|edit_unique[tbl_broker.broker_phone_number.' . $brokerId . ']',array('edit_unique' => 'This {field} Already Exists'));
        }

        $validation->setRule('broker_name', lang('Broker.broker_name'), 'required');
        $validation->setRule('broker_address', lang('Broker.broker_address'), 'required');
        // $validation->setRule('ifsc_code', lang('Broker.ifsc_code'), 'required');
		

		if (!$validation->withRequest($this->request)->run()) {
			$errors = $validation->getErrors();
            $response['success'] = false;
			$response['msg'] = implode("\n", $errors);
			echo json_encode($response);
			exit;
		} else {
            
            $brokerSocietyData = array();
            if(!empty($brokerId)) {
                $brokerSocietyData = $this->broker_model->getBrokerSocietyData(array(
                    'broker_id' => $brokerId,
                    'is_multiple' => 1
                ));
            }
			$brokerUpdateArray = array();
			$brokerArray = array(
				'broker_id' => $brokerId,
				'broker_name' => $brokerName,
				'broker_phone_number' => $brokerPhoneNumber,
				'broker_address' => $brokerAddress,
				// 'ifsc_code' => $brokerIfscCode,
				'is_active' => isset($isActive) ? 1 : 0,
			);

			if(!empty($brokerId)){
                $brokerUpdateData = $this->broker_model->getBrokerData(array(
                    'broker_id' => $brokerId,
                ));
                $brokerUpdateArray = compareArray($brokerArray,$brokerUpdateData);
            }
			$brokerData = $this->broker_model->insertUpdateRecord($brokerArray, 'broker_id', MASTER_DB.'.tbl_broker', 1,'',array(),array(),$brokerUpdateArray);
			$lastBrokerId = $brokerData['lastInsertedId'];

            $societyIdArray = $this->request->getVar('society_id[]');
            $sessionSocietyId = $this->session->get('society_id');
            if (!is_array($societyIdArray)) {
                $societyIdArray = []; // Initialize as an empty array
            }

            // Check and push sessionSocietyId if not already present
            if (!in_array($sessionSocietyId, $societyIdArray)) {
                $societyIdArray[] = $sessionSocietyId; // Alternative to array_push()
            }

            // if (!in_array($sessionSocietyId, $societyIdArray)) {
            //     array_push($societyIdArray, $sessionSocietyId);
            // }
            if(isset($brokerId) && $brokerId != ''){
                $this->broker_model->deleteSocietyRecord($brokerId);
            }
            if(isset($societyIdArray)&& $societyIdArray != ''){
                $societyForArray = array();
                foreach($societyIdArray as $societyId){
                    $societyForArray[] = array(
                        'broker_society_id' => '',
                        'broker_id' => $lastBrokerId,
                        'society_id' => $societyId,
                        'created_at' => date('Y-m-d H:i:s'),
                        'updated_at' => date('Y-m-d H:i:s'),
                        'created_by' => $this->data['userId'],
                        'updated_by' => $this->data['userId']
                    );
                }
                $brokerSocietyExtraDataArray = array();
                $brokerSocietyExtraDataArray['module_id'] = $lastBrokerId;
                $brokerSocietyExtraDataArray['module'] = 'Broker Society';
                $brokerSocietyExtraDataArray['type'] = 'Broker';
                $brokerSocietyExtraDataArray['old_data'] = $brokerSocietyData;
                $brokerSocietyExtraDataArray['user_id'] = $this->data['userId'];
                $brokerSocietyExtraDataArray['society_id'] = $this->session->get('society_id');

                if(!empty($societyForArray)){
                    $this->broker_model->batchInsert($societyForArray,MASTER_DB.'.tbl_broker_society',$brokerSocietyExtraDataArray);
                }
            }
            $transactionStatus = $this->centralDB->transComplete();
			if (isset($brokerId) && $brokerId != '') {
				if (($brokerData['success']) && ($transactionStatus == 1)) {
					$response['success'] = true;
					$response['msg'] = sprintf(lang('CommonMessage.update_record'),lang('Broker.broker'));
				} else {
					$response['success'] = false;
					$response['msg'] = sprintf(lang('CommonMessage.update_record_error'),lang('Broker.broker'));
				}
			} else {
				if (($brokerData['success']) && ($transactionStatus == 1)) {
					$response['success'] = true;
					$response['msg'] = sprintf(lang('CommonMessage.create_record'),lang('Broker.broker'));
				} else {
					$response['success'] = false;
					$response['msg'] = sprintf(lang('CommonMessage.create_record_error'),lang('Broker.broker'));
				}
			}
			echo json_encode($response);
			exit;
		}
	}
    public function changeStatus()
    {
        $brokerId = $this->request->getVar('broker_id');
        $status = $this->request->getVar('status');

        //$status         = ($status == 0) ? 1 : 0;
        $return = $this->broker_model->statusChange($brokerId,$status,'broker_id','tbl_broker');
        if ($return == 1) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.status_change'),lang('Broker.broker'));
        } else {
            $response['success'] = false;
            $response['msg']     = sprintf(lang('CommonMessage.status_change_error'),lang('Broker.broker'));
        }
        echo json_encode($response);
        exit();
    }


    public function delete()
    {
        $this->db->transStart();
        $brokerId = $this->request->getVar('broker_id');
        $societyId = $this->session->get('society_id');
        $ids = is_array($brokerId) ? implode(',', $brokerId) : $brokerId;
       if( isReferenceInTable( 'broker_id','tbl_rentals', $brokerId,'society_id',$societyId)
       ){
           if(!empty($brokerId)){
               foreach($brokerId as $broker){
                   $deleteDataArray['module'] = 'Broker';
                   $deleteDataArray['activity'] = "Tried to delete Broker ";
                   $deleteDataArray['module_id'] = $broker;
                   logActivity('Tried to delete Broker [BrokerID: ' . $broker . ']',$this->data['userId'],'Broker',$broker,json_encode($deleteDataArray),'','Broker',$broker);
               }
           }

           $response['success'] = false;
           $response['msg'] = lang('CommonMessage.common_delete_record_dependency');
           echo json_encode($response);
           exit;
       }
        $societyId = $this->session->get('society_id');
        $brokerData = $this->broker_model->deleteFromSocietyRecord($brokerId,$societyId);
        $transactionStatus= $this->db->transComplete();
        if (($brokerData) && ($transactionStatus == 1)) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('Broker.broker'));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'),lang('Broker.broker'));
        }
        echo json_encode($response);
        exit;
    }

    public function getBrokerDd(){
        $filterParameter = $this->request->getVar('filter_param');
        $page            = $this->request->getVar('page');
        $brokerId = $this->request->getVar('broker_id');

        $filterData = array(
            'filter_param' => $filterParameter,
            'page' => $page,
            'start' => 0,
            'limit' => DATA_LIMIT,
            'is_active' => 1,
            'broker_id' => $brokerId,

        );
        echo $this->broker_model->getBroker($filterData);
    }

    public function excelExportBroker()
    {
        $fileName ='broker-' . DATETIMEFORMAT;
        $sheetName = 'Broker-' . DATEFORMAT;
        $excelHeaderName = 'Broker';
        $tableData = $this->getBrokerListing(true, $_GET);
        $dataRows = array();
        $dataRows[] = array(
            // lang('Society.society_name'),
            lang('Broker.broker_name'),
            lang('Broker.broker_phone_number'),
            lang('Broker.broker_address'),
            lang('CommonMessage.common_updated_by'),
            lang('CommonMessage.common_updated_at')
        );
        foreach ($tableData as $row) {
            $dataRows[] = array(
                // $row["society_name"],
                $row["broker_name"],
                $row["broker_phone_number"],
                $row["broker_address"],
                // $row["ifsc_code"],
                $row["updated_by"],
                $row["updated_at"]
            );
        }
        $subTotalCellValueArray = [];
        $toColumn = 'E';
        $excelFilterData = array(
            'file_name' => $fileName,
            'sheet_name' => $sheetName,
            'excel_header_name' => $excelHeaderName,
            'data_row' => $dataRows,
            'sub_total_cell_value_array' => $subTotalCellValueArray,
            'to_column' => $toColumn,
            'skip_header' => false,
            'ignore_currency_symbols_sub_total_cell_value_array' => array(),
            'row_cell_currency_format' => array()
        );
        excelExport($excelFilterData);
    }

    public function getBrokerDetail(){
        $validation = \Config\Services::validation();
        $brokerPhoneNumber = $this->request->getVar('broker_phone_number');
        $validation->setRule('broker_phone_number', lang('Broker.broker_phone_number'), 'required');
        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {
            $brokerSocietyData = array();
            $brokerData = $this->broker_model->getBrokerData(array(
                'broker_phone_number' => $brokerPhoneNumber,
            ));

            if(!empty($brokerData)){
                $brokerSocietyData = $this->broker_model->getBrokerSocietyData(array(
                    'broker_id' => $brokerData['broker_id'],
                    'is_multiple' => 1,
                ));
            }
            $response['is_button_click'] = 1;
            if(!empty($brokerData)){
                $response['success'] = true;
                $response['broker_data'] = $brokerData;
                $response['broker_society_data'] = $brokerSocietyData;
                
                
            }
            echo json_encode($response);
            exit;
        }
    }
}
