<?php 
namespace App\Controllers\Admin;

use App\Models\AmenitiesModel;
use CodeIgniter\Controller;
use App\Models\BookingModel;
use App\Models\OwnershipFlatModel;
use App\Models\CommonWebServiceModel;

class Booking extends BaseController
{

	protected $booking_model;
	protected $amenities_model;
	protected $ownership_flat_model;
    public function __construct() {
        $this->booking_model = new BookingModel();
        $this->amenities_model = new AmenitiesModel();
        $this->ownership_flat_model = new OwnershipFlatModel();
        $this->common_web_service_model = new CommonWebServiceModel();
    }
	public function index()
	{

		$data['extra_js'] = array(
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
			"vendor/libs/moment/moment.js",
			"vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.js"
        );
		$data['title'] = 'Booking';
		$dataFilters['filters'] = array(
			array(
				"type" => "multi_select",
				"dynamic" => true,
				"class" => "amenitiesDd",
				"id" => "filter_amenities_id",
				"name" => "filter_amenities_id",
				"title" => "Booking.amenities",
			),
			// array(
			// 	"type" => "multi_select",
			// 	"dynamic" => true,
			// 	"class" => "timeSlotDd",
			// 	"id" => "filter_time_slot_id",
			// 	"name" => "filter_time_slot_id",
			// 	"title" => "Booking.time_slot",
			// ),
			array(
				"type" => "multi_select",
				"dynamic" => true,
				"class" => "flatDd",
				"id" => "filter_flat_id",
				"name" => "filter_flat_id",
				"title" => "Booking.flat",
			),
			
			array(
				"type" => "daterange",
				"id" => "filter_booking_date",
				"name" => "filter_booking_date",
				"title" => "Booking.booking_date",
			),
			array(
				"type" => "daterange",
				"id" => "filter_created_at",
				"name" => "filter_created_at",
				"title" => "CommonMessage.common_created_at",
			),
			array(
				"type" => "daterange",
				"id" => "filter_updated_at",
				"name" => "filter_updated_at",
				"title" => "CommonMessage.common_updated_at",
			),
		);
		$select2Condition = array(
            'isAmenities' => true,
        );
		$data['select2_ajax'] = view("Admin/CommonMaster/Select2View", isset($select2Condition) ? $select2Condition : array());
        $data['advance_filter'] = view('Admin/CommonMaster/FilterModalView', isset($dataFilters) ? $dataFilters : array());
		return $this->dt_ci_template->load("Admin","Booking/BookingView",$data);
	}

	public function manage($bookingId = '')
	{

		$data['extra_js'] = array(
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js"
        );

        if ($bookingId != '') {
			$filterData = array(
				"booking_id" => $bookingId
			);
			$data['booking_data'] = $this->booking_model->getBookingData($filterData);

			if (empty($data['booking_data'])) {
                return redirect()->to('Admin/Booking');
            }
		}
		$select2Condition = array(
            'isAmenities' => true,
        );
		if ($bookingId != '') {
			$data['title'] = 'Edit Booking';
		} else {
			$data['title'] = 'Add Booking';
		}
		$data['select2_ajax'] = view("Admin/CommonMaster/Select2View", isset($select2Condition) ? $select2Condition : array());
        if (isset($data['booking_data']) && !empty($data['booking_data'])){
            $bookingDate = isset($data['booking_data']['booking_date']) ? $data['booking_data']['booking_date'] : "";
            if(strtotime($bookingDate) < strtotime(TODAY_DATE) ){
                if(!$this->dt_ci_acl->checkAccess('Booking|previousEdit')) {
                    return redirect()->to('Admin/Booking');
                }
            }
        }


		if ((isset($data['booking_data']['society_id']) && $data['booking_data']['society_id'] != $this->session->get('society_id'))) {
            return redirect()->to('Admin/Booking');
        }
		return $this->dt_ci_template->load("Admin","Booking/BookingManageView",$data);
	}

    public function getBookingListing($return = false,$filterData=array())
    {
    	if($return == TRUE){
			$filterData['length'] = '';
			$_POST = $filterData;
		}

		$createdAt = $this->request->getVar("filter_created_at");
		$amenitiesId = $this->request->getVar("filter_amenities_id");
		$timeSlotId = $this->request->getVar("filter_time_slot_id");
		$flatId = $this->request->getVar("filter_flat_id");
		$bookingDate = $this->request->getVar("filter_booking_date");
		$updatedAt = $this->request->getVar("filter_updated_at");

       	$this->datatables->table("tbl_booking as tb");
		$this->datatables->select("tb.booking_id,tb.booking_date,tb.is_active,ts.society_name,concat(tt.tower_name,' - ',tf.flat_no) as tower_flat_name, ta.amenities_name,tb.flat_id,tb.status");
		// $this->datatables->select("concat(tb.start_time,' - ',tb.end_time) as time_slot_name");
		$this->datatables->select("concat(DATE_FORMAT(tb.start_time, '%H:%i'), ' - ', DATE_FORMAT(tb.end_time, '%H:%i')) as time_slot_name,tm.name,tau.unit_name");
		$this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by,tb.updated_at,tb.contact_person_name,tb.contact_phone_number");
		$this->datatables->join(MASTER_DB.".tbl_society as ts","ts.society_id = tb.society_id","left");
		$this->datatables->join("tbl_flat as tf","tf.flat_id = tb.flat_id","left");
		$this->datatables->join("tbl_tower as tt","tt.tower_id = tf.tower_id","left");
		$this->datatables->join("tbl_ownership_flat_member as tofm","tofm.ownership_flat_member_id = tb.ownership_flat_member_id","left");
		$this->datatables->join(MASTER_DB.".tbl_member as tm", "tm.member_id = tofm.member_id",  "left");
		$this->datatables->join("tbl_amenities_unit as tau","tau.amenities_unit_id = tb.amenities_unit_id","left");
		$this->datatables->join("tbl_amenities as ta","ta.amenities_id = tb.amenities_id","left");
		$this->datatables->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = tb.updated_by AND tupdate.society_id = tb.society_id","left");
       
		if(isset($flatId)) {
			if(is_array($flatId)){
				$this->datatables->whereIn("tb.flat_id",$flatId);
			} else {
				$this->datatables->where("tb.flat_id",$flatId);
			}
		}

		if(isset($amenitiesId)) {
			if(is_array($amenitiesId)){
				$this->datatables->whereIn("tb.amenities_id",$amenitiesId);
			} else {
				$this->datatables->where("tb.amenities_id",$amenitiesId);
			}
		}

		if(isset($timeSlotId)) {
			if(is_array($timeSlotId)){
				$this->datatables->whereIn("tb.time_slot_id",$timeSlotId);
			} else {
				$this->datatables->where("tb.time_slot_id",$timeSlotId);
			}
		}

		if($bookingDate != ''){
			list($fromDate,$toDate) = explode(" - ",$bookingDate);
			$fromDate = DMYToYMD($fromDate);
			$toDate = DMYToYMD($toDate);
			if(strtotime($fromDate) != strtotime($toDate)){
				$this->datatables->where("date_format(tb.booking_date,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
				$this->datatables->where("date_format(tb.booking_date,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
			} else {
				$this->datatables->where("date_format(tb.booking_date,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
			}
		}

		if($createdAt != ''){
			list($fromDate,$toDate) = explode(" - ",$createdAt);
			$fromDate = DMYToYMD($fromDate);
			$toDate = DMYToYMD($toDate);
			if(strtotime($fromDate) != strtotime($toDate)){
				$this->datatables->where("date_format(tb.created_at,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
				$this->datatables->where("date_format(tb.created_at,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
			} else {
				$this->datatables->where("date_format(tb.created_at,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
			}
		}

		if($updatedAt != ''){
			list($fromDate,$toDate) = explode(" - ",$updatedAt);
			$fromDate = DMYToYMD($fromDate);
			$toDate = DMYToYMD($toDate);
			if(strtotime($fromDate) != strtotime($toDate)){
				$this->datatables->where("date_format(tb.updated_at,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
				$this->datatables->where("date_format(tb.updated_at,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
			} else {
				$this->datatables->where("date_format(tb.updated_at,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
			}
		}

		$this->datatables->groupBy("tb.booking_id");
		accessFilter($this->datatables, array("society" => "tb.society_id"));
		$dataReport =  $this->datatables->generate();
		$dataReport = json_decode($dataReport, true);
		$data       = $dataReport['data'];
		if(count($data) > 0){
			foreach($data as $key => $displayData){
				$actionButtonFilter = array(
					"booking_id" => isset($displayData['booking_id']) ? $displayData['booking_id'] : "",
					"booking_date" => isset($displayData['booking_date']) ? $displayData['booking_date'] : "",
					"status" => isset($displayData['status']) ? $displayData['status'] : "",
				);
				$data[$key]['action_button'] = bookingActionButton($actionButtonFilter);
				$approvedButtonFilter = array(
                    "button_id" => isset($displayData['booking_id']) ? $displayData['booking_id'] : "",
                    "form_submit" => isset($displayData['status']) ? $displayData['status'] : "",
                    "permission_label" => 'Booking',
                    "permission_name" => $this->dt_ci_acl->checkAccess("Booking|submitForm"),
                    // "unapproved_permission_name" => $this->dt_ci_acl->checkAccess("Booking|unapprove"),
                    // "view_unapproved_button" => 0,
                    "approved_module" => "booking",

                );
                $data[$key]['approved_button'] = approvedButton($approvedButtonFilter);
				$data[$key]['booking_date'] = siteDateFormat($displayData['booking_date']);
				$data[$key]['updated_at'] = isValidDate($displayData['updated_at']) ? siteDateFormat($displayData['updated_at'],true) : "";
				$data[$key]['excel_flat_no'] = isset($displayData['tower_flat_name']) ?  $displayData['tower_flat_name'] : "";
				$data[$key]['tower_flat_name'] = isset($displayData['tower_flat_name']) ?  flatDocumentToHtml($displayData['tower_flat_name'],$displayData['flat_id']) : "";
			}
		}

		if($return){
			return $data;
		}else{
			$dataReport['data'] = $data;
			echo json_encode($dataReport);
			exit;
		}
        
    }

    public function changeStatus(){
        $bookingId = $this->request->getVar('booking_id');
        $status = $this->request->getVar('status');
        $return = $this->booking_model->statusChange($bookingId,$status,'booking_id','tbl_booking');
		if ($return == 1) {
			$response['success'] = true;
			$response['msg']     = sprintf(lang('CommonMessage.status_change'),lang('Booking.booking'));
		} else {
			$response['success'] = false;
			$response['msg']     = sprintf(lang('CommonMessage.status_change_error'),lang('Booking.booking'));
		}
		echo json_encode($response);
		exit;
    }

    public function save()
	{
		$this->db->transStart();
		$validation = \Config\Services::validation();
		$bookingId = $this->request->getVar('booking_id');
		$bookingDate = $this->request->getVar('booking_date');
		// $flatId = $this->request->getVar('flat_id');
		$ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');
		$amenitiesId = $this->request->getVar('amenities_id');
		$amenitiesUnitId = $this->request->getVar('amenities_unit_id');
		$timeSlot = $this->request->getVar('time_slots');

		$validation->setRule('booking_date', lang('Booking.booking_date'), 'required');
		$validation->setRule('ownership_flat_member_id', lang('Booking.member'), 'required');
		$validation->setRule('amenities_id', lang('Booking.amenities'), 'required');
		$validation->setRule('amenities_unit_id', lang('Booking.amenities_unit'), 'required');
		$validation->setRule('time_slots', lang('Booking.time_slot'), 'required');
		if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {
			$timeSlotArray = explode(' - ', $timeSlot); // Splits time slot by ' - '
        	$startTime = $timeSlotArray[0]; // Start time
        	$endTime = $timeSlotArray[1]; 

			// printArray($startTime);
			// printArray($endTime,1);

			$amenitiesData = $this->amenities_model->getAmenitiesData(array(
			'amenities_id' => $amenitiesId
			));

			if(!empty($amenitiesData)){
                if(isset($amenitiesData['admin_approval_required']) && $amenitiesData['admin_approval_required'] != 0){
                    $adminApprovalRequired = 1;
                } else {
                    $adminApprovalRequired = 0;
                }
            }

			$dbFlatId = 0;
			$getOwnershipFlatMemberData = $this->ownership_flat_model->getOwnershipFlatMemberData(array('ownership_flat_member_id' => $ownershipFlatMemberId, 'is_show_all_member' => 1,'is_active' => 1));
			$dbFlatId = isset($getOwnershipFlatMemberData['flat_id']) ? $getOwnershipFlatMemberData['flat_id'] : 0;
			$bookingDateFilter = array(
				'booking_date' => DMYToYMD($bookingDate),
				'amenities_id' => $amenitiesId,
				'start_time' => $startTime,
				'end_time' => $endTime,
				'booking_id_not' => $bookingId,
				'amenities_unit_id' => $amenitiesUnitId,
				'society_id' =>$this->session->get('society_id'),
				'is_api' => 1,
				'is_multiple' => 1
			);
			$bookingAmenitiesData = $this->booking_model->getBookingData($bookingDateFilter);
			// lastQuery();
			// printArray($bookingAmenitiesData,1);
			if (!empty($bookingAmenitiesData)) {
				foreach ($bookingAmenitiesData as $key => $bookingAmenities) {
					if($bookingAmenities['cancel_by'] == 0){
						$response['success'] = false;
						$response['msg'] = 'Amenities ' . $bookingAmenities['amenities_name'] . lang('Booking.amenities_already_booked_for_this_time_slot');
						echo json_encode($response);
						exit;
					}
				}
			}
			$isPaymentRequired = 0;
			$taxId = 0;
			$taxRate = 0;
			$amenitiesData = $this->amenities_model->getAmenitiesData(array('amenities_id' => $amenitiesId));
			if (!empty($amenitiesData)) {
				$isPaymentRequired = isset($amenitiesData['payment_required']) ? $amenitiesData['payment_required'] : 0;
				$taxId = isset($amenitiesData['tax_id']) ? $amenitiesData['tax_id'] : 0;
				$taxRate = isset($amenitiesData['tax_rate']) ? $amenitiesData['tax_rate'] : 0;
			}
			$unitPrice = 0;
			$amenitiesBookingSlotUnitPriceId = 0;
			$getAmenitiesBookingSlotUnitPriceData = $this->amenities_model->getAmenitiesBookingSlotUnitPriceData(array('amenities_id' => $amenitiesId, 'unit_id' => $amenitiesUnitId));
			if (!empty($getAmenitiesBookingSlotUnitPriceData)) {
				$unitPrice = isset($getAmenitiesBookingSlotUnitPriceData['price']) ? $getAmenitiesBookingSlotUnitPriceData['price'] : 0;
				$amenitiesBookingSlotUnitPriceId = isset($getAmenitiesBookingSlotUnitPriceData['amenities_booking_slot_unit_price_id']) ? $getAmenitiesBookingSlotUnitPriceData['amenities_booking_slot_unit_price_id'] : 0;
			}
			$amount = 0;
			if ($unitPrice != 0) {
				$unitTaxAmount = $unitPrice * $taxRate / 100;
				$amount = $unitPrice + roundNumber($unitTaxAmount, 2);
			}
			$bookingUpdateArray = array();
            $bookingArray = array(
                'booking_id' => $bookingId,
                'amenities_unit_id' => $amenitiesUnitId,
                'booking_date' => DMYToYMD($bookingDate),
                'amenities_id' => $amenitiesId,
                'start_time' => $startTime,
                'end_time' => $endTime,
                'flat_id' => $dbFlatId,
                'ownership_flat_member_id' => $ownershipFlatMemberId,
                'amenities_booking_slot_unit_price_id' => $amenitiesBookingSlotUnitPriceId,
                'unit_price' => $unitPrice,
                'tax_id' => $taxId,
                'amount' => $amount,
                // 'status' => $adminApprovalRequired != 0,
                'society_id' =>$this->session->get('society_id'),
                'is_active' => 1,
            );

			if($adminApprovalRequired == 0){
                $bookingArray['status'] = 'confirmed';   
            } else {
                $bookingArray['status'] = 'pending';
            }

			if(!empty($bookingId)){
                $bookingUpdateData = $this->booking_model->getBookingData(array(
                    'booking_id' => $bookingId,
                ));
                $bookingUpdateArray = compareArray($bookingArray,$bookingUpdateData);
            }
			$bookingData = $this->booking_model->insertUpdateRecord($bookingArray, 'booking_id', 'tbl_booking', 1,'',array(),array(),$bookingUpdateArray);
			$lastBookingId = $bookingData['lastInsertedId'];
			$transactionStatus = $this->db->transComplete();
			if (isset($bookingId) && $bookingId != '') {
				if (($bookingData['success']) && ($transactionStatus == 1)) {
					$response['success'] = true;
					$response['msg'] = sprintf(lang('CommonMessage.update_record'), lang("Booking.booking"));
				} else {
					$response['success'] = false;
					$response['msg'] = sprintf(lang('CommonMessage.update_record_error'), lang("Booking.booking"));
				}
			} else {
				if (($bookingData['success']) && ($transactionStatus == 1)) {
					if (($bookingId == '') && ($adminApprovalRequired == 1)) {
		                $memberIdArray = array();
		                $notificationDataArray = array();
		                $resourceTypeData = $this->resource_type_model->getResourceTypeData(array(
			                'resource_type_name' => RESOURCE_TYPE_MANAGER,
			                'society_id' => $this->session->get('society_id'),
			            ));
			            if(!empty($resourceTypeData)){
			                $userManagerData = $this->common_web_service_model->getUserSocietyData(array(
			                    'society_id' => $this->session->get('society_id'),
			                    'resource_type_id' => $resourceTypeData['resource_type_id'],
			                    'is_active' => 1,
			                    'is_multiple' => 1
			                ));
			                // printArray($userManagerData,1);
			                $userDeviceUserIdArray = [];
			                $userDeviceUserTypeIdArray = [];
			                $userDeviceUserTypeArray = [];
			                if (!empty($userManagerData)) {
			                    foreach ($userManagerData as $userManagerElement) {
			                        $userDeviceUserIdArray[] = isset($userManagerElement['user_society_id']) ? $userManagerElement['user_society_id'] : 0;
			                    }
			                    $userDevice = $this->common_web_service_model->deviceData(array(
			                        "user_society_id" => $userDeviceUserIdArray,
			                        "user_type" => MANAGER_APP,
			                        "is_latest" => 1,
			                        "is_multiple" => 1
			                    ));
			                    if (!empty($userDevice)) {
			                        foreach ($userDevice as $userDeviceElement) {
			                            if ($userDeviceElement['one_signal_id'] != '' && $userDeviceElement['player_id'] != '') {
			                                $notificationArray = array(
			                                    'ownership_flat_id' => 0,
			                                    'ownership_flat_member_id' => $ownershipFlatMemberId,
			                                    'type' => 'amenities',
			                                    'status' => 'amenities',
			                                    'type_id' => $lastBookingId,
			                                    'user_id' => $this->data['userId'],
			                                    'member_name' => $getOwnershipFlatMemberData['name'],
			                                    'society_id' => $this->session->get('society_id'),
			                                    'notification_title' => 'New Amenities Booking',
			                                    'description' => 'A new amenities booking has been registered by '.$getOwnershipFlatMemberData['name'].' regarding ',
			                                    'module' => 'amenities',
			                                    'action_type' => 'send',
			                                    'device_type' => isset($userDeviceElement['device_type']) ? strtolower($userDeviceElement['device_type']) : '',
			                                    'notification_for' => isset($userDeviceElement['device_type']) ? strtolower($userDeviceElement['device_type']) : '',
			                                    'one_signal_id' => isset($userDeviceElement['one_signal_id']) ? $userDeviceElement['one_signal_id'] : '',
			                                    'player_id' => isset($userDeviceElement['player_id']) ? $userDeviceElement['player_id'] : '',
			                                    // 'app_url' => MEMBER_URL .'ticket_detail_page/' . $lastBookingId,
			                                );
		                                    $notificationArray['send_for_notification'] = 'manager';
		                                    $notificationArray['send_for_notification_id'] = $this->data['userId'];
		                                    $notificationArray['receive_for_notification'] = isset($userDeviceElement['user_type']) ? $userDeviceElement['user_type'] : '';
		                                    $notificationArray['receive_for_notification_id'] = isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0;
			                                $notificationArray['extra_data_json'] = json_encode($notificationArray);
			                                array_push($notificationDataArray, $notificationArray);
			                            }
			                        }
			                    }
			                }
			                if (isset($notificationDataArray) && !empty($notificationDataArray)) {
			                    sendNotificationComplainAndroid($notificationDataArray);
			                }
			            }
		            }
					$response['success'] = true;
					$response['msg'] = sprintf(lang('CommonMessage.create_record'), lang("Booking.booking"));
				} else {
					$response['success'] = false;
					$response['msg'] = sprintf(lang('CommonMessage.create_record_error'), lang("Booking.booking"));
				}
			}
			echo json_encode($response);
			exit;
		}
	}

    public function delete()
    {
    	$this->db->transStart();
        $bookingId = $this->request->getVar('booking_id');


        $bookingData = $this->booking_model->getBookingData(array("booking_id" => $bookingId,'is_multiple' => 1));

        if(!empty($bookingData)){
            $bookingNumber = array();
            foreach ($bookingData as $bookingElement){
                $bookingDate = isset($bookingElement['booking_date']) ? $bookingElement['booking_date']: '';
                $towerFlatName = isset($bookingElement['tower_flat_name']) ? $bookingElement['tower_flat_name']: '';
                if(strtotime($bookingDate) < strtotime(TODAY_DATE) ){
                    if(!$this->dt_ci_acl->checkAccess('Booking|previousDelete')){
                        $bookingNumber[]= $towerFlatName.' - ' .YMDToDMY($bookingDate);
                    }

                }
            }
        }
        if(!empty($bookingNumber)){
            $flatNo = implode(",", $bookingNumber);
            $response['success'] = false;
            $response['msg'] = 'Flat '. $flatNo . "  Previous Record Booking Not Deleted." ;
            echo json_encode($response);
            exit;
        }
        $bookingData = $this->booking_model->deleteRecord($bookingId);
        $transactionStatus = $this->db->transComplete();
        if (($bookingData) && ($transactionStatus == 1)) {
            $response['success'] = true;
            $response['msg'] = sprintf(lang('CommonMessage.delete_record'), lang("Booking.booking"));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'), lang("Booking.booking"));
        }
        echo json_encode($response);
        exit;
    }

    public function getBookingDd(){
        $filterParameter = $this->request->getVar('filter_param');
        $page = $this->request->getVar('page');
        $bookingId = $this->request->getVar('booking_id');
        $filterData = array(
            'booking_id' => $bookingId,
            'filter_param' => $filterParameter,
            'page' => $page,
            'start' => 0,
            'limit' => DATA_LIMIT
        );

        echo $this->booking_model->getBooking($filterData);
    }

    public function view($id = null)
	{
		$bookingId = $this->request->getVar("view_id");
		if($bookingId == "" && $bookingId == null){
            return redirect()->to('Admin/Booking');
		}
		else {
			$id = $bookingId;
			$filterData = array(
				"booking_id" => $bookingId
			);
			$data['booking_data'] = $this->booking_model->getBookingData($filterData);
			$bookingView = view("Admin/Booking/BookingModelView", $data);
			$response['view_title'] = "Booking Details";
			$response['view_detail'] = $bookingView;
			$response['success'] = true;
			echo json_encode($response);
		}
	}

	public function excelExportBooking()
	{
		$fileName ='booking-' . DATETIMEFORMAT;
		$sheetName = 'Booking-' . DATEFORMAT;
		$excelHeaderName = 'Booking';
		$tableData = $this->getBookingListing(true, $_GET);
		$dataRows = array();
		$dataRows[] = array(
			// lang('Booking.society'),
			lang('Booking.amenities'),
			lang('Booking.flat'),
			lang('Booking.amenities_unit'),
			lang('Booking.booking_date'),
			lang('Booking.time_slot'),
			lang('Booking.status'),
			lang('Booking.booked_by'),
			lang('CommonMessage.common_updated_by'),
			lang('CommonMessage.common_updated_at')
		);
		foreach ($tableData as $row) {
			$dataRows[] = array(
				// $row["society_name"],
				$row["amenities_name"],
				$row["excel_flat_no"],
				$row["unit_name"],
				$row["booking_date"],
				$row["time_slot_name"],
				$row["status"],
				$row["name"],
				$row["updated_by"],
				$row["updated_at"]
			);
		}
		$subTotalCellValueArray = [];
		$toColumn = 'I';
		$excelFilterData = array(
			'file_name' => $fileName,
			'sheet_name' => $sheetName,
			'excel_header_name' => $excelHeaderName,
			'data_row' => $dataRows,
			'sub_total_cell_value_array' => $subTotalCellValueArray,
			'to_column' => $toColumn,
			'skip_header' => false,
			'ignore_currency_symbols_sub_total_cell_value_array' => array(),
			'row_cell_currency_format' => array()
		);
		excelExport($excelFilterData);
	}

	public function submitForm()
    {
        $bookingId = $this->request->getVar('booking_id');
        $formStatus = $this->request->getVar('form_status');
        $this->db->transStart();

        if ($formStatus == 'confirmed' || $formStatus == 'cancelled') {
            $bookingDataArray = $this->booking_model->getBookingData(array(
                'booking_id' => $bookingId,
                'is_multiple' => 1
            ));

            $bookingArray = array();

            foreach ($bookingDataArray as $bookingData) {

                if (isset($bookingData['form_submit']) && ($bookingData['form_submit'] == $formStatus)) {
                    $response['success'] = false;
                    $response['msg'] = sprintf(lang('CommonMessage.status_change_error'), lang('Event.booking'));
                    echo json_encode($response);
                    exit;
                }

                $bookingArray[] = array(
                    'booking_id' => $bookingData['booking_id'],
                    'status' => $formStatus,
                    'approved_by' => $this->data['userId'],
                    'approved_at' => DATE_TIME_DATABASE,
                    'updated_by' => $this->data['userId'],
                    'updated_at' => DATE_TIME_DATABASE
                );
            }
        }

        if ($formStatus == 'pending') {

            $bookingDataArray = $this->booking_model->getBookingData(array(
                'booking_id' => $bookingId,
                'is_multiple' => 1
            ));

            foreach ($bookingDataArray as $bookingData) {
				
                if (isset($bookingData['form_submit']) && ($bookingData['form_submit'] == $formStatus)) {
                    $response['success'] = false;
                    $response['msg'] = sprintf(lang('CommonMessage.status_change_error'), lang('Event.booking'));
                    echo json_encode($response);
                    exit;
                }

                $bookingArray[] = array(
                    'booking_id' => $bookingData['booking_id'],
                    'status' => $formStatus,
                    'unapproved_by' => $this->data['userId'],
                    'unapproved_at' => DATE_TIME_DATABASE,
                    'updated_by' => $this->data['userId'],
                    'updated_at' => DATE_TIME_DATABASE
                );

            }
        }


        $bookingResponse = $this->booking_model->batchUpdate($bookingArray, 'booking_id', 'tbl_booking');
        $transactionStatus = $this->db->transComplete();
        if ((isset($bookingResponse['success']) && $bookingResponse['success']) && ($transactionStatus == 1)) {
            $response['title'] = lang('CommonMessage.common_success');
            $response['msg'] = lang('CommonMessage.booking_approved_success');
            $response['success'] = true;
        } else {
            $response['title'] = lang('common_error');
            $response['success'] = false;
            $response['msg'] = lang('common_approved_error');
        }
        echo json_encode($response);
    }

	public function getAmenitiesTimeSlot() {
		// printArray($_POST,1);
		$validation = \Config\Services::validation();
		// $data['row_number'] = $this->request->getVar("row_number");
		$amenitiesId = $this->request->getVar('amenities_id');
		$bookingDate = $this->request->getVar('booking_date');
		
		// Validation rules
		$validation->setRule('amenities_id', lang('EventBooking.amenities_id'), 'required',array("required" => lang('EventBooking.amenities_id')." Is Required"));

		// Validate the input
		if (!$validation->withRequest($this->request)->run()) {
			$errors = $validation->getErrors();
			$response['success'] = false;
			$response['msg'] = implode("\n", $errors);
			echo json_encode($response);
			exit;
		} else {
			$amenitiesBookingSlotData = $this->amenities_model->getAmenitiesBookingSlotData(array('amenities_id' => $amenitiesId,'is_multiple' => 1));
			$isToday = (date('Y-m-d') === date('Y-m-d', strtotime($bookingDate)));
			$timeSlotsArray = [];
			if (!empty($amenitiesBookingSlotData)) {
                foreach ($amenitiesBookingSlotData as $absKey => $amenitiesBookingSlots) {
                    $startTime = $amenitiesBookingSlots['start_time'] ?? ''; // 'HH:mm' format
                    $endTime = $amenitiesBookingSlots['end_time'] ?? ''; // 'HH:mm' format
                    $hours = $amenitiesBookingSlots['hour'] ?? 1; // slot duration in hours
                    $minutes = $amenitiesBookingSlots['minutes'] ?? 0; // slot duration in minutes
                    $currentTime = date('H:i'); // current real time in 'HH:mm'
                    $currentTimestamp = strtotime($currentTime); // current real time as a timestamp
                    $timeSlots = [];
                    $startTimestamp = strtotime($startTime);
                    $endTimestamp = strtotime($endTime);
                    $interval = ($hours * 3600) + ($minutes * 60); // slot interval in seconds
                    if ($isToday) {
                        $current = max($currentTimestamp, $startTimestamp);
                        $roundedCurrent = ceil(($current - $startTimestamp) / $interval) * $interval + $startTimestamp;
                        $current = max($startTimestamp, $roundedCurrent); // Use rounded start time
                    } else {
                        $current = $startTimestamp; // If not today, start from the beginning
                    }
                    while ($current < $endTimestamp) {
                        $slotStartTimestamp = $current;
                        $slotEndTimestamp = $current + $interval;
                        if ($slotEndTimestamp > $endTimestamp) {
                            $slotEndTimestamp = $endTimestamp;
                        }
                        $slotStart = date('H:i', $slotStartTimestamp);
                        $slotEnd = date('H:i', $slotEndTimestamp);
                        $timeSlots[] = $slotStart . ' - ' . $slotEnd; // add the time slot to the array
                        $current += $interval;
                    }
					$timeSlotsArray = array_merge($timeSlotsArray, $timeSlots);
                    $amenitiesBookingSlotData[$absKey]['time_slots'] = $timeSlots;
                    $amenitiesBookingSlotData[$absKey]['booking_slot_timings'] = date('h:i A', strtotime($amenitiesBookingSlots['start_time'])) . ' - ' . date('h:i A', strtotime($amenitiesBookingSlots['end_time']));
                }
            }
			// printArray($amenitiesBookingSlotData);
			// printArray($timeSlotsArray,1);

			// $totalPayment = ($adultRate * (int) $totalAdult) + ($childRate * (int) $totalChild) + ($guestRate * (int) $totalGuest);
			// // printArray($adultRate);
			// // printArray($childRate);
			// // printArray($guestRate);
			// // printArray($totalPayment,1);
			$response['success'] = true;
			$response['time_slots_array'] = $timeSlotsArray;
			echo json_encode($response);
			exit;
		}
	}

	public function cancelBooking()
	{
		// printArray($_POST,1);
		$validation = \Config\Services::validation();
		$this->db->transStart();
		$bookingIdArray    = $this->request->getVar('booking_id');

		// $validation->setRule('modal_complain_id', lang('Complain.complain_id'), 'required');
		// $validation->setRule('status_id', lang('Complain.status'), 'required');
		// $validation->setRule('remarks', lang('Complain.remarks'), 'required');
		
		// if (!$validation->withRequest($this->request)->run()) {
        //     $errors = $validation->getErrors();
        //     $response['success'] = false;
        //     $response['msg'] = implode("\n", $errors);
        //     echo json_encode($response);
        //     exit;
        // } else {

			// $eventBookingIdArray = explode(',', $modalEventBookingId);

			if (!empty($bookingIdArray)) {
				foreach($bookingIdArray as $bookingId){
					$bookingData = $this->booking_model->getBookingData(array('booking_id' => $bookingId,
                	'society_id' => $this->session->get('society_id')));

					$dbBookingStatus = '';
            		$dbStartTime = '';
            		$dbEndTime = '';
            		if (!empty($bookingData)) {
            		    $dbBookingStatus = isset($bookingData['status']) ? $bookingData['status'] : '';
            		    $dbStartTime = isset($bookingData['start_time']) ? $bookingData['start_time'] : '';
            		    $dbEndTime = isset($bookingData['end_time']) ? $bookingData['end_time'] : '';
            		    $paymentRequired = isset($bookingData['payment_required']) ? $bookingData['payment_required'] : '';
            		    if ($dbBookingStatus == 'cancelled') {
							$response['success'] = false;
        					$response['msg'] = 'Booking Status Already Cancelled';
        					echo json_encode($response);
        					exit;
            		    }
            		    $currentDateTime = strtotime(date('Y-m-d H:i:s')); // Current date and time as a timestamp
            		    $bookingDateTime = strtotime($bookingData['booking_date'] . ' ' . $dbStartTime); // Booking date and start time as a timestamp
            		    // printArray($bookingDateTime,1);
            		    if ($currentDateTime >= $bookingDateTime) {
							$response['success'] = false;
        					$response['msg'] = 'Sorry, this booking has already started and cannot be cancelled.';
        					echo json_encode($response);
        					exit;
            		    }
            		    if (isset($paymentRequired) && $paymentRequired != 0) {
            		        $cancelBefore = isset($bookingData['cancel_before']) ? (int)$bookingData['cancel_before'] : 0;
            		        $cancelBeforeType = isset($bookingData['cancel_before_type']) ? $bookingData['cancel_before_type'] : '';
            		        if ($cancelBeforeType === 'minutes') {
            		            $adjustedBookingTime = $bookingDateTime - ($cancelBefore * 60);
            		        } elseif ($cancelBeforeType === 'hours') {
            		            $adjustedBookingTime = $bookingDateTime - ($cancelBefore * 3600);
            		        }
            		        // printArray($adjustedBookingTime,1);
            		        if ($currentDateTime > $adjustedBookingTime) {
								$response['success'] = false;
        						$response['msg'] = 'Cancellations Must Be Made Atleast '. $cancelBefore .' '. $cancelBeforeType .' ago';
        						echo json_encode($response);
        						exit;
            		        }
            		    }
            		}

					$bookingUpdateArray = array();
            		$bookingArray = array(
            		    'booking_id' => $bookingId,
            		    'status' => 'cancelled',
            		    'cancel_at' => date('Y-m-d H:i:s'),
            		    'cancel_by' => $this->data['userId'],
            		);
            		if(!empty($bookingId)){
						$bookingUpdateData = $this->booking_model->getBookingData(array(
							'booking_id' => $bookingId,
						));
						$bookingUpdateArray = compareArray($bookingArray,$bookingUpdateData);
					}
					$bookingData = $this->booking_model->insertUpdateRecord($bookingArray, 'booking_id', 'tbl_booking', 1,'',array(),array(),$bookingUpdateArray);

				}	
			}
			$transactionStatus = $this->db->transComplete();
			if (($bookingData['success']) && ($transactionStatus == 1)) {
				$response['success']  = true;
				$response['msg']      = "Event Booking Cancelled Successfully";
			} else {
				$response['success']  = false;
				$response['msg']      = "Event Booking Cancel Error!";
			}
			echo json_encode($response);
			exit();
		// }
	}
}
