<?php
namespace App\Controllers\Admin;
use CodeIgniter\Controller;
use App\Models\AmenitiesModel;
use App\Models\CommonWebServiceModel;
use App\Models\ResourceTypeModel;
use App\Models\OwnershipFlatModel;
class Amenities extends BaseController
{
    protected $amenities_model;
    public function __construct() {
        $this->amenities_model = new AmenitiesModel();
        $this->common_web_service_model = new CommonWebServiceModel();
        $this->ownership_flat_model = new OwnershipFlatModel();
        $this->resource_type_model = new ResourceTypeModel();
    }
    public function index()
    {
        $data['extra_js'] = array(
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
            "vendor/libs/moment/moment.js",
            "vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.js"
        );
        $data['title'] = 'Amenities';
        $dataFilters['filters'] = array(
            array(
                "type" => "multi_select",
                "dynamic" => true,
                "class" => "commonAreaDd",
                "id" => "filter_common_area_id",
                "name" => "filter_common_area_id",
                "title" => "Amenities.common_area",
            ),
            // array(
            //     "type" => "amenities_status",
            //     "id" => "filter_amenities_status",
            //     "name" => "filter_amenities_status",
            //     "title" => "Amenities.amenities_status",
            // ),
            array(
                "type" => "daterange",
                "id" => "filter_created_at",
                "name" => "filter_created_at",
                "title" => "CommonMessage.common_created_at",
            ),
            array(
                "type" => "daterange",
                "id" => "filter_updated_at",
                "name" => "filter_updated_at",
                "title" => "CommonMessage.common_updated_at",
            ),
        );
        $data['select2_ajax'] = view("Admin/CommonMaster/Select2View",  array());
        $data['amenities_reject_resaon_modal_view'] = view('Admin/Amenities/RejectReasonModalView',array());
        $data['advance_filter'] = view('Admin/CommonMaster/FilterModalView', isset($dataFilters) ? $dataFilters : array());
       // $data['amenities_modal_view'] = view('Admin/Amenities/AmenitiesModalView', $data);
        return $this->dt_ci_template->load("Admin","Amenities/AmenitiesView",$data);
    }

    public function manage($amenitiesId = '',$view = '')
    {

        $data['extra_js'] = array(
            "js/jquery.form.min.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/bootstrap-datepicker/bootstrap-datepicker.js",
            "vendor/libs/flatpickr/flatpickr.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
            "vendor/libs/jquery-timepicker/jquery-timepicker.js",
            "vendor/libs/moment/moment.js",
            "vendor/libs/ckeditor/ckeditor_classic.js",
        );

        if ($amenitiesId != '') {
            $filterData = array(
                "amenities_id" => $amenitiesId
            );
            $data['amenities_data'] = $this->amenities_model->getAmenitiesData($filterData);

            $amenitiesUnitData = $this->amenities_model->getAmenitiesUnitData(array(
                "amenities_id" => $amenitiesId,
                'is_multiple' => 1
            ));
            $data['amenities_unit_data'] = $amenitiesUnitData;

            $amenitiesBookingSlotData = $this->amenities_model->getAmenitiesBookingSlotData(array(
                "amenities_id" => $amenitiesId,
                'is_multiple' => 1,
                'is_deleted' => 0,
            ));

            $amenitiesBookingSlotDayData =  $this->amenities_model->getAmenitiesBookingSlotDayData(array(
                "amenities_id" => $amenitiesId,
                'is_multiple' => 1,
            ));
            $absdDataBookingSlotIdWise = array();
            if(!empty($amenitiesBookingSlotDayData)){
                foreach ($amenitiesBookingSlotDayData as $resourceFlatWorkingDayElement){
                    $absdDataBookingSlotIdWise[$resourceFlatWorkingDayElement['amenities_booking_slot_id']][] = $resourceFlatWorkingDayElement;
                }
            }
            
            if(!empty($amenitiesBookingSlotData)){
                foreach ($amenitiesBookingSlotData as $rfKey => $resourceFlatElement){
                    //$amenitiesBookingSlotData[$rfKey]['unit_payment_json'] = json_encode($unitPaymentArray,true);
                    $amenitiesBookingSlotData[$rfKey]['day_data'] = !empty($absdDataBookingSlotIdWise) && array_key_exists($resourceFlatElement['amenities_booking_slot_id'],$absdDataBookingSlotIdWise) ? $absdDataBookingSlotIdWise[$resourceFlatElement['amenities_booking_slot_id']]: array();
                }
            }
            $data['amenities_booking_slot_data'] = $amenitiesBookingSlotData;

            $data['common_area_data'] = $this->amenities_model->getAmenitiesCommonAreaData(array(
                'amenities_id' => $amenitiesId,
                'is_multiple' => 1
            ));

            if (empty($data['amenities_data'])) {
                return redirect()->to('Admin/Amenities');
            }
        }
        if ($amenitiesId != '') {
            $data['title'] = 'Edit Amenities';
        } else {
            $data['title'] = 'Add Amenities';
        }
        if ((isset($data['amenities_data']['society_id']) && $data['amenities_data']['society_id'] != $this->session->get('society_id'))) {
            return redirect()->to('Admin/Amenities');
        }

        $data['amenities_data']['view'] = (isset($view) && $view != '' ? 1 : 0);
        $data['amenities_unit_table'] = view('Admin/Amenities/AmenitiesUnitView', isset($data) ? $data : array());
        $data['payment_modal_view'] = view('Admin/Amenities/AmenitiesUnitPaymentModalView', isset($data) ? $data : array());
        $data['amenities_booking_slot_table'] = view('Admin/Amenities/AmenitiesBookingSlotView', isset($data) ? $data : array());
        
        $data['select2_ajax'] = view("Admin/CommonMaster/Select2View", isset($select2Ajax)? $select2Ajax : array());
        // printArray($data,1);
        $this->dt_ci_template->load("Admin","Amenities/AmenitiesManageView",$data);
    }

    public function getAmenitiesListing($return = false ,$filterData = array())
    {
        if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }

        // printArray($filterData,1);
        $commonAreaId = $this->request->getVar("filter_common_area_id");
        $createdAt = $this->request->getVar("filter_created_at");
        $updatedAt = $this->request->getVar("filter_updated_at");

        $societyId = $this->session->get('society_id');

        $this->datatables->table("tbl_amenities as ta");
        $this->datatables->select("ta.amenities_id, ta.from_hour,ta.to_hour ,ta.amenities_name, ta.is_active, tsoc.society_name,ta.total_quantity,ta.society_id");
        $this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by,ta.updated_at,GROUP_CONCAT(tcm.common_area_name SEPARATOR ',') as common_area_name,GROUP_CONCAT(tcm.common_area_id SEPARATOR ',') as common_area_id");
        $this->datatables->join("tbl_amenities_common_area as tacm","tacm.amenities_id = ta.amenities_id","left");
        $this->datatables->join("tbl_common_area as tcm","tcm.common_area_id = tacm.common_area_id","left");
        $this->datatables->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = ta.updated_by AND tupdate.society_id = ta.society_id","left");
        $this->datatables->join(MASTER_DB.".tbl_society as tsoc","tsoc.society_id = ta.society_id","left");
        accessFilter($this->datatables, array("society" => "ta.society_id"));
        
        
        if(isset($societyId) && !empty($societyId)) {
            if (is_array($societyId)) {
                $this->datatables->whereIn('ta.society_id', $societyId);
            } else {
                $this->datatables->where('ta.society_id', $societyId);
            }
        }

        if(isset($commonAreaId)) {
            if(is_array($commonAreaId)){
                $this->datatables->whereIn("tacm.common_area_id",$commonAreaId);
            } else {
                $this->datatables->where("tacm.common_area_id",$commonAreaId);
            }
        }

        if($createdAt != ''){
            list($fromDate,$toDate) = explode(" - ",$createdAt);
            $fromDate = DMYToYMD($fromDate);
            $toDate = DMYToYMD($toDate);
            if(strtotime($fromDate) != strtotime($toDate)){
                $this->datatables->where("date_format(ta.created_at,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
                $this->datatables->where("date_format(ta.created_at,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
            } else {
                $this->datatables->where("date_format(ta.created_at,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
            }
        }
        if($updatedAt != ''){
            list($fromDate,$toDate) = explode(" - ",$updatedAt);
            $fromDate = DMYToYMD($fromDate);
            $toDate = DMYToYMD($toDate);
            if(strtotime($fromDate) != strtotime($toDate)){
                $this->datatables->where("date_format(ta.updated_at,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
                $this->datatables->where("date_format(ta.updated_at,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
            } else {
                $this->datatables->where("date_format(ta.updated_at,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
            }
        }

        $this->datatables->groupBy("ta.amenities_id");

        $dataReport =  $this->datatables->generate();
        $dataReport = json_decode($dataReport, true);
        $data       = $dataReport['data'];
        if(count($data) > 0){
            foreach($data as $key => $displayData){
                $actionButtonFilter = array(
                    "amenities_id" => isset($displayData['amenities_id']) ? $displayData['amenities_id'] : "",
                );
                $data[$key]['action_button'] = amenitiesActionButton($actionButtonFilter);

                $fromHour = isset($displayData['from_hour']) ? $displayData['from_hour']: '';
                $toHour = isset($displayData['to_hour']) ? $displayData['to_hour']: '';

                $data[$key]['from_and_to_hours'] = date('g:i A', strtotime($fromHour)) ." - ".date('g:i A', strtotime($toHour));

                // $data[$key]['display_type'] = underscoreToUcWord($displayData['type']);
            }
        }
        if($return){
            return $data;
        }else{
            $dataReport['data'] = $data;
            echo json_encode($dataReport);
            exit;
        }
    }
    public function save()
    {
        $this->db->transStart();
        $validation = \Config\Services::validation();

        $amenitiesId = $this->request->getVar('amenities_id');
        $amenitiesName = $this->request->getVar('amenities_name');
        $isActive = $this->request->getVar('is_active');
        $paymentRequired = $this->request->getVar('payment_required');
        $adminApprovalRequired = $this->request->getVar('admin_approval_required');
        $bookingAllowed = $this->request->getVar('booking_allowed');
        // $type = $this->request->getVar('type');
        $totalQuantiity = $this->request->getVar('total_quantity');
        $shortDescription = $this->request->getVar('short_description');
        $maxAdvanceBooking = $this->request->getVar('max_advance_booking');
        $maxBookingPerSlot = $this->request->getVar('max_booking_per_slot');
        $dayType = $this->request->getVar('day_type');
        $fromHour = $this->request->getVar('from_hour');
        $toHour = $this->request->getVar('to_hour');
        $longDescription = $this->request->getVar('long_description');
        $rulesAndRegulations = $this->request->getVar('rules_and_regulations');
        $cancelBefore = $this->request->getVar('cancel_before');
        $cancelBeforeType = $this->request->getVar('cancel_before_type');
        $payBefore = $this->request->getVar('pay_before');
        $payBeforeType = $this->request->getVar('pay_before_type');
        $contactPersonName = $this->request->getVar('contact_person_name');
        $contactPersonNumber = $this->request->getVar('contact_phone_number');
        $taxId = $this->request->getVar('tax_id');
        $deleteAmenitiesUnitId = $this->request->getVar('delete_amenities_unit_id');

        if (isset($amenitiesId) && $amenitiesId == '') {
            $validation->setRule('amenities_name', lang('Amenities.amenities_name'), 'required|combination_unique[tbl_amenities.amenities_name.'.$this->session->get('society_id').'.]',array('combination_unique' => 'This {field} Already Exists'));
        } else {
            $validation->setRule('amenities_name', lang('Amenities.amenities_name'), 'required|edit_unique[tbl_amenities.amenities_name.' . $amenitiesId . '.'. $this->session->get('society_id').']',array('edit_unique' => 'This {field} Already Exists'));
        }

        // $validation->setRule('type', lang('Amenities.type'), 'required');
        $validation->setRule('total_quantity', lang('Amenities.total_quantity'), 'required');

        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {

            if(isset($paymentRequired)){
                if($cancelBeforeType == 'minutes'){
                    if ($cancelBefore > 60 || $cancelBefore < 0) {
                        $response['success'] = false;
                        $response['msg'] = "Cancel Before Should Be Between 0 to 60";
                        echo json_encode($response);
                        exit;
                    }
                }
                // if($cancelBeforeType == 'hours'){
                //     if ($cancelBefore > 12 || $cancelBefore < 1) {
                //         $response['success'] = false;
                //         $response['msg'] = "Cancel Before Should Be Between 1 to 12";
                //         echo json_encode($response);
                //         exit;
                //     }
                // }
                if($payBeforeType == 'minutes'){
                    if ($payBefore > 60 || $payBefore < 0) {
                        $response['success'] = false;
                        $response['msg'] = "Pay Before Should Be Between 0 to 60";
                        echo json_encode($response);
                        exit;
                    }
                }
                // if($payBeforeType == 'hours'){
                //     if ($payBefore > 12 || $payBefore < 1) {
                //         $response['success'] = false;
                //         $response['msg'] = "Pay Before Should Be Between 1 to 12";
                //         echo json_encode($response);
                //         exit;
                //     }
                // }
            }
            
            $fromHourTimeStamp = strtotime($fromHour);
            $toHourTimeStamp = strtotime($toHour);
    
            // Explicit validation: Out-Time should not be less than In-Time unless crossing midnight
            if ($toHourTimeStamp <= $fromHourTimeStamp) {
                $response['success'] = false;
                $response['msg'] = "To-hour Can/t Be Earlier Than Or Equal To From-hour ";
                echo json_encode($response);
                exit;
            }

            $amenitiesBookingSlotIdArray = $this->request->getVar('amenities_booking_slot_id');
            $startTimeArray = $this->request->getVar('start_time');
            $endTimeArray = $this->request->getVar('end_time');
            $hourArray = $this->request->getVar('hour');
            $minutesArray = $this->request->getVar('minutes');
            $dayArray = $this->request->getVar('day');
            $unitPriceJsonArray = $this->request->getVar('unit_price_json');

            if (!empty($amenitiesBookingSlotIdArray)) {
                $dayWiseTimeSlots = [];  // Store time slots grouped by working days
            
                foreach ($amenitiesBookingSlotIdArray as $abskey => $amenitiesBookingSlotId) {
                    $startTime = array_key_exists($abskey, $startTimeArray) ? $startTimeArray[$abskey] : '';
                    $endTime = array_key_exists($abskey, $endTimeArray) ? $endTimeArray[$abskey] : '';
                    $dayData = array_key_exists($abskey, $dayArray) ? $dayArray[$abskey] : array();
            
                    $startTimeStamp = strtotime($startTime);
                    $endTimeStamp = strtotime($endTime);
                    $fromHourTimeStamp = strtotime($fromHour);
                    $toHourTimeStamp = strtotime($toHour);

                    // Adjust end time if it crosses midnight
                    if ($endTimeStamp < $startTimeStamp) {
                        $endTimeStamp += 24 * 60 * 60;  // Add 24 hours to end time
                    }
            
                    // Adjust toHour for comparison if it is 12:00 AM and the end time crosses midnight
                    if ($toHourTimeStamp < $fromHourTimeStamp) {
                        $toHourTimeStamp += 24 * 60 * 60;
                    }
            
                    // Ensure start time and end time fall within the fromHour-toHour range
                    if ($startTimeStamp < $fromHourTimeStamp || $endTimeStamp > $toHourTimeStamp) {
                        $response['success'] = false;
                        $response['msg'] = "Start-Time and End-Time must be between From Hour and To Hour at Row: " . ($abskey);
                        echo json_encode($response);
                        exit;
                    }
            
                    if ($endTimeStamp <= $startTimeStamp) {
                        $response['success'] = false;
                        $response['msg'] = "Start-Time can't be earlier than or equal to End-Time at Row : " . ($abskey);
                        echo json_encode($response);
                        exit;
                    }
            
                    foreach ($dayData as $day) {
                        if (!isset($dayWiseTimeSlots[$day])) {
                            $dayWiseTimeSlots[$day] = [];
                        }
            
                        if ($day == 'everyday' && (count($dayData) > 1)) {
                            $response['success'] = false;
                            $response['msg'] = "Please Only Select 'Everyday' At Row " . ($abskey);
                            echo json_encode($response);
                            exit;
                        }
            
                        // Check for overlap with existing time slots on the same working day
                        foreach ($dayWiseTimeSlots[$day] as $slot) {
                            list($existingInTime, $existingOutTime) = explode('-', $slot);
                            $existingInTimeStamp = strtotime($existingInTime);
                            $existingOutTimeStamp = strtotime($existingOutTime);
            
                            // Adjust existing Out-Time if it crosses midnight
                            if ($existingOutTimeStamp < $existingInTimeStamp) {
                                $existingOutTimeStamp += 24 * 60 * 60;
                            }
            
                            if (($startTimeStamp < $existingOutTimeStamp) && ($endTimeStamp > $existingInTimeStamp)) {
                                $response['success'] = false;
                                $response['msg'] = "Time slot overlaps on working day at Row " . ($abskey) . " with another entry.";
                                echo json_encode($response);
                                exit;
                            }
                        }
            
                        $dayWiseTimeSlots[$day][] = $startTime . '-' . $endTime;
                    }
                }
            }            

            $unitPriceValidationArr = array(); // Store validation messages

            if(isset($paymentRequired)){
                // Loop through each booking slot
                foreach ($amenitiesBookingSlotIdArray as $abskey => $amenitiesBookingSlotId) {

                    // Retrieve corresponding payment information for the current booking slot
                    $unitPriceJson = isset($unitPriceJsonArray[$abskey]) ? $unitPriceJsonArray[$abskey] : '';

                    // Decode the payment information JSON
                    $unitPrice = json_decode($unitPriceJson, true);
                    
                    if (!empty($unitPrice)) {
                        // Loop through each payment unit for this booking slot
                        foreach ($unitPrice as $priceKey => $priceElement) {

                            // Get unit name and price from the decoded JSON
                            $unitName = isset($priceElement['unit_name']) ? $priceElement['unit_name'] : '';
                            $unitPriceValue = isset($priceElement['unit_price']) ? $priceElement['unit_price'] : '';

                            // Validate unit name
                            if ($unitName == '') {
                                $unitPriceValidationArr[] = lang('Amenities.unit_price_line') . ' ' . ($priceKey + 1) . ' ' . lang('Amenities.required') .' for Booking Slot Row ' . ($abskey);
                            }

                            // Validate unit price
                            if ($unitPriceValue == 0 || $unitPriceValue == '') {
                                $unitPriceValidationArr[] = lang('Amenities.unit_price_line') . ' ' . ($priceKey + 1) . ' ' . lang('Amenities.required') .' for Booking Slot Row ' . ($abskey);
                            }
                        }
                    } else {
                        // Handle the case where payment info is missing entirely for a slot
                        $unitPriceValidationArr[] = lang('Amenities.unit_price') . ' for Booking Slot Row ' . ($abskey);
                    }
                }
            }
            if (!empty($unitPriceValidationArr)) {
                $response['success'] = false;
                $response['msg'] = implode("\n", $unitPriceValidationArr);
                echo json_encode($response);
                exit();
            }


            

            $dbAmenitiesUnitIdArray = array();
            $oldAmenitiesUnitData = array();
            if(!empty($amenitiesId)) {
                $oldAmenitiesUnitData = $this->amenities_model->getAmenitiesUnitData(array(
                    'amenities_id' => $amenitiesId,
                    'is_multiple' => 1
                ));
            }

            $amenitiesUnitIdArray = $this->request->getVar('amenities_unit_id');
            $unitNameArray = $this->request->getVar('unit_name');

            // Normalize the unit names to lowercase for case-insensitive comparison
            $normalizedUnitNames = array_map('strtolower', $unitNameArray);
            // Count occurrences of each unit name
            $unitNameCount = array_count_values($normalizedUnitNames);

            foreach ($amenitiesUnitIdArray as $fkey => $amenitiesUnitId) {
                if(!empty($amenitiesUnitId)){
                    array_push($dbAmenitiesUnitIdArray,$amenitiesUnitId);
                }
                $unitName = array_key_exists($fkey, $unitNameArray) ? $unitNameArray[$fkey] : '';

                if ($unitName && $unitNameCount[strtolower($unitName)] > 1) {
                    // If duplicate, return an error message
                    $response['success'] = false;
                    $response['msg'] = 'Unit Name Can\t Be Same';
                    echo json_encode($response);
                    exit();
                }
            }

            $oldCommonAreaData = array();
            if(!empty($amenitiesId)) {
                $oldCommonAreaData = $this->amenities_model->getAmenitiesCommonAreaData(array(
                    'amenities_id' => $amenitiesId,
                    'is_multiple' => 1
                ));
            }


            if(!empty($deleteAmenitiesUnitId )){
                $deleteAmenitiesUnitIdArray = explode(",",$deleteAmenitiesUnitId);
                $checkAmenitiesUnitIdData = array_intersect($dbAmenitiesUnitIdArray,$deleteAmenitiesUnitIdArray);

                if(!empty($checkAmenitiesUnitIdData)){
                    $response['success'] = false;
                    $response['msg'] = "Delete Amenities Unit Some Error!";
                    echo json_encode($response);
                    exit();
                }

                $amenitiesUnitData = $this->amenities_model->getAmenitiesUnitData(array(
                    'amenities_id' => $amenitiesId,
                    "amenities_unit_id" => $deleteAmenitiesUnitIdArray,
                    "is_multiple" => 1
                ));

                if(count($deleteAmenitiesUnitIdArray) != count($amenitiesUnitData)){
                    $response['success'] = false;
                    $response['msg'] = "Delete Amenities Unit Miss Match Id";
                    echo json_encode($response);
                    exit();
                }

                if(!empty($deleteAmenitiesUnitIdArray)){
                     $this->amenities_model->deleteAmenitiesUnitRecord($deleteAmenitiesUnitIdArray);
                }
            }


            $amenitiesUpdateArray = array();
            $amenitiesArray = array(
                'amenities_id' => $amenitiesId,
                'amenities_name' => $amenitiesName,
                'society_id' => $this->session->get('society_id'),
                'is_active' => isset($isActive) ? 1 : 0,
                'payment_required' => isset($paymentRequired) ? 1 : 0,
                'admin_approval_required' => isset($adminApprovalRequired) ? 1 : 0,
                'booking_allowed' => isset($bookingAllowed) ? 1 : 0,
                // 'type' => $type,
                'total_quantity' => $totalQuantiity,
                'short_description' => $shortDescription,
                'max_advance_booking' => $maxAdvanceBooking,
                'max_booking_per_slot' => $maxBookingPerSlot,
                'day_type' => $dayType,
                'from_hour' => date("H:i:s", strtotime($fromHour)),
                'to_hour' => date("H:i:s", strtotime($toHour)),
                'long_description' => $longDescription,
                'rules_and_regulations' => $rulesAndRegulations,
                'cancel_before' => $cancelBefore,
                'cancel_before_type' => $cancelBeforeType,
                'pay_before' => $payBefore,
                'pay_before_type' => $payBeforeType,
                'contact_person_name' => $contactPersonName,
                'contact_phone_number' => $contactPersonNumber,
                'tax_id' => $taxId,
            );
            if(isset($paymentRequired)){
                $amenitiesArray['cancel_before'] =  $cancelBefore;
                $amenitiesArray['cancel_before_type'] = $cancelBeforeType;
                $amenitiesArray['pay_before'] = $payBefore;
                $amenitiesArray['pay_before_type'] = $payBeforeType;
                $amenitiesArray['tax_id'] = $taxId;
            }
            else {
                $amenitiesArray['cancel_before'] =  '';
                $amenitiesArray['cancel_before_type'] = '';
                $amenitiesArray['pay_before'] = '';
                $amenitiesArray['pay_before_type'] = '';
                $amenitiesArray['tax_id'] = '';
            }
            // printArray($amenitiesArray,1);

            if(!empty($amenitiesId)){
                $amenitiesUpdateData = $this->amenities_model->getAmenitiesData(array(
                    'amenities_id' => $amenitiesId,
                ));
                $amenitiesUpdateArray = compareArray($amenitiesArray,$amenitiesUpdateData);
            }

            $amenitiesData = $this->amenities_model->insertUpdateRecord($amenitiesArray,'amenities_id','tbl_amenities', 1,'',array(),array(),$amenitiesUpdateArray);
            $lastAmenitiesId = $amenitiesData['lastInsertedId'];

            $commonAreaIdArray = $this->request->getVar('common_area_id[]');
             if(isset($amenitiesId) && $amenitiesId != ''){
                $this->amenities_model->deleteCommonAreaRecord($amenitiesId);
            }
            if(isset($commonAreaIdArray)&& $commonAreaIdArray != ''){
                $commonAreaArray = array();
                foreach($commonAreaIdArray as $commonAreaId){
                    $commonAreaArray[] = array(
                        'amenities_common_area_id' => '',
                        'amenities_id' => $lastAmenitiesId,
                        'common_area_id' => $commonAreaId,
                        'created_at' => date('Y-m-d H:i:s'),
                        'updated_at' => date('Y-m-d H:i:s'),
                        'created_by' => $this->data['userId'],
                        'updated_by' => $this->data['userId']
                    );
                }
                //printArray($documentForArray);

                $amenitiesCommonAreaExtraDataArray = array();
                $amenitiesCommonAreaExtraDataArray['module_id'] = $lastAmenitiesId;
                $amenitiesCommonAreaExtraDataArray['module'] = 'Amenities Common Area';
                $amenitiesCommonAreaExtraDataArray['type'] = 'Amenities';
                $amenitiesCommonAreaExtraDataArray['old_data'] = $oldCommonAreaData;
                $amenitiesCommonAreaExtraDataArray['user_id'] = $this->data['userId'];
                $amenitiesCommonAreaExtraDataArray['society_id'] = $this->session->get('society_id');

                if(!empty($commonAreaArray)){
                    $this->amenities_model->batchInsert($commonAreaArray,'tbl_amenities_common_area',$amenitiesCommonAreaExtraDataArray);
                }
            }

            if (!empty($amenitiesUnitIdArray)) {
                // if(!empty($amenitiesId)){
                //     $this->amenities_model->deleteAmenitiesUnit($amenitiesId);
                //     $deleteDataArray['module'] = 'Amenities Unit';
                //     $deleteDataArray['activity'] = "Amenities Unit Deleted";
                //     $deleteDataArray['module_id'] = $amenitiesId;
                //     logActivity('Edit Record To Amenities Unit Deleted [AmenitiesId: ' . $amenitiesId . ']',$this->data['userId'],'Amenities Unit',$amenitiesId,json_encode($deleteDataArray),'','Amenities',$amenitiesId);
                // }
                foreach ($amenitiesUnitIdArray as $fkey => $amenitiesUnitId) {
                    $unitName = array_key_exists($fkey, $unitNameArray) ? $unitNameArray[$fkey] : '';

                        $unitInsertUpdateArray = array(
                            'amenities_unit_id' => $amenitiesUnitId,
                            'amenities_id' => $lastAmenitiesId,
                            'unit_name' => $unitName,
                            'created_by' => $this->data['userId'],
                            'updated_by' => $this->data['userId'],
                            'created_at' => date("Y-m-d H:i:s"),
                            'updated_at' => date("Y-m-d H:i:s"),
                        );

                        $amenitiesUnitInsertUpdateData = $this->amenities_model->insertUpdateRecord($unitInsertUpdateArray, 'amenities_unit_id', 'tbl_amenities_unit', 1,'',array(),array());
                        $lastAmenitiesUnitId = $amenitiesUnitInsertUpdateData['lastInsertedId'];
                }
                // $itemExtraDataArray = array();
                // $itemExtraDataArray['module_id'] = $lastAmenitiesId;
                // $itemExtraDataArray['module'] = 'Amenities Unit';
                // $itemExtraDataArray['type'] = 'Amenities';
                // $itemExtraDataArray['old_data'] = $oldAmenitiesUnitData;
                // $itemExtraDataArray['user_id'] = $this->data['userId'];
                // $itemExtraDataArray['society_id'] = $this->session->get('society_id');

                // if (!empty($itemInsertArray)) {
                //     $this->amenities_model->batchInsert($itemInsertArray, 'tbl_amenities_unit',$itemExtraDataArray);
                // }

                $amenitiesUnitData = $this->amenities_model->getAmenitiesUnitData(array(
                    "amenities_id" => $amenitiesId,
                    'is_multiple' => 1
                ));


                $amenitiesUnitDataUnitNameWise = array();
                if(!empty($amenitiesUnitData)){
                    foreach($amenitiesUnitData as $amenitiesUnitElement){
                        $amenitiesUnitDataUnitNameWise[$amenitiesUnitElement['unit_name']] = $amenitiesUnitElement;
                    }
                }

                if (!empty($amenitiesBookingSlotIdArray)) {
                    if(isset($amenitiesId) && $amenitiesId != ''){
                        $this->amenities_model->deleteAmenitiesBookingSlotUnitPrice($amenitiesId,$this->data['userId']);
                        $this->amenities_model->deleteAmenitiesBookingSlotDay($amenitiesId);
                    }

                    foreach ($amenitiesBookingSlotIdArray as $fkey => $amenitiesBookingSlotId) {
                        $startTime = array_key_exists($fkey, $startTimeArray) ? $startTimeArray[$fkey] : '';
                        $endTime = array_key_exists($fkey, $endTimeArray) ? $endTimeArray[$fkey] : '';
                        $dayData = array_key_exists($fkey, $dayArray) ? $dayArray[$fkey] : array();
                        
                        $hour = array_key_exists($fkey, $hourArray) ? $hourArray[$fkey] : '';
                        $minutes = array_key_exists($fkey, $minutesArray) ? $minutesArray[$fkey] : '';

                        $unitPriceJson = array_key_exists($fkey, $unitPriceJsonArray) ? $unitPriceJsonArray[$fkey] : '[]';

                        $amenitiesBookingSlotInsertUpdateArray = array(
                            'amenities_booking_slot_id' => $amenitiesBookingSlotId,
                            'amenities_id' => $lastAmenitiesId,
                            'start_time' => date("H:i:s", strtotime($startTime)),
                            'end_time' => date("H:i:s", strtotime($endTime)),
                            'unit_price_json' => $unitPriceJson,
                            'hour' => $hour,
                            'minutes' => $minutes,
                        );
    
                        // printArray($amenitiesBookingSlotInsertUpdateArray,1);
                        $amenitiesBookiSlotData = $this->amenities_model->insertUpdateRecord($amenitiesBookingSlotInsertUpdateArray, 'amenities_booking_slot_id', 'tbl_amenities_booking_slot', 1,'',array(),array());
                        $lastAmenitiesBookingSlotId = $amenitiesBookiSlotData['lastInsertedId'];

                        if ($unitPriceJson != '') {
                            $unitPrice = json_decode($unitPriceJson, true);
                            foreach ($unitPrice as $priceElement) {
                                $unitName = isset($priceElement['unit_name']) ? $priceElement['unit_name'] : '';
                                $unitId = array_key_exists($unitName,$amenitiesUnitDataUnitNameWise) ? $amenitiesUnitDataUnitNameWise[$unitName]['amenities_unit_id']: 0;

                                $unitPriceInsertUpdateArray = array(
                                    'amenities_booking_slot_unit_price_id' => '',
                                    'amenities_id' => $lastAmenitiesId,
                                    'amenities_booking_slot_id' => $lastAmenitiesBookingSlotId,
                                    'unit_id' => $unitId,
                                    'unit_name' => $unitName,
                                    'price' => isset($priceElement['unit_price']) ? $priceElement['unit_price'] : 0,
                                    'created_by' => $this->data['userId'],
                                    'updated_by' => $this->data['userId'],
                                    'created_at' => date("Y-m-d H:i:s"),
                                    'updated_at' => date("Y-m-d H:i:s"),
                                );
                                $this->amenities_model->insertUpdate($unitPriceInsertUpdateArray, 'amenities_booking_slot_unit_price_id', 'tbl_amenities_booking_slot_unit_price', 1);
                            }
                        }


                        foreach ($dayData as $dayElement) {
                            $amenitiesBookingSlotDayInsertUpdateArray = array(
                                'amenities_booking_slot_day_id' => '',
                                'amenities_id' => $lastAmenitiesId,
                                'amenities_booking_slot_id' => $lastAmenitiesBookingSlotId,
                                'day' => $dayElement,
                                'created_by' => $this->data['userId'],
                                'updated_by' => $this->data['userId'],
                                'created_at' => date("Y-m-d H:i:s"),
                                'updated_at' => date("Y-m-d H:i:s"),
                            );
                            $this->amenities_model->insertUpdate($amenitiesBookingSlotDayInsertUpdateArray, 'amenities_booking_slot_day_id', 'tbl_amenities_booking_slot_day', 1);
                        }
                    }
                }
            }
            $transactionStatus = $this->db->transComplete();
            if (isset($amenitiesId) && $amenitiesId != '') {
                if (($amenitiesData['success']) && ($transactionStatus == 1)) {
                    $response['success']    = true;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record'),lang('Amenities.amenities'));
                } else {
                    $response['success']    = false;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record_error'),lang('Amenities.amenities'));
                }
            } else {
                if (($amenitiesData['success']) && ($transactionStatus == 1)) {
                    if(!isset($paymentRequired)){
                        $memberIdArray = array();
                        $userSocietyIdArray = array();
                        $customerDataArray = array();
                        $batchNotificationDataArray = array();
                        $notificationArray = array(
                            'notification_title' => 'New Amenities Added',
                            'description' => 'A new Amenities name '.$amenitiesName.' has been published by the management. Please check the app to read the full details.',
                        );
                        $playerIdArray = array();
                        $iosPlayerIdArray = array();
                        $customerData['title_name'] = isset($notificationArray['notification_title']) ? $notificationArray['notification_title'] : "";
                        $customerData['description'] = isset($notificationArray['description']) ? $notificationArray['description'] : "";
                        $resourceTypeData = $this->resource_type_model->getResourceTypeData(array(
                            'resource_type_name' => RESOURCE_TYPE_MEMBER,
                            'society_id' => $this->session->get('society_id'),
                        ));
                        $ownershipFlatMemberData = $this->ownership_flat_model->getOwnershipFlatMemberData(array(
                            'society_id' => $this->session->get('society_id'),
                            'is_active' => 1,
                            'is_multiple' => 1
                        ));
                        if(!empty($ownershipFlatMemberData)){
                            foreach ($ownershipFlatMemberData as $ownershipFlatMember) {
                                $memberIdArray[] = $ownershipFlatMember['member_id'];
                            }
                        }
                        if(!empty($memberIdArray)){
                            $userSocietyData = $this->common_web_service_model->getUserSocietyData(array(
                                "type_id" => $memberIdArray,
                                "resource_type_id" => $resourceTypeData['resource_type_id'],
                                'society_id' => $this->session->get('society_id'),
                                'is_multiple' => 1
                            ));
                            if(!empty($userSocietyData)){
                                foreach ($userSocietyData as $userElement) {
                                    $userSocietyIdArray[] = $userElement['user_society_id'];
                                }
                            }
                            if(!empty($userSocietyIdArray)){
                                $userDeviceArray = $this->common_web_service_model->deviceData(array(
                                    "user_society_id" => $userSocietyIdArray,
                                    'user_type' => MEMBER_APP,
                                    "is_latest" => 1,
                                    "is_multiple" => 1,
                                ));
                            }
                            if(!empty($userDeviceArray)){
                                foreach($userDeviceArray as $userDevice){
                                    $notificationOtherArray = array(
                                        'notification_id' => '',
                                        'society_id' => $this->session->get('society_id'),
                                        'notification_date' => TODAY_DATE_YMD,
                                        'notification_for' => (isset($userDevice['device_type'])) ? strtolower($userDevice['device_type']) : "",
                                        'type' => 'amenities',
                                        'type_id' => $lastAmenitiesId,
                                        // 'module' => 'poll',
                                        'created_by' => $this->data['userId'],
                                        'updated_by' => $this->data['userId'],
                                        'created_at' => date("Y-m-d H:i:s"),
                                        'updated_at' => date("Y-m-d H:i:s"),
                                    );
                                    $notificationOtherArray['send_for_notification'] = 'manager';
                                    $notificationOtherArray['send_for_notification_id'] = $this->data['userId'];
                                    $notificationOtherArray['receive_for_notification'] = $userDevice['user_type'];
                                    $notificationOtherArray['receive_for_notification_id'] = $userDevice['user_type_id'];
                                    if(!empty($notificationArray)){
                                        $notificationArray = array_merge($notificationArray,$notificationOtherArray);
                                        $extraDataJsonArray = $notificationArray;
                                        $extraDataJsonArray['module'] = 'amenities';
                                        $extraDatajson = json_encode($extraDataJsonArray);
                                        $notificationArray['extra_data'] = $extraDatajson;
                                        $customerData['extra_data'] = $extraDatajson;
                                        //send notification data
                                        $deviceToken = $userDevice['one_signal_id'];
                                        $playerId = $userDevice['player_id'];
                                        $batchNotificationDataArray[] = $notificationArray;
                                        if(strtolower($userDevice['device_type']) == 'android'){
                                            if (!empty($playerId)) {
                                                array_push($playerIdArray,$playerId);
                                            }
                                        } else {
                                            if (!empty($playerId)) {
                                                array_push($iosPlayerIdArray,$playerId);
                                            }
                                        }
                                    }
                                }
                            }
                            if(!empty($batchNotificationDataArray)){
                                $this->ownership_flat_model->batchInsert($batchNotificationDataArray,'tbl_notification');
                            }
                            $sendNotificationData = array();
                            if(!empty($playerIdArray)){
                                $customerData['player_id'] = $playerIdArray;
                                $customerData['app_url'] = MEMBER_URL .'amenities_detail/' . $lastAmenitiesId;
                                $sendNotificationData = $customerData;
                                sendNotificationAndroid($sendNotificationData);
                            }
                            $sendNotificationIOSData = array();
                            if(!empty($iosPlayerIdArray)){
                                $customerData['player_id'] = $iosPlayerIdArray;
                                $customerData['app_url'] = MEMBER_URL .'amenities_detail/' . $lastAmenitiesId;
                                $sendNotificationIOSData = $customerData;
                                sendNotificationIOS($sendNotificationIOSData);
                            }
                        }
                    }
                    $response['success']  = true;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record'),lang('Amenities.amenities'));
                } else {
                    $response['success']  = false;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record_error'),lang('Amenities.amenities'));
                }
            }
            echo json_encode($response);
            exit();
        }

    }

    public function changeStatus()
    {
        $amenitiesId = $this->request->getVar('amenities_id');
        $status = $this->request->getVar('status');

        //$status         = ($status == 0) ? 1 : 0;
        $return = $this->amenities_model->statusChange($amenitiesId,$status,'amenities_id','tbl_amenities');
        if ($return == 1) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.status_change'),lang('Amenities.amenities'));
        } else {
            $response['success'] = false;
            $response['msg']     = sprintf(lang('CommonMessage.status_change_error'),lang('Amenities.amenities'));
        }
        echo json_encode($response);
        exit();
    }


    public function delete()
    {
        $this->db->transStart();
        $amenitiesId = $this->request->getVar('amenities_id');
        $ids = is_array($amenitiesId) ? implode(',', $amenitiesId) : $amenitiesId;
        if( isReferenceInTable( 'amenities_id','tbl_booking', $amenitiesId) ||
        isReferenceInTable( 'amenities_id','tbl_amc_detail', $amenitiesId) ||
        isReferenceInTable( 'amenities_id','tbl_module_access_card_token', $amenitiesId) 
        ){

            if(!empty($amenitiesId)){
                foreach($amenitiesId as $amenities){
                    $deleteDataArray['module'] = 'Amenities';
                    $deleteDataArray['activity'] = "Tried to delete Amenities ";
                    $deleteDataArray['module_id'] = $amenities;
                    logActivity('Tried to delete Amenities [AmenitiesID: ' . $amenities . ']',$this->data['userId'],'Amenities',$amenities,json_encode($deleteDataArray),'','Amenities',$amenities);
                }
            }

            $response['success'] = false;
            $response['msg'] = lang('CommonMessage.common_delete_record_dependency');
            echo json_encode($response);
            exit;
        }
        $this->amenities_model->deleteAmenitiesUnit($amenitiesId);
        $this->amenities_model->deleteAmenitiesBookingSlotUnitPrice($amenitiesId,$this->data['userId']);
        $this->amenities_model->deleteAmenitiesBookingSlotDay($amenitiesId);
        $this->amenities_model->deleteCommonAreaRecord($amenitiesId);
        $this->amenities_model->deleteAmenitiesBookingSlot($amenitiesId,$this->data['userId']);

        $amenitiesData = $this->amenities_model->deleteRecord($amenitiesId);
        $transactionStatus = $this->db->transComplete();
        if (($amenitiesData) && ($transactionStatus == 1)) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('Amenities.amenities'));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'),lang('Amenities.amenities'));
        }
        echo json_encode($response);
        exit;
    }

    public function addAmenitiesUnitRow()
    {
        $data['row_number'] = $this->request->getVar("row_number");
        $unitRow = view('Admin/Amenities/AmenitiesUnitRowView', $data);
        echo $unitRow;
    }

    public function deleteAmenitiesUnitRow()
    {
        $this->db->transStart();

        $amenitiesUnitId  = $this->request->getVar('amenities_unit_id');
        $amenitiesId = $this->request->getVar('amenities_id');

        $amenitiesUnitData = $this->amenities_model->deleteAmenitiesUnitRecord($amenitiesUnitId);
        
        if (($amenitiesUnitData)) {
            if(!empty($amenitiesUnitId)){
                foreach($amenitiesUnitId as $documentElement){
                    $deleteDataArray['module'] = 'Amenities Unit';
                    $deleteDataArray['activity'] = "Amenities Unit Deleted";
                    $deleteDataArray['module_id'] = $documentElement;
                    logActivity('Amenities Unit Deleted [AmenitiesUnitID: ' . $documentElement . ']',$this->data['userId'],'Amenities Unit',$documentElement,json_encode($deleteDataArray),'','Amenities',$amenitiesId);
                }
            }
            $transactionStatus = $this->db->transComplete();
            if($transactionStatus == 1){
                $response['success'] = true;
                $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('Amenities.amenities_unit'));
            }
            else{
                $response['success'] = false;
                $response['msg'] = sprintf(lang('CommonMessage.delete_error'),lang('Amenities.amenities_unit'));
            }
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.delete_error'),lang('Amenities.amenities_unit'));
        }
        echo json_encode($response);
        exit();
    }

    public function addAmenitiesBookingSlotRow()
    {
        $data['booking_slot_row_number'] = $this->request->getVar("booking_slot_row_number");
        $bookingSlotRow = view('Admin/Amenities/AmenitiesBookingSlotRowView', $data);
        echo $bookingSlotRow;
    }

    public function deleteAmenitiesBookingSlotRow()
    {
        $this->db->transStart();

        $amenitiesBookingSlotId  = $this->request->getVar('amenities_booking_slot_id');
        $amenitiesId = $this->request->getVar('amenities_id');
        $amenitiesBookingSlotData = $this->amenities_model->deleteAmenitiesBookingSlotRecord($amenitiesBookingSlotId,$this->data['userId']);
        $this->amenities_model->deleteAmenitiesBookingSlotDayRecord($amenitiesBookingSlotId);
        $this->amenities_model->deleteAmenitiesBookingSlotUnitPriceRecord($amenitiesBookingSlotId,$this->data['userId']);
        
        if (($amenitiesBookingSlotData)) {
            if(!empty($amenitiesBookingSlotId)){
                foreach($amenitiesBookingSlotId as $documentElement){
                    $deleteDataArray['module'] = 'Amenities Booking Slot';
                    $deleteDataArray['activity'] = "Amenities Booking Slot Deleted";
                    $deleteDataArray['module_id'] = $documentElement;
                    logActivity('Amenities Booking Slot Deleted [AmenitiesBookingSlotID: ' . $documentElement . ']',$this->data['userId'],'Amenities Booking Slot',$documentElement,json_encode($deleteDataArray),'','Amenities',$amenitiesId);
                }
            }
            $transactionStatus = $this->db->transComplete();
            if($transactionStatus == 1){
                $response['success'] = true;
                $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('Amenities.amenities_booking_slot'));
            }
            else{
                $response['success'] = false;
                $response['msg'] = sprintf(lang('CommonMessage.delete_error'),lang('Amenities.amenities_booking_slot')); 
            }
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.delete_error'),lang('Amenities.amenities_booking_slot'));
        }
        echo json_encode($response);
        exit();
    }

    public function getUnitPaymentData()
	{
		$data['row_number'] = $this->request->getVar("row_number");
		$data['amenities_booking_slot_id'] = $this->request->getVar("amenities_booking_slot_id");
		$unitNameArray = $this->request->getVar("unit_name");
		$priceJson = $this->request->getVar("unit_price_json");
		$priceJsonArray = json_decode($priceJson,true);
		$data['current_unit_price_json'] =$this->request->getVar("unit_price_json");
		$data['unit_price_data'] = $priceJsonArray;
		$itemRow = view('Admin/Amenities/AmenitiesUnitPaymentModalView', isset($data) ? $data : array());
		$response['success'] = true;
		$response['item_row_data'] = $itemRow;
		echo json_encode($response);
		exit;
	}
    
    public function getAmenitiesDd(){
        $filterParameter = $this->request->getVar('filter_param');
        $page = $this->request->getVar('page');
        $amenitiesId = $this->request->getVar('amenities_id');
        // $type = $this->request->getVar('type');

        // echo($type);
        // die();

        $filterData = array(
            'amenities_id' => $amenitiesId,
            'filter_param' => $filterParameter,
            // 'type' => $type,
            'page' => $page,
            'start' => 0,
            'limit' => DATA_LIMIT
        );

        echo $this->amenities_model->getAmenities($filterData);
    }

    public function getAmenitiesUnitDd(){

        // printArray($_POST,1);
        $filterParameter = $this->request->getVar('filter_param');
        $page = $this->request->getVar('page');
        $amenitiesId = $this->request->getVar('amenities_id');
        // $type = $this->request->getVar('type');

        // echo($type);
        // die();

        $filterData = array(
            'amenities_id' => $amenitiesId,
            'filter_param' => $filterParameter,
            // 'type' => $type,
            'page' => $page,
            'start' => 0,
            'limit' => DATA_LIMIT
        );

        echo $this->amenities_model->getAmenitiesUnit($filterData);
    }

    public function excelExportAmenities()
    {
        $fileName ='amenities-' . DATETIMEFORMAT;
        $sheetName = 'Amenities-' . DATEFORMAT;
        $excelHeaderName = 'Amenities';
        $tableData = $this->getAmenitiesListing(true, $_GET);
        $dataRows = array();
        $dataRows[] = array(
            // lang('Amenities.society'),
            // lang('Amenities.type'),
            lang('Amenities.amenities'),
            lang('Amenities.total_quantity'),
            lang('Amenities.common_area'),
            lang('CommonMessage.common_updated_by'),
            lang('CommonMessage.common_updated_at')
        );
        foreach ($tableData as $row) {
            $dataRows[] = array(
                // $row["society_name"],
                // $row["type"],
                $row["amenities_name"],
                $row["total_quantity"],
                $row["common_area_name"],
                $row["updated_by"],
                $row["updated_at"]
            );
        }
        $subTotalCellValueArray = [];
        $toColumn = 'E';
        $excelFilterData = array(
            'file_name' => $fileName,
            'sheet_name' => $sheetName,
            'excel_header_name' => $excelHeaderName,
            'data_row' => $dataRows,
            'sub_total_cell_value_array' => $subTotalCellValueArray,
            'to_column' => $toColumn,
            'skip_header' => false,
            'ignore_currency_symbols_sub_total_cell_value_array' => array(),
            'row_cell_currency_format' => array()
        );
        excelExport($excelFilterData);
    }


    public function view($id = null)
    {
        $amenitiesId = $this->request->getVar("view_id");
        if($amenitiesId == "" && $amenitiesId == null){
            return redirect()->to('Admin/Amenities');
        }
        else {
            $id = $amenitiesId;
            $filterData = array(
                "amenities_id" => $amenitiesId
            );
            $data['amenities_data'] = $this->amenities_model->getAmenitiesData($filterData);
            $amenitiesUnitData = $this->amenities_model->getAmenitiesUnitData(array(
                "amenities_id" => $amenitiesId,
                'is_multiple' => 1
            ));
            $data['amenities_unit_data'] = $amenitiesUnitData;

            $amenitiesBookingSlotData = $this->amenities_model->getAmenitiesBookingSlotData(array(
                "amenities_id" => $amenitiesId,
                'is_multiple' => 1,
                'is_deleted' => 0,
            ));

            $amenitiesBookingSlotDayData =  $this->amenities_model->getAmenitiesBookingSlotDayData(array(
                "amenities_id" => $amenitiesId,
                'is_multiple' => 1,
            ));
            $absdDataBookingSlotIdWise = array();
            if(!empty($amenitiesBookingSlotDayData)){
                foreach ($amenitiesBookingSlotDayData as $resourceFlatWorkingDayElement){
                    $absdDataBookingSlotIdWise[$resourceFlatWorkingDayElement['amenities_booking_slot_id']][] = $resourceFlatWorkingDayElement;
                }
            }
            
            if(!empty($amenitiesBookingSlotData)){
                foreach ($amenitiesBookingSlotData as $rfKey => $resourceFlatElement){
                    //$amenitiesBookingSlotData[$rfKey]['unit_payment_json'] = json_encode($unitPaymentArray,true);
                    $amenitiesBookingSlotData[$rfKey]['day_data'] = !empty($absdDataBookingSlotIdWise) && array_key_exists($resourceFlatElement['amenities_booking_slot_id'],$absdDataBookingSlotIdWise) ? $absdDataBookingSlotIdWise[$resourceFlatElement['amenities_booking_slot_id']]: array();
                }
            }
            $data['amenities_booking_slot_data'] = $amenitiesBookingSlotData;

            $data['Amenities'] = $amenitiesUnitData;
            
            // Iterate through each amenities booking slot
            foreach ($data['amenities_booking_slot_data'] as $key => $slot) {
                if (!empty($slot['unit_price_json'])) {
                    // Decode JSON if it exists
                    $unitPriceArray = json_decode($slot['unit_price_json'], true);
                    $data['amenities_booking_slot_data'][$key]['unit_price_data'] = $unitPriceArray;
                } else {
                    // If unit_price_json is empty, set an empty array for unit_price_data
                    $data['amenities_booking_slot_data'][$key]['unit_price_data'] = [];
                }
                
                // Optionally remove the original unit_price_json if not needed
                unset($data['amenities_booking_slot_data'][$key]['unit_price_json']);
            }

            $data['common_area_data'] = $this->amenities_model->getAmenitiesCommonAreaData(array(
                'amenities_id' => $amenitiesId,
                'is_multiple' => 1
            ));

            if (empty($data['amenities_data'])) {
                return redirect()->to('Admin/Amenities');
            }
            
            // printArray($data,1);
            $amenitiesView = view("Admin/Amenities/AmenitiesModelView", $data);
            $response['view_title'] = "Amenities Details";
            $response['view_detail'] = $amenitiesView;
            $response['success'] = true;
            echo json_encode($response);
        }
    }

}
