<?php
namespace App\Controllers\Admin;
use CodeIgniter\Controller;
use App\Models\ActivityLogModel;
class ActivityLog extends BaseController
{
    protected $activity_log_model;
    public function __construct() {
        $this->activity_log_model = new ActivityLogModel();
    }
    //Index page
    public function index($return = false)
    {
        $data['extra_js'] = array(
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
            "vendor/libs/moment/moment.js",
            "vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.js"
        );
        $dataFilters['filters'] = array(
            array(
                "type" => "multi_select",
                "dynamic" => false,
                "id" => "module",
                "name" => "module",
                "tbl_name" => "tbl_activity_log",
                "columns" => array('module','module'),
                "title" => "CommonMessage.module",
                "group_by" => "module",
            ),
            array(
                "type" => "multi_select",
                "dynamic" => false,
                "tbl_name" => "tbl_users",
                "columns" => array("id,concat(first_name,' ',last_name)"),
                "id" => "filter_user_id",
                "name" => "filter_user_id",
                "title" => "CommonMessage.user_name",
            ),
            array(
                "type" => "daterange",
                "id" => "date",
                "name" => "date",
                "title" => "CommonMessage.date",
            ),
        );
        $data['advance_filter'] = view('Admin/CommonMaster/FilterModalView', isset($dataFilters) ? $dataFilters : array());
        $data['title'] = 'Activity Log';
        $this->dt_ci_template->load("Admin", "ActivityLog/ActivityLogView", $data);    
    }
    function loadMoreActivityLog(){
        $limit = 20;
        $start = $this->request->getVar('offset');
        $module = $this->request->getVar('module');
        $userId = $this->request->getVar('filter_user_id');
        $date = $this->request->getVar("date");
        $activityLogFilter = array(
            'start' => $start,
            'limit' => $limit,
            "is_multiple" => 1,
            'module' => $module,
            'user_id' => $userId,
            "date" => $date,
            'society_id' => $this->session->get('society_id'),
        );
        // printArray($activityLogFilter);
        $activityLogData = $this->activity_log_model->getActivityLogData($activityLogFilter);

        if(!empty($activityLogData)){
            foreach ($activityLogData as $bkey => $activityLog) {
                $activityLogData[$bkey]['date'] = date('M d Y, H:i',strtotime($activityLog['date']));
            }
        }
        $data['activity_log_data'] = $activityLogData;
        $itemRowHtml = '';
        if(!empty($activityLogData)){
            $response['success'] = true;
            $response['msg'] = "";
            $itemRowHtml = view('Admin/ActivityLog/LoadMoreActivityLogView', isset($data) ? $data : array());
        } else {
            $response['success'] = false;
            $response['msg'] = "No Data Found";
        }
        $response['view'] = $itemRowHtml;
        $response['offset'] = $start +1;
        echo json_encode($response);
        exit;
    }
}
?>
