<?php
namespace App\Controllers\Admin;
use App\Models\CommonWebServiceModel;
use CodeIgniter\Controller;
use App\Models\AccountModel;
use App\Models\DocumentModel;
class Account extends BaseController
{
    protected $account_model;
    public function __construct() {
        $this->account_model = new AccountModel();
    }
	public function index()
	{
		$data['extra_js'] = array(
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
			"vendor/libs/moment/moment.js",
			"vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.js"
        );
		$data['title'] = 'Account';
		$data['select2_ajax'] = view("Admin/CommonMaster/Select2View",  array());
        $data['advance_filter'] = view('Admin/CommonMaster/FilterModalView', isset($dataFilters) ? $dataFilters : array());
		$this->dt_ci_template->load("Admin","Account/AccountView",$data);
	}

	public function manage($accountId = '')
	{

		$data['extra_js'] = array(
            "js/jquery.form.min.js",
			"vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
			"vendor/libs/flatpickr/flatpickr.js",
			"js/validate.min.js",
			"js/additional_methods.min.js",
        );

        if ($accountId != '') {
			$filterData = array(
				"account_id" => $accountId
			);
			$data['account_data'] = $this->account_model->getAccountData($filterData);

			if (empty($data['account_data'])) {
                return redirect()->to('Admin/Account');
            }

		   	// $accountSubAccountData = $this->account_model->getAccountSubAccountData(array(
			// 	'account_id' => $accountId,
			// 	'is_multiple' => 1
			// ));
			// $data['account_sub_data'] = $accountSubAccountData;
		}
		if ($accountId != '') {
			$data['title'] = 'Edit Account';
		} else {
			$data['title'] = 'Add Account';
		}

		$data['select2_ajax'] = view("Admin/CommonMaster/Select2View",  array());
		if ((isset($data['account_data']['society_id']) && $data['account_data']['society_id'] != $this->session->get('society_id'))) {
            return redirect()->to('Admin/Account');
        }
		$this->dt_ci_template->load("Admin","Account/AccountManageView",$data);
	}

    public function getAccountListing($return = false,$filterData=array())
    {
    	if($return == TRUE){
			$filterData['length'] = '';
			$_POST = $filterData;
		}

        $this->datatables->table("tbl_account as ts");
		$this->datatables->select("ts.account_id,ts.account_name,ts.account_code,ts.account_type,tsoc.society_name");
		$this->datatables->select("ts.is_active,concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by,ts.updated_at");
		$this->datatables->join(MASTER_DB.".tbl_society as tsoc","tsoc.society_id = ts.society_id","left");
		$this->datatables->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = ts.updated_by AND tupdate.society_id = ts.society_id","left");

		$this->datatables->groupBy("ts.account_id");
		accessFilter($this->datatables, array("society" => "ts.society_id"));
		$dataReport =  $this->datatables->generate();
		$dataReport = json_decode($dataReport, true);
		$data       = $dataReport['data'];
		// printArray($data,1);
		if(count($data) > 0){
			foreach($data as $key => $displayData){
				$actionButtonFilter = array(
					"account_id" => isset($displayData['account_id']) ? $displayData['account_id']: ""
				);
				$data[$key]['action_button'] = accountActionButton($actionButtonFilter);
				$data[$key]['updated_at'] = isValidDate($data[$key]['updated_at']) ? siteDateFormat($data[$key]['updated_at'],true) : "";
				$data[$key]['account_type'] = isset($displayData['account_type']) ? underscoreToUcWord($displayData['account_type']): "";
			}
		}

		if($return){
			return $data;
		}else{
			$dataReport['data'] = $data;
			echo json_encode($dataReport);
			exit;
		}
        
    }

    public function changeStatus(){
        $accountId = $this->request->getVar('account_id');
        $status = $this->request->getVar('status');
        $return = $this->account_model->statusChange($accountId,$status,'account_id','tbl_account');
		if ($return == 1) {
			$response['success'] = true;
			$response['msg']     = sprintf(lang('CommonMessage.status_change'),lang('Account.account'));
		} else {
			$response['success'] = false;
			$response['msg']     = sprintf(lang('CommonMessage.status_change_error'),lang('Account.account'));
		}
		echo json_encode($response);
		exit;
    }

    public function save()
	{
	    $this->db->transStart();
		$validation = \Config\Services::validation();
		$accountId = $this->request->getVar('account_id');
		$accountCode = $this->request->getVar('account_code');
		$accountName = $this->request->getVar('account_name');
		$accountType = $this->request->getVar('account_type');
		$isActive = $this->request->getVar('is_active');

		if (isset($accountId) && $accountId == '') {
			$validation->setRule('account_code', lang('Account.account_code'), 'required|combination_unique[tbl_account.account_code.'.$this->session->get('society_id').'.]',array('combination_unique' => 'This {field} Already Exists'));
        } else {
			$validation->setRule('account_code', lang('Account.account_code'), 'required|edit_unique[tbl_account.account_code.' . $accountId . '.'. $this->session->get('society_id').']',array('edit_unique' => 'This {field} Already Exists'));
        }
		
		// $validation->setRule('account_code', lang('Account.account_code'), 'required');
		$validation->setRule('account_name', lang('Account.account_name'), 'required');
		if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {

			$accountUpdateArray = array();
			$accountArray = array(
				'account_id' => $accountId,
				'account_code' => $accountCode,
				'account_name' => $accountName,
				'account_type' => $accountType,
				'society_id' => $this->session->get('society_id'),
				'is_active' => isset($isActive) ? 1 : 0,
			);

			if(!empty($accountId)){
                $accountUpdateData = $this->account_model->getAccountData(array(
                    'account_id' => $accountId,
                ));
                $accountUpdateArray = compareArray($accountArray,$accountUpdateData);
            }

			$accountData = $this->account_model->insertUpdateRecord($accountArray, 'account_id', 'tbl_account', 1,'',array(),array(),$accountUpdateArray);
			$lastAccountId = $accountData['lastInsertedId'];

			$accountSubAccountData = array();
            if(!empty($accountId)) {
                $accountSubAccountData = $this->account_model->getAccountSubAccountData(array(
                    'account_id' => $accountId,
                    'is_multiple' => 1
                ));
            }

			// $subAccountIdArray = $this->request->getVar('sub_account_id[]');
            // if(isset($accountId) && $accountId != ''){
            //     $this->account_model->deleteSubAccountRecord($accountId);
            // }
            // if(isset($subAccountIdArray)&& $subAccountIdArray != ''){
            //     $accountSubAccountArray = array();
            //     foreach($subAccountIdArray as $subAccountId){
            //         $accountSubAccountArray[] = array(
            //             'account_sub_account_id' => '',
            //             'account_id' => $lastAccountId,
            //             'sub_account_id' => $subAccountId,
            //             'created_at' => date('Y-m-d H:i:s'),
            //             'updated_at' => date('Y-m-d H:i:s'),
            //             'created_by' => $this->data['userId'],
            //             'updated_by' => $this->data['userId']
            //         );
            //     }
            //     $accountSocietyExtraDataArray = array();
            //     $accountSocietyExtraDataArray['module_id'] = $lastAccountId;
            //     $accountSocietyExtraDataArray['module'] = 'Account Sub Account';
            //     $accountSocietyExtraDataArray['type'] = 'Account';
            //     $accountSocietyExtraDataArray['old_data'] = $accountSubAccountData;
            //     $accountSocietyExtraDataArray['user_id'] = $this->data['userId'];
            //     $accountSocietyExtraDataArray['society_id'] = $this->session->get('society_id');

            //     if(!empty($accountSubAccountArray)){
            //         $this->account_model->batchInsert($accountSubAccountArray,'tbl_account_sub_account',$accountSocietyExtraDataArray);
            //     }
            // }
            $transactionStatus = $this->db->transComplete();
			if (isset($accountId) && $accountId != '') {
				if (($accountData['success']) && ($transactionStatus == 1)) {
					$response['success'] = true;
					$response['msg'] = sprintf(lang('CommonMessage.update_record'), lang("Account.account"));
				} else {
					$response['success'] = false;
					$response['msg'] = sprintf(lang('CommonMessage.update_record_error'), lang("Account.account"));
				}
			} else {
				if (($accountData['success']) && ($transactionStatus == 1)) {
					$response['success'] = true;
					$response['msg'] = sprintf(lang('CommonMessage.create_record'), lang("Account.account"));
				} else {
					$response['success'] = false;
					$response['msg'] = sprintf(lang('CommonMessage.create_record_error'), lang("Account.account"));
				}
			}
			echo json_encode($response);
			exit;
		}
	}

    public function delete()
    {
        $this->db->transStart();
        $accountId = $this->request->getVar('account_id');
         if( isReferenceInTable( 'account_id','tbl_account_sub_account', $accountId) ||
         	isReferenceInTable( 'account_id','tbl_budget_sub_account', $accountId)){
			 if(!empty($accountId)){
			 	foreach($accountId as $documentElement){
			 		$deleteDataArray['module'] = 'Account';
			 		$deleteDataArray['activity'] = "Tried to Delete Account ";
			 		$deleteDataArray['module_id'] = $documentElement;
			 		logActivity('Tried to delete Account [AccountID: ' . $documentElement . ']',$this->data['userId'],'Account',$documentElement,json_encode($deleteDataArray),'','Account',$documentElement);
			 	}
			 }
             $response['success'] = false;
             $response['msg'] = lang('CommonMessage.common_delete_record_dependency');
             echo json_encode($response);
             exit;
         }

        $accountData = $this->account_model->deleteRecord($accountId);
        // $accountGuardData = $this->account_model->deleteSubAccountRecord($accountId);
        $transactionStatus = $this->db->transComplete();
        if (($accountData) && ($transactionStatus == 1)) {
            $response['success'] = true;
            $response['msg'] = sprintf(lang('CommonMessage.delete_record'), lang("Account.account"));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'), lang("Account.account"));
        }
        echo json_encode($response);
        exit;
    }

    public function getAccountDd(){
    	$filterParameter = $this->request->getVar('filter_param');
        $page = $this->request->getVar('page');
        $accountId = $this->request->getVar('account_id');
        $societyId = $this->request->getVar('society_id');
        $filterData = array(
            'account_id' => $accountId,
            'society_id' => $this->session->get('society_id'),
            'filter_param' => $filterParameter,
            'page' => $page,
            'start' => 0,
            'is_active' => 1,
            'limit' => DATA_LIMIT
        );

        echo $this->account_model->getAccount($filterData);
    }

	public function excelExportAccount()
	{
		$fileName ='account-' . DATETIMEFORMAT;
		$sheetName = 'Account-' . DATEFORMAT;
		$excelHeaderName = 'Account';
		$tableData = $this->getAccountListing(true, $_GET);
		$dataRows = array();
		$dataRows[] = array(
			lang('Account.account_type'),
			lang('Account.account_name'),
			lang('Account.father_name'),
			lang('Account.date_of_birth'),
			lang('Account.gender'),
			lang('Account.work'),
			lang('Account.contact_no'),
			lang('Account.present_address'),
			lang('Account.permanent_address'),
			lang('Account.reference'),
			lang('CommonMessage.common_updated_by'),
			lang('common_updated_at')
		);
		foreach ($tableData as $row) {
			$dataRows[] = array(
				$row["account_type"],
				$row["account_name"],
				$row["father_name"],
				$row["date_of_birth"],
				$row["gender"],
				$row["work"],
				$row["contact_no"],
				$row["present_address"],
				$row["permanent_address"],
				$row["reference"],
				$row["updated_by"],
				$row["updated_at"]
			);
		}
		$subTotalCellValueArray = [];
		$toColumn = 'L';
		$excelFilterData = array(
			'file_name' => $fileName,
			'sheet_name' => $sheetName,
			'excel_header_name' => $excelHeaderName,
			'data_row' => $dataRows,
			'sub_total_cell_value_array' => $subTotalCellValueArray,
			'to_column' => $toColumn,
			'skip_header' => false,
			'ignore_currency_symbols_sub_total_cell_value_array' => array(),
			'row_cell_currency_format' => array()
		);
		//excelExport($filename,$sheetName,$excelHeaderName,$dataRows,$subTotalCellValueArray,$toColumn,false,array(),array());
		excelExport($excelFilterData);
	}


}
