<?php
namespace App\Controllers\Admin;
use CodeIgniter\Controller;
use App\Models\AMCModel;
use App\Models\SocietyModel;
use App\Models\VendorModel;
use App\Models\FinancialYearModel;
class AMC extends BaseController
{
    protected $amc_model;
    protected $society_model;
    protected $financial_year_model;
    public function __construct() {
        $this->amc_model = new AMCModel();
        $this->society_model = new SocietyModel();
        $this->financial_year_model = new FinancialYearModel();
        $this->vendor_model = new VendorModel();
    }
	public function index()
	{
		$data['extra_js'] = array(
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
			"vendor/libs/moment/moment.js",
			"vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.js"
        );
		$data['title'] = 'AMC';
		$dataFilters['filters'] = array(
			array(
				"type" => "multi_select",
				"dynamic" => true,
				"class" => "vendorDd",
				"id" => "filter_vendor_id",
				"name" => "filter_vendor_id",
				"title" => "AMC.company_person",
			),
			array(
				"type" => "amc_type",
				"id" => "amc_type",
				"name" => "amc_type",
				"title" => "AMC.amc_type",
			),
			array(
				"type" => "daterange",
				"id" => "filter_period_from",
				"name" => "filter_period_from",
				"title" => "AMC.period",
			),
			array(
				"type" => "daterange",
				"id" => "filter_created_at",
				"name" => "filter_created_at",
				"title" => "CommonMessage.common_created_at",
			),
			array(
				"type" => "daterange",
				"id" => "filter_updated_at",
				"name" => "filter_updated_at",
				"title" => "CommonMessage.common_updated_at",
			),
		);
		
		$data['select2_ajax'] = view("Admin/CommonMaster/Select2View",  array());
        $data['advance_filter'] = view('Admin/CommonMaster/FilterModalView', isset($dataFilters) ? $dataFilters : array());
		$this->dt_ci_template->load("Admin","AMC/AMCView",$data);
	}

	public function manage($amcId = '')
	{
		$data['extra_js'] = array(
			"js/jquery.form.min.js",
			"vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
			"vendor/libs/flatpickr/flatpickr.js",
			"js/validate.min.js",
			"js/additional_methods.min.js",
		);

        if ($amcId != '') {
			$filterData = array(
				"amc_id" => $amcId
			);
			$data['amc_data'] = $this->amc_model->getAmcData($filterData);

			if (empty($data['amc_data'])) {
                return redirect()->to('Admin/AMC');
            }
		}
		$select2Condition = array(
            'isFacilitiesAmenities' => true,
        );
		if ($amcId != '') {
			$data['title'] = 'Edit AMC';
		} else {
			$data['title'] = 'Add AMC';
		}
		$data['select2_ajax'] = view("Admin/CommonMaster/Select2View", isset($select2Condition) ? $select2Condition : array());
		if ((isset($data['amc_data']['society_id']) && $data['amc_data']['society_id'] != $this->session->get('society_id'))) {
            return redirect()->to('Admin/AMC');
        }
		$this->dt_ci_template->load("Admin","AMC/AMCManageView",$data);
	}

    public function getAMCListing($return = false,$filterData=array())
    {
    	if($return == TRUE){
			$filterData['length'] = '';
			$_POST = $filterData;
		}
		$createdAt = $this->request->getVar("filter_created_at");
		$updatedAt = $this->request->getVar("filter_updated_at");
		$vendorId = $this->request->getVar("filter_vendor_id");
		$periodFrom = $this->request->getVar("filter_period_from");
		$amcType = $this->request->getVar("amc_type");

        $this->datatables->table("tbl_amc_detail as tad");
		$this->datatables->select("tad.amc_id,tad.place, tad.amc_type,tad.particular,tad.period_from,tad.period_upto,tad.amount,tad.is_active,tad.society_id,COALESCE(ts.society_name,'') as society_name,COALESCE(ta.amenities_name,'') as amenities_name");
		$this->datatables->select("COALESCE(tv.vendor_name,'') as vendor_name,tad.vendor_id");
		$this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by,tad.updated_at");
		$this->datatables->join(MASTER_DB.".tbl_society as ts","ts.society_id = tad.society_id","left");
		$this->datatables->join("tbl_vendor as tv","tv.vendor_id = tad.vendor_id","left");
		$this->datatables->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = tad.updated_by AND tupdate.society_id = tad.society_id","left");
        $this->datatables->join("tbl_amenities as ta","ta.amenities_id = tad.amenities_id","left");

		if(isset($vendorId)) {
			if(is_array($vendorId)){
				$this->datatables->whereIn("tad.vendor_id",$vendorId);
			} else {
				$this->datatables->where("tad.vendor_id",$vendorId);
			}
		}
		if (isset($amcType)) {
			if (is_array($amcType)) {
				$this->datatables->whereIn("tad.amc_type", $amcType);
			} else {
				$this->datatables->where("tad.amc_type", $amcType);
			}
		}
		if($periodFrom != ''){
			list($fromDate,$toDate) = explode(" - ",$periodFrom);
			$fromDate = DMYToYMD($fromDate);
			$toDate = DMYToYMD($toDate);
			if(strtotime($fromDate) != strtotime($toDate)){
				$this->datatables->where("date_format(tad.period_from,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
				$this->datatables->where("date_format(tad.period_upto,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
			} else {
				$this->datatables->where("date_format(tad.period_from,'".DATE_FORMATE_MYSQL_YMD."') = ",$fromDate);
				$this->datatables->where("date_format(tad.period_upto,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
			}
		}
		if($createdAt != ''){
			list($fromDate,$toDate) = explode(" - ",$createdAt);
			$fromDate = DMYToYMD($fromDate);
			$toDate = DMYToYMD($toDate);
			if(strtotime($fromDate) != strtotime($toDate)){
				$this->datatables->where("date_format(tad.created_at,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
				$this->datatables->where("date_format(tad.created_at,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
			} else {
				$this->datatables->where("date_format(tad.created_at,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
			}
		}
		if($updatedAt != ''){
			list($fromDate,$toDate) = explode(" - ",$updatedAt);
			$fromDate = DMYToYMD($fromDate);
			$toDate = DMYToYMD($toDate);
			if(strtotime($fromDate) != strtotime($toDate)){
				$this->datatables->where("date_format(tad.updated_at,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
				$this->datatables->where("date_format(tad.updated_at,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
			} else {
				$this->datatables->where("date_format(tad.updated_at,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
			}
		}
		accessFilter($this->datatables, array("society" => "tad.society_id"));
		$this->datatables->groupBy("tad.amc_id");
		$dataReport =  $this->datatables->generate();
		$dataReport = json_decode($dataReport, true);
		$data       = $dataReport['data'];
		if(count($data) > 0){
			foreach($data as $key => $displayData){
				$actionButtonFilter = array(
					"amc_id" => isset($displayData['amc_id']) ? $displayData['amc_id'] : ""
				);
				$data[$key]['action_button'] = amcActionButton($actionButtonFilter);
				$data[$key]['amc_type'] = underscoreToUcWord($displayData['amc_type']);
				$data[$key]['period_from'] = siteDateFormat($displayData['period_from']);
				$data[$key]['period_upto'] = siteDateFormat($displayData['period_upto']);
				$data[$key]['amount'] = indianMoneyFormat($displayData['amount'],2,0);
				$data[$key]['updated_at'] = isValidDate($displayData['updated_at']) ? siteDateFormat($displayData['updated_at'],true) : "";
				$data[$key]['excel_vendor_name'] = isset($displayData['vendor_name']) ?  $displayData['vendor_name'] : "";
				$data[$key]['vendor_name'] = isset($displayData['vendor_name']) ?  vendorDocumentToHtml($displayData['vendor_name'],$displayData['vendor_id']) : "";
			}
		}

		if($return){
			return $data;
		}else{
			$dataReport['data'] = $data;
			echo json_encode($dataReport);
			exit;
		}
        
    }

    public function changeStatus(){
        $amcId = $this->request->getVar('amc_id');
        $status = $this->request->getVar('status');
        $return = $this->amc_model->statusChange($amcId,$status,'amc_id','tbl_amc_detail');
		if ($return == 1) {
			$response['success'] = true;
			$response['msg']     = sprintf(lang('CommonMessage.status_change'),lang('AMC.amc'));
		} else {
			$response['success'] = false;
			$response['msg']     = sprintf(lang('CommonMessage.status_change_error'),lang('AMC.amc'));
		}
		echo json_encode($response);
		exit;
    }

    public function save()
	{
		$this->db->transStart();
		$validation = \Config\Services::validation();
		$amcId = $this->request->getVar('amc_id');
		$financialYearId = $this->request->getVar('financial_year_id');
		$vendorId = $this->request->getVar('vendor_id');
		$particular = $this->request->getVar('particular');
		$amcType = $this->request->getVar('amc_type');
		$periodFrom = $this->request->getVar('period_from');
		$periodTo = $this->request->getVar('period_to');
		$amenitiesId = $this->request->getVar('amenities_id');
		$place = $this->request->getVar('place');
		$amount = $this->request->getVar('amount');
		$isActive = $this->request->getVar('is_active');
		$payable = $this->request->getVar("payable");
		$itemId = $this->request->getVar("item_id");
		$serviceType = $this->request->getVar("service_type");


		$validation->setRule('particular', lang('AMC.particular'), 'required');
		$validation->setRule('amc_type', lang('AMC.amc_type'), 'required');
		$validation->setRule('vendor_id', lang('AMC.company_person'), 'required');
		$validation->setRule('financial_year_id', lang('AMC.financial_year'), 'required');
		$validation->setRule('period_from', lang('AMC.period_from'), 'required');
		$validation->setRule('period_to', lang('AMC.period_to'), 'required');
		// $validation->setRule('amount', lang('AMC.amount'), 'required');
		$validation->setRule('service_type', lang('AMC.service_type'), 'required');

		if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {

			if (strtotime($periodFrom) > strtotime($periodTo)){
				$response['success'] = false;
				$response['msg'] = lang('AMC.amc_period_from_date_to_date_message');
				echo json_encode($response);
				exit;
			}
			if(!isset($payable)){
				$amount = 0;
			}
			$amcUpdateArray = array();
			$amcArray = array(
				'amc_id' => $amcId,
				'society_id' => $this->session->get('society_id'),
				'financial_year_id' => $financialYearId,
				'amc_type' => $amcType,
				'item_id' => $itemId,
				'service_type' => $serviceType,
				'particular' => $particular,
				'vendor_id' => $vendorId,
				'period_from' => DMYToYMD($periodFrom),
				'period_upto' => DMYToYMD($periodTo),
				'amount' => $amount,
				'amenities_id' => $amenitiesId,
				'place' => $place,
				'payable' => isset($payable) ? 1 : 0,
				'is_active' => isset($isActive) ? 1 : 0,
			);
			if(!empty($amcId)){
                $amcUpdateData = $this->amc_model->getAmcData(array(
                    'amc_id' => $amcId,
                ));
                $amcUpdateArray = compareArray($amcArray,$amcUpdateData);
            }
			$amcData = $this->amc_model->insertUpdateRecord($amcArray, 'amc_id', 'tbl_amc_detail', 1,'',array(),array(),$amcUpdateArray);
			$lastAMCId = $amcData['lastInsertedId'];
			$transactionStatus = $this->db->transComplete();
			if (isset($amcId) && $amcId != '') {
				if (($amcData['success']) && ($transactionStatus == 1)) {
					$response['success'] = true;
					$response['msg'] = sprintf(lang('CommonMessage.update_record'), lang("AMC.amc"));
				} else {
					$response['success'] = false;
					$response['msg'] = sprintf(lang('CommonMessage.update_record_error'), lang("AMC.amc"));
				}
			} else {
				if (($amcData['success']) && ($transactionStatus == 1)) {
					$response['success'] = true;
					$response['msg'] = sprintf(lang('CommonMessage.create_record'), lang("AMC.amc"));
				} else {
					$response['success'] = false;
					$response['msg'] = sprintf(lang('CommonMessage.create_record_error'), lang("AMC.amc"));
				}
			}
			echo json_encode($response);
			exit;
		}
	}

    public function delete()
    {
    	$this->db->transStart();
		$amcId = $this->request->getVar('amc_id');
		if( isReferenceInTable( 'amc_id','tbl_visit', $amcId)
        ){

            if(!empty($amcId)){
                foreach($amcId as $amc){
                    $deleteDataArray['module'] = 'AMC';
                    $deleteDataArray['activity'] = "Tried to delete AMC ";
                    $deleteDataArray['module_id'] = $amc;
                    logActivity('Tried to delete AMC [AMCID: ' . $amc . ']',$this->data['userId'],'AMC',$amc,json_encode($deleteDataArray),'','AMC',$amc);
                }
            }

            $response['success'] = false;
            $response['msg'] = lang('CommonMessage.common_delete_record_dependency');
            echo json_encode($response);
            exit;
        }
		$amcData = $this->amc_model->deleteRecord($amcId);
		$transactionStatus = $this->db->transComplete();
        if (($amcData) && ($transactionStatus == 1)) {
            $response['success'] = true;
            $response['msg'] = sprintf(lang('CommonMessage.delete_record'), lang("AMC.amc"));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'), lang("AMC.amc"));
        }
        echo json_encode($response);
        exit;
    }


	public function vendorData()
    {
        $validation = \Config\Services::validation();
		$vendorId = $this->request->getVar('vendor_id');
		$validation->setRule('vendor_id', lang('AMC.company_person'), 'required');
		if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {

			$vendorData = $this->vendor_model->getVendorData(array('vendor_id' => $vendorId ));
			$vendorMobileData = $this->vendor_model->getVendorMobileData(array(
				'vendor_id' => $vendorId,
				'is_multiple' => 1
			));
	
			$data['vendor_data'] = $vendorData;
			$data['vendor_mobile_data'] = $vendorMobileData;
			$vendorDataModal = view('Admin/AMC/VendorDetailView', isset($data) ? $data : array());
			$response['success'] = true;
			$response['vendor_modal_data'] = $vendorDataModal;
			echo json_encode($response);
			exit;

		}
    }

	public function getAmcDd(){
        $filterParameter = $this->request->getVar('filter_param');
        $page = $this->request->getVar('page');
        $amcId = $this->request->getVar('amc_id');
        $vendorId = $this->request->getVar('vendor_id');
        $filterData = array(
            'amc_id' => $amcId,
            'vendor_id' => $vendorId,
            'filter_param' => $filterParameter,
            'page' => $page,
            'start' => 0,
            'is_active' => 1,
            'limit' => DATA_LIMIT
        );
        echo $this->amc_model->getAmc($filterData);
    }

    public function view($id = null)
	{
		$amcId = $this->request->getVar("view_id");
		if($amcId == "" && $amcId == null){
            return redirect()->to('Admin/AMC');
		}
		else {
			$id = $amcId;
			$filterData = array(
				"amc_id" => $amcId
			);
			$data['amc_data'] = $this->amc_model->getAmcData($filterData);
			$amcView = view("Admin/AMC/AMCModelView", $data);

			$response['view_title'] = lang('AMC.amc_detail');
			$response['view_detail'] = $amcView;
			$response['success'] = true;
			echo json_encode($response);
		}
	}

	public function excelExportAMC()
	{
		$fileName ='amc-' . DATETIMEFORMAT;
		$sheetName = 'Amc-' . DATEFORMAT;
		$excelHeaderName = 'AMC';
		$tableData = $this->getAMCListing(true, $_GET);
		$dataRows = array();
		$dataRows[] = array(
			lang('AMC.amc_type'),
			lang('AMC.particular'),
			lang('AMC.company_person'),
			lang('AMC.period_from'),
			lang('AMC.period_to'),
			lang('AMC.amount'),
			lang('AMC.facilities'),
			lang('AMC.place'),
			lang('CommonMessage.common_updated_by'),
			lang('CommonMessage.common_updated_at')
		);
		foreach ($tableData as $row) {
			$dataRows[] = array(
				$row["amc_type"],
				$row["particular"],
				$row["excel_vendor_name"],
				$row["period_from"],
				$row["period_upto"],
				$row["amount"],
				$row["amenities_name"],
				$row["place"],
				$row["updated_by"],
				$row["updated_at"]
			);
		}
		$subTotalCellValueArray = [];
		$toColumn = 'J';
		$excelFilterData = array(
			'file_name' => $fileName,
			'sheet_name' => $sheetName,
			'excel_header_name' => $excelHeaderName,
			'data_row' => $dataRows,
			'sub_total_cell_value_array' => $subTotalCellValueArray,
			'to_column' => $toColumn,
			'skip_header' => false,
			'ignore_currency_symbols_sub_total_cell_value_array' => array(),
			'row_cell_currency_format' => array()
		);
		//excelExport($filename,$sheetName,$excelHeaderName,$dataRows,$subTotalCellValueArray,$toColumn,false,array(),array());
		excelExport($excelFilterData);
	}

	public function amcPdf()
	{
		if(!$this->dt_ci_acl->checkAccess('AMC|pdf')){
			return show_error(NO_ACCESS_SECTION);
		} else {
			$societyData = $this->society_model->getSocietyData(array(
				"society_id" => $this->session->get('society_id'),
			));
			$data['society_data'] = $societyData;

			$getCurrentFinancialYear = currentFinancialYear();
			$financialYearData = array();
			if($getCurrentFinancialYear != ''){
				list($fromDate,$toDate) = explode(" - ",$getCurrentFinancialYear);
				$fromDate = DMYToYMD($fromDate);
				$toDate = DMYToYMD($toDate);

				$financialYearData = $this->financial_year_model->getFinancialYearData(array(
					"start_date" => $fromDate,
					"end_date" => $toDate
				));
			}
			$data['financial_year_data'] = $financialYearData;

			$filterData = array(
				'is_multiple' => 1,
				'financial_year_id' => isset($financialYearData['financial_year_id']) ? $financialYearData['financial_year_id']: '',
			);
			$amcData = $this->amc_model->getAmcData($filterData);
//            printArray($amcData,1);

			$amcDataTypeWiseArray = array();
			if(!empty($amcData)) {
				foreach ($amcData as $akey => $amc) {
					$amcDataTypeWiseArray[$amc['amc_type']][] = $amc;
				}
			}

			$data['amc_data'] = $amcDataTypeWiseArray;
			$data['name'] = lang("AMC.amc_pdf") . ".pdf";
			$printHeader = '';
			$printFooter = '';

			$printFooter = pdfFooter( 0, array());

			$html = view('Admin/AMC/Pdf/AMCPdfView', $data);

			generate_pdf($html, $data['name'], false, $printFooter, '', $printHeader, '', 'P');
		}
	}

}
