<?php

/*
 | --------------------------------------------------------------------
 | App Namespace
 | --------------------------------------------------------------------
 |
 | This defines the default Namespace that is used throughout
 | CodeIgniter to refer to the Application directory. Change
 | this constant to change the namespace that all application
 | classes should use.
 |
 | NOTE: changing this will require manually modifying the
 | existing namespaces of App\* namespaced-classes.
 */
defined('APP_NAMESPACE') || define('APP_NAMESPACE', 'App');

/*
 | --------------------------------------------------------------------------
 | Composer Path
 | --------------------------------------------------------------------------
 |
 | The path that Composer's autoload file is expected to live. By default,
 | the vendor folder is in the Root directory, but you can customize that here.
 */
defined('COMPOSER_PATH') || define('COMPOSER_PATH', ROOTPATH . 'vendor/autoload.php');

/*
 |--------------------------------------------------------------------------
 | Timing Constants
 |--------------------------------------------------------------------------
 |
 | Provide simple ways to work with the myriad of PHP functions that
 | require information to be in seconds.
 */
defined('SECOND') || define('SECOND', 1);
defined('MINUTE') || define('MINUTE', 60);
defined('HOUR')   || define('HOUR', 3600);
defined('DAY')    || define('DAY', 86400);
defined('WEEK')   || define('WEEK', 604800);
defined('MONTH')  || define('MONTH', 2_592_000);
defined('YEAR')   || define('YEAR', 31_536_000);
defined('DECADE') || define('DECADE', 315_360_000);

/*
 | --------------------------------------------------------------------------
 | Exit Status Codes
 | --------------------------------------------------------------------------
 |
 | Used to indicate the conditions under which the script is exit()ing.
 | While there is no universal standard for error codes, there are some
 | broad conventions.  Three such conventions are mentioned below, for
 | those who wish to make use of them.  The CodeIgniter defaults were
 | chosen for the least overlap with these conventions, while still
 | leaving room for others to be defined in future versions and user
 | applications.
 |
 | The three main conventions used for determining exit status codes
 | are as follows:
 |
 |    Standard C/C++ Library (stdlibc):
 |       http://www.gnu.org/software/libc/manual/html_node/Exit-Status.html
 |       (This link also contains other GNU-specific conventions)
 |    BSD sysexits.h:
 |       http://www.gsp.com/cgi-bin/man.cgi?section=3&topic=sysexits
 |    Bash scripting:
 |       http://tldp.org/LDP/abs/html/exitcodes.html
 |
 */
defined('EXIT_SUCCESS')        || define('EXIT_SUCCESS', 0);        // no errors
defined('EXIT_ERROR')          || define('EXIT_ERROR', 1);          // generic error
defined('EXIT_CONFIG')         || define('EXIT_CONFIG', 3);         // configuration error
defined('EXIT_UNKNOWN_FILE')   || define('EXIT_UNKNOWN_FILE', 4);   // file not found
defined('EXIT_UNKNOWN_CLASS')  || define('EXIT_UNKNOWN_CLASS', 5);  // unknown class
defined('EXIT_UNKNOWN_METHOD') || define('EXIT_UNKNOWN_METHOD', 6); // unknown class member
defined('EXIT_USER_INPUT')     || define('EXIT_USER_INPUT', 7);     // invalid user input
defined('EXIT_DATABASE')       || define('EXIT_DATABASE', 8);       // database error
defined('EXIT__AUTO_MIN')      || define('EXIT__AUTO_MIN', 9);      // lowest automatically-assigned error code
defined('EXIT__AUTO_MAX')      || define('EXIT__AUTO_MAX', 125);    // highest automatically-assigned error code

/**
 * @deprecated Use \CodeIgniter\Events\Events::PRIORITY_LOW instead.
 */
define('EVENT_PRIORITY_LOW', 200);

/**
 * @deprecated Use \CodeIgniter\Events\Events::PRIORITY_NORMAL instead.
 */
define('EVENT_PRIORITY_NORMAL', 100);

/**
 * @deprecated Use \CodeIgniter\Events\Events::PRIORITY_HIGH instead.
 */
define('EVENT_PRIORITY_HIGH', 10);
//$protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] != 'off' ? 'https://'.$_SERVER['HTTP_HOST'] : 'http://'.$_SERVER['HTTP_HOST'];
//defined('BASE') || define('BASE',$protocol);

// $base_url = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] == 'on' ? 'https://' : 'http://') . $_SERVER['HTTP_HOST'] . dirname($_SERVER['SCRIPT_NAME']) . (substr(dirname($_SERVER['SCRIPT_NAME']), -1) == '/' ? '' : '/');

$slug = isset($_SESSION['society_slug']) ? $_SESSION['society_slug'] . '/' : '';

$base_url = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] == 'on' ? 'https://' : 'http://')
    . $_SERVER['HTTP_HOST']
    . dirname($_SERVER['SCRIPT_NAME'])
    . (substr(dirname($_SERVER['SCRIPT_NAME']), -1) == '/' ? '' : '/')
    . $slug;

defined('BASE') || define('BASE', $base_url);

defined('TIMEZONE') OR define('TIMEZONE', 'Asia/Kolkata');
date_default_timezone_set(TIMEZONE);

defined('DATA_LIMIT') OR define('DATA_LIMIT', 10);

/********* Button Constant *******/
defined('BTN_SUCCESS') OR define('BTN_SUCCESS', '#66BB6A');
defined('BTN_ERROR') OR define('BTN_ERROR', '#F44336');
defined('BTN_DELETE_INFO') OR define('BTN_DELETE_INFO', '#2196F3');
defined('BTN_DELETE_WARNING') OR define('BTN_DELETE_WARNING', '#FF7043');
defined('BTN_SPINNER_COLOR') OR define('BTN_SPINNER_COLOR', '#03A9F4');
defined('STR_TO_TIME') OR define('STR_TO_TIME', strtotime(date("Y-m-d H:i:s")));
defined('SITE_NAME') OR define('SITE_NAME', 'Society Management');
defined('DATE_TIME_DATABASE') OR define('DATE_TIME_DATABASE', date("Y-m-d H:i:s"));
defined('DATETIMEFORMAT') OR define('DATETIMEFORMAT', date("l-dS-F-Y-H-i-s-A", STR_TO_TIME));
define('TODAY_DATE_TIME', date("d-m-Y H:i:s"));
defined('DATEFORMAT') OR define('DATEFORMAT', date("D-dS-M-y", STR_TO_TIME));

defined('MINIMUM_DECIMAL_POINT') OR define('MINIMUM_DECIMAL_POINT', 0);
defined('MAXIMUM_DECIMAL_POINT') OR define('MAXIMUM_DECIMAL_POINT', 4);
defined('PRODUCT_CATEGORY_PATH') OR define('PRODUCT_CATEGORY_PATH', 'uploads/product_category/');


defined('MEDIA_IMAGE_PATH') OR define('MEDIA_IMAGE_PATH','uploads/media/');
defined('THUMBNAIL_MEDIA_IMAGE_PATH') OR define('THUMBNAIL_MEDIA_IMAGE_PATH','uploads/media/thumbnail/');
defined('VISITOR_COMPANY_IMAGE_PATH') OR define('VISITOR_COMPANY_IMAGE_PATH','uploads/visitorCompany/');
defined('THUMBNAIL_VISITOR_COMPANY_IMAGE_PATH') OR define('THUMBNAIL_VISITOR_COMPANY_IMAGE_PATH','uploads/visitorCompany/thumbnail/');
defined('CATEGORY_IMAGE_PATH') OR define('CATEGORY_IMAGE_PATH','uploads/category/');
defined('THUMBNAIL_CATEGORY_IMAGE_PATH') OR define('THUMBNAIL_CATEGORY_IMAGE_PATH','uploads/category/thumbnail/');
defined('DOCUMENT_IMAGE_PATH') OR define('DOCUMENT_IMAGE_PATH','uploads/document/');
defined('THUMBNAIL_DOCUMENT_IMAGE_PATH') OR define('THUMBNAIL_DOCUMENT_IMAGE_PATH','uploads/document/thumbnail/');
defined('SOS_IMAGE_PATH') OR define('SOS_IMAGE_PATH','uploads/sos/');
defined('THUMBNAIL_SOS_IMAGE_PATH') OR define('THUMBNAIL_SOS_IMAGE_PATH','uploads/sos/thumbnail/');
defined('VEHICLE_IMAGE_PATH') OR define('VEHICLE_IMAGE_PATH','uploads/vehicle/');
defined('THUMBNAIL_VEHICLE_IMAGE_PATH') OR define('THUMBNAIL_VEHICLE_IMAGE_PATH','uploads/vehicle/thumbnail/');
defined('IMAGE_PDF_UPLOAD_MESSAGE') OR define('IMAGE_PDF_UPLOAD_MESSAGE', 'Accepted formats: jpeg, png, jpg, JPG, mp4,pdf Max file size 4Mb');
defined('IMAGE_UPLOAD_MESSAGE') OR define('IMAGE_UPLOAD_MESSAGE', 'Accepted formats: jpeg, png, jpg, JPG Max file size 4Mb');
defined('DOCUMENT_FOLDER_UPLOAD_MESSAGE') OR define('DOCUMENT_FOLDER_UPLOAD_MESSAGE', 'Accepted formats: jpeg, png, jpg, JPG, pdf, PDF Max file size 4Mb');
defined('MEETING_UPLOAD_MESSAGE') OR define('MEETING_UPLOAD_MESSAGE', 'Accepted formats: mp3, ogg, jpg, jpeg, pdf, PDF Max file size 4Mb');
defined('MAX_IMAGE_SIZE_LIMIT') OR define('MAX_IMAGE_SIZE_LIMIT', 40960000);
defined('FILE_UPLOAD_TYPE') OR define('FILE_UPLOAD_TYPE', 'png,jpeg,jpg,pdf');
defined('FILE_UPLOAD_TYPE_MSG') OR define('FILE_UPLOAD_TYPE_MSG', 'Accepted formats: jpeg, png, jpg ,JPG Max file size 4Mb');
defined('DOCUMENT_FILE_UPLOAD_TYPE_MSG') OR define('DOCUMENT_FILE_UPLOAD_TYPE_MSG', 'xlsx | xls');
defined('MAX_DOCUMENT_SIZE_LIMIT') OR define('MAX_DOCUMENT_SIZE_LIMIT', 40960000);

defined('REST_ENABLE_LOGGING') OR define('REST_ENABLE_LOGGING', TRUE);
defined('RENTAL_PREFIX') OR define('RENTAL_PREFIX', 'RNT-');
defined('MATERIAL_PREFIX') OR define('MATERIAL_PREFIX', 'MAT-');
defined('INVOICE_PREFIX') OR define('INVOICE_PREFIX', 'INV-');
defined('BUILDER') OR define('BUILDER', 'Builder');
defined('MEMBER_GROUP') OR define('MEMBER_GROUP', 'member_group');
defined('GUARD_GROUP') OR define('GUARD_GROUP', 'guard');
defined('MASTER_DB') OR define('MASTER_DB', 'yoursonlysmco_master');
defined('THIS_MONTH') OR define('THIS_MONTH', date("m-Y"));
// defined('MASTER_DB') OR define('MASTER_DB', 'society_master_db');


// live
defined('DB_HOST') OR define('DB_HOST','localhost');
defined('DB_USER') OR define('DB_USER','yoursonlysmco_dtv');
defined('DB_PASS') OR define('DB_PASS','3hk~L?RBG=b]&d?I');


// Email Constants
defined('EMAIL_HOST') OR define('EMAIL_HOST', 'email-smtp.eu-west-1.amazonaws.com');
defined('EMAIL_PORT') OR define('EMAIL_PORT', '587');
defined('EMAIL_SMTP_SECURE') OR define('EMAIL_SMTP_SECURE', 'tls');
defined('FROM_EMAIL') OR define('FROM_EMAIL', 'notifications@fredungenx.co.in');
defined('FROM_NAME') OR define('FROM_NAME', 'VIDI');
defined('EMAIL_USERNAME') OR define('EMAIL_USERNAME', 'AKIAI77IUAMEH4NPVRCQ');
defined('EMAIL_PASSWORD') OR define('EMAIL_PASSWORD', 'AuIUi2Bp3r5Xj7TzUEamumiOyGT4tQsCFwOwwYfJti+r');

/* STRING CONSTANTS*/
defined('NO_ACCESS_SECTION')  OR define('NO_ACCESS_SECTION', 'You do not have enough priviledges to view this section.');
defined('DATE_FORMATE_MYSQL_YMD') OR define('DATE_FORMATE_MYSQL_YMD', '%Y-%m-%d');
defined('TODAY_DATE') OR define('TODAY_DATE', date("d-m-Y"));
defined('TODAY_DATE_YMD') OR define('TODAY_DATE_YMD', date("Y-m-d"));
defined('LAST_MONTH_DMY') OR define('LAST_MONTH_DMY', date('01-m-Y', strtotime('first day of last month')) . ' - ' . date('t-m-Y', strtotime('last month')));
defined('LAST_MONTH') OR define('LAST_MONTH', date('d-m-Y', strtotime('first day of last month')) . ' - ' . date('d-m-Y', strtotime('last day of last month')));



//SITESETTING CONSTANTS
defined('TODAY_DATE_TIME_YMD') OR define('TODAY_DATE_TIME_YMD', date("Y-m-d H:i:s"));
defined('PHP_DATE_FORMATE') OR define('PHP_DATE_FORMATE', 'd-m-Y');
defined('PHP_TIME_FORMATE') OR define('PHP_TIME_FORMATE', 'H:i:s');
defined('PHP_TIME_MYSQL_FORMAT') OR define('PHP_TIME_MYSQL_FORMAT', '%h:%i:%s %p');
defined('DATE_FORMATE') OR define('DATE_FORMATE', 'dd-mm-yy');
defined('DATE_FORMATE_MYSQL') OR define('DATE_FORMATE_MYSQL', '%d-%m-%Y');
defined('DATE_TIME_FORMATE_MYSQL') OR define('DATE_TIME_FORMATE_MYSQL', '%d-%m-%Y %H:%i:%s');
defined('PERPAGE_DISPLAY') OR define('PERPAGE_DISPLAY', 25);
defined('DATATABLE_MINIMUM_DELAY') OR define('DATATABLE_MINIMUM_DELAY', 1000);
defined('DATATABLE_MINIMUM_INPUT_LENGTH') OR define('DATATABLE_MINIMUM_INPUT_LENGTH', 3);
defined('DATATABLE_MAXIMUM_INPUT_LENGTH') OR define('DATATABLE_MAXIMUM_INPUT_LENGTH', 15);
defined('SELECT2_MINIMUM_INPUT_LENGTH') OR define('SELECT2_MINIMUM_INPUT_LENGTH', 1);
defined('SELECT2_MAXIMUM_INPUT_LENGTH') OR define('SELECT2_MAXIMUM_INPUT_LENGTH', 15);
defined('SELECT2_MINIMUM_DELAY') OR define('SELECT2_MINIMUM_DELAY', 1000);
defined('TRANSFERRED')        OR define('TRANSFERRED', "transferred");
defined('MEETING_RECORD_PATH') OR define('MEETING_RECORD_PATH','uploads/meeting/');
defined('VISITOR_IMAGE_PATH') OR define('VISITOR_IMAGE_PATH','uploads/visitor/');
defined('THUMBNAIL_VISITOR_IMAGE_PATH') OR define('THUMBNAIL_VISITOR_IMAGE_PATH','uploads/visitor/thumbnail/');
defined('FLAT_MEMBER_IMAGE_PATH') OR define('FLAT_MEMBER_IMAGE_PATH','uploads/flatMember/');
defined('THUMBNAIL_FLAT_MEMBER_IMAGE_PATH') OR define('THUMBNAIL_FLAT_MEMBER_IMAGE_PATH','uploads/flatMember/thumbnail/');
defined('RENTALS_IMAGE_PATH') OR define('RENTALS_IMAGE_PATH','uploads/rentals/');
defined('THUMBNAIL_RENTALS_IMAGE_PATH') OR define('THUMBNAIL_RENTALS_IMAGE_PATH','uploads/rentals/thumbnail/');
defined('QR_CODE_IMAGE_PATH') OR define('QR_CODE_IMAGE_PATH','uploads/qrcode/');
defined('EVENT_QR_CODE_IMAGE_PATH') OR define('EVENT_QR_CODE_IMAGE_PATH','uploads/qrcode/event/');
defined('COMPLAIN_IMAGE_PATH') OR define('COMPLAIN_IMAGE_PATH','uploads/complain/');
defined('THUMBNAIL_COMPLAIN_IMAGE_PATH') OR define('THUMBNAIL_COMPLAIN_IMAGE_PATH','uploads/complain/thumbnail/');
defined('COMPLAIN_PREFIX') OR define('COMPLAIN_PREFIX', 'C000');
defined('EVENT_IMAGE_PATH') OR define('EVENT_IMAGE_PATH', 'uploads/event/');
defined('THUMBNAIL_EVENT_IMAGE_PATH') OR define('THUMBNAIL_EVENT_IMAGE_PATH', 'uploads/event/thumbnail/');
defined('STAFF_IMAGE_PATH') OR define('STAFF_IMAGE_PATH','uploads/staff/');
defined('THUMBNAIL_STAFF_IMAGE_PATH') OR define('THUMBNAIL_STAFF_IMAGE_PATH','uploads/staff/thumbnail/');
defined('SOCIETY_IMAGE_PATH') OR define('SOCIETY_IMAGE_PATH','uploads/society/');
defined('THUMBNAIL_SOCIETY_IMAGE_PATH') OR define('THUMBNAIL_SOCIETY_IMAGE_PATH','uploads/society/thumbnail/');
defined('ITEM_IMAGE_PATH') OR define('ITEM_IMAGE_PATH','uploads/item/');
defined('THUMBNAIL_ITEM_IMAGE_PATH') OR define('THUMBNAIL_ITEM_IMAGE_PATH','uploads/item/thumbnail/');
defined('ID_PROOF_PATH') OR define('ID_PROOF_PATH','uploads/visitor/idProof/');
defined('THUMBNAIL_ID_PROOF_PATH') OR define('THUMBNAIL_ID_PROOF_PATH','uploads/visitor/idProof/thumbnail/');

defined('USER_IMAGE_PATH') OR define('USER_IMAGE_PATH','uploads/user/');
defined('THUMBNAIL_USER_IMAGE_PATH') OR define('THUMBNAIL_USER_IMAGE_PATH','uploads/user/thumbnail/');

defined('RESOURCE_IMAGE_PATH') OR define('RESOURCE_IMAGE_PATH','uploads/resource/');
defined('THUMBNAIL_RESOURCE_IMAGE_PATH') OR define('THUMBNAIL_RESOURCE_IMAGE_PATH','uploads/resource/thumbnail/');

define('UPLOAD_REL_PATH', FCPATH."uploads/");

/*********  Service Constant *******/
defined('FIRST_DATE_CURRENT_FINANCIAL') OR define('FIRST_DATE_CURRENT_FINANCIAL', date("01-04-Y") );
defined('LAST_DATE_CURRENT_FINANCIAL') OR define('LAST_DATE_CURRENT_FINANCIAL', date('31-03-') .(date('Y')+1));
defined('CURRENT_FINANCIAL') OR define('CURRENT_FINANCIAL', date('01-04-') .(date('Y')-1));
defined('LAST_CURRENT_FINANCIAL') OR define('LAST_CURRENT_FINANCIAL', date("31-03-Y") );
defined('OTP_CODE') OR define('OTP_CODE','1234');
defined('DELIVERY_OTP_CODE') OR define('DELIVERY_OTP_CODE','123456');
defined('DEV_ENVIRONMENT') OR define('DEV_ENVIRONMENT', "development");
defined('GATE_KEEPER') OR define('GATE_KEEPER', "gate_keeper");
defined('MEMBER_APP') OR define('MEMBER_APP', "member");
defined('MANAGER_APP') OR define('MANAGER_APP', "manager");
defined('MANAGER_PERMISSION') OR define('MANAGER_PERMISSION', "manager");
defined('GATE_KEEPER_URL') OR define('GATE_KEEPER_URL', "society_gate_keeper://");
defined('MEMBER_URL') OR define('MEMBER_URL', "youronly://");

defined('FLAT_OWNER_COLOR_CODE') OR define('FLAT_OWNER_COLOR_CODE', '#ecd3d3');
defined('VISITOR_COLOR_CODE') OR define('VISITOR_COLOR_CODE', '#eeeddf');
defined('FREE_SLOT_COLOR_CODE') OR define('FREE_SLOT_COLOR_CODE', '#dfeee4');

defined('ENTERED_COLOR_CODE') OR define('ENTERED_COLOR_CODE', '#2acb58');
defined('EXITED_COLOR_CODE') OR define('EXITED_COLOR_CODE', '#cb2a2a');
defined('PENDING_COLOR_CODE') OR define('PENDING_COLOR_CODE', '#cbc02a');
defined('IS_SHOW_MOBILE_NO') OR define('IS_SHOW_MOBILE_NO', 1);
defined('PASSWORD') OR define('PASSWORD', 12345678);
defined('BEFORE_MINUTES_SCAN') OR define('BEFORE_MINUTES_SCAN', 15);
// defined('MANAGER_APP') OR define('MANAGER_APP', "admin");
defined('MANAGER_URL') OR define('MANAGER_URL', "society_manager://");
defined('APP_ID') OR define('APP_ID', "fd9f886e-ead2-4607-9b8f-657369c3cdbb");
defined('NO_OF_RECORDING') OR define('NO_OF_RECORDING', '3');
defined('RECORDING_LIMIT') OR define('RECORDING_LIMIT', '20'); //  ALWAYS IN SECOND

defined('DATERANGEPICKER_MIN_DATE') OR define('DATERANGEPICKER_MIN_DATE', date('d-m-Y', strtotime('-0 days')));


// resource type
defined('RESOURCE_TYPE_MEMBER') OR define('RESOURCE_TYPE_MEMBER', "member");
defined('RESOURCE_TYPE_MANAGER') OR define('RESOURCE_TYPE_MANAGER', "manager");

defined('ROUND_DECIMAL_POINT')        OR define('ROUND_DECIMAL_POINT', 2);
defined('TAX_DECIMAL_POINT')        OR define('TAX_DECIMAL_POINT', 3);