<ul class="nav nav-tabs" role="tablist">
	<li class="nav-item">
		<button type="button" class="nav-link active" role="tab" data-bs-toggle="tab" data-bs-target="#warranty_detail" aria-controls="warranty_detail" aria-selected="true">
			<?= lang('Warranty.warranty_detail'); ?>
		</button>
	</li>
	
</ul>

<div class="tab-content">
	<div class="tab-pane fade show active" id="warranty_detail" role="tabpanel">
		<div class="table-responsive text-nowrap">
			<table id="warranty_detail_table" class="table table-xs">
				<thead>
					<tr>
						<th><?= lang("CommonMessage.common_detail"); ?></th>
						<th><?= lang("CommonMessage.common_value"); ?></th>
					</tr>
				</thead>
				<tbody>
					<tr>
						<td><?= lang("Warranty.warranty_for"); ?></td>
						<td><?php
							echo (isset($warranty_data['warranty_for']) && $warranty_data['warranty_for'] != "") ? underscoreToUcWord($warranty_data['warranty_for']) : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang("Warranty.item"); ?></td>
						<td><?php
							echo (isset($warranty_data['item_name']) && $warranty_data['item_name'] != "") ? $warranty_data['item_name'] : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang("Warranty.manufacturer"); ?></td>
						<td><?php
							echo (isset($warranty_data['manufacturer_name']) && $warranty_data['manufacturer_name'] != "") ? $warranty_data['manufacturer_name'] : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang("Warranty.vendor"); ?></td>
						<td><?php
							echo (isset($warranty_data['vendor_name']) && $warranty_data['vendor_name'] != "") ? $warranty_data['vendor_name'] : '-';
							?>
						</td>
					</tr>
					<tr>
                        <td><?= lang("Warranty.warranty_period_from"); ?></td>
                        <td><?php
                            echo (isset($warranty_data['warranty_period_from']) && $warranty_data['warranty_period_from'] != "") ? YMDToDMY($warranty_data['warranty_period_from']) : '-';
                            ?>
                        </td>
                    </tr>


                    <tr>
                        <td><?= lang("Warranty.warranty_period_to"); ?></td>
                        <td><?php
                            echo (isset($warranty_data['warranty_period_to']) && $warranty_data['warranty_period_to'] != "") ? YMDToDMY($warranty_data['warranty_period_to']) : '-';
                            ?>
                        </td>
                    </tr>
					
					
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_created_at"); ?></td>
						<td><?php
							echo (isset($warranty_data['created_at']) && isValidDate($warranty_data['created_at'])) ? siteDateFormat($warranty_data['created_at'], TRUE) : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_created_by"); ?></td>
						<td><?php
							echo (isset($warranty_data['created_by']) && $warranty_data['created_by'] != "") ? $warranty_data['created_by'] : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_updated_at"); ?></td>
						<td><?php
							echo (isset($warranty_data['updated_at']) && isValidDate($warranty_data['updated_at'])) ? siteDateFormat($warranty_data['updated_at'], TRUE) : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_updated_by"); ?></td>
						<td><?php
							echo (isset($warranty_data['updated_by']) && $warranty_data['updated_by'] != "") ? $warranty_data['updated_by'] : '-';
							?></td>
					</tr>
				</tbody>
			</table>
		</div>
	</div>
	
</div>