<div class="row">
    <div class="col-md-12">
        <div class="card mb-4">
            <div class="card-header d-flex align-items-center justify-content-between">
                <h5 class="mb-0"><?= lang('Warranty.warranty_detail'); ?></h5>
            </div>
            <div class="card-body">
                <?php
                //create  form open tag
                $form_id = array(
                    'id' => 'form_warranty',
                );
                echo form_open_multipart('', $form_id);
                $warrantyId = (isset($warranty_data['warranty_id']) && ($warranty_data['warranty_id'] != '')) ? $warranty_data['warranty_id'] : '';
                ?>
                <input type="hidden" id="warranty_id" name="warranty_id" value="<?= $warrantyId ?>">

                <div class="row mb-3">
                        <label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Warranty.warranty_for');?><span class="text-danger"> *</span></label>
                        <div class="col-sm-10">
                            <?php
                                $warrantyFors = warrantyFor();
                            ?>
                            <select data-placeholder="Select  <?= lang('Warranty.warranty_for'); ?>" name="warranty_for"
                                id="warranty_for" class="select2 form-select dt-warranty-for">
                                <option value=""> </option>
                                <?php
                                $selectedWarrantyFor = isset($warranty_data['warranty_for']) ? $warranty_data['warranty_for'] : "";
                                foreach ($warrantyFors as $warrantyKey => $warrantyFor) { ?>
                                    <option <?= ($selectedWarrantyFor == $warrantyKey) ? "selected" : ""; ?>
                                        value="<?= $warrantyKey; ?>"> <?= $warrantyFor; ?> </option>
                                <?php } ?>
                            </select>
                        </div>
                    </div>

                
                    <div class="row mb-3">
                        <label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Warranty.item'); ?><span
                                    class="text-danger"> *</span></label>
                        <div class="col-sm-10">
                            <select id="item_id" name="item_id" class="select2 form-select form-select-lg itemDd"
                                    data-allow-clear="true">
                                <option></option>
                                <?php if (isset($warranty_data['item_id']) && $warranty_data['item_id'] != 0) { ?>
                                    <option value="<?= isset($warranty_data['item_id']) ? $warranty_data['item_id'] : 0 ?>"
                                            selected> <?= isset($warranty_data['item_name']) ? $warranty_data['item_name'] : '' ?> </option>
                                <?php } ?>
                            </select>
                        </div>
                    </div>

                <div class="row mb-3">
                    <label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Warranty.manufacturer'); ?><span
                                class="text-danger"> *</span></label>
                    <div class="col-sm-10">
                        <select id="manufacturer_id" name="manufacturer_id"  class="select2 form-select form-select-lg manufacturerDd dt-manufacturer" data-placeholder="Select <?= lang('Warranty.manufacturer'); ?>"
                                data-allow-clear="true">
                            <?php if (isset($warranty_data['manufacturer_id']) && $warranty_data['manufacturer_id'] != 0) { ?>
                                <option value="<?= isset($warranty_data['manufacturer_id']) ? $warranty_data['manufacturer_id'] : 0 ?>"
                                        selected> <?= isset($warranty_data['manufacturer_name']) ? $warranty_data['manufacturer_name'] : '' ?> </option>
                            <?php } ?>
                        </select>
                    </div>
                </div>

                <div class="row mb-3">
                    <label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Warranty.vendor'); ?><span
                                class="text-danger"> *</span></label>
                    <div class="col-sm-10">
                        <select id="vendor_id" name="vendor_id"  class="select2 form-select form-select-lg vendorDd dt-vendor" data-placeholder="Select <?= lang('Warranty.vendor'); ?>"
                                data-allow-clear="true">
                            <?php if (isset($warranty_data['vendor_id']) && $warranty_data['vendor_id'] != 0) { ?>
                                <option value="<?= isset($warranty_data['vendor_id']) ? $warranty_data['vendor_id'] : 0 ?>"
                                        selected> <?= isset($warranty_data['vendor_name']) ? $warranty_data['vendor_name'] : '' ?> </option>
                            <?php } ?>
                        </select>
                    </div>
                </div>
                <div class="row mb-3">
                    <label class="col-sm-2 col-form-label"
                           for="basic-default-name"><?= lang('Warranty.warranty_period_from'); ?><span class="text-danger"> *</span></label>
                    <div class="col-sm-10">
                        <td>
                            <input type="text" name="warranty_period_from" id="warranty_period_from"
                            class="form-control dt-warranty-period-from" placeholder="Select <?= lang('Warranty.warranty_period_from'); ?>" value="<?= isset($warranty_data['warranty_period_from']) ? YMDToDMY($warranty_data['warranty_period_from']) : ""; ?>" readonly/>
                        </td>
                    </div>
                </div>

                <div class="row mb-3">
                    <label class="col-sm-2 col-form-label"
                           for="basic-default-name"><?= lang('Warranty.warranty_period_to'); ?><span
                                class="text-danger"> *</span></label>
                    <div class="col-sm-10">
                        <td>
                            <input type="text" name="warranty_period_to" id="warranty_period_to"
                            class="form-control dt-warranty-period-to" placeholder="Select <?= lang('Warranty.warranty_period_to'); ?>" value="<?= isset($warranty_data['warranty_period_to']) ? YMDToDMY($warranty_data['warranty_period_to']) : ""; ?>" readonly/>
                        </td>
                    </div>
                </div>

                <hr class="my-4 mx-n4" />
                <h6> <?= lang('Warranty.vendor_contact_information'); ?></h6>
                <div class="row">
                    <?= isset($vendor_contact_table) ? $vendor_contact_table : ""; ?>
                </div>
                <hr class="my-4 mx-n4" />

                <div class="row mb-3">
                    <label class="col-sm-2 col-form-label"
                           for="basic-default-name"><?= lang('CommonMessage.common_active'); ?></label>
                    <div class="col-sm-10">
                        <label class="switch switch-sm"><span class="switch-label"></span>
                            <input type="checkbox" class="switch-input form-add-switchery" name="is_active"
                                   id="is_active" <?php echo (!isset($warranty_data['is_active']) || $warranty_data['is_active'] == 1) ? 'checked="checked"' : ''; ?>/>
                            <span class="switch-toggle-slider">
		                              <span class="switch-on"></span>
		                              <span class="switch-off"></span>
		                            </span>

                        </label>
                    </div>
                </div>
                <div class="pt-4">
                    <button type="submit" id="submitBtn"
                            class="btn btn-primary me-sm-3 me-1 submit"><?= lang('CommonMessage.common_submit'); ?></button>
                    <button type="button" id="cancelBtn" onclick="window.location.href='<?php echo admin_url('Warranty'); ?>'"
                            class="btn btn-label-secondary"> <?= lang('CommonMessage.common_cancel'); ?></button>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
</div>

<script>

    // let fromPeriod;
    // let toPeriod;

    // function fromAndToPeriod() {
    //     var fromPeriod = $(".dt-warranty-period-from").flatpickr({
    //         //monthSelectorType: 'static',
    //         dateFormat: 'd-m-Y',
    //         onChange: function (selectedDates, dateStr, instance) {
    //             toPeriod.set('minDate', dateStr)
    //         }
    //     });

    //     var toPeriod = $(".dt-warranty-period-to").flatpickr({
    //         //monthSelectorType: 'static',
    //         dateFormat: 'd-m-Y',
    //     });
    // }

    $(document).ready(function () {
        // fromAndToPeriod();
        $(".manufacturerDd").select2();
        itemDd();
        vendorDd();
        $(".dt-warranty-for").select2();
        switcheryKeyGen("datatable-list-switchery");
        addSerialNumber("vendor_mobile_table");
        // Initialize
        var validator = $("#form_warranty").validate({
            ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
            errorClass: 'validation-invalid-label',
            successClass: 'validation-valid-label',
            validClass: 'validation-valid-label',
            highlight: function (element, errorClass) {
                $(element).removeClass(errorClass);
            },
            unhighlight: function (element, errorClass) {
                $(element).removeClass(errorClass);
            },
            success: function (label) {
                label.addClass('validation-valid-label').text('Success.'); // remove to hide Success message
            },
            // Different components require proper error label placement
            errorPlacement: function (error, element) {

                // Unstyled checkboxes, radios
                if (element.parents().hasClass('form-check')) {
                    error.appendTo(element.parents('.form-check').parent());
                }

                // Input with icons and Select2
                else if (element.parents().hasClass('form-group row-feedback') || element.hasClass('select2-hidden-accessible')) {
                    error.appendTo(element.parent());
                }

                // Input group, styled file input
                else if (element.parent().is('.uniform-uploader, .uniform-select') || element.parents().hasClass('input-group')) {
                    error.appendTo(element.parent().parent());
                }

                // Other elements
                else {
                    error.insertAfter(element);
                }
            },
            rules: {
                warranty_name: {
                    required: true
                },
                warranty_for: {
                    required: true
                },
                item_id: {
                    required: true
                },
                manufacturer_id: {
                    required: true
                },
                vendor_id: {
                    required: true
                },
                warranty_period_from: {
                    required: true
                },
                warranty_period_to: {
                    required: true
                },
            },
            messages: {
                warranty_name: {
                    required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('Warranty.warranty_name');?>"
                },
                warranty_for: {
                    required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('Warranty.warranty_for');?>"
                },
                manufacturer_id: {
                    required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('Warranty.manufacturer');?>"
                },
                item_id: {
                    required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('Warranty.item');?>"
                },
                vendor_id: {
                    required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('Warranty.vendor');?>"
                },
                warranty_period_from: {
                    required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('Warranty.warranty_period_from');?>"
                },
                warranty_period_to: {
                    required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('Warranty.warranty_period_to');?>"
                },
            },
            submitHandler: function (e) {
                $(e).ajaxSubmit({
                    url: '<?php echo admin_url("Warranty/save");?>',
                    type: 'post',
                    beforeSubmit: function (formData, jqForm, options) {
                        dtButtonHide('#submitBtn');
						dtButtonHide('#cancelBtn');
                    },
                    complete: function () {

                    },
                    dataType: 'json',
                    clearForm: false,
                    success: function (resObj, statusText) {
						if (resObj.success) {
							toastr.success(resObj.msg, 'Success', {
								closeButton: true,
								progressBar: true,
								positionClass: 'toast-top-right',
								timeOut: 1000,
                                onHidden: function () {
                                    dtButtonShow('#submitBtn');
									dtButtonShow('#cancelBtn');
                                    window.location.href = '<?php echo admin_url('Warranty');?>';
                                }
							});

							// setTimeout(function () {
							// 	window.location.href = '<?php echo admin_url('Warranty');?>';
							// }, 1000);

						} else {
                            dtButtonShow('#submitBtn');
                            dtButtonShow('#cancelBtn');
							toastr.error(resObj.msg, 'Error', {
								closeButton: true,
								// progressBar: true,
								positionClass: 'toast-top-right',
								// timeOut: 1000
							});
						}
					}
                });
            }
        });
    });

    $(document).on('change', '#vendor_id', function () {
        var vendorId      = $(this).val();
        $.ajax({
            type: "POST",
            url: "<?php echo admin_url('Warranty/getVendorContactTableRow'); ?>",
            dataType: "json",
            data: {
                vendor_id : vendorId,
            },
            delay: '<?= SELECT2_MINIMUM_DELAY; ?>',
            beforeSend: function (formData, jqForm, options) {
            },
            complete: function () {
            },
            success: function (resObj) {
                if (resObj.success) {
                    $('#vendor_mobile_table tbody').html(resObj.vendor_row_data);
                    addSerialNumber('vendor_mobile_table');
                } else {
                    console.log("ELSE");
                    console.log(resObj);
                    $('#vendor_mobile_table tbody').html(resObj.vendor_row_data);
                    addSerialNumber('vendor_mobile_table');
                }
            }
        });
    });
</script>

<?= isset($select2_ajax) ? $select2_ajax : ""; ?>
