<?php
$html = '';
if (isset($vendor_mobile_data) && !empty($vendor_mobile_data)) {
	foreach ($vendor_mobile_data as $key => $value) {
		$data["row_number"] = $key + 1;
		$data["vendor_mobile_data"] = $value;
		$html .= view('Admin/Vendor/VendorMobileRowView', $data);
	}
}
?>
<!-- Responsive Table -->
	<div class="table-responsive text-nowrap">
		<table id="vendor_mobile_table" class="table">
			<thead>
			<tr class="text-nowrap">
				<th><?= lang('CommonMessage.common_sr_no'); ?></th>
				<th><?= lang('Vendor.person_name'); ?><span class="text-danger"> *</span></th>
				<th><?= lang('Vendor.designation'); ?><span class="text-danger"> *</span></th>
				<th><?= lang('Vendor.mobile'); ?><span class="text-danger"> *</span></th>
				<th><?= lang('CommonMessage.common_action'); ?></th>
			</tr>
			</thead>
			<tbody class="table-border-bottom-0">
			<?php
			if (isset($vendor_mobile_data) && !empty($vendor_mobile_data)) {
				echo $html;
			}else { ?>
				<?php
				$data["row_number"] =  1;
				echo view('Admin/Vendor/VendorMobileRowView',$data); ?>
			<?php } ?>

			</tbody>
		</table>
	</div>
<!--/ Responsive Table -->
<script>
	var rowNumber;

	function addVendorMobile() {
		var lastIndex = ($("#vendor_mobile_table tbody tr:last").length >= 1) ? $("#vendor_mobile_table tbody tr:last").attr("data-id").split("_").pop() : 0;
		rowNumber = parseInt(lastIndex) + 1;
		$.ajax({
			type: "post",
			url: "<?= admin_url('Vendor/addVendorMobileRow'); ?>",
			dataType: "html",
			async: false,
			data: {
				row_number: rowNumber,
			},
			success: function (data) {
				if (data) {
					$('table#vendor_mobile_table tbody').append(data);
					addSerialNumber('vendor_mobile_table');
					vendorMobile();
					numberInit();
				}
			}
		});
	}


	$(document).on('click', '.dt-delete-vendor-row', function () {
		var trField = $(this).closest('tr');
		var id = $(this).closest('tr').find(".vendor_mobile_id").val();
		var vendorId = $("#vendor_id").val();

		if (id != '') {
				Swal.fire({
					title: "<?= ucwords(lang('CommonMessage.delete')); ?>",
					text: "<?= lang('CommonMessage.delete_warning'); ?>",
					icon: 'warning',
					showCancelButton: true,
					confirmButtonText: 'OK',
					customClass: {
						confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
						cancelButton: 'btn btn-label-secondary waves-effect waves-light'
					},
					buttonsStyling: false

			}).then(function (result) {
				if (result.value) {
					var deleteId = [];
					deleteId.push(id);
					$.ajax({
						type: "POST",
						url: "<?php echo admin_url('Vendor/deleteVendorMobileRow');?>",
						dataType: "json",
						async:false,
						data: {
							vendor_mobile_id: deleteId,
							vendor_id: vendorId
						},
						success: function (resObj) {
							if (resObj.success) {
								$(trField).remove();
								addSerialNumber('vendor_mobile_table');
								Swal.fire({
									title: 'Success',
									text: resObj['msg'],
									icon: 'success',
									customClass: {
										confirmButton: 'btn btn-primary waves-effect waves-light'
									},
									buttonsStyling: false
								}).then(function() {
									if ($('#vendor_mobile_table tbody > tr').length == 0) {
										addVendorMobile();
									}
								});
							} else {
								Swal.fire({
									title: 'Error!',
									text: resObj['msg'],
									icon: 'error',
									customClass: {
										confirmButton: 'btn btn-primary waves-effect waves-light'
									},
									buttonsStyling: false
								});
							}
						}
					});
				}
			});
		} else {
			$(trField).remove();
			addSerialNumber('vendor_mobile_table');
			if ($('#vendor_mobile_table tbody > tr').length == 0) {
				addVendorMobile();
			}
		}
	});


</script>
