<div class="row">
	<div class="col-md-12">
		<div class="card mb-4">
			<div class="card-header d-flex align-items-center justify-content-between">
				<h5 class="mb-0"><?= lang('TagAssign.tag_assign_detail');?></h5>
			</div>
			<div class="card-body">
				<?php
				//create  form open tag
				$form_id = array(
					'id'=>'form_tag',
				);
				echo form_open_multipart('',$form_id);
				$tagAssign = (isset($tag_assign_data['tag_assign_id']) && ($tag_assign_data['tag_assign_id'] != '')) ? $tag_assign_data['tag_assign_id'] : '';
				?>
				<input type="hidden" id="tag_assign_id" name="tag_assign_id" value="<?= $tagAssign ?>">
				<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('TagAssign.flat');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">
							<select id="flat_id" name="flat_id" class="select2 form-select form-select-lg flatDd" data-allow-clear="true">
								<option></option>
								<?php if(isset($tag_assign_data['flat_id']) && $tag_assign_data['flat_id'] != 0){ ?>
                       				 <option value="<?= isset($tag_assign_data['flat_id']) ? $tag_assign_data['flat_id'] : 0 ?>" selected> <?= isset($tag_assign_data['flat_no']) ? $tag_assign_data['flat_no'] : ''  ?> </option>
                    			<?php } ?>
							</select>
						</div>
					</div>
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('TagAssign.tag');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">
							<select id="tag_id" name="tag_id" class="select2 form-select form-select-lg tagDd" data-allow-clear="true">
								<option></option>
								<?php if(isset($tag_assign_data['tag_id']) && $tag_assign_data['tag_id'] != 0){ ?>
                       				 <option value="<?= isset($tag_assign_data['tag_id']) ? $tag_assign_data['tag_id'] : 0 ?>" selected> <?= isset($tag_assign_data['tag_no']) ? $tag_assign_data['tag_no'] : ''  ?> </option>
                    			<?php } ?>
							</select>
						</div>
					</div>
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('TagAssign.issue_date');?><span class="text-danger"> *</span></label>
							<div class="col-sm-10">
									<input type="text"  name="issue_date" id="issue_date" class="form-control dt-issue-date" placeholder="Select <?= lang('TagAssign.issue_date'); ?>" value="<?= isset($tag_assign_data['issue_date']) ? YMDToDMY($tag_assign_data['issue_date']): ""; ?>"/>
							</div>
					</div>
					<div class="pt-4">
						<button type="submit" id="submitBtn" class="btn btn-primary me-sm-3 me-1 submit"><?= lang('CommonMessage.common_submit'); ?></button>
						<button type="button" id="cancelBtn" onclick="window.location.href='<?php echo admin_url('TagAssign'); ?>'" class="btn btn-label-secondary"> <?= lang('CommonMessage.common_cancel'); ?></button>
					</div>
				<?php echo form_close(); ?>
			</div>
		</div>
	</div>
</div>

<script>
    $(document).ready(function() {
    	numberInit();
		flatDd();
		tagDd();
		switcheryKeyGen("datatable-list-switchery");
        // Initialize
		var validator = $("#form_tag").validate({
			ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
			errorClass: 'validation-invalid-label',
			successClass: 'validation-valid-label',
			validClass: 'validation-valid-label',
			highlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			unhighlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			success: function(label) {
				label.addClass('validation-valid-label').text('Success.'); // remove to hide Success message
			},
			// Different components require proper error label placement
			errorPlacement: function(error, element) {

				// Unstyled checkboxes, radios
				if (element.parents().hasClass('form-check')) {
					error.appendTo( element.parents('.form-check').parent() );
				}

				// Input with icons and Select2
				else if (element.parents().hasClass('form-group row-feedback') || element.hasClass('select2-hidden-accessible')) {
					error.appendTo( element.parent() );
				}

				// Input group, styled file input
				else if (element.parent().is('.uniform-uploader, .uniform-select') || element.parents().hasClass('input-group')) {
					error.appendTo( element.parent().parent() );
				}

				// Other elements
				else {
					error.insertAfter(element);
				}
			},
            rules: {
				tag_id: {
					required: true
				},
				flat_id: {
					required: true
				},
				issue_date: {
					required: true
				},
            },
            messages: {
				tag_id: {
					required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('TagAssign.tag');?>"
				},
				flat_id: {
					required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('TagAssign.flat');?>"
				},
				issue_date: {
					required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('TagAssign.issue_date');?>"
				},
            },
            submitHandler: function (e) {
				$(e).ajaxSubmit({
					url: '<?php echo admin_url("TagAssign/save");?>',
					type: 'post',
					beforeSubmit: function (formData, jqForm, options) {
						dtButtonHide('#submitBtn');
						dtButtonHide('#cancelBtn');
					},
					complete: function () {

					},
					dataType: 'json',
					clearForm: false,
					success: function (resObj, statusText) {
						if (resObj.success) {
							toastr.success(resObj.msg, 'Success', {
								closeButton: true,
								progressBar: true,
								positionClass: 'toast-top-right',
								timeOut: 1000,
								onHidden: function () {
                                    dtButtonShow('#submitBtn');
									dtButtonShow('#cancelBtn');
                                    window.location.href = '<?php echo admin_url('TagAssign');?>';
                                }
							});

							// setTimeout(function () {
							// 	window.location.href = '<?php echo admin_url('TagAssign');?>';
							// }, 1000);

						} else {
							dtButtonShow("#submitBtn");
							dtButtonShow('#cancelBtn');
							toastr.error(resObj.msg, 'Error', {
								closeButton: true,
								// progressBar: true,
								positionClass: 'toast-top-right',
								// timeOut: 1000
							});
						}
					}
				});
            }
        });
    });

	$("#issue_date").flatpickr({
			// monthSelectorType: 'static',
    		// enableTime: true,
    		dateFormat: "d-m-Y",
			// dateFormat: 'd-m-Y'
		});
</script>

<?= isset($select2_ajax) ? $select2_ajax : ""; ?>
