<div class="row">
	<div class="col-md-12">
		<div class="card mb-4">
			<div class="card-header d-flex align-items-center justify-content-between">
				<h5 class="mb-0"><?= lang('Tag.tag_detail');?></h5>
			</div>
			<div class="card-body">
				<?php
				//create  form open tag
				$form_id = array(
					'id'=>'form_tag',
				);
				echo form_open_multipart('',$form_id);
				$tagId = (isset($tag_data['tag_id']) && ($tag_data['tag_id'] != '')) ? $tag_data['tag_id'] : '';
				?>
				<input type="hidden" id="tag_id" name="tag_id" value="<?= $tagId ?>">
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Tag.tag_type');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">
							<?php
								$tagTypes = tagType();
							?>
							<select data-placeholder="Select  <?= lang('Tag.tag_type'); ?>" name="tag_type"
								id="tag_type" class="select2 form-select dt-tag-type">
								<option value=""> </option>
								<?php
								$selectedTagType = isset($tag_data['tag_type']) ? $tag_data['tag_type'] : "";
								foreach ($tagTypes as $tagTypeKey => $tagType) { ?>
									<option <?= ($selectedTagType == $tagTypeKey) ? "selected" : ""; ?>
										value="<?= $tagTypeKey; ?>"> <?= $tagType; ?> </option>
								<?php } ?>
							</select>
						</div>
					</div>
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Tag.tag_no');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">	
							<input type="text" class="form-control" name="tag_no" id="tag_no" placeholder="Enter <?= lang('Tag.tag_no');?>" value="<?= (isset($tag_data['tag_no']) && ($tag_data['tag_no'] != '')) ? $tag_data['tag_no'] : '';  ?>" />
						</div>
					</div>
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('CommonMessage.common_active');?></label>
							<div class="col-sm-10">
							<label class="switch switch-sm"><span class="switch-label"></span>
								<input type="checkbox" class="switch-input form-add-switchery"  name="is_active" id="is_active" <?php echo (!isset($tag_data['is_active']) || $tag_data['is_active'] == 1) ? 'checked="checked"' : ''; ?>/>
								<span class="switch-toggle-slider">
		                              <span class="switch-on"></span>
		                              <span class="switch-off"></span>
		                            </span>
								
							</label>
						</div>
					</div>
					<div class="pt-4">
						<button type="submit" id="submitBtn" class="btn btn-primary me-sm-3 me-1 submit"><?= lang('CommonMessage.common_submit'); ?></button>
						<button type="button" id="cancelBtn" onclick="window.location.href='<?php echo admin_url('Tag'); ?>'" class="btn btn-label-secondary"> <?= lang('CommonMessage.common_cancel'); ?></button>
					</div>
				<?php echo form_close(); ?>
			</div>
		</div>
	</div>
</div>

<script>
    $(document).ready(function() {
    	numberInit();
		switcheryKeyGen("datatable-list-switchery");
		$(".dt-tag-type").select2();
        // Initialize
		var validator = $("#form_tag").validate({
			ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
			errorClass: 'validation-invalid-label',
			successClass: 'validation-valid-label',
			validClass: 'validation-valid-label',
			highlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			unhighlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			success: function(label) {
				label.addClass('validation-valid-label').text('Success.'); // remove to hide Success message
			},
			// Different components require proper error label placement
			errorPlacement: function(error, element) {

				// Unstyled checkboxes, radios
				if (element.parents().hasClass('form-check')) {
					error.appendTo( element.parents('.form-check').parent() );
				}

				// Input with icons and Select2
				else if (element.parents().hasClass('form-group row-feedback') || element.hasClass('select2-hidden-accessible')) {
					error.appendTo( element.parent() );
				}

				// Input group, styled file input
				else if (element.parent().is('.uniform-uploader, .uniform-select') || element.parents().hasClass('input-group')) {
					error.appendTo( element.parent().parent() );
				}

				// Other elements
				else {
					error.insertAfter(element);
				}
			},
            rules: {
				tag_type: {
					required: true
				},
				tag_no: {
					required: true
				},
            },
            messages: {
				tag_type: {
					required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('Tag.tag_type');?>"
				},
				tag_no: {
					required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('Tag.tag_no');?>"
				},
            },
            submitHandler: function (e) {
				$(e).ajaxSubmit({
					url: '<?php echo admin_url("Tag/save");?>',
					type: 'post',
					beforeSubmit: function (formData, jqForm, options) {
						dtButtonHide('#submitBtn');
						dtButtonHide('#cancelBtn');
					},
					complete: function () {

					},
					dataType: 'json',
					clearForm: false,
					success: function (resObj, statusText) {
						if (resObj.success) {
							toastr.success(resObj.msg, 'Success', {
								closeButton: true,
								progressBar: true,
								positionClass: 'toast-top-right',
								timeOut: 1000,
								onHidden: function () {
                                    dtButtonShow('#submitBtn');
									dtButtonShow('#cancelBtn');
                                    window.location.href = '<?php echo admin_url('Tag');?>';
                                }
							});

							// setTimeout(function () {
							// 	window.location.href = '<?php echo admin_url('Tag');?>';
							// }, 1000);

						} else {
							dtButtonShow("#submitBtn");
							dtButtonShow('#cancelBtn');
							toastr.error(resObj.msg, 'Error', {
								closeButton: true,
								// progressBar: true,
								positionClass: 'toast-top-right',
								// timeOut: 1000
							});
						}
					}
				});
            }
        });
    });
</script>

<?= isset($select2_ajax) ? $select2_ajax : ""; ?>
