<?php
$assets = base_url() . 'assets/';
$staffData = !empty($staff_data) && is_array($staff_data) ? $staff_data : array(); ?>
<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<title><?= $name; ?></title>
	<link href="https://fonts.googleapis.com/css?family=Roboto:400,300,100,500,700,900" rel="stylesheet"
		  type="text/css">

	<link href="<?= $assets ?>css/pdf_bootstrap.css" rel="stylesheet" type="text/css">
	<link href="<?= $assets ?>css/pdf_style_sheet.css" rel="stylesheet" type="text/css">

</head>

<body style='font-family:chelvetica;font-size: 9px'>
<div class="row">
	<div class="col-xs-12">
		<h3 style="color: red;text-align: center;"><?= lang('Staff.staff_details'); ?></h3>
		<table class="table" border="1" cellpadding="1" cellspacing="1" width="100%">
			<tbody>
				<tr>
					<td colspan="7" rowspan="2" ><center><strong><?= lang('Staff.staff'); ?></center></td>
					<td colspan="3" ><center><strong>
						<?= isset($staffData["society_name"]) ? $staffData["society_name"] : ""; ?>
                            </strong></center></td>
				</tr>
				<tr>
					<td colspan="3" ><center>
						<?= isset($staffData["staff_type"]) ? underscoreToUcWord($staffData["staff_type"]) : ""; ?></center>
					</td>
				</tr>
				<tr>
					<td colspan="2">
                        <center><strong><?= lang('Staff.name'); ?></strong></center>
					</td>
					<td colspan="4">
						<?= isset($staffData["staff_name"]) ? $staffData["staff_name"] : ""; ?>
					</td>
					<td colspan="4" rowspan="5" class="photo-cell">
					<?php 
                    if(isset($staff_image_data) && is_array($staff_image_data) && !empty($staff_image_data)){
                        	if(file_exists(STAFF_IMAGE_PATH . $staff_image_data[0]['staff_image'])){
		                        $paths = site_url() . STAFF_IMAGE_PATH .$staff_image_data[0]['staff_image']; ?> &nbsp;&nbsp;&nbsp;
		                 		<a href="<?= $paths; ?>" target="_blank"> <img src="<?= $paths; ?>" width="100" class="img-fluid" alt=""></a>
            		<?php }} ?>
					</td>
				</tr>
				<tr>
					<td colspan="2">
                        <center><strong><?= lang('Staff.father_name'); ?></strong></center>
					</td>
					<td colspan="4">
						<?= isset($staffData["father_name"]) ? $staffData["father_name"] : ""; ?>
					</td>
				</tr>
				<tr>
					<td colspan="2">
                        <center><strong><?= lang('Staff.date_of_birth'); ?></strong></center>
					</td>
					<td colspan="4">
						<?= isset($staffData["date_of_birth"]) ? siteDateFormat($staffData["date_of_birth"]) : ""; ?>
					</td>
				</tr>
				<tr>
					<td colspan="2">
                        <center><strong><?= lang('Staff.gender'); ?></strong></center>
					</td>
					<td colspan="4">
						<?= isset($staffData["gender"]) ? underscoreToUcWord($staffData["gender"]) : ""; ?>
					</td>
				</tr>
				<tr>
					<td colspan="2">
                        <center><strong><?= lang('Staff.work'); ?></strong></center>
					</td>
					<td colspan="4">
						<?= isset($staffData["work"]) ? $staffData["work"] : ""; ?>
					</td>
				</tr>
				<tr>
					<td colspan="2">
                        <center><strong><?= lang('Staff.contact_no'); ?></strong></center>
					</td>
					<td colspan="8">
						<?= isset($staffData["contact_no"]) ? $staffData["contact_no"] : ""; ?>
					</td>
				</tr>
				<tr>
					<td colspan="2">
                        <center><strong><?= lang('Staff.present_address'); ?></strong></center>
					</td>
					<td colspan="8">
						<?= isset($staffData["present_address"]) ? $staffData["present_address"] : ""; ?>
					</td>
				</tr>
				<tr>
					<td colspan="2">
                        <center><strong><?= lang('Staff.permanent_address'); ?></strong></center>
					</td>
					<td colspan="8">
						<?= isset($staffData["permanent_address"]) ? $staffData["permanent_address"] : ""; ?>
					</td>
				</tr>
				<tr>
					<td colspan="2">
                        <center><strong><?= lang('Staff.reference'); ?></strong></center>
					</td>
					<td colspan="8">
						<?= isset($staffData["reference"]) ? $staffData["reference"] : ""; ?>
					</td>
				</tr>
				<tr>
					<td colspan="9" rowspan="3" class="declaration-cell">
						<strong>Declaration</strong><br>
						The above-mentioned information is true &amp; correct. If any discrepancy is found, I am responsible for any action taken by society. The rules set by society will be followed by me.
					</td>
					<td ><center><?= lang('Staff.sign'); ?></center></td>
				</tr>
				<tr>
					<td rowspan="3" style="height: 200"></td>
				</tr>
			</tbody>
		</table>	
	</div>
</div>
</body>
</html>
