<ul class="nav nav-tabs" role="tablist">
	<li class="nav-item">
		<button type="button" class="nav-link active" role="tab" data-bs-toggle="tab" data-bs-target="#sos_detail" aria-controls="sos_detail" aria-selected="true">
			<?= lang('Sos.sos_detail'); ?>
		</button>
	</li>
</ul>

<div class="tab-content">
	<div class="tab-pane fade show active" id="sos_detail" role="tabpanel">
		<div class="table-responsive text-nowrap">
			<table id="sos_detail_table" class="table table-xs">
				<thead>
					<tr>
						<th><?= lang("CommonMessage.common_detail"); ?></th>
						<th><?= lang("CommonMessage.common_value"); ?></th>
					</tr>
				</thead>
				<tbody>
					<tr>
						<td><?= lang("Sos.sos_name"); ?></td>
						<td><?php
							echo (isset($sos_data['sos_name']) && $sos_data['sos_name'] != "") ? $sos_data['sos_name'] : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang("Sos.sos_image"); ?></td>
						<td>
							<?php 
		                        	if(isset($sos_data['sos_image']) && file_exists(SOS_IMAGE_PATH . $sos_data['sos_image'])){
				                        $paths = site_url() . SOS_IMAGE_PATH . $sos_data['sos_image']; ?> 
				                 		<span class="document-image-<?= $sos_data['sos_id']; ?>">
				                 			<a href="<?= $paths; ?>" target="_blank"> <img src="<?= $paths; ?>" width="100" class="img-fluid" alt=""> </a>
				        				</span>
		            		<?php } ?>
						</td>
					</tr>
					
					
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_created_at"); ?></td>
						<td><?php
							echo (isset($sos_data['created_at']) && isValidDate($sos_data['created_at'])) ? siteDateFormat($sos_data['created_at'], TRUE) : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_created_by"); ?></td>
						<td><?php
							echo (isset($sos_data['created_by']) && $sos_data['created_by'] != "") ? $sos_data['created_by'] : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_updated_at"); ?></td>
						<td><?php
							echo (isset($sos_data['updated_at']) && isValidDate($sos_data['updated_at'])) ? siteDateFormat($sos_data['updated_at'], TRUE) : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_updated_by"); ?></td>
						<td><?php
							echo (isset($sos_data['updated_by']) && $sos_data['updated_by'] != "") ? $sos_data['updated_by'] : '-';
							?></td>
					</tr>
				</tbody>
			</table>
		</div>
	</div>
</div>