<div class="row">
	<div class="col-md-12">
		<div class="card mb-4">
			<div class="card-header d-flex align-items-center justify-content-between">
				<h5 class="mb-0"><?= lang('Sos.sos_detail');?></h5>
			</div>
			<div class="card-body">
				<?php
				//create  form open tag
				$form_id = array(
					'id'=>'form_sos',
				);
				echo form_open_multipart('',$form_id);
				$sosId = (isset($sos_data['sos_id']) && ($sos_data['sos_id'] != '')) ? $sos_data['sos_id'] : '';
				?>
				<input type="hidden" id="sos_id" name="sos_id" value="<?= $sosId ?>">
				<div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Sos.sos_name');?><span class="text-danger"> *</span></label>
					<div class="col-sm-10">	
						<input type="text" class="form-control" name="sos_name" id="sos_name" placeholder="Enter <?= lang('Sos.sos_name');?>" value="<?= (isset($sos_data['sos_name']) && ($sos_data['sos_name'] != '')) ? $sos_data['sos_name'] : '';  ?>" />
					</div>
				</div>

				<div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Sos.sos_image');?><span class="text-danger"> *</span></label>
					<div class="col-sm-10">
						<input type="file" accept="image/*" class="form-control" name="sos_image">
						<?php 
		                    if(isset($sos_data['sos_image']) && file_exists(SOS_IMAGE_PATH . $sos_data['sos_image'])){
		                    	$thumbnailPaths = site_url() . THUMBNAIL_SOS_IMAGE_PATH . $sos_data['sos_image']; 
				                $paths = site_url() . SOS_IMAGE_PATH . $sos_data['sos_image']; ?> &nbsp;&nbsp;&nbsp;
				            	<span class="document-image-<?= $sos_data['sos_id']; ?>">
				            		<a href="<?= $paths; ?>" target="_blank"> 
										<img src="<?= $thumbnailPaths; ?>" width="100" class="img-fluid" alt=""> 
									</a>
				    			</span>
		            	<?php } ?>
					</div>
				</div>
                
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('CommonMessage.common_active');?></label>
							<div class="col-sm-10">
							<label class="switch switch-sm"><span class="switch-label"></span>
								<input type="checkbox" class="switch-input form-add-switchery"  name="is_active" id="is_active" <?php echo (!isset($sos_data['is_active']) || $sos_data['is_active'] == 1) ? 'checked="checked"' : ''; ?>/>
								<span class="switch-toggle-slider">
		                            <span class="switch-on"></span>
		                            <span class="switch-off"></span>
		                        </span>
								
							</label>
						</div>
					</div>
					<div class="pt-4">
						<button type="submit" class="btn btn-primary me-sm-3 me-1"><?= lang('CommonMessage.common_submit'); ?></button>
						<button type="button" onclick="window.location.href='<?php echo admin_url('Sos'); ?>'" class="btn btn-label-secondary"> <?= lang('CommonMessage.common_cancel'); ?></button>
					</div>
				<?php echo form_close(); ?>
			</div>
		</div>
	</div>
</div>

<script>
    $(document).ready(function() {
    	numberInit();
		switcheryKeyGen("datatable-list-switchery");
        // Initialize
		var validator = $("#form_sos").validate({
			ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
			errorClass: 'validation-invalid-label',
			successClass: 'validation-valid-label',
			validClass: 'validation-valid-label',
			highlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			unhighlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			success: function(label) {
				label.addClass('validation-valid-label').text('Success.'); // remove to hide Success message
			},
			// Different components require proper error label placement
			errorPlacement: function(error, element) {

				// Unstyled checkboxes, radios
				if (element.parents().hasClass('form-check')) {
					error.appendTo( element.parents('.form-check').parent() );
				}

				// Input with icons and Select2
				else if (element.parents().hasClass('form-group row-feedback') || element.hasClass('select2-hidden-accessible')) {
					error.appendTo( element.parent() );
				}

				// Input group, styled file input
				else if (element.parent().is('.uniform-uploader, .uniform-select') || element.parents().hasClass('input-group')) {
					error.appendTo( element.parent().parent() );
				}

				// Other elements
				else {
					error.insertAfter(element);
				}
			},
            rules: {
				sos_name: {
					required: true
				},
				<?php
        		if($sosId == '') { ?>
					sos_image:{
						required : true,
	                },
            	<?php } ?>
            },
            messages: {
				sos_name: {
					required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('Sos.sos_name');?>"
				},
				<?php
        		if($sosId == '') { ?>
					sos_image:{
						required : '<?= lang("CommonMessage.common_please_select"); ?> <?= lang("Sos.sos_image"); ?>',
	                },
	            <?php } ?>
            },
            submitHandler: function (e) {
				$(e).ajaxSubmit({
					url: '<?php echo admin_url("Sos/save");?>',
					type: 'post',
					beforeSubmit: function (formData, jqForm, options) {

					},
					complete: function () {

					},
					dataType: 'json',
					clearForm: false,
					success: function (resObj, statusText) {
						if (resObj.success) {
							toastr.success(resObj.msg, 'Success', {
								closeButton: true,
								progressBar: true,
								positionClass: 'toast-top-right',
								timeOut: 1000
							});

							setTimeout(function () {
								window.location.href = '<?php echo admin_url('Sos');?>';
							}, 1000);

						} else {
							toastr.error(resObj.msg, 'Error', {
								closeButton: true,
								// progressBar: true,
								positionClass: 'toast-top-right',
								// timeOut: 1000
							});
						}
					}
				});
            }
        });
    });
</script>

<?= isset($select2_ajax) ? $select2_ajax : ""; ?>
