<!-- Add New Address Modal -->
<div class="modal fade" id="withdrawn_modal" tabindex="-1" aria-hidden="true">
	<div class="modal-dialog modal-lg modal-simple modal-add-new-address">
		<div class="modal-content p-3 p-md-5">
			<div class="modal-body">
				<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
				<div class="text-center mb-4">
					<h3 class="address-title mb-2"><?= lang('SinkingFund.withdrawn_form'); ?></h3>
				</div>
				<?php
				$form_id = array(
					'id' => 'form_withdrawn',
					'method' => 'post',
					'class' => 'row g-3',
					'autocomplete' => 'off'
				);
				echo form_open_multipart('',$form_id);
				?>
				<input type="hidden" name="sinking_fund_withdrawn_id" id="sinking_fund_withdrawn_id">
				<input type="hidden" name="sinking_funds_id" id="sinking_funds_id">

				<div class="col-12">
					<label class="form-label" for="basic-default-name"><?= lang('SinkingFund.withdrawn_date');?><span class="text-danger"> *</span></label>
						<input type="text"  name="withdrawn_date" id="withdrawn_date" class="form-control dt-on-date" placeholder="Select <?= lang('SinkingFund.withdrawn_date'); ?>"/>
				</div>

				<div class="col-12">
					<label class="form-label" for=""><?= lang('SinkingFund.amount'); ?><span class="text-danger"> *</span></label>
					<input type="text" id="amounts" name="amounts" class="form-control numberInit" placeholder="Enter <?= lang('SinkingFund.amount'); ?>"/>
				</div>

				<div class="col-12">
					<label class="form-label" for=""><?= lang('SinkingFund.remarks'); ?><span class="text-danger"> </span></label>
					<textarea name="remarks"  id="remarks" placeholder="Enter <?= lang('SinkingFund.remarks'); ?>" rows="3" cols="5"  class="form-control"></textarea>
				</div>
				<div class="col-12 text-center">
					<button type="submit" id="submitBtns" class="btn btn-primary me-sm-3 me-1 submit">Submit</button>
					<button
						id="cancelBtns"
						type="reset"
						class="btn btn-label-secondary"
						data-bs-dismiss="modal"
						aria-label="Close">
						Cancel
					</button>
				</div>
				<?= form_close(); ?>
			</div>
		</div>
	</div>
</div>
<!--/ Add New Address Modal -->


<!--  add,update and delete model code here-->
<script type="text/javascript">
	//var laddaSubmitBtn = Ladda.create(document.querySelector('#submit'));
	$(document).ready(function () {
		numberInit();
		//validation
		var validator = $("#form_withdrawn").validate({
			ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
			errorClass: 'validation-invalid-label',
			successClass: 'validation-valid-label',
			validClass: 'validation-valid-label',
			highlight: function (element, errorClass) {
				$(element).removeClass(errorClass);
			},
			unhighlight: function (element, errorClass) {
				$(element).removeClass(errorClass);
			},
			success: function (label) {
				label.addClass('validation-valid-label'); // remove to hide Success message
			},
			// Different components require proper error label placement
			errorPlacement: function (error, element) {
				// Unstyled checkboxes, radios
				if (element.parents().hasClass('form-check')) {
					error.appendTo(element.parents('.form-check').parent());
				}

				// Input with icons and Select2
				else if (element.parents().hasClass('form-group-feedback') || element.hasClass('select2-hidden-accessible')) {
					error.appendTo(element.parent());
				}

				// Input group, styled file input
				else if (element.parent().is('.uniform-uploader, .uniform-select') || element.parents().hasClass('input-group')) {
					error.appendTo(element.parent().parent());
				}

				// Other elements
				else {
					error.insertAfter(element);
				}
			},
			rules: {
				amounts: {
					required: true
				},
				withdrawn_date: {
					required: true
				},
			},
			messages: {
				amounts: {
					required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('SinkingFund.amount'); ?>",
				},
				withdrawn_date: {
					required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('SinkingFund.withdrawn_date'); ?>",
				},
			},
			submitHandler: function (e) {
				$(e).ajaxSubmit({
					url: '<?php echo admin_url("SinkingFund/addEditWithdrawn");?>',
					type: 'post',
					beforeSubmit: function (formData, jqForm, options) {
						dtButtonHide('#submitBtns');
						dtButtonHide('#cancelBtns');
					},
					complete: function () {
						//laddaStop();
					},
					dataType: 'json',
					clearForm: false,
					success: function (resObj, statusText) {
						if (resObj.success) {
							toastr.success(resObj.msg, 'Success', {
								closeButton: true,
								progressBar: true,
								positionClass: 'toast-top-right',
								timeOut: 1000,
                                onHidden: function () {
                                    dtButtonShow('#submitBtns');
									dtButtonShow('#cancelBtns');
                                    $('#withdrawn_modal').modal('hide');
                                    dt_DataTable.ajax.reload(null, false);
                                }
							});
						} else {
							dtButtonShow('#submitBtns');
							dtButtonShow('#cancelBtns');
							toastr.error(resObj.msg, 'Error', {
								closeButton: true,
								// progressBar: true,
								positionClass: 'toast-top-right',
								// timeOut: 1000
							});
						}
					}
				});
			}
		});
	});

	$("#withdrawn_date").flatpickr({
		dateFormat: "d-m-Y",
	});
</script>
<?= isset($select2_ajax) ? $select2_ajax : ""; ?>