<?php
$dtCIAcl = new \App\Libraries\Dt_ci_acl();
?>
<style type="text/css">
	.action-button {
        white-space: nowrap;
        vertical-align: middle;
    }
</style>
<a style="display: none;" href="" class="dt-export-anchor" target="_blank"></a>
<div class="card">
	<div class="card-datatable table-responsive">
		<table id="sinking_fund_table" class="table dt-datatable">
			<thead class="border-top">
			<tr>
				<th><input class="form-check-input datatable-select-all-second" type="checkbox"  /></th>
				<th class="font-weight-bold"><?= lang("SinkingFund.flat"); ?></th>
				<th class="font-weight-bold"><?= lang("SinkingFund.member"); ?></th>
				<th class="font-weight-bold"><?= lang('SinkingFund.financial_year'); ?></th>
				<th class="font-weight-bold"><?= lang('SinkingFund.on_date'); ?></th>
				<th class="font-weight-bold"><?= lang('SinkingFund.for_period'); ?></th>
				<th class="font-weight-bold"><?= lang('SinkingFund.amount'); ?></th>
				<th class="font-weight-bold"><?= lang('SinkingFund.investment_amount'); ?></th>
				<th class="font-weight-bold"><?= lang('SinkingFund.withdrawn_amount'); ?></th>
				<th class="font-weight-bold"><?= lang('CommonMessage.common_updated_at'); ?></th>
				<th class="font-weight-bold"><?= lang('CommonMessage.common_updated_by'); ?></th>
                <th class="font-weight-bold"><?= lang("CommonMessage.common_action"); ?></th>
			</tr>
			</thead>
		</table>
	</div>
</div>
<?= isset($v_investment_modal) ? $v_investment_modal : ""; ?>
<?= isset($v_withdrawn_modal) ? $v_withdrawn_modal : ""; ?>
<script type="text/javascript">
	var dt_DataTable;

	function modalBankDd() {
		$('.bankDd').each(function() {
			var $this = $(this);
			$this.wrap('<div class="position-relative"></div>').select2({
				placeholder: 'Select value',
				dropdownParent: $this.parent(),
				ajax: {
					url: "<?= admin_url('Bank/getBankDd') ?>",
					dataType: 'json',
					type: 'post',
					delay: '<?= SELECT2_MINIMUM_DELAY; ?>',
					data: function(params) {
						return {
							filter_param: params.term || '', // search term
							page: params.page || 1,

						};
					},
					processResults: function(data, params) {
						// parse the results into the format expected by Select2
						// since we are using custom formatting functions we do not need to
						// alter the remote JSON data, except to indicate that infinite
						// scrolling can be used
						//                    params.page = params.page || 1;
						params.page = params.page || 1;
						return {
							results: data.result,
							pagination: {
								more: (data.page * 10) < data.totalRows

							}
						};
					},
					//cache: true
				},
				placeholder: 'Select Bank',
				escapeMarkup: function(markup) {
					return markup;
				}, // let our custom formatter work
				//minimumInputLength: 2,
			}).on('select2:select', function(flat) {
				if ($("#" + $(this).attr('id')).valid()) {
					$("#" + $(this).attr('id')).removeClass('invalid').addClass('success');
				}

			});
		});
	}


	$(document).ready(function () {
		dt_DataTable = $('#sinking_fund_table').DataTable( {
			dom:'<"card-header d-flex border-top rounded-0 flex-wrap py-0"' +
				'<"me-5 ms-n2 pe-5"f>' +
				'<"d-flex justify-content-start justify-content-md-end align-items-baseline"<"dt-action-buttons d-flex flex-column align-items-start align-items-md-center justify-content-sm-center mb-3 mb-md-0 pt-0 gap-4 gap-sm-0 flex-sm-row"lB>>' +
				'>t' +
				'<"row mx-2"' +
				'<"col-sm-12 col-md-6"i>' +
				'<"col-sm-12 col-md-6"p>' +
				'>',
			processing: true,
			serverSide: true,
			displayLength: 10,
			language: {
				sLengthMenu: 'Show _MENU_',
				search: '',
				searchPlaceholder: 'Search <?= lang('SinkingFund.sinking_fund');?>',
				info: 'Displaying _START_ to _END_ of _TOTAL_ entries'
			},
			buttons: [
				{
					extend: 'collection',
					className: 'btn btn-label-secondary px-2 dropdown-toggle me-2 waves-effect waves-light',
					text: '<i class="ti ti-download me-1 ti-xs"></i>Export',
					buttons: [
						{
							text: '<i class="ti ti-file me-2" ></i>Excel',
							className: 'dropdown-item dt-excel-export'
						},
						<?php /* if ($dtCIAcl->checkAccess("SinkingFund|pdf")) { ?> {
							extend: 'pdf',
							text: '<i class="ti ti-file-text me-2"></i>Pdf',
							className: 'dropdown-item',
							action: function() {
								window.location.href = '<?= admin_url('SinkingFund/sinking_fundPdf'); ?>';
							}
						},
						<?php } */?>
					]
				},
				<?php if ($dtCIAcl->checkAccess("SinkingFund|manage")) { ?>
				{
					text: '<i class="ti ti-plus me-0 me-sm-1 ti-xs"></i><span class="d-none d-sm-inline-block"><?= lang('SinkingFund.add_sinking_fund');?></span>',
					className: 'add-new btn btn-primary px-1 me-2',
					action: function () {
						window.location.href = '<?= admin_url("SinkingFund/manage");?>';
					}
				},
				<?php } ?>
				<?php if ($dtCIAcl->checkAccess("SinkingFund|delete")) { ?>
				{
					text: '<i class="ti ti-trash me-0 me-sm-1 ti-xs"></i><span class="d-none d-sm-inline-block"><?= lang('SinkingFund.delete_sinking_fund');?></span>',
					className: 'btn btn-danger  px-1 dt-delete-record',
				},
				<?php } ?>
			],
			"ajax": {
				"url": "<?php echo admin_url('SinkingFund/getSinkingFundListing'); ?>",
				"type": "POST",
				"data": function ( d ) {

				}
			},
			"stateSave": true,
			"order": [[ 0, "asc" ]],
			"columns": [
				{
					"data": "sinking_fund_id",
					"render": function (data, type, row) {
						return '<input class="form-check-input datatable-checkbox" type="checkbox" id="ids_' + row['sinking_fund_id'] + '" name="ids[]" value="' + row['sinking_fund_id'] + '"/>';
					},
					"class": "no_click_allowed",
					"sortable": false,
					"searchable": false
				},
				{"data": "flat_no"},
				{"data": "name"},
				{"data": "financial_year_prefix"},
				{"data": "on_date"},
				{"data": "for_period"},
				{"data": "amount"},
				{"data": "investment_amount"},
				{"data": "withdrawn_amount"},
				{"data": "updated_at"},
				{"data": "updated_by"},
				{
					"data": "action_button",
					"class" : "text-center no_click_allowed action-button",
					"sortable": false,
					"searchable": false
				},
			],
			createdRow: function (row, data, dataIndex) {
			    // First action: for column index 7
			    var col7 = $('td', row).eq(7);
			    col7.addClass('dt-detail-model-view');
			    col7.attr('data-dt_view_id', data['sinking_fund_id']);
			    col7.attr('data-dt_view_url', '<?= admin_url("SinkingFund/investmentView"); ?>');

			    // Second action: for column index 8
			    var col8 = $('td', row).eq(8);
			    col8.addClass('dt-detail-model-view');
			    col8.attr('data-dt_view_id', data['sinking_fund_id']);
			    col8.attr('data-dt_view_url', '<?= admin_url("SinkingFund/withdrawnView"); ?>');
			},
			"fnDrawCallback": function (oSettings, json) {
				customToolTip();
				$('.dataTables_length').addClass('mt-2 mt-sm-0 mt-md-3 me-2');
				$('.dt-buttons').addClass('d-flex flex-wrap');
				$('.dataTables_filter .form-control').removeClass('form-control-sm');
				$('.dataTables_length .form-select').removeClass('form-select-sm');
				//checkBoxRefresh("datatable-checkbox");
				switcheryKeyGen("datatable-list-switchery");

			}
		});
		dtDataTableSearch();
	});

    //Delete Record
    $(document).on('click', '.dt-delete-record', function () {
        var id = $(this).attr("data-id");
        var deleteId = [];
        if(id != undefined){
            $('.datatable-select-all-second').prop('checked', false);
            $('.datatable-checkbox').prop('checked', false);
            $("#ids_" + id).prop("checked", true);
            deleteId.push(id);
        }
        else{
            var deleteElement =$('#sinking_fund_table tbody .datatable-checkbox:checked');
            var selectedLength = deleteElement.length;
            if (selectedLength == 0) {
                Swal.fire({
                    title: "<?= ucwords(lang('CommonMessage.common_sweet_alert_info')); ?>",
                    text: "<?= lang('CommonMessage.delete_info'); ?>",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonText: 'OK',
                    customClass: {
                        confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
                        cancelButton: 'btn btn-label-secondary waves-effect waves-light'
                    },
                    buttonsStyling: false
                }).then(function () {
                    return false;
                });
            } else {
                $.each(deleteElement, function (i, ele) {
                    deleteId.push($(ele).val());
                });
            }
        }
        if (deleteId.length > 0) {
            Swal.fire({
                title: "<?= ucwords(lang('CommonMessage.common_sweet_alert_delete')); ?>",
                text: "<?= lang('CommonMessage.delete_warning'); ?>",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'OK',
                customClass: {
                    confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
                    cancelButton: 'btn btn-label-secondary waves-effect waves-light'
                },
                buttonsStyling: false
            }).then(function(result) {
                if (result.value) {
                    $.ajax({
                        type: "post",
                        url: "<?= admin_url("SinkingFund/delete")?>",
                        dataType: "json",
                        data: {sinking_fund_id: deleteId},
                        success: function (data) {
                            if (data['success']) {
                                Swal.fire({
                                    title: 'Success',
                                    text: data['msg'],
                                    icon: 'success',
                                    customClass: {
                                        confirmButton: 'btn btn-primary waves-effect waves-light'
                                    },
                                    buttonsStyling: false
                                }).then(function() {
                                    dt_DataTable.ajax.reload();
                                });
                            } else {
                                Swal.fire({
                                    title: 'Error!',
                                    text: data['msg'],
                                    icon: 'error',
                                    customClass: {
                                        confirmButton: 'btn btn-primary waves-effect waves-light'
                                    },
                                    buttonsStyling: false
                                }).then(function() {
                                    dt_DataTable.ajax.reload();
                                });
                            }
                        }
                    });
                }
                else {
                    $('.datatable-checkbox').prop('checked', false);
                }
            });
        }
    });

	$(document).on('click', '.datatable-checkbox', function () {
		$(".dt-delete-record").removeClass( "invisible" );

	});

	// $(document).on('click', '.add-investment', function () {
	// 	console.log("zdfdsfsfd");
    //     dtFormClear('form_category');
    //     $("form#form_category input[name=category_id]").val('');
    //     $('#category_modal').modal('show');
    //     Select2InitModalPopup();
    // });

	$(document).on('click', '.dt-excel-export', function() {
		$(this).removeClass(".dt-excel-export");
		var dataTableParams = dt_DataTable.ajax.params();
		url = '<?= admin_url('SinkingFund/excelExportSinkingFund/') . ""  ?>';
		var recursiveEncoded = $.param(dataTableParams);
		$('.dt-export-anchor').attr('href', url + "?" + recursiveEncoded);
		$('.dt-export-anchor')[0].click();
	});


	$(document).on('click', '.add-investment', function () {
		var taskManagementId = $(this).attr('data-id');
		
		if (taskManagementId != 0) {
				// swalInit.fire({
				// 	title: processName.toUpperCase(),
				// 	text: "<?= ucwords(lang('common_start')); ?>" + ' '+ processName,
				// 	type: "<?= lang('warning'); ?>",
				// 	showCancelButton: true,
				// 	closeOnConfirm: false,
				// 	confirmButtonColor: "<?= BTN_DELETE_WARNING; ?>",
				// 	showLoaderOnConfirm: true
				// }).then(function(result) {
				// 	if(result.value) {
						
						dtFormClear('form_investment');
				        $("form#form_investment input[name=sinking_fund_investment_id]").val('');
				        $('#investment_modal').modal('show');
				        $('#sinking_fund_id').val(taskManagementId);
				        modalBankDd();
		// 			}else{
		// 				window.location.href = '<?php echo admin_url('TaskManagement');?>';
		// 			}
		// 		});
		}
	});

	$(document).on('click', '.add-withdrawn', function () {
		var taskManagementId = $(this).attr('data-id');
		
		if (taskManagementId != 0) {
				// swalInit.fire({
				// 	title: processName.toUpperCase(),
				// 	text: "<?= ucwords(lang('common_start')); ?>" + ' '+ processName,
				// 	type: "<?= lang('warning'); ?>",
				// 	showCancelButton: true,
				// 	closeOnConfirm: false,
				// 	confirmButtonColor: "<?= BTN_DELETE_WARNING; ?>",
				// 	showLoaderOnConfirm: true
				// }).then(function(result) {
				// 	if(result.value) {
						
						dtFormClear('form_withdrawn');
				        $("form#form_withdrawn input[name=sinking_fund_withdrawn_id]").val('');
				        $('#withdrawn_modal').modal('show');
				        $('#sinking_funds_id').val(taskManagementId);
		// 			}else{
		// 				window.location.href = '<?php echo admin_url('TaskManagement');?>';
		// 			}
		// 		});
		}
	});
</script>
<?= isset($select2_ajax) ? $select2_ajax : ""; ?>
