
<div class="table-responsive text-nowrap">
	<table id="investment_details_table" class="table table-bordered" data-sinking-fund-id="<?= $sinking_fund_id ?>">
		<thead>
			<tr>
				<th class="text-center" style="width: 5%"><?= lang("CommonMessage.common_sr_no"); ?></th>
				<th style="width: 10%"><?= lang("SinkingFund.bank"); ?></th>
				<th style="width: 10%"><?= lang("SinkingFund.investment_date"); ?></th>
				<th style="width: 10%"><?= lang("SinkingFund.amount"); ?></th>
				<th style="width: 10%"><?= lang("CommonMessage.common_action"); ?></th>
			</tr>
		</thead>
		<tbody class="">
        	<?php if($sinking_fund_investment_data != '' && array_filter($sinking_fund_investment_data)) {
                $sr = 1;
                foreach ($sinking_fund_investment_data as $key => $value) {?>
					<tr>
						<td class="text-center"><?= $sr; ?></td>
                        <td colspan="1"><?= $value['bank_name']; ?> </td>
                        <td colspan="1"><?= YMDToDMY($value['on_date']); ?> </td>
                        <td colspan="1"><?= $value['amount']; ?> </td>
                        <td colspan="1">
						    <!-- EDIT Button -->
						    <a href="javascript:void(0);" 
						       data-bs-toggle="tooltip" 
						       data-id="<?= $value['sinking_fund_investment_id'] ?>" 
						       data-bs-placement="top" 
						       data-bs-custom-class="custom-tooltip" 
						       title="<?= lang('SinkingFund.edit_investment'); ?>" 
						       class="btn btn-sm btn-icon edit-investment">
						        <i class="ti ti-pencil"></i>
						    </a>

						    <!-- DELETE Button -->
						    <a href="javascript:void(0);"
						       class="btn btn-sm btn-icon text-danger delete-investment"
						       data-id="<?= $value['sinking_fund_investment_id']; ?>"
						       title="<?= lang('CommonMessage.common_delete'); ?>">
						        <i class="ti ti-trash"></i>
						    </a>
						</td>
					</tr>
                <?php $sr++;} }  else {?>
				<tr>
					<td colspan="5" align="center"> <?= lang('CommonMessage.common_no_data_found'); ?></td>
				</tr>
			<?php } ?>
		</tbody>
	</table>
</div>

<script type="text/javascript">
	$(document).on('click', '.edit-investment', function () {
	    var sinkingFundInvestmentId = $(this).data('id');

	    $.ajax({
	        url: '<?= admin_url("SinkingFund/getSinkingFundInvestmentData"); ?>',
	        type: 'POST',
	        data: { sinking_fund_investment_id: sinkingFundInvestmentId },
	        dataType: 'json',
	        success: function (response) {
	        	console.log(response);
	            if (response.success) {
	            	$('#view_module_detail').modal('hide'); 
	                $('#sinking_fund_investment_id').val(response.data.sinking_fund_investment_id);
	                $('#sinking_fund_id').val(response.data.sinking_fund_id);

	                var onDate = response.data.on_date;
					var parts = onDate.split('-');
					var formattedDate = parts[2] + '-' + parts[1] + '-' + parts[0];


	                $('#on_date').val(formattedDate);
	                $('#amount').val(response.data.amount);

	            	
	                var bankId = 0;
					var bankName = '';
					$.each(response.data, function(key,val ) {
						if (key == 'bank_id') {
							bankId = val;
						} else if (key == 'bank_name') {
							bankName = val;
						}
					});

					if (bankId != 0) {
						var bankOption = new Option(bankName, bankId, true, true);
						$('#bank_id').append(bankOption).trigger('change');
					}


	                $('#investment_modal').modal('show');
	            } else {
	                alert("<?= lang('CommonMessage.common_error_occurred'); ?>");
	            }
	        }
	    });
	});

	$(document).on('click', '.delete-investment', function () {
	    var sinkingFundInvestmentId = $(this).data('id');
	    var sinkingFundId = $('#investment_details_table').data('sinking-fund-id');
	    Swal.fire({
            title: "<?= ucwords(lang('CommonMessage.common_sweet_alert_delete')); ?>",
            text: "<?= lang('CommonMessage.delete_warning'); ?>",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'OK',
            customClass: {
                confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
                cancelButton: 'btn btn-label-secondary waves-effect waves-light'
            },
            buttonsStyling: false
        }).then(function(result) {
            if (result.value) {
            	$.ajax({
                    type: "post",
                    url: "<?= admin_url("SinkingFund/deleteInvestment")?>",
                    dataType: "json",
                    data: {sinking_fund_investment_id: sinkingFundInvestmentId},
                    success: function (data) {
                        if (data['success']) {
                            Swal.fire({
                                title: 'Success',
                                text: data['msg'],
                                icon: 'success',
                                customClass: {
                                    confirmButton: 'btn btn-primary waves-effect waves-light'
                                },
                                buttonsStyling: false
                            }).then(function() {
                                dt_DataTable.ajax.reload();
                                reloadInvestmentTable(sinkingFundId);
                            });
                        } else {
                            Swal.fire({
                                title: 'Error!',
                                text: data['msg'],
                                icon: 'error',
                                customClass: {
                                    confirmButton: 'btn btn-primary waves-effect waves-light'
                                },
                                buttonsStyling: false
                            }).then(function() {
                               dt_DataTable.ajax.reload();
                                reloadInvestmentTable(sinkingFundId);
                            });
                        }
                    }
                });
            }
        	else {
                
            }
        });
    });

    function reloadInvestmentTable(sinkingFundId) {
	    $.ajax({
	        url: '<?= admin_url("SinkingFund/investmentView"); ?>',
	        type: 'GET',
	        data: { view_id: sinkingFundId },
	        dataType: 'json', 
	        success: function (response) {
	            if (response.success && response.view_detail) {
	                $('#investment_details_table').closest('.table-responsive').html(response.view_detail);
	            } else {
	                console.error("Invalid view_detail or success false");
	            }
	        },
	        error: function (xhr, status, error) {
	            console.error("AJAX error:", error);
	        }
	    });
	}
</script>