<style>
	.form-controls {
		display: block;
		padding: 0.422rem 0.875rem;
		font-size: 0.9375rem;
		font-weight: 400;
		line-height: 1.5;
		color: #6f6b7d;
		appearance: none;
		background-color: #fff;
		background-clip: padding-box;
		border: var(--bs-border-width) solid #dbdade;
		border-radius: var(--bs-border-radius);
		transition: border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out;
	}

	.form-selects {
		--bs-form-select-bg-img: url(data:image/svg+xml,%3Csvg width= '20' height= '20' viewBox= '0 0 20 20' fill= 'none' xmlns= 'http://www.w3.org/2000/svg' %3E%3Cpath d= 'M5 7.5L10 12.5L15 7.5' stroke= '%236f6b7d' stroke-width= '1.5' stroke-linecap= 'round' stroke-linejoin= 'round' /%3E%3Cpath d= 'M5 7.5L10 12.5L15 7.5' stroke= 'white' stroke-opacity= '0.2' stroke-width= '1.5' stroke-linecap= 'round' stroke-linejoin= 'round' /%3E%3C/svg%3E);
		display: block;
		padding: 0.422rem 2.45rem 0.422rem 0.875rem;
		font-size: 0.9375rem;
		font-weight: 400;
		line-height: 1.5;
		color: #6f6b7d;
		appearance: none;
		background-color: #fff;
		background-image: var(--bs-form-select-bg-img), var(--bs-form-select-bg-icon, none);
		background-repeat: no-repeat;
		background-position: right 0.875rem center;
		background-size: 22px 20px;
		border: var(--bs-border-width) solid #dbdade;
		border-radius: var(--bs-border-radius);
		transition: border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out;
	}
</style>

<?php
$html = '';
if (isset($rentals_parking_data) && !empty($rentals_parking_data)) {
	foreach ($rentals_parking_data as $key => $value) {
		$data["parking_row_number"] = $key + 1;
		$data["rentals_parking_data"] = $value;
		$html .= view('Admin/Rentals/RentalsParkingRowView', $data);
	}
}
?>
<!-- Responsive Table -->
	<div class="table-responsive text-nowrap">
		<table id="rentals_parking_table" class="table">
			<thead>
			<tr class="text-nowrap">
				<th><?= lang('CommonMessage.common_sr_no'); ?></th>
				<th><?= lang('Rentals.vehicle_type'); ?><span class="text-danger"> *</span></th>
				<th><?= lang('Rentals.vehicle_no'); ?></th>
				<th><?= lang('Rentals.parking_slot'); ?><span class="text-danger"> </span></th>
				<!-- <th><?= lang('Rentals.parking_slot_no'); ?></th> -->
				<th><?= lang('Rentals.token_no'); ?></th>
				<th><?= lang('Rentals.is_electric'); ?></th>
				<th><?= lang('Rentals.vehicle_image'); ?></th>
				<th><?= lang('CommonMessage.common_action'); ?></th>
			</tr>
			</thead>
			<tbody class="table-border-bottom-0">
			<?php
			if (isset($rentals_parking_data) && !empty($rentals_parking_data)) {
				echo $html;
			}else { ?>
				<?php
				$data["parking_row_number"] =  1;
				echo view('Admin/Rentals/RentalsParkingRowView',$data); ?>
			<?php } ?>

			</tbody>
		</table>
	</div>
<!--/ Responsive Table -->
<script>
	var parkingRowNumber;

	function addRentalsParking() {
		var lastIndex = ($("#rentals_parking_table tbody tr:last").length >= 1) ? $("#rentals_parking_table tbody tr:last").attr("data-id").split("_").pop() : 0;
		parkingRowNumber = parseInt(lastIndex) + 1;
		$.ajax({
			type: "post",
			url: "<?= admin_url('Rentals/addRentalsParkingRow'); ?>",
			dataType: "html",
			async: false,
			data: {
				parking_row_number: parkingRowNumber,
			},
			success: function (data) {
				if (data) {
					$('table#rentals_parking_table tbody').append(data);
					addSerialNumber('rentals_parking_table');
					parkingSlotDd();
					rentalsParking();
					customToolTip();
				}
			}
		});
	}


	$(document).on('click', '.dt-delete-parking-row', function () {
		var trField = $(this).closest('tr');
		var id = $(this).closest('tr').find(".ownership_flat_parking_id").val();
		var rentalsId = $("#rentals_id").val();

		if (id != '') {
				Swal.fire({
					title: "<?= ucwords(lang('CommonMessage.common_sweet_alert_delete')); ?>",
					text: "<?= lang('CommonMessage.delete_warning'); ?>",
					icon: 'warning',
					showCancelButton: true,
					confirmButtonText: 'OK',
					customClass: {
						confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
						cancelButton: 'btn btn-label-secondary waves-effect waves-light'
					},
					buttonsStyling: false

			}).then(function (result) {
				if (result.value) {
					var deleteId = [];
					deleteId.push(id);
					$.ajax({
						type: "POST",
						url: "<?php echo admin_url('Rentals/deleteRentalsParkingRow');?>",
						dataType: "json",
						async:false,
						data: {
                            ownership_flat_parking_id: deleteId,
							rentals_id: rentalsId
						},
						success: function (resObj) {
							if (resObj.success) {
								$(trField).remove();
								addSerialNumber('rentals_parking_table');
								Swal.fire({
									title: 'Success',
									text: resObj['msg'],
									icon: 'success',
									customClass: {
										confirmButton: 'btn btn-primary waves-effect waves-light'
									},
									buttonsStyling: false
								}).then(function() {
									if ($('#rentals_parking_table tbody > tr').length == 0) {
										addRentalsParking();
									}
								});
							} else {

								Swal.fire({
									title: 'Error!',
									text: resObj['msg'],
									icon: 'error',
									customClass: {
										confirmButton: 'btn btn-primary waves-effect waves-light'
									},
									buttonsStyling: false
								});
							}
						}
					});
				}
			});
		} else {
			$(trField).remove();
			addSerialNumber('rentals_parking_table');
			if ($('#rentals_parking_table tbody > tr').length == 0) {
				addRentalsParking();
			}
		}
	});


</script>
