<ul class="nav nav-tabs" role="tablist">
	<li class="nav-item">
		<button type="button" class="nav-link active" role="tab" data-bs-toggle="tab" data-bs-target="#rentals_detail" aria-controls="rentals_detail" aria-selected="true">
			<?= lang('Rentals.rentals_detail'); ?>
		</button>
	</li>
	<li class="nav-item">
		<button type="button" class="nav-link" role="tab" data-bs-toggle="tab" data-bs-target="#closed-information" aria-controls="closed-information" aria-selected="false">
			<?= lang('Rentals.closed_information'); ?>
		</button>
	</li>
	<li class="nav-item">
		<button type="button" class="nav-link" role="tab" data-bs-toggle="tab" data-bs-target="#member-information" aria-controls="member-information" aria-selected="false">
			<?= lang('Rentals.member_information'); ?>
		</button>
	</li>
	<li class="nav-item">
		<button type="button" class="nav-link" role="tab" data-bs-toggle="tab" data-bs-target="#emergency-contact" aria-controls="emergency-contact" aria-selected="false">
			<?= lang('Rentals.emergency_informations'); ?>
		</button>
	</li>
	<li class="nav-item">
		<button type="button" class="nav-link" role="tab" data-bs-toggle="tab" data-bs-target="#vehicle-detail" aria-controls="vehicle-detail" aria-selected="false">
			<?= lang('Rentals.parking_information'); ?>
		</button>
	</li>
	<?php /*
	<li class="nav-item">
		<button type="button" class="nav-link" role="tab" data-bs-toggle="tab" data-bs-target="#access-card-detail" aria-controls="access-card-detail" aria-selected="false">
			<?= lang('Rentals.access_card_information'); ?>
		</button>
	</li> */ ?>
	<li class="nav-item">
		<button type="button" class="nav-link" role="tab" data-bs-toggle="tab" data-bs-target="#attached-document" aria-controls="attached-document" aria-selected="false">
			<?= lang('Rentals.rentals_document'); ?>
		</button>
	</li>
</ul>

<div class="tab-content">
	<div class="tab-pane fade show active" id="rentals_detail" role="tabpanel">
		<div class="table-responsive text-nowrap">
			<table id="rentals_detail_table" class="table table-xs">
				<thead>
					<tr>
						<th><?= lang("CommonMessage.common_detail"); ?></th>
						<th><?= lang("CommonMessage.common_value"); ?></th>
					</tr>
				</thead>
				<tbody>
				<tr>
						<td><?= lang("Rentals.rental_number"); ?></td>
						<td><?php
							echo (isset($rentals_data['document_number']) && $rentals_data['document_number'] != "") ? $rentals_data['document_number'] : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang("Rentals.flat_no"); ?></td>
						<td><?php
							echo (isset($rentals_data['flat_no']) && $rentals_data['flat_no'] != "") ? $rentals_data['flat_no'] : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang("Rentals.bhk"); ?></td>
						<td><?php
							echo (isset($rentals_data['bhk']) && $rentals_data['bhk'] != "") ? roundNumber($rentals_data['bhk']) : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang("Rentals.sq_ft"); ?></td>
						<td><?php
							echo (isset($rentals_data['sqr_ft']) && $rentals_data['sqr_ft'] != "") ? roundNumber($rentals_data['sqr_ft']) : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang("Rentals.intercom_no"); ?></td>
						<td><?php
							echo (isset($rentals_data['intercom_no']) && $rentals_data['intercom_no'] != "") ? $rentals_data['intercom_no'] : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang("Rentals.resident"); ?></td>
						<td><?php
							echo (isset($rentals_data['resident']) && $rentals_data['resident'] != "") ? $rentals_data['resident'] : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang("Rentals.owner_member"); ?></td>
						<td><?php
							echo (isset($rentals_data['owner_member_name']) && $rentals_data['owner_member_name'] != "") ? $rentals_data['owner_member_name'] : '-';
							?>
						</td>
					</tr>

					<tr>
						<td><?= lang("Rentals.owner_contact_no"); ?></td>
						<td><?php
							echo (isset($rentals_data['owner_contact_no']) && $rentals_data['owner_contact_no'] != "") ? $rentals_data['owner_contact_no'] : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang("Rentals.broker"); ?></td>
						<td><?php
							echo (isset($rentals_data['broker_name']) && $rentals_data['broker_name'] != "") ? $rentals_data['broker_name'] : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang("Rentals.broker_contact_no"); ?></td>
						<td><?php
							echo (isset($rentals_data['broker_contact_no']) && $rentals_data['broker_contact_no'] != "") ? $rentals_data['broker_contact_no'] : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang("Rentals.tenant_name"); ?></td>
						<td><?php
							echo (isset($rentals_data['tenant_name']) && $rentals_data['tenant_name'] != "") ? $rentals_data['tenant_name'] : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang("Rentals.tenant_contact_no"); ?></td>
						<td><?php
							echo (isset($rentals_data['tenant_contact_no']) && $rentals_data['tenant_contact_no'] != "") ? $rentals_data['tenant_contact_no'] : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang("Rentals.tenant_email"); ?></td>
						<td><?php
							echo (isset($rentals_data['tenant_email']) && $rentals_data['tenant_email'] != "") ? $rentals_data['tenant_email'] : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang("Rentals.rent_agreement_period_from"); ?></td>
						<td><?php
							echo (isset($rentals_data['rent_agreement_period_from']) && $rentals_data['rent_agreement_period_from'] != "") ? siteDateFormat($rentals_data['rent_agreement_period_from']) : '-';
							?></td>
					</tr>
					<tr>
						<td><?= lang("Rentals.rent_agreement_period_to"); ?></td>
						<td><?php
							echo (isset($rentals_data['rent_agreement_period_to']) && $rentals_data['rent_agreement_period_to'] != "") ? siteDateFormat($rentals_data['rent_agreement_period_to']) : '-';
							?></td>
					</tr>
					<tr>
						<td><?= lang("Rentals.permanent_address"); ?></td>
						<td><?php
							echo (isset($rentals_data['permanent_address']) && $rentals_data['permanent_address'] != "") ? $rentals_data['permanent_address'] : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang("Rentals.work_address"); ?></td>
						<td><?php
							echo (isset($rentals_data['work_address']) && $rentals_data['work_address'] != "") ? $rentals_data['work_address'] : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang("Rentals.status_name"); ?></td>

						<td><?php
						$isClose = $rentals_data['is_close'];
						if($isClose == 1){ ?>
							<span class="badge bg-label-danger text-capitalized" > <?= (isset($rentals_data['status_name']) && $rentals_data['status_name'] != "") ? $rentals_data['status_name'] : '-'; ?></span>
						<?php } else {?>
							<span class="badge bg-label-success text-capitalized" > <?= (isset($rentals_data['status_name']) && $rentals_data['status_name'] != "") ? $rentals_data['status_name'] : '-'; ?></span>
						<?php } ?>
						</td>
					</tr>
					
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_created_at"); ?></td>
						<td><?php
							echo (isset($rentals_data['created_at']) && isValidDate($rentals_data['created_at'])) ? siteDateFormat($rentals_data['created_at'], TRUE) : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_created_by"); ?></td>
						<td><?php
							echo (isset($rentals_data['created_by']) && $rentals_data['created_by'] != "") ? $rentals_data['created_by'] : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_updated_at"); ?></td>
						<td><?php
							echo (isset($rentals_data['updated_at']) && isValidDate($rentals_data['updated_at'])) ? siteDateFormat($rentals_data['updated_at'], TRUE) : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_updated_by"); ?></td>
						<td><?php
							echo (isset($rentals_data['updated_by']) && $rentals_data['updated_by'] != "") ? $rentals_data['updated_by'] : '-';
							?></td>
					</tr>
				</tbody>
			</table>
		</div>
	</div>
	<div class="tab-pane fade" id="closed-information" role="tabpanel">
		<div class="table-responsive text-nowrap">
			<table id="rentals_detail_table" class="table table-xs">
				<thead>
					<tr>
						<th><?= lang("CommonMessage.common_detail"); ?></th>
						<th><?= lang("CommonMessage.common_value"); ?></th>
					</tr>
				</thead>
				<tbody>
					<tr>
						<td><?= lang("Rentals.closing_date"); ?></td>
						<td><?php
							echo (isset($rentals_data['rental_closing_date']) && $rentals_data['rental_closing_date'] != "") ? siteDateFormat($rentals_data['rental_closing_date']) : '-';
							?></td>
					</tr>
					<tr>
						<td><?= lang("Rentals.closing_reason"); ?></td>
						<td><?php
							echo (isset($rentals_data['rental_closing_reason']) && $rentals_data['rental_closing_reason'] != "") ? $rentals_data['rental_closing_reason'] : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang("Rentals.status_name"); ?></td>
						<td><?php
						$isClose = $rentals_data['is_close'];
						if($isClose == 1){ ?>
							<span class="badge bg-label-danger text-capitalized"> <?= (isset($rentals_data['status_name']) && $rentals_data['status_name'] != "") ? $rentals_data['status_name'] : '-'; ?></span>
						<?php } else {?>
							<span class="badge bg-label-success text-capitalized"> <?= (isset($rentals_data['status_name']) && $rentals_data['status_name'] != "") ? $rentals_data['status_name'] : '-'; ?></span>
						<?php } ?>
						</td>
					</tr>
				</tbody>
			</table>
		</div>
	</div>
	<div class="tab-pane fade" id="member-information" role="tabpanel">
		<div class="table-responsive text-nowrap">
			<table id="member_details_table" class="table table-bordered">
				<thead>
					<tr>
						<th><?= lang("CommonMessage.common_sr_no"); ?></th>
						<th><?= lang("Rentals.name"); ?></th>
						<th><?= lang("Rentals.email_id"); ?></th>
						<th><?= lang("Rentals.mobile"); ?></th>
						<th><?= lang("Rentals.gender"); ?></th>
						<th><?= lang("Rentals.birth_yr"); ?></th>
						<th><?= lang("Rentals.blood_gp"); ?></th>
					</tr>
				</thead>
				<tbody class="">
					<?php if ($rentals_member_data != '' && array_filter($rentals_member_data)) { ?>
						<?php
						$sr = 1;
						foreach ($rentals_member_data as $key => $value) { ?>
							<tr>
								<td><?= $sr; ?></td>
								<td><?= $value['name']; ?> </td>
								<td> <?= $value['email_id']; ?> </td>
								<td> <?= $value['mobile_no']; ?> </td>
								<td> <?= underscoreToUcWord($value['gender']); ?> </td>
								<td> <?= YMDToDMY($value['birth_date']); ?> </td>
								<td> <?= $value['blood_group']; ?> </td>
							</tr>
						<?php $sr++;
						}
					} else {   ?>
						<tr>
							<td colspan="9" align="center"> <?= lang('CommonMessage.common_no_data_found'); ?></td>
						</tr>
					<?php } ?>
				</tbody>
			</table>
		</div>
	</div>
	<div class="tab-pane fade" id="emergency-contact" role="tabpanel">
		<div class="table-responsive text-nowrap">
			<table id="emergency_details_table" class="table table-bordered">
				<thead>
					<tr>
						<th><?= lang("CommonMessage.common_sr_no"); ?></th>
						<th><?= lang("Rentals.e_name"); ?></th>
						<th><?= lang("Rentals.e_place"); ?></th>
						<th><?= lang("Rentals.e_relation"); ?></th>
						<th><?= lang("Rentals.e_mobile"); ?></th>
					</tr>
				</thead>
				<tbody class="">
					<?php if ($rentals_emergency_contact_data != '' && array_filter($rentals_emergency_contact_data)) { ?>
						<?php
						$sr = 1;
						foreach ($rentals_emergency_contact_data as $key => $value) { ?>
							<tr>
								<td> <?= $sr; ?></td>
								<td> <?= $value['name']; ?> </td>
								<td> <?= $value['place']; ?> </td>
								<td> <?= underscoreToUcWord($value['relation']); ?> </td>
								<td> <?= $value['mobile_no']; ?> </td>
							</tr>
						<?php $sr++;
						}
					} else {   ?>
						<tr>
							<td colspan="5" align="center"> <?= lang('CommonMessage.common_no_data_found'); ?></td>
						</tr>
					<?php } ?>
				</tbody>
			</table>
		</div>
	</div>

	<div class="tab-pane fade" id="vehicle-detail" role="tabpanel">
		<div class="table-responsive text-nowrap">
			<table id="vehicle_details_table" class="table table-bordered">
				<thead>
					<tr>
						<th><?= lang("CommonMessage.common_sr_no"); ?></th>
						<th><?= lang("Rentals.vehicle_type"); ?></th>
						<th><?= lang("Rentals.parking_slot"); ?></th>
						<th><?= lang("Rentals.vehicle_no"); ?></th>
						<th><?= lang("Rentals.parking_slot_no"); ?></th>
						<th><?= lang("Rentals.token_no"); ?></th>

					</tr>
				</thead>
				<tbody class="">
					<?php if ($rentals_parking_data != '' && array_filter($rentals_parking_data)) { ?>
						<?php
						$sr = 1;
						foreach ($rentals_parking_data as $key => $value) { ?>
							<tr>
								<td><?= $sr; ?></td>
								<td><?= underscoreToUcWord($value['vehicle_type']); ?> </td>
								<td> <?= $value['parking_area']; ?> </td>
								<td> <?= $value['vehicle_no']; ?> </td>
								<td> <?= $value['parking_slot_no']; ?> </td>
								<td> <?= $value['token_no']; ?> </td>
							</tr>
						<?php $sr++;
						}
					} else {   ?>
						<tr>
							<td colspan="6" align="center"> <?= lang('CommonMessage.common_no_data_found'); ?></td>
						</tr>
					<?php } ?>
				</tbody>
			</table>
		</div>
	</div>

	<?php /*
	<div class="tab-pane fade" id="access-card-detail" role="tabpanel">

		<div class="table-responsive text-nowrap">
			<table id="access-card-detail_table" class="table table-bordered">
				<thead>
					<tr>
						<th><?= lang("CommonMessage.common_sr_no"); ?></th>
						<th><?= lang("Rentals.remarks"); ?></th>
						<th><?= lang("Rentals.lifts_access"); ?></th>
						<th><?= lang("Rentals.amenities_usage"); ?></th>
						<th><?= lang("Rentals.vehical_type"); ?></th>
					</tr>
				</thead>
				<tbody class="">

					<?php if ($rentals_access_card_data != '' && array_filter($rentals_access_card_data)) { ?>
						<?php
						$sr = 1;
						foreach ($rentals_access_card_data as $key => $value) { ?>
							<tr>
								<td><?= $sr; ?></td>
								<td> <?= $value['remarks']; ?> </td>
								<td> <?= $value['lift_access']; ?> </td>
								<td> <?= $value['amenities_name']; ?> </td>
								<td>
									<?php foreach ($value['vehicle_data'] as $key => $value) { ?>
										<?= underscoreToUcWord($value['vehicle_type']); ?>
									<?php } ?>
								</td>
							</tr>
						<?php $sr++;
						}
					} else {   ?>
						<tr>
							<td colspan="6" align="center"> <?= lang('CommonMessage.common_no_data_found'); ?></td>
						</tr>
					<?php } ?>
				</tbody>
			</table>
		</div>

	</div> */ ?>

	<div class="tab-pane fade" id="attached-document" role="tabpanel">
		<div class="table-responsive text-nowrap">
			<table id="document_details_table" class="table table-bordered">
				<thead>
					<tr>
						<th class="text-center" style="width: 5%"><?= lang("CommonMessage.common_sr_no"); ?></th>
						<th style="width: 10%"><?= lang("Rentals.document_name"); ?></th>
						<th style="width: 10%"><?= lang("Rentals.document_image"); ?></th>
					</tr>
				</thead>
				<tbody class="">
                	<?php if($document_data != '' && array_filter($document_data)) {
                    $sr = 1;
                    foreach ($document_data as $key => $value) { ?>
						<tr>
							<td class="text-center"><?= $sr; ?></td>
                            <td colspan="1"><?= underscoreToUcWord($value['document_name']); ?> </td>
                            <td colspan="1">
							<?php if (isset($value['module_image_data']) && $value['module_image_data'] != '' ) {?>
								<?php
								foreach($value['module_image_data'] as $document){
								$paths = site_url() . DOCUMENT_IMAGE_PATH . $document['document_image'];
								if(file_exists( DOCUMENT_IMAGE_PATH .$document['document_image'])){ ?>
									<a href="<?= $paths; ?>"  target="_blank">
										<img src="<?= $paths; ?>" width="100" height="100" class="img-fluid" alt="">
									</a>
								<?php } } } ?> 
							</td>
						</tr>
                    <?php $sr++;} }  else {   ?>
						<tr>
							<td colspan="3" align="center"> <?= lang('CommonMessage.common_no_data_found'); ?></td>
						</tr>
					<?php } ?>
			</tbody>
			</table>
		</div>
	</div>
</div>