<?php
$dtCIAcl = new \App\Libraries\Dt_ci_acl();
?>
<a style="display: none;" href="" class="dt-export-anchor" target="_blank"></a>
<div class="card">
	<div class="card-datatable text-nowrap table-responsive">
		<table id="poll_votes_table" class="table dt-datatable dt-scrollableTable">
			<thead class="border-top">
			<tr>
                <th class="font-weight-bold"><?= lang("PollVotes.poll_id"); ?></th>
				<th class="font-weight-bold"><?= lang("PollVotes.poll_option"); ?></th>
				<th class="font-weight-bold"><?= lang("PollVotes.poll_title"); ?></th>
				<th class="font-weight-bold"><?= lang("PollVotes.vote_count"); ?></th>
                <th class="font-weight-bold"><?= lang("CommonMessage.common_created_at"); ?></th>
                <th class="font-weight-bold"><?= lang("CommonMessage.common_created_by"); ?></th>
                <th class="font-weight-bold"><?= lang("CommonMessage.common_updated_at"); ?></th>
                <th class="font-weight-bold"><?= lang("CommonMessage.common_updated_by"); ?></th>
                <th class="font-weight-bold"><?= lang("CommonMessage.common_action"); ?></th>
			</tr>
			</thead>
		</table>
	</div>
</div>
<script type="text/javascript">
	var dt_DataTable;
	$(document).ready(function () {
		dt_DataTable = $('#poll_votes_table').DataTable( {
			dom:'<"card-header d-flex border-top rounded-0 flex-wrap py-0"' +
				'<"me-5 ms-n2 pe-5"f>' +
				'<"d-flex justify-content-start justify-content-md-end align-items-baseline"<"dt-action-buttons d-flex flex-column align-items-start align-items-md-center justify-content-sm-center mb-3 mb-md-0 pt-0 gap-4 gap-sm-0 flex-sm-row"lB>>' +
				'>t' +
				'<"row mx-2"' +
				'<"col-sm-12 col-md-6"i>' +
				'<"col-sm-12 col-md-6"p>' +
				'>',
			processing: true,
			serverSide: true,
            scrollX: true,
			displayLength: 10,
			language: {
				sLengthMenu: 'Show _MENU_',
				search: '',
				searchPlaceholder: 'Search <?= lang('PollVotes.poll_votes');?>',
				info: 'Displaying _START_ to _END_ of _TOTAL_ entries'
			},
			buttons: [
			],
			"ajax": {
				"url": "<?php echo admin_url('PollVotes/getPollVotesListing'); ?>",
				"type": "POST",
				"data": function ( d ) {

				}
			},
			"stateSave": true,
			"order": [[ 0, "asc" ]],
			"columns": [
				{
					"data": "poll_id",
					visible: false,
                    "searchable":false,
				},
				{
					"className": 'dt-option-detail no_click_allowed',
					"sortable": false,
					"searchable": false,
					"data": null,
					"render": function (data, type, row) {
						return '<button class="btn btn-primary" style="padding: 5px 5px; font-size: 10px;"> <i class="ti ti-plus me-0 me-sm-1 ti-xs"></i> </button> ';
					}
				},
				{"data": "poll_title" },
				{"data": "vote_count" },
				{"data": "created_at" },
				{"data": "created_by" },
				{"data": "updated_at" },
				{"data": "updated_by" },
				{
					"data": "action_button",
					"class" : "text-center no_click_allowed",
					"sortable": false,
					"searchable": false
				},
			],
			"fnDrawCallback": function (oSettings, json) {
				customToolTip();
				$('.dataTables_length').addClass('mt-2 mt-sm-0 mt-md-3 me-2');
				$('.dt-buttons').addClass('d-flex flex-wrap');
				$('.dataTables_filter .form-control').removeClass('form-control-sm');
				$('.dataTables_length .form-select').removeClass('form-select-sm');
				//checkBoxRefresh("datatable-checkbox");
				switcheryKeyGen("datatable-list-switchery");

			}
		});
		dtDataTableSearch();
		$('#poll_votes_table tbody').on('click', 'td.dt-option-detail', function () {
		    var tr = $(this).closest('tr'); 
		    var row = dt_DataTable.row(tr);

		    if (row.child.isShown()) {
		        // This row is already open - close it
		        row.child.hide();
		        tr.removeClass('shown');
		    } else {
		        // Open this row
		        hideViewDtData();
		        row.child(getOptionDetail(row.data())).show();
				tr.addClass('shown');
		    }
		});
	});
	function hideViewDtData() {
        $(".dt-option-detail").each(function () {
            var selfElem    = $(this);
            var tr          = $(this).closest('tr');
            var row         = dt_DataTable.row(tr);
            if (row.child.isShown()) {
                row.child.hide();
                selfElem.html('<button class="btn btn-primary" style="padding: 5px 5px; font-size: 10px;"> <i class="ti ti-plus me-0 me-sm-1 ti-xs"></i> </button>');
                selfElem.removeClass('btn-danger');
            }
        });
    }
	function getOptionDetail ( d ) {
		var div = $('<div/>')
				.addClass( 'loading' )
				.text( 'Loading...' );
		$.ajax({
			type: 'post',
			url: '<?php echo admin_url('PollVotes/getOptionData'); ?>',
			dataType: 'json',
			data: d,
			success: function (jsonObj) {
				var option_data = '';
				option_data +='<div class="table-responsive">';
				option_data +='<table class="table  table-hover table-bordered" id="list_table_json">';
				option_data +='<thead>';
				option_data +='<tr>';
				option_data +='<th class="font-weight-bold"><?= lang('PollVotes.poll_votes'); ?></th>';
				option_data +='<th class="font-weight-bold"><?= lang('PollVotes.total_votes'); ?></th>';
				option_data +='<th class="font-weight-bold"><?= lang('CommonMessage.common_action'); ?></th>';
				
				option_data +='</tr>';
				option_data +='</tr>';		                  
				option_data +='</thead>';
				option_data +='<tbody>';
			if(jsonObj.option_data.length > 0){
	            $.each(jsonObj.option_data, function(index, value){
	            	var adminUrl = '<?= admin_url('') ?>';
	            	var editTaskManagementLang = '<?= lang('PollVotes.view_poll_votes_detail') ?>';
	                option_data += '<tr>';
					option_data += '<td>'+value.poll_option+'</td>';
					option_data += '<td>'+value.total_votes+'</td>';
					option_data += '<td> <a href="' + adminUrl + 'PollVotesDetail?poll_id=' + value.poll_id + '&poll_option_id=' + value.poll_option_id +'" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title="' + editTaskManagementLang + '" title="' + editTaskManagementLang + '" class="btn btn-sm btn-icon"><i class="fa fa-eye"></i></a> </td>';
	                option_data += '</tr>';
	            });
	        }
	        else{
				option_data += '<tr><td colspan="2" class="text-center"> No Data Available </td></tr>';
	        }
			option_data +='</tbody>';
			option_data +='</table>';
			option_data +='</div>';
				div.html( option_data ).removeClass( 'loading' );
			}
		});
		return div;
	}

</script>