<?php
$dtCIAcl = new \App\Libraries\Dt_ci_acl();
$session = \Config\Services::session();
$pollView = isset($poll_data['view']) ? $poll_data['view'] : 0;
?>
    <!-- Multi Column with Form Separator -->
    <div class="card mb-4">
        <h5 class="card-header"><?= lang('Material.material_form'); ?>

        </h5>
        <?php
        //create  form open tag
        $form_id = array(
            'id' => 'form_poll',
            'class' => 'card-body',
        );
        echo form_open_multipart('', $form_id);
        $pollId = (isset($poll_data['poll_id']) && ($poll_data['poll_id'] != '')) ? $poll_data['poll_id'] : '';
        ?>
        <input type="hidden" id="poll_id" name="poll_id" value="<?= $pollId ?>">
        <h6>1. <?= lang('Poll.poll_basic_information') ?></h6>
        <div class="row g-3">

            <div class="col-md-6">
                <label class="form-label" for="basic-default-name"><?= lang('Poll.start_date'); ?><span
                            class="text-danger"> *</span></label>
                <input type="text" class="form-control dt-start-date" name="start_date" id="start_date"
                       placeholder="Select <?= lang('Poll.start_date'); ?>"
                       value="<?= (isset($poll_data['start_date']) && isValidDate($poll_data['start_date'])) ? siteDateFormat($poll_data['start_date']) : ''; ?>"
                />
            </div>

            <div class="col-md-6">
                <label class="form-label" for="basic-default-name"><?= lang('Poll.end_date'); ?><span
                            class="text-danger"> *</span></label>
                <input type="text" class="form-control dt-end-date" name="end_date" id="end_date"
                       placeholder="Select <?= lang('Poll.end_date'); ?>"
                       value="<?= (isset($poll_data['end_date']) && isValidDate($poll_data['end_date'])) ? siteDateFormat($poll_data['end_date']) : ''; ?>"
                />
            </div>


            <div class="col-md-12">
                <label class="form-label" for="basic-default-name"><?= lang('Poll.question'); ?><span
                            class="text-danger"> *</span></label>
                <input type="text" class="form-control" name="title" id="title"
                       placeholder="Enter <?= lang('Poll.question'); ?>"
                       value="<?= isset($poll_data['poll_title']) ? $poll_data['poll_title'] : ''; ?>"
                />

            </div>

        </div>
        <hr class="my-4 mx-n4"/>

        <h6>2. <?= lang('Poll.answer_information'); ?></h6>
        <div class="row g-3">
            <?= isset($poll_option_table) ? $poll_option_table : ""; ?>
        </div>
        <?php if ($dtCIAcl->checkAccess('Poll|manage')) { ?>
            <button type="button" class="btn btn-xs btn-primary" onclick="addPollOption()">
                <i class="ti ti-plus me-1"></i>
                <span class="align-middle"><?= lang('CommonMessage.common_add_row'); ?></span>
            </button>
        <?php } ?>
        <?php if ($pollView != 1) { ?>

            <div class="pt-4">
                <button type="submit" id="submitBtn"
                        class="btn btn-primary me-sm-3 me-1 submit"><?= lang('CommonMessage.common_submit'); ?></button>
                <button type="button" id="cancelBtn" onclick="window.location.href='<?php echo admin_url('Poll'); ?>'"
                        class="btn btn-label-secondary"><?= lang('CommonMessage.common_cancel'); ?></button>
            </div>
        <?php } ?>
        <?php echo form_close(); ?>
    </div>

    <script>
        let startDate;
        let endDate;

	    function startAndEndDate(){
	    	var startDate = $(".dt-start-date").flatpickr({
	    		//monthSelectorType: 'static',
	    		dateFormat: 'd-m-Y',
	    		onChange: function( selectedDates, dateStr, instance ) {
	    			endDate.set('minDate', dateStr)
	    		}
	    	});
	    	var endDate = $(".dt-end-date").flatpickr({
	    		//monthSelectorType: 'static',
	    		dateFormat: 'd-m-Y',
	    	});
	    }
        var editable = <?= $pollView ?>;
        if (editable == 1) {
            $("#form_poll :input").prop("disabled", true);
            $(".dt-delete-item-row").removeAttr("onclick");
            $(".dt-delete-item-row").remove();
        }

        function pollOption() {
            addValidation("input", ".dt-option", {
                required: true,
                messages: {
                    required: "<?= lang('CommonMessage.common_please_enter');?> " + "<?= lang('Poll.option');?>",
                }
            });
            addValidation("input", ".dt-sort-order", {
                required: true,
                messages: {
                    required: "<?= lang('CommonMessage.common_please_enter');?> " + "<?= lang('Poll.sort_order');?>",
                }
            });
        }

        $(document).ready(function () {
            addSerialNumber('poll_option_table');
            numberInit();
            startAndEndDate();
            // Initialize
            var validator = $("#form_poll").validate({
                ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
                errorClass: 'validation-invalid-label',
               // successClass: 'validation-valid-label',
                validClass: 'validation-valid-label',
                highlight: function (element, errorClass) {
                    $(element).removeClass(errorClass);
                },
                unhighlight: function (element, errorClass) {
                    $(element).removeClass(errorClass);
                },
                success: function (label) {
                    //label.addClass('validation-valid-label').text('Success.'); // remove to hide Success message
                },
                // Different components require proper error label placement
                errorPlacement: function (error, element) {

                    // Unstyled checkboxes, radios
                    if (element.parents().hasClass('form-check')) {
                        error.appendTo(element.parents('.form-check').parent());
                    }

                    // Input with icons and Select2
                    else if (element.parents().hasClass('form-group row-feedback') || element.hasClass('select2-hidden-accessible')) {
                        error.appendTo(element.parent());
                    }

                    // Input group, styled file input
                    else if (element.parent().is('.uniform-uploader, .uniform-select') || element.parents().hasClass('input-group')) {
                        error.appendTo(element.parent().parent());
                    }

                    // Other elements
                    else {
                        error.insertAfter(element);
                    }
                },
                rules: {
                    title: {
                        required: true,
                    },
                    start_date: {
                        required: true,
                    },
                    end_date: {
                        required: true,
                    },
                },
                messages: {
                    title: {
                        required: '<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("Poll.question"); ?>.'
                    },
                    start_date: {
                        required: '<?= lang("CommonMessage.common_please_select"); ?> <?= lang("Poll.start_date"); ?>.'
                    },
                    end_date: {
                        required: '<?= lang('CommonMessage.common_please_select'); ?> <?= lang("Poll.end_date"); ?>.',
                    },
                },
                submitHandler: function (e) {
                    $(e).ajaxSubmit({
                        url: '<?php echo admin_url("Poll/save");?>',
                        type: 'post',
                        beforeSubmit: function (formData, jqForm, options) {
                            dtButtonHide('#submitBtn');
                            dtButtonHide('#cancelBtn');
                        },
                        complete: function () {

                        },
                        dataType: 'json',
                        clearForm: false,
                        success: function (resObj, statusText) {
						if (resObj.success) {
							toastr.success(resObj.msg, 'Success', {
								closeButton: true,
								progressBar: true,
								positionClass: 'toast-top-right',
								timeOut: 1000,
                                onHidden: function () {
                                    dtButtonShow('#submitBtn');
									dtButtonShow('#cancelBtn');
                                    window.location.href = '<?php echo admin_url('Poll');?>';
                                }
							});

							// setTimeout(function () {
							// 	window.location.href = '<?php echo admin_url('Poll');?>';
							// }, 1000);

						} else {
                            dtButtonShow('#submitBtn');
                            dtButtonShow('#cancelBtn');
							toastr.error(resObj.msg, 'Error', {
								closeButton: true,
								// progressBar: true,
								positionClass: 'toast-top-right',
								// timeOut: 1000
							});
						}
					}
                    });
                }
            });
            pollOption();

            // $("#start_date").flatpickr({
            //     // monthSelectorType: 'static',
            //     dateFormat: "d-m-Y",
            //     // dateFormat: 'd-m-Y',
            //     // minDate: "today",
            //     //maxDate:"15-07-2024"
            // });

            // $("#end_date").flatpickr({
            //     // monthSelectorType: 'static',
            //     dateFormat: "d-m-Y",
            //     // dateFormat: 'd-m-Y',
            //     // minDate: "today",
            //     //maxDate:"15-07-2024"
            // });
        });

    </script>
<?= isset($select2_ajax) ? $select2_ajax : ""; ?>