<?php
$dtCIAcl = new \App\Libraries\Dt_ci_acl();
?>
<a style="display: none;" href="" class="dt-export-anchor" target="_blank"></a>
<div class="card">
	<div class="card-datatable table-responsive">
		<ul class="nav nav-tabs" role="tablist">
			<li class="nav-item">
				<button type="button" class="nav-link active" role="tab" data-bs-toggle="tab" data-bs-target="#all" aria-controls="all" aria-selected="true">
					All
				</button>
			</li>
			<li class="nav-item">
				<button type="button" class="nav-link" role="tab" data-bs-toggle="tab" data-bs-target="#allocated_parking" aria-controls="allocated_parking" aria-selected="false">
					Allocated Parking
				</button>
			</li>
			<li class="nav-item">
				<button type="button" class="nav-link" role="tab" data-bs-toggle="tab" data-bs-target="#free_parking" aria-controls="free_parking" aria-selected="false">
					Free Parking
				</button>
			</li>
		</ul>
		<table id="parking_slot_table" class="table dt-datatable">
			<thead class="border-top">
				<tr>
					<th><input class="form-check-input datatable-select-all-second" type="checkbox" /></th>
					<!-- <th class="font-weight-bold"><?//= lang("ParkingSlot.society"); ?></th> -->
                    <th class="font-weight-bold"><?= lang("ParkingSlot.parking_area"); ?></th>
					<th class="font-weight-bold"><?= lang("ParkingArea.vehicle_type"); ?></th>
                    <th class="font-weight-bold"><?= lang("ParkingSlot.flat_no"); ?></th>
					<th class="font-weight-bold"><?= lang("ParkingSlot.number"); ?></th>
					<th class="font-weight-bold"><?= lang("ParkingSlot.is_visitor_parking"); ?></th>
					<th class="font-weight-bold"><?= lang("ParkingSlot.ownership_flat_member"); ?></th>
					<th class="font-weight-bold"><?= lang("CommonMessage.common_active"); ?></th>
                	<th class="font-weight-bold"><?= lang("CommonMessage.common_action"); ?></th>
				</tr>
			</thead>
		</table>
	</div>
</div>
<?= isset($v_parking_slot_modal) ? $v_parking_slot_modal : ""; ?>
<script type="text/javascript">
	function modalFlatDd() {
    $('.flatDd').each(function() {
        var $this = $(this);
        $this.wrap('<div class="position-relative"></div>').select2({
            placeholder: 'Select Flat No', // Fixed typo
            dropdownParent: $this.parent(),
            allowClear: true,
            ajax: {
                url: "<?= admin_url('Flat/getFlatDd') ?>",
                dataType: 'json',
                type: 'post',
                delay: <?= SELECT2_MINIMUM_DELAY; ?>, // Ensure it's a number
                data: function(params) {
                    return {
                        filter_param: params.term || '', // Search term
                        page: params.page || 1,
                    };
                },
                processResults: function(data, params) {
                    params.page = params.page || 1;
                    return {
                        results: data.result,
                        pagination: {
                            more: (params.page * 10) < data.totalRows
                        }
                    };
                }
            },
            escapeMarkup: function(markup) {
                return markup;
            } // Let our custom formatter work
        })
        .on('select2:select', function() {
            var elementId = $(this).attr('id');
            if ($("#" + elementId).valid()) {
                $("#" + elementId).removeClass('invalid').addClass('success');
            }
        })
        .on('select2:unselect', function() {
            // Handle when user clears selection
            var elementId = $(this).attr('id');
            $("#" + elementId).removeClass('success').addClass('invalid');
        });
    });
}


	function modalParkingVehicleDd() {
		$('.parkingVehicleDd').each(function() {
			var $this = $(this);
			$this.wrap('<div class="position-relative"></div>').select2({
				placeholder: 'Select Parking Vehicle',
				dropdownParent: $this.parent(),
				allowClear: true,
				ajax: {
					url: "<?= admin_url('ParkingArea/getParkingVehicleDd') ?>",
					dataType: 'json',
					type: 'post',
					delay: '<?= SELECT2_MINIMUM_DELAY; ?>',
					data: function(params) {
						return {
							filter_param: params.term || '', // search term
							page: params.page || 1,

						};
					},
					processResults: function(data, params) {
						params.page = params.page || 1;
	                    return {
	                        results: data.result,
	                        pagination: {
	                            more: (params.page * 10) < data.totalRows
	                        }
	                    };
					},
				},
				escapeMarkup: function(markup) {
					return markup;
				},
			}).on('select2:select', function(parkingVehicle) {
				var elementId = $(this).attr('id');
	            if ($("#" + elementId).valid()) {
	                $("#" + elementId).removeClass('invalid').addClass('success');
	            }
				var parkingVehicleData = parkingVehicle.params.data;
	            if ($(".dt-parking-area-id").length > 0) {
	                $(".dt-parking-area-id").val(parkingVehicleData.remarks);
	            }

	            if ($(".dt-vehicle-type").length > 0) {
	                $(".dt-vehicle-type").val(parkingVehicleData.vehicle_type);
	            }
			})
			.on('select2:unselect', function() {
	            var elementId = $(this).attr('id');
	            $("#" + elementId).removeClass('success').addClass('invalid');
	        });
		});
	}

	function modalOwnershipFlatVehicleDd() {
		$('.ownershipFlatVehicleDd').each(function() {
			var $this = $(this);
			$this.wrap('<div class="position-relative"></div>').select2({
				placeholder: 'Select Ownership Flat Vehicle',
				dropdownParent: $this.parent(),
				allowClear: true,
				ajax: {
					url: "<?= admin_url('OwnershipFlat/getOwnershipFlatParkingDd') ?>",
					dataType: 'json',
					type: 'post',
					delay: '<?= SELECT2_MINIMUM_DELAY; ?>',
					data: function(params) {
						var flatId;
	                    if ($("#flat_id").length > 0) {
	                        flatId = $("#flat_id").val() || 0;
	                    }
	                    var vehicleType;
	                    if ($("#vehicle_type").length > 0) {
	                        vehicleType = $("#vehicle_type").val() || 0;
	                    }
						return {
							vehicle_type: vehicleType,
                        	flat_id: flatId,
							filter_param: params.term || '', // search term
							page: params.page || 1,

						};
					},
					processResults: function(data, params) {
						params.page = params.page || 1;
	                    return {
	                        results: data.result,
	                        pagination: {
	                            more: (params.page * 10) < data.totalRows
	                        }
	                    };
					},
				},
				escapeMarkup: function(markup) {
					return markup;
				},
			}).on('select2:select', function() {
				var elementId = $(this).attr('id');
	            if ($("#" + elementId).valid()) {
	                $("#" + elementId).removeClass('invalid').addClass('success');
	            }				
			})
			.on('select2:unselect', function() {
	            var elementId = $(this).attr('id');
	            $("#" + elementId).removeClass('success').addClass('invalid');
	        });
		});
	}

	var dt_DataTable;
	$(document).ready(function() {
		// tabModule = 'all'
		// $('.nav-item').on('click',function () {
		// 	var tabName = $(this).attr('id');
		// 	tabModule = tabName;
		// 	$('li a').removeClass("active");
		// 	$(this).closest("li").find("a").addClass("active");
		// 	dt_DataTable.ajax.reload(null,false);
		// });

		var tabModule = 'all';

$('.nav-item button').on('click', function () {
    var tabName = $(this).data('bs-target').replace('#', ''); // Extract tab name without #
    tabModule = tabName;
    
    $('.nav-item .nav-link').removeClass("active"); // Remove active class from all tabs
    $(this).addClass("active"); // Add active class to the clicked tab

    dt_DataTable.ajax.reload(null, false);
});


		dt_DataTable = $('#parking_slot_table').DataTable({
			dom: '<"card-header d-flex border-top rounded-0 flex-wrap py-0"' +
				'<"me-5 ms-n2 pe-5"f>' +
				'<"d-flex justify-content-start justify-content-md-end align-items-baseline"<"dt-action-buttons d-flex flex-column align-items-start align-items-md-center justify-content-sm-center mb-3 mb-md-0 pt-0 gap-4 gap-sm-0 flex-sm-row"lB>>' +
				'>t' +
				'<"row mx-2"' +
				'<"col-sm-12 col-md-6"i>' +
				'<"col-sm-12 col-md-6"p>' +
				'>',
			processing: true,
			serverSide: true,
			displayLength: 10,
			// language: {
			// 	sLengthMenu: 'Show _MENU_',
			// 	search: '',
			// 	searchSlotholder: 'Search <?= lang('ParkingSlot.parking_slot'); ?>',
			// 	info: 'Displaying _START_ to _END_ of _TOTAL_ entries'
			// },
			language: {
                sLengthMenu: 'Show _MENU_',
                search: '',
                searchPlaceholder: 'Search <?= lang('ParkingSlot.parking_slot'); ?>',
                info: 'Displaying _START_ to _END_ of _TOTAL_ entries'
            },
			buttons: [
				{
					extend: 'collection',
					className: 'btn btn-label-secondary px-2 dropdown-toggle me-2 waves-effect waves-light',
					text: '<i class="ti ti-download me-1 ti-xs"></i>Export',
					buttons: [
						{
							text: '<i class="ti ti-file me-2" ></i>Excel',
							className: 'dropdown-item dt-excel-export'
						},
						// {
						// 	extend: 'pdf',
						// 	text: '<i class="ti ti-file-text me-2"></i>Pdf',
						// 	className: 'dropdown-item',
						//
						// }
					]
				},
				<?php /*?>
				<?php if ($dtCIAcl->checkAccess("ParkingSlot|addEdit")) { ?>
                {
                    text: '<i class="ti ti-plus me-0 me-sm-1 ti-xs"></i><span class="d-none d-sm-inline-block"><?= lang('ParkingSlot.add_parking_slot');?></span>',
                    className: 'add-new btn btn-primary  px-1 me-2 add_parking_slot',
                    // action: function () {
                    // 	window.location.href = productAdd;
                    // }
                },

                <?php } ?>
                <?php if ($dtCIAcl->checkAccess("ParkingSlot|delete")) { ?>
                {
                    text: '<i class="ti ti-trash me-0 me-sm-1 ti-xs"></i><span class="d-none d-sm-inline-block"><?= lang('ParkingSlot.delete_parking_slot');?></span>',
                    //className: 'btn btn-danger ms-2 ms-sm-0 waves-effect waves-light dt-delete-record invisible',
                    className: 'btn btn-danger  px-1 dt-delete-record',
                },
                <?php } ?>
				<?php */?>
			],
			"ajax": {
				"url": "<?php echo admin_url('ParkingSlot/getParkingSlotListing'); ?>",
				"type": "POST",
				"data": function(d) {
					var params = {};
                    params["<?= csrf_token(); ?>"] = "<?= csrf_hash() ?>";
					params["tab_module"] = tabModule;
					var filterData = $("#advanceFilter").serializeArray();
					$.each(filterData, function(i, val) {
						var name = val.name;
						if (typeof params[name] == 'undefined') {
							params[name] = val.value;
						} else if ($.isArray(params[name])) {
							params[name].push(val.value);
						} else {
							params[name] = [params[name]];
							params[name].push(val.value);
						}
					});

					return $.extend({}, d, params);
				}
			},
			"stateSave": true,
			"order": [
				[0, "desc"]
			],
			"columns": [{
					"data": "parking_slot_id",
					"render": function(data, type, row) {
						return '<input class="form-check-input datatable-checkbox" type="checkbox" id="ids_' + row['parking_slot_id'] + '" name="ids[]" value="' + row['parking_slot_id'] + '"/>';
					},
					"sortable": false,
					"searchable": false
				},
				// {
				// 	"data": "society_name"
				// },
                {
                    "data": "parking_area_name"
                },
				{
					"data": "vehicle_type",
					"render": function (data, type, row) {
						return row['display_vehicle_type'];
					}
				},
				{
					"data": "flat_no",
					"class": "no_click_allowed",
				 	"render": function (data, type, row) {
						return row['display_flat_no'];
					}
				},

				{"data": "number"},
                {"data": "is_visitor_parking_display"},
                {"data": "name",
                	"searchable": false
            	},
				{
					"data": "is_active",
					"sortable": false,
					"searchable": false,
					"render": function(data, type, row) {
						var checked = (data == 1) ? "checked" : "";
						return '<label class="switch switch-primary switch-sm">' +
							'<input type="checkbox" class="switch-input  dt-active-status" ' + checked + '  data-id="' + row['parking_slot_id'] + '" value="1" />' +
							'<span class="switch-toggle-slider">' +
							'<span class="switch-on"></span>' +
							'<span class="switch-off"></span>' +
							'</span>';
						'</label>';
					}
				},
				{
					"data": "action_button",
					"class": "text-center",
					"sortable": false,
					"searchable": false
				},
			],
			"fnDrawCallback": function(oSettings, json) {
				customToolTip();
				$('.dataTables_length').addClass('mt-2 mt-sm-0 mt-md-3 me-2');
				$('.dt-buttons').addClass('d-flex flex-wrap');
				$('.dataTables_filter .form-control').removeClass('form-control-sm');
				$('.dataTables_length .form-select').removeClass('form-select-sm');
				//checkBoxRefresh("datatable-checkbox");
				switcheryKeyGen("datatable-list-switchery");

			}
		});
		dtDataTableSearch();
	});

	$(document).on('click', '.add_parking_slot', function () {
        dtFormClear('form_parking_slot');
        $("form#form_parking_slot input[name=parking_slot_id]").val('');
        $('#parking_slot_modal').modal('show');
        modalFlatDd();
        modalParkingVehicleDd();
        modalOwnershipFlatVehicleDd();
    });



	$(document).on('click', '.dt-active-status', function() {
		var id = $(this).attr('data-id');
		var isActive = $(this).is(":checked") ? 1 : 0;
		$.ajax({
			type: 'post',
			url: '<?php echo admin_url('ParkingSlot/changeStatus'); ?>',
			data: {
				parking_slot_id: id,
				status: isActive
			},
			dataType: 'json',
			success: function(data) {
				if (data) {
					Swal.fire({
						title: 'Success',
						text: data.msg,
						icon: 'success',
						customClass: {
							confirmButton: 'btn btn-primary waves-effect waves-light'
						},
						buttonsStyling: false
					}).then(function() {
						dt_DataTable.ajax.reload(null, false);
					});
				} else {
					Swal.fire({
						title: 'Error!',
						text: data.msg,
						icon: 'error',
						customClass: {
							confirmButton: 'btn btn-primary waves-effect waves-light'
						},
						buttonsStyling: false
					});
				}
			}
		});
	});

	$(document).on('click', '.dt-delete-record', function () {
        var id = $(this).attr("data-id");
        var deleteId = [];
        if(id != undefined){
            $('.datatable-select-all-second').prop('checked', false);
            $('.datatable-checkbox').prop('checked', false);
            $("#ids_" + id).prop("checked", true);
            deleteId.push(id);
        }
        else{
            var deleteElement =$('#parking_slot_table tbody .datatable-checkbox:checked');
            var selectedLength = deleteElement.length;
            if (selectedLength == 0) {
                Swal.fire({
                    title: "<?= ucwords(lang('CommonMessage.common_sweet_alert_info')); ?>",
                    text: "<?= lang('CommonMessage.delete_info'); ?>",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonText: 'OK',
                    customClass: {
                        confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
                        cancelButton: 'btn btn-label-secondary waves-effect waves-light'
                    },
                    buttonsStyling: false
                }).then(function () {
                    return false;
                });
            } else {
                $.each(deleteElement, function (i, ele) {
                    deleteId.push($(ele).val());
                });
            }
        }
        if (deleteId.length > 0) {
            Swal.fire({
                title: "<?= ucwords(lang('CommonMessage.common_sweet_alert_delete')); ?>",
                text: "<?= lang('CommonMessage.delete_warning'); ?>",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'OK',
                customClass: {
                    confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
                    cancelButton: 'btn btn-label-secondary waves-effect waves-light'
                },
                buttonsStyling: false
            }).then(function(result) {
                if (result.value) {
                    $.ajax({
                        type: "post",
                        url: "<?= admin_url("ParkingSlot/delete")?>",
                        dataType: "json",
                        data: {parking_slot_id: deleteId},
                        success: function (data) {
                            if (data['success']) {
                                Swal.fire({
                                    title: 'Success',
                                    text: data['msg'],
                                    icon: 'success',
                                    customClass: {
                                        confirmButton: 'btn btn-primary waves-effect waves-light'
                                    },
                                    buttonsStyling: false
                                }).then(function() {
                                    dt_DataTable.ajax.reload();
                                });
                            } else {
                                Swal.fire({
                                    title: 'Error!',
                                    text: data['msg'],
                                    icon: 'error',
                                    customClass: {
                                        confirmButton: 'btn btn-primary waves-effect waves-light'
                                    },
                                    buttonsStyling: false
                                }).then(function() {
                                    dt_DataTable.ajax.reload();
                                });
                            }
                        }
                    });
                }
                else {
                    $('.datatable-checkbox').prop('checked', false);
                }
            });
        }
    });


	//Edit Record
	$(document).on('click', '.dt-edit-record', function() {
		$('.datatable-select-all-second').prop('checked', false);
		$('.datatable-checkbox').prop('checked', false);
		$("form#form_parking_slot .validation-invalid-label").html('');
		var id = $(this).attr('data-id');
		$("#ids_" + id).prop("checked", true);
		var edit_val = $('.datatable-checkbox:checked').val();
		var selected_tr = $('.datatable-checkbox:checked');
		var element = $(selected_tr).closest('tr').get(0);	
		var aData = dt_DataTable.row(element).data();
		dtFormFill('form_parking_slot', aData);
		var flatId = 0;
		var flatName = '';
		var parkingAreaId = 0;
		var parkingAreaName = '';

		var ownershipFlatParkingId = 0;
		var ownershipFlatParkingName = '';
		$.each(aData, function(key,val ) {
			if (key == 'flat_id') {
				flatId = val;
			} else if (key == 'flat_no') {
				flatName = val;
			}
			else if (key == 'parking_vehicle_id') {
				parkingAreaId = val;
			}
			else if (key == 'parking_area_vehicle_type_name') {
				parkingAreaName = val;
			}
			else if (key == 'ownership_flat_parking_id') {
				ownershipFlatParkingId = val;
			}
			else if (key == 'vehicle_no') {
				ownershipFlatParkingName = val;
			}
		});

		if (flatId != 0) {
			var flatOption = new Option(flatName, flatId, true, true);
			$('#flat_id').append(flatOption).trigger('change');
		}

		if (parkingAreaId != 0) {
			var parkingAreaOption = new Option(parkingAreaName, parkingAreaId, true, true);
			$('#parking_vehicle_id').append(parkingAreaOption).trigger('change');
		}

		if (ownershipFlatParkingId != 0) {
			var ownershipFlatParkingOption = new Option(ownershipFlatParkingName, ownershipFlatParkingId, true, true);
			$('#ownership_flat_parking_id').append(ownershipFlatParkingOption).trigger('change');
		}

		$('#parking_slot_modal').modal('show');
		modalFlatDd();
		modalParkingVehicleDd();
		modalOwnershipFlatVehicleDd();
	});

	// unchecked all checkbox of table on modal close
	$(document).on('hide.bs.modal', '#parking_slot_modal', function() {
		$('.datatable-select-all-second').prop('checked', false);
		$('#parking_slot_table .datatable-checkbox').prop('checked', false);
	});

	$('#parking_slot_modal').on('shown.bs.modal', function() {
		$('#parking_area_id').focus();
	});

	$(document).on('click', '.datatable-checkbox', function() {
		$(".dt-delete-record").removeClass("invisible");
	});
	$(document).on('click', '.dt-excel-export', function() {
		$(this).removeClass(".dt-excel-export");
		var dataTableParams = dt_DataTable.ajax.params();
		url = '<?= admin_url('ParkingSlot/excelExportParkingSlot/') . ""  ?>';
		var recursiveEncoded = $.param(dataTableParams);
		$('.dt-export-anchor').attr('href', url + "?" + recursiveEncoded);
		$('.dt-export-anchor')[0].click();
	});
</script>
<?= isset($select2_ajax) ? $select2_ajax : ""; ?>