<?php
$dtCIAcl = new \App\Libraries\Dt_ci_acl();
?>
<a style="display: none;" href="" class="dt-export-anchor" target="_blank"></a>
<div class="card">
	<div class="card-datatable table-responsive">
		<table id="parking_place_table" class="table dt-datatable">
			<thead class="border-top">
				<tr>
					<th><input class="form-check-input datatable-select-all-second" type="checkbox" /></th>
					<!-- <th class="font-weight-bold"><?//= lang("ParkingPlace.society"); ?></th> -->
                    <th class="font-weight-bold"><?= lang("ParkingPlace.area"); ?></th>
					<th class="font-weight-bold"><?= lang("Area.vehicle_type"); ?></th>
                    <th class="font-weight-bold"><?= lang("ParkingPlace.flat_no"); ?></th>
					<th class="font-weight-bold"><?= lang("ParkingPlace.number"); ?></th>
					<th class="font-weight-bold"><?= lang("ParkingPlace.is_visitor_parking"); ?></th>
					<th class="font-weight-bold"><?= lang("ParkingPlace.ownership_flat_member"); ?></th>
					<th class="font-weight-bold"><?= lang("CommonMessage.common_active"); ?></th>
                	<th class="font-weight-bold"><?= lang("CommonMessage.common_action"); ?></th>
				</tr>
			</thead>
		</table>
	</div>
</div>
<?= isset($v_parking_place_modal) ? $v_parking_place_modal : ""; ?>
<script type="text/javascript">
	function modalFlatDd() {
		$('.flatDd').each(function() {
			var $this = $(this);
			$this.wrap('<div class="position-relative"></div>').select2({
				placeholder: 'Select value',
				dropdownParent: $this.parent(),
			ajax: {
				url: "<?= admin_url('Flat/getFlatDd') ?>",
				dataType: 'json',
				type: 'post',
				delay: '<?= SELECT2_MINIMUM_DELAY; ?>',
				data: function(params) {
					return {
						filter_param: params.term || '', // search term
						page: params.page || 1,
					};
				},
				processResults: function(data, params) {
					// parse the results into the format expected by Select2
					// since we are using custom formatting functions we do not need to
					// alter the remote JSON data, except to indicate that infinite
					// scrolling can be used
					//                    params.page = params.page || 1;

					params.page = params.page || 1;
					return {
                        results: data.result,
                        pagination: {
                            more: (params.page * 10) < data.total_count
                        }
					};
				},
				//cache: true
			},
			placeholder: 'Select Flat No',
			escapeMarkup: function(markup) {
				return markup;
			}, // let our custom formatter work
			//minimumInputLength: 2,
		}).on('select2:select', function(flat) {
			if ($("#" + $(this).attr('id')).valid()) {
				$("#" + $(this).attr('id')).removeClass('invalid').addClass('success');
			}
		});
	});
	}

	function modalAreaDd() {
		$('.areaDd').each(function() {
			var $this = $(this);
			$this.wrap('<div class="position-relative"></div>').select2({
				placeholder: 'Select value',
				dropdownParent: $this.parent(),
				ajax: {
					url: "<?= admin_url('Area/getAreaDd') ?>",
					dataType: 'json',
					type: 'post',
					delay: '<?= SELECT2_MINIMUM_DELAY; ?>',
					data: function(params) {
						return {
							filter_param: params.term || '', // search term
							page: params.page || 1,

						};
					},
					processResults: function(data, params) {
						// parse the results into the format expected by Select2
						// since we are using custom formatting functions we do not need to
						// alter the remote JSON data, except to indicate that infinite
						// scrolling can be used
						//                    params.page = params.page || 1;
						params.page = params.page || 1;
						return {
							results: data.result,
							pagination: {
								more: (data.page * 10) < data.totalRows

							}
						};
					},
					//cache: true
				},
				placeholder: 'Select Area',
				escapeMarkup: function(markup) {
					return markup;
				}, // let our custom formatter work
				//minimumInputLength: 2,
			}).on('select2:select', function(flat) {
				if ($("#" + $(this).attr('id')).valid()) {
					$("#" + $(this).attr('id')).removeClass('invalid').addClass('success');
				}

			});
		});
	}

	var dt_DataTable;
	$(document).ready(function() {
		dt_DataTable = $('#parking_place_table').DataTable({
			dom: '<"card-header d-flex border-top rounded-0 flex-wrap py-0"' +
				'<"me-5 ms-n2 pe-5"f>' +
				'<"d-flex justify-content-start justify-content-md-end align-items-baseline"<"dt-action-buttons d-flex flex-column align-items-start align-items-md-center justify-content-sm-center mb-3 mb-md-0 pt-0 gap-4 gap-sm-0 flex-sm-row"lB>>' +
				'>t' +
				'<"row mx-2"' +
				'<"col-sm-12 col-md-6"i>' +
				'<"col-sm-12 col-md-6"p>' +
				'>',
			processing: true,
			serverSide: true,
			displayLength: 10,
			// language: {
			// 	sLengthMenu: 'Show _MENU_',
			// 	search: '',
			// 	searchPlaceholder: 'Search <?= lang('ParkingPlace.parking_place'); ?>',
			// 	info: 'Displaying _START_ to _END_ of _TOTAL_ entries'
			// },
			language: {
                sLengthMenu: 'Show _MENU_',
                search: '',
                searchPlaceholder: 'Search Parking Place',
                info: 'Displaying _START_ to _END_ of _TOTAL_ entries'
            },
			buttons: [
				{
					extend: 'collection',
					className: 'btn btn-label-secondary px-2 dropdown-toggle me-2 waves-effect waves-light',
					text: '<i class="ti ti-download me-1 ti-xs"></i>Export',
					buttons: [
						{
							text: '<i class="ti ti-file me-2" ></i>Excel',
							className: 'dropdown-item dt-excel-export'
						},
						// {
						// 	extend: 'pdf',
						// 	text: '<i class="ti ti-file-text me-2"></i>Pdf',
						// 	className: 'dropdown-item',
						//
						// }
					]
				},
				<?php /*?>
				<?php if ($dtCIAcl->checkAccess("ParkingPlace|addEdit")) { ?>
                {
                    text: '<i class="ti ti-plus me-0 me-sm-1 ti-xs"></i><span class="d-none d-sm-inline-block"><?= lang('ParkingPlace.add_parking_place');?></span>',
                    className: 'add-new btn btn-primary  px-1 me-2 add_parking_place',
                    // action: function () {
                    // 	window.location.href = productAdd;
                    // }
                },

                <?php } ?>
                <?php if ($dtCIAcl->checkAccess("ParkingPlace|delete")) { ?>
                {
                    text: '<i class="ti ti-trash me-0 me-sm-1 ti-xs"></i><span class="d-none d-sm-inline-block"><?= lang('ParkingPlace.delete_parking_place');?></span>',
                    //className: 'btn btn-danger ms-2 ms-sm-0 waves-effect waves-light dt-delete-record invisible',
                    className: 'btn btn-danger  px-1 dt-delete-record',
                },
                <?php } ?>
				<?php */?>
			],
			"ajax": {
				"url": "<?php echo admin_url('ParkingPlace/getParkingPlaceListing'); ?>",
				"type": "POST",
				"data": function ( d ) {

                }
			},
			"stateSave": true,
			"order": [
				[0, "desc"]
			],
			"columns": [{
					"data": "parking_place_id",
					"render": function(data, type, row) {
						return '<input class="form-check-input datatable-checkbox" type="checkbox" id="ids_' + row['parking_place_id'] + '" name="ids[]" value="' + row['parking_place_id'] + '"/>';
					},
					"sortable": false,
					"searchable": false
				},
				// {
				// 	"data": "society_name"
				// },
                {
                    "data": "area_name"
                },
				{"data": "vehicle_type"},
				{
					"data": "flat_no",
					"class": "no_click_allowed",
				 	"render": function (data, type, row) {
						return row['display_flat_no'];
					}
				},

				{"data": "number"},
                {"data": "is_visitor_parking_display"},
                {"data": "name"},
				{
					"data": "is_active",
					"sortable": false,
					"searchable": false,
					"render": function(data, type, row) {
						var checked = (data == 1) ? "checked" : "";
						return '<label class="switch switch-primary switch-sm">' +
							'<input type="checkbox" class="switch-input  dt-active-status" ' + checked + '  data-id="' + row['parking_place_id'] + '" value="1" />' +
							'<span class="switch-toggle-slider">' +
							'<span class="switch-on"></span>' +
							'<span class="switch-off"></span>' +
							'</span>';
						'</label>';
					}
				},
				{
					"data": "action_button",
					"class": "text-center",
					"sortable": false,
					"searchable": false
				},
			],
			"fnDrawCallback": function(oSettings, json) {
				customToolTip();
				$('.dataTables_length').addClass('mt-2 mt-sm-0 mt-md-3 me-2');
				$('.dt-buttons').addClass('d-flex flex-wrap');
				$('.dataTables_filter .form-control').removeClass('form-control-sm');
				$('.dataTables_length .form-select').removeClass('form-select-sm');
				//checkBoxRefresh("datatable-checkbox");
				switcheryKeyGen("datatable-list-switchery");

			}
		});
		dtDataTableSearch();
	});

	$(document).on('click', '.add_parking_place', function () {
        dtFormClear('form_parking_place');
        $("form#form_parking_place input[name=parking_place_id]").val('');
        $('#parking_place_modal').modal('show');
        modalFlatDd();
        modalAreaDd();
    });



	$(document).on('click', '.dt-active-status', function() {
		var id = $(this).attr('data-id');
		var isActive = $(this).is(":checked") ? 1 : 0;
		$.ajax({
			type: 'post',
			url: '<?php echo admin_url('ParkingPlace/changeStatus'); ?>',
			data: {
				parking_place_id: id,
				status: isActive
			},
			dataType: 'json',
			success: function(data) {
				if (data) {
					Swal.fire({
						title: 'Success',
						text: data.msg,
						icon: 'success',
						customClass: {
							confirmButton: 'btn btn-primary waves-effect waves-light'
						},
						buttonsStyling: false
					}).then(function() {
						dt_DataTable.ajax.reload(null, false);
					});
				} else {
					Swal.fire({
						title: 'Error!',
						text: data.msg,
						icon: 'error',
						customClass: {
							confirmButton: 'btn btn-primary waves-effect waves-light'
						},
						buttonsStyling: false
					});
				}
			}
		});
	});

	$(document).on('click', '.dt-delete-record', function () {
        var id = $(this).attr("data-id");
        var deleteId = [];
        if(id != undefined){
            $('.datatable-select-all-second').prop('checked', false);
            $('.datatable-checkbox').prop('checked', false);
            $("#ids_" + id).prop("checked", true);
            deleteId.push(id);
        }
        else{
            var deleteElement =$('#parking_place_table tbody .datatable-checkbox:checked');
            var selectedLength = deleteElement.length;
            if (selectedLength == 0) {
                Swal.fire({
                    title: "<?= ucwords(lang('CommonMessage.common_sweet_alert_info')); ?>",
                    text: "<?= lang('CommonMessage.delete_info'); ?>",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonText: 'OK',
                    customClass: {
                        confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
                        cancelButton: 'btn btn-label-secondary waves-effect waves-light'
                    },
                    buttonsStyling: false
                }).then(function () {
                    return false;
                });
            } else {
                $.each(deleteElement, function (i, ele) {
                    deleteId.push($(ele).val());
                });
            }
        }
        if (deleteId.length > 0) {
            Swal.fire({
                title: "<?= ucwords(lang('CommonMessage.common_sweet_alert_delete')); ?>",
                text: "<?= lang('CommonMessage.delete_warning'); ?>",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'OK',
                customClass: {
                    confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
                    cancelButton: 'btn btn-label-secondary waves-effect waves-light'
                },
                buttonsStyling: false
            }).then(function(result) {
                if (result.value) {
                    $.ajax({
                        type: "post",
                        url: "<?= admin_url("ParkingPlace/delete")?>",
                        dataType: "json",
                        data: {parking_place_id: deleteId},
                        success: function (data) {
                            if (data['success']) {
                                Swal.fire({
                                    title: 'Success',
                                    text: data['msg'],
                                    icon: 'success',
                                    customClass: {
                                        confirmButton: 'btn btn-primary waves-effect waves-light'
                                    },
                                    buttonsStyling: false
                                }).then(function() {
                                    dt_DataTable.ajax.reload();
                                });
                            } else {
                                Swal.fire({
                                    title: 'Error!',
                                    text: data['msg'],
                                    icon: 'error',
                                    customClass: {
                                        confirmButton: 'btn btn-primary waves-effect waves-light'
                                    },
                                    buttonsStyling: false
                                }).then(function() {
                                    dt_DataTable.ajax.reload();
                                });
                            }
                        }
                    });
                }
                else {
                    $('.datatable-checkbox').prop('checked', false);
                }
            });
        }
    });


	//Edit Record
	$(document).on('click', '.dt-edit-record', function() {
		$('.datatable-select-all-second').prop('checked', false);
		$('.datatable-checkbox').prop('checked', false);
		$("form#form_parking_place .validation-invalid-label").html('');
		var id = $(this).attr('data-id');
		$("#ids_" + id).prop("checked", true);
		var edit_val = $('.datatable-checkbox:checked').val();
		var selected_tr = $('.datatable-checkbox:checked');
		var element = $(selected_tr).closest('tr').get(0);	
		var aData = dt_DataTable.row(element).data();
		dtFormFill('form_parking_place', aData);
		var flatId = 0;
		var flatName = '';
		var areaId = 0;
		var areaName = '';
		$.each(aData, function(key,val ) {
			if (key == 'flat_id') {
				flatId = val;
			} else if (key == 'flat_no') {
				flatName = val;
			}
			else if (key == 'area_id') {
				areaId = val;
			}
			else if (key == 'area_vehicle_type_name') {
				areaName = val;
			}
		});

		if (flatId != 0) {
			var flatOption = new Option(flatName, flatId, true, true);
			$('#flat_id').append(flatOption).trigger('change');
		}

		if (areaId != 0) {
			var areaOption = new Option(areaName, areaId, true, true);
			$('#area_id').append(areaOption).trigger('change');
		}

		$('#parking_place_modal').modal('show');
		modalFlatDd();
		modalAreaDd();
	});

	// unchecked all checkbox of table on modal close
	$(document).on('hide.bs.modal', '#parking_place_modal', function() {
		$('.datatable-select-all-second').prop('checked', false);
		$('#parking_place_table .datatable-checkbox').prop('checked', false);
	});

	$('#parking_place_modal').on('shown.bs.modal', function() {
		$('#area_id').focus();
	});

	$(document).on('click', '.datatable-checkbox', function() {
		$(".dt-delete-record").removeClass("invisible");
	});
	$(document).on('click', '.dt-excel-export', function() {
		$(this).removeClass(".dt-excel-export");
		var dataTableParams = dt_DataTable.ajax.params();
		url = '<?= admin_url('ParkingPlace/excelExportParkingPlace/') . ""  ?>';
		var recursiveEncoded = $.param(dataTableParams);
		$('.dt-export-anchor').attr('href', url + "?" + recursiveEncoded);
		$('.dt-export-anchor')[0].click();
	});
</script>
<?= isset($select2_ajax) ? $select2_ajax : ""; ?>