<?php 
(isset($type) && $type != "") ? $type : '-';

if($type == TRANSFERRED) {
    $ownershipFlat = 'TransferredFlat.';
}
else{
    $ownershipFlat = 'OwnershipFlat.';
}
?>
<ul class="nav nav-tabs" role="tablist">
	<li class="nav-item">
		<button type="button" class="nav-link active" role="tab" data-bs-toggle="tab" data-bs-target="#ownership_flat_detail" aria-controls="ownership_flat_detail" aria-selected="true">
			<?= lang($ownershipFlat.'ownership_flat_detail'); ?>
		</button>
	</li>
	<li class="nav-item">
		<button type="button" class="nav-link" role="tab" data-bs-toggle="tab" data-bs-target="#member-information" aria-controls="member-information" aria-selected="false">
			<?= lang($ownershipFlat.'member_information'); ?>
		</button>
	</li>
	<li class="nav-item">
		<button type="button" class="nav-link" role="tab" data-bs-toggle="tab" data-bs-target="#emergency-contact" aria-controls="emergency-contact" aria-selected="false">
			<?= lang($ownershipFlat.'emergency_informations'); ?>
		</button>
	</li>
	<li class="nav-item">
		<button type="button" class="nav-link" role="tab" data-bs-toggle="tab" data-bs-target="#vehicle-detail" aria-controls="vehicle-detail" aria-selected="false">
			<?= lang($ownershipFlat.'parking_information'); ?>
		</button>
	</li>
	<?php /*
	<li class="nav-item">
		<button type="button" class="nav-link" role="tab" data-bs-toggle="tab" data-bs-target="#access-card-detail" aria-controls="access-card-detail" aria-selected="false">
			<?= lang($ownershipFlat.'access_card_information'); ?>
		</button>
	</li> */ ?>
	<li class="nav-item">
		<button type="button" class="nav-link" role="tab" data-bs-toggle="tab" data-bs-target="#attached-document" aria-controls="attached-document" aria-selected="false">
			<?= lang($ownershipFlat.'ownership_flat_document'); ?>
		</button>
	</li>
</ul>

<div class="tab-content">
	<div class="tab-pane fade show active" id="ownership_flat_detail" role="tabpanel">
		<div class="table-responsive text-nowrap">
			<table id="ownership_flat_detail_table" class="table table-xs">
				<thead>
					<tr>
						<th><?= lang("CommonMessage.common_detail"); ?></th>
						<th><?= lang("CommonMessage.common_value"); ?></th>
					</tr>
				</thead>
				<tbody>
					<tr>
						<td><?= lang($ownershipFlat."flat_no"); ?></td>
						<td><?php
							echo (isset($ownership_flat_data['flat_no']) && $ownership_flat_data['flat_no'] != "") ? $ownership_flat_data['flat_no'] : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang($ownershipFlat."bhk"); ?></td>
						<td><?php
							echo (isset($ownership_flat_data['bhk']) && $ownership_flat_data['bhk'] != "") ? roundNumber($ownership_flat_data['bhk']) : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang($ownershipFlat."sq_ft"); ?></td>
						<td><?php
							echo (isset($ownership_flat_data['sqr_ft']) && $ownership_flat_data['sqr_ft'] != "") ? roundNumber($ownership_flat_data['sqr_ft']) : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang($ownershipFlat."intercom_no"); ?></td>
						<td><?php
							echo (isset($ownership_flat_data['intercom_no']) && $ownership_flat_data['intercom_no'] != "") ? $ownership_flat_data['intercom_no'] : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang($ownershipFlat."date_of_registry"); ?></td>
						<td><?php
							echo (isset($ownership_flat_data['date_of_registry']) && $ownership_flat_data['date_of_registry'] != "") ? siteDateFormat($ownership_flat_data['date_of_registry']) : '-';
							?></td>
					</tr>
					<tr>
						<td><?= lang($ownershipFlat."index_no"); ?></td>
						<td><?php
							echo (isset($ownership_flat_data['index_no']) && $ownership_flat_data['index_no'] != "") ? $ownership_flat_data['index_no'] : '-';
							?>
						</td>
					</tr>
                    <tr>
                        <td><?= lang($ownershipFlat."buyer"); ?></td>
                        <td><?php
                            echo (isset($ownership_flat_data['buyer_name']) && $ownership_flat_data['buyer_name'] != "") ? $ownership_flat_data['buyer_name'] : '-';
                            ?>
                        </td>
                    </tr>

					<tr>
						<td><?= lang($ownershipFlat."purchased_from"); ?></td>
						<td><?php
							echo (isset($ownership_flat_data['owner_name']) && $ownership_flat_data['owner_name'] != "") ? $ownership_flat_data['owner_name'] : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang($ownershipFlat."resident"); ?></td>
						<td><?php
							echo (isset($ownership_flat_data['resident']) && $ownership_flat_data['resident'] != "") ? $ownership_flat_data['resident'] : '-';
							?>
						</td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_created_at"); ?></td>
						<td><?php
							echo (isset($ownership_flat_data['created_at']) && isValidDate($ownership_flat_data['created_at'])) ? siteDateFormat($ownership_flat_data['created_at'], TRUE) : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_created_by"); ?></td>
						<td><?php
							echo (isset($ownership_flat_data['created_by']) && $ownership_flat_data['created_by'] != "") ? $ownership_flat_data['created_by'] : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_updated_at"); ?></td>
						<td><?php
							echo (isset($ownership_flat_data['updated_at']) && isValidDate($ownership_flat_data['updated_at'])) ? siteDateFormat($ownership_flat_data['updated_at'], TRUE) : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_updated_by"); ?></td>
						<td><?php
							echo (isset($ownership_flat_data['updated_by']) && $ownership_flat_data['updated_by'] != "") ? $ownership_flat_data['updated_by'] : '-';
							?></td>
					</tr>
				</tbody>
			</table>
		</div>
	</div>
	<div class="tab-pane fade" id="member-information" role="tabpanel">
		<div class="table-responsive text-nowrap">
			<table id="member_details_table" class="table table-bordered">
				<thead>
					<tr>
						<th><?= lang("CommonMessage.common_sr_no"); ?></th>
						<th><?= lang($ownershipFlat."name"); ?></th>
						<th><?= lang($ownershipFlat."email_id"); ?></th>
						<th><?= lang($ownershipFlat."mobile"); ?></th>
						<th><?= lang($ownershipFlat."gender"); ?></th>
						<th><?= lang($ownershipFlat."birth_yr"); ?></th>
						<th><?= lang($ownershipFlat."blood_gp"); ?></th>
						<th><?= lang($ownershipFlat."is_owner"); ?></th>
					</tr>
				</thead>
				<tbody class="">
					<?php if ($ownership_flat_member_data != '' && array_filter($ownership_flat_member_data)) { ?>
						<?php
						$sr = 1;
						foreach ($ownership_flat_member_data as $key => $value) { ?>
							<tr>
								<td><?= $sr; ?></td>
								<td><?= $value['name']; ?> </td>
								<td> <?= $value['email_id']; ?> </td>
								<td> <?= $value['mobile_no']; ?> </td>
								<td> <?= underscoreToUcWord($value['gender']); ?> </td>
								<td> <?= YMDToDMY($value['birth_date']); ?> </td>
								<td> <?= $value['blood_group']; ?> </td>
								<td> <?= (isset($value['is_owner']) && $value['is_owner'] == 1) ? 'Yes' : 'No'; ?> </td>
							</tr>
						<?php $sr++;
						}
					} else {   ?>
						<tr>
							<td colspan="8" align="center"> <?= lang('CommonMessage.common_no_data_found'); ?></td>
						</tr>
					<?php } ?>
				</tbody>
			</table>
		</div>

	</div>
	<div class="tab-pane fade" id="emergency-contact" role="tabpanel">

		<div class="table-responsive text-nowrap">
			<table id="emergency_details_table" class="table table-bordered">
				<thead>
					<tr>
						<th><?= lang("CommonMessage.common_sr_no"); ?></th>
						<th><?= lang($ownershipFlat."e_name"); ?></th>
						<th><?= lang($ownershipFlat."e_place"); ?></th>
						<th><?= lang($ownershipFlat."e_relation"); ?></th>
						<th><?= lang($ownershipFlat."e_mobile"); ?></th>
					</tr>
				</thead>
				<tbody class="">
					<?php if ($ownership_flat_emergency_contact_data != '' && array_filter($ownership_flat_emergency_contact_data)) { ?>
						<?php
						$sr = 1;
						foreach ($ownership_flat_emergency_contact_data as $key => $value) { ?>
							<tr>
								<td> <?= $sr; ?></td>
								<td> <?= $value['name']; ?> </td>
								<td> <?= $value['place']; ?> </td>
								<td> <?= underscoreToUcWord($value['relation']); ?> </td>
								<td> <?= $value['mobile_no']; ?> </td>
							</tr>
						<?php $sr++;
						}
					} else {   ?>
						<tr>
							<td colspan="5" align="center"> <?= lang('CommonMessage.common_no_data_found'); ?></td>
						</tr>
					<?php } ?>
				</tbody>
			</table>
		</div>
	</div>

	<div class="tab-pane fade" id="vehicle-detail" role="tabpanel">

		<div class="table-responsive text-nowrap">
			<table id="vehicle_details_table" class="table table-bordered">
				<thead>
					<tr>
						<th><?= lang("CommonMessage.common_sr_no"); ?></th>
						<th><?= lang($ownershipFlat."vehicle_type"); ?></th>
						<th><?= lang($ownershipFlat."parking_slot"); ?></th>
						<th><?= lang($ownershipFlat."vehicle_no"); ?></th>
						<th><?= lang($ownershipFlat."parking_slot_no"); ?></th>
						<th><?= lang($ownershipFlat."token_no"); ?></th>

					</tr>
				</thead>
				<tbody class="">

					<?php if ($ownership_flat_parking_data != '' && array_filter($ownership_flat_parking_data)) { ?>
						<?php
						$sr = 1;
						foreach ($ownership_flat_parking_data as $key => $value) { ?>
							<tr>
								<td><?= $sr; ?></td>
								<td><?= underscoreToUcWord($value['vehicle_type']); ?> </td>
								<td> <?= $value['parking_area']; ?> </td>
								<td> <?= $value['vehicle_no']; ?> </td>
								<td> <?= $value['parking_slot_no']; ?> </td>
								<td> <?= $value['token_no']; ?> </td>
							</tr>
						<?php $sr++;
						}
					} else {   ?>
						<tr>
							<td colspan="6" align="center"> <?= lang('CommonMessage.common_no_data_found'); ?></td>
						</tr>
					<?php } ?>
				</tbody>
			</table>
		</div>

	</div>
	<?php /*
	<div class="tab-pane fade" id="access-card-detail" role="tabpanel">

		<div class="table-responsive text-nowrap">
			<table id="access-card-detail_table" class="table table-bordered">
				<thead>
					<tr>
						<th><?= lang("CommonMessage.common_sr_no"); ?></th>
						<th><?= lang($ownershipFlat."remarks"); ?></th>
						<th><?= lang($ownershipFlat."lifts_access"); ?></th>
						<th><?= lang($ownershipFlat."amenities_usage"); ?></th>
						<th><?= lang($ownershipFlat."vehicle_type"); ?></th>
					</tr>
				</thead>
				<tbody class="">

					<?php if ($ownership_flat_access_card_data != '' && array_filter($ownership_flat_access_card_data)) { ?>
						<?php
						$sr = 1;
						foreach ($ownership_flat_access_card_data as $key => $value) { ?>
							<tr>
								<td><?= $sr; ?></td>
								<td> <?= $value['remarks']; ?> </td>
								<td> <?= $value['lift_access']; ?> </td>
								<td> <?= $value['amenities_name']; ?> </td>
								<td>
									<?php foreach ($value['vehicle_data'] as $key => $value) { ?>
										<?= underscoreToUcWord($value['vehicle_type']); ?>
									<?php } ?>
								</td>
							</tr>
						<?php $sr++;
						}
					} else {   ?>
						<tr>
							<td colspan="6" align="center"> <?= lang('CommonMessage.common_no_data_found'); ?></td>
						</tr>
					<?php } ?>
				</tbody>
			</table>
		</div>

	</div> */ ?>

	<div class="tab-pane fade" id="attached-document" role="tabpanel">
		<div class="table-responsive text-nowrap">
			<table id="document_details_table" class="table table-bordered">
				<thead>
					<tr>
						<th class="text-center" style="width: 5%"><?= lang("CommonMessage.common_sr_no"); ?></th>
						<th style="width: 10%"><?= lang("Document.document_name"); ?></th>
						<th style="width: 10%"><?= lang("Document.document_image"); ?></th>
					</tr>
				</thead>
				<tbody class="">
                	<?php if($document_data != '' && array_filter($document_data)) {
                    $sr = 1;
                    foreach ($document_data as $key => $value) { ?>
						<tr>
							<td class="text-center"><?= $sr; ?></td>
                            <td colspan="1"><?= underscoreToUcWord($value['document_name']); ?> </td>
                            <td colspan="1">
							<?php if (isset($value['module_image_data']) && $value['module_image_data'] != '' ) {?>
								<?php
								foreach($value['module_image_data'] as $document){
								$paths = site_url() . DOCUMENT_IMAGE_PATH . $document['document_image'];
									if(file_exists( DOCUMENT_IMAGE_PATH .$document['document_image'])){ ?>
									 
									

									<a href="<?= $paths; ?>"  target="_blank">
										<img src="<?= $paths; ?>" width="100" height="100" class="img-fluid" alt="">
									</a>
									<?php }?>
								<?php }  ?>
							<?php } ?> 
							</td>
						</tr>
                    <?php $sr++;} }  else {   ?>
						<tr>
							<td colspan="3" align="center"> <?= lang('CommonMessage.common_no_data_found'); ?></td>
						</tr>
					<?php } ?>
			</tbody>
			</table>
		</div>
	</div>
</div>