<style>
	.form-controls {
		display: block;
		padding: 0.422rem 0.875rem;
		font-size: 0.9375rem;
		font-weight: 400;
		line-height: 1.5;
		color: #6f6b7d;
		appearance: none;
		background-color: #fff;
		background-clip: padding-box;
		border: var(--bs-border-width) solid #dbdade;
		border-radius: var(--bs-border-radius);
		transition: border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out;
	}

	.form-selects {
		--bs-form-select-bg-img: url(data:image/svg+xml,%3Csvg width= '20' height= '20' viewBox= '0 0 20 20' fill= 'none' xmlns= 'http://www.w3.org/2000/svg' %3E%3Cpath d= 'M5 7.5L10 12.5L15 7.5' stroke= '%236f6b7d' stroke-width= '1.5' stroke-linecap= 'round' stroke-linejoin= 'round' /%3E%3Cpath d= 'M5 7.5L10 12.5L15 7.5' stroke= 'white' stroke-opacity= '0.2' stroke-width= '1.5' stroke-linecap= 'round' stroke-linejoin= 'round' /%3E%3C/svg%3E);
		display: block;
		padding: 0.422rem 2.45rem 0.422rem 0.875rem;
		font-size: 0.9375rem;
		font-weight: 400;
		line-height: 1.5;
		color: #6f6b7d;
		appearance: none;
		background-color: #fff;
		background-image: var(--bs-form-select-bg-img), var(--bs-form-select-bg-icon, none);
		background-repeat: no-repeat;
		background-position: right 0.875rem center;
		background-size: 22px 20px;
		border: var(--bs-border-width) solid #dbdade;
		border-radius: var(--bs-border-radius);
		transition: border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out;
	}
</style>

<?php
$type = $request->getPost('type');
$html = '';
if (isset($ownership_flat_access_card_data) && !empty($ownership_flat_access_card_data)) {
	foreach ($ownership_flat_access_card_data as $key => $value) {
		$data["access_card_row_number"] = $key + 1;
		$data["ownership_flat_access_card_data"] = $value;
		$html .= view('Admin/OwnershipFlat/OwnershipFlatAccessCardRowView', $data);
	}
}
?>
<!-- Responsive Table -->
	<div class="table-responsive text-nowrap">
		<table id="ownership_flat_access_card_table" class="table">
			<thead>
			<tr class="text-nowrap">
				<th><?= lang('CommonMessage.common_sr_no'); ?></th>
				<th><?= lang('OwnershipFlat.remarks'); ?><span class="text-danger"> *</span></th>
				<th><?= lang('OwnershipFlat.lifts_access'); ?><span class="text-danger"> *</span></th>
				<th><?= lang('OwnershipFlat.amenities_usage'); ?><span class="text-danger"> *</span></th>
				<th><?= lang('OwnershipFlat.vehicle_type'); ?></th>
				<th><?= lang('CommonMessage.common_action'); ?></th>
			</tr>
			</thead>
			<tbody class="table-border-bottom-0">
			<?php
			if (isset($ownership_flat_access_card_data) && !empty($ownership_flat_access_card_data)) {
				echo $html;
			}else { ?>
				<?php
				$data["access_card_row_number"] =  1;
				echo view('Admin/OwnershipFlat/OwnershipFlatAccessCardRowView',$data); ?>
			<?php } ?>

			</tbody>
		</table>
	</div>
<!--/ Responsive Table -->
<script>
	var accessCardRowNumber;

	function addOwnershipFlatAccessCard() {
		var lastIndex = ($("#ownership_flat_access_card_table tbody tr:last").length >= 1) ? $("#ownership_flat_access_card_table tbody tr:last").attr("data-id").split("_").pop() : 0;
        accessCardRowNumber = parseInt(lastIndex) + 1;
		$.ajax({
			type: "post",
			url: "<?= admin_url('OwnershipFlat/addOwnershipFlatAccessCardRow'); ?>",
			dataType: "html",
			async: false,
			data: {
				access_card_row_number: accessCardRowNumber,
			},
			success: function (data) {
				if (data) {
					$('table#ownership_flat_access_card_table tbody').append(data);
					addSerialNumber('ownership_flat_access_card_table');
                    amenitiesDd();
                    $('.dt-access-card-vehicle-type').select2();
					customToolTip();
				}
			}
		});
	}


	$(document).on('click', '.dt-delete-access-card-row', function () {
		var trField = $(this).closest('tr');
		var id = $(this).closest('tr').find(".module_access_card_token_id").val();
		var ownershipFlatId = $("#ownership_flat_id").val();

		if (id != '') {
				Swal.fire({
					title: "<?= ucwords(lang('CommonMessage.common_sweet_alert_delete')); ?>",
					text: "<?= lang('CommonMessage.delete_warning'); ?>",
					icon: 'warning',
					showCancelButton: true,
					confirmButtonText: 'OK',
					customClass: {
						confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
						cancelButton: 'btn btn-label-secondary waves-effect waves-light'
					},
					buttonsStyling: false

			}).then(function (result) {
				if (result.value) {
					var deleteId = [];
					deleteId.push(id);
					$.ajax({
						type: "POST",
						url: "<?php echo admin_url('OwnershipFlat/deleteOwnershipFlatAccessCardRow');?>",
						dataType: "json",
						async:false,
						data: {
                            module_access_card_token_id: deleteId,
							module_type: 'ownership_flat',
							module_type_id: ownershipFlatId,
							type : '<?= $type;?>'
						},
						success: function (resObj) {
							if (resObj.success) {
								$(trField).remove();
								addSerialNumber('ownership_flat_access_card_table');
								Swal.fire({
									title: 'Success',
									text: resObj['msg'],
									icon: 'success',
									customClass: {
										confirmButton: 'btn btn-primary waves-effect waves-light'
									},
									buttonsStyling: false
								}).then(function() {
									if ($('#ownership_flat_access_card_table tbody > tr').length == 0) {
										addOwnershipFlatAccessCard();
									}
								});
							} else {

								Swal.fire({
									title: 'Error!',
									text: resObj['msg'],
									icon: 'error',
									customClass: {
										confirmButton: 'btn btn-primary waves-effect waves-light'
									},
									buttonsStyling: false
								});
							}
						}
					});
				}
			});
		} else {
			$(trField).remove();
			addSerialNumber('ownership_flat_access_card_table');
			if ($('#ownership_flat_access_card_table tbody > tr').length == 0) {
				addOwnershipFlatAccessCard();
			}
		}
	});


</script>
