<?php
$dtCIAcl = new \App\Libraries\Dt_ci_acl();
?>
<div class="row">
	<div class="col-md-12">
		<div class="card mb-4">
			<div class="card-header d-flex align-items-center justify-content-between">
				<h5 class="mb-0"><?= lang('OrganicWasteRecord.organic_waste_record_details');?></h5>
			</div>
			<div class="card-body">
				<?php
				//create  form open tag
				$form_id = array(
					'id'=>'form_organic_waste_record',
				);
				echo form_open_multipart('',$form_id);
				$organic_waste_recordId = (isset($organic_waste_record_data['organic_waste_record_id']) && ($organic_waste_record_data['organic_waste_record_id'] != '')) ? $organic_waste_record_data['organic_waste_record_id'] : '';
				?>
				<input type="hidden" id="organic_waste_record_id" name="organic_waste_record_id" value="<?= $organic_waste_recordId ?>">
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('OrganicWasteRecord.record_date');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">	
							<input type="text" class="form-control" name="record_date" id="record_date" placeholder="Enter <?= lang('OrganicWasteRecord.record_date');?>" value="<?= (isset($organic_waste_record_data['record_date']) && isValidDate($organic_waste_record_data['record_date'])) ? siteDateFormat($organic_waste_record_data['record_date']) : ''; ?>" />
						</div>
					</div>
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('OrganicWasteRecord.kitchen_waste');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">	
							<input type="text" class="form-control numberInit" name="kitchen_waste" id="kitchen_waste" placeholder="Enter <?= lang('OrganicWasteRecord.kitchen_waste');?>" value="<?= (isset($organic_waste_record_data['kitchen_waste']) && ($organic_waste_record_data['kitchen_waste'] != '')) ? $organic_waste_record_data['kitchen_waste'] : '';  ?>" />
						</div>
					</div>
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('OrganicWasteRecord.processed_compost');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">	
							<input type="text" class="form-control numberInit" name="processed_compost" id="processed_compost" placeholder="Enter <?= lang('OrganicWasteRecord.processed_compost');?>" value="<?= (isset($organic_waste_record_data['processed_compost']) && ($organic_waste_record_data['processed_compost'] != '')) ? $organic_waste_record_data['processed_compost'] : '';  ?>" />
						</div>
					</div>
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('OrganicWasteRecord.sawdust');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">	
							<input type="text" class="form-control numberInit" name="sawdust" id="sawdust" placeholder="Enter <?= lang('OrganicWasteRecord.sawdust');?>" value="<?= (isset($organic_waste_record_data['sawdust']) && ($organic_waste_record_data['sawdust'] != '')) ? $organic_waste_record_data['sawdust'] : '';  ?>" />
						</div>
					</div>
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('OrganicWasteRecord.bacteria');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">	
							<input type="text" class="form-control numberInit" name="bacteria" id="bacteria" placeholder="Enter <?= lang('OrganicWasteRecord.bacteria');?>" value="<?= (isset($organic_waste_record_data['bacteria']) && ($organic_waste_record_data['bacteria'] != '')) ? $organic_waste_record_data['bacteria'] : '';  ?>" />
						</div>
					</div>
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('OrganicWasteRecord.ready_compost');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">	
							<input type="text" class="form-control numberInit" name="ready_compost" id="ready_compost" placeholder="Enter <?= lang('OrganicWasteRecord.ready_compost');?>" value="<?= (isset($organic_waste_record_data['ready_compost']) && ($organic_waste_record_data['ready_compost'] != '')) ? $organic_waste_record_data['ready_compost'] : '';  ?>" />
						</div>
					</div>
					<div class="pt-4">
						<button type="submit" id="submitBtn" class="btn btn-primary me-sm-3 me-1 submit">Submit</button>
						<button type="button" id="cancelBtn" onclick="window.location.href='<?php echo admin_url('OrganicWasteRecord'); ?>'" class="btn btn-label-secondary">Cancel</button>
					</div>
				<?php echo form_close(); ?>
			</div>
		</div>
	</div>
</div>

<script>
    $(document).ready(function() {
    	numberInit();
		$("#record_date").flatpickr({
			dateFormat: 'd-m-Y'
		});
		switcheryKeyGen("datatable-list-switchery");
        // Initialize
		var validator = $("#form_organic_waste_record").validate({
			ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
			errorClass: 'validation-invalid-label',
			successClass: 'validation-valid-label',
			validClass: 'validation-valid-label',
			highlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			unhighlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			success: function(label) {
				label.addClass('validation-valid-label').text('Success.'); // remove to hide Success message
			},
			// Different components require proper error label placement
			errorPlacement: function(error, element) {

				// Unstyled checkboxes, radios
				if (element.parents().hasClass('form-check')) {
					error.appendTo( element.parents('.form-check').parent() );
				}

				// Input with icons and Select2
				else if (element.parents().hasClass('form-group row-feedback') || element.hasClass('select2-hidden-accessible')) {
					error.appendTo( element.parent() );
				}

				// Input group, styled file input
				else if (element.parent().is('.uniform-uploader, .uniform-select') || element.parents().hasClass('input-group')) {
					error.appendTo( element.parent().parent() );
				}

				// Other elements
				else {
					error.insertAfter(element);
				}
			},
            rules: {
				record_date: {
					required: true,
				},
				kitchen_waste: {
					required: true,
				},
				processed_compost: {
					required: true,
				},
				sawdust: {
					required: true,
				},
				bacteria: {
					required: true,
				},
				ready_compost: {
					required: true,
				},
            },
            messages: {
				record_date: {
					required: '<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("OrganicWasteRecord.record_date"); ?>',
				},
				kitchen_waste: {
					required: '<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("OrganicWasteRecord.kitchen_waste"); ?>',
				},
				processed_compost: {
					required: '<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("OrganicWasteRecord.processed_compost"); ?>',
				},
				sawdust: {
					required: '<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("OrganicWasteRecord.sawdust"); ?>',
				},
				bacteria: {
					required: '<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("OrganicWasteRecord.bacteria"); ?>',
				},
				ready_compost: {
					required: '<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("OrganicWasteRecord.ready_compost"); ?>',
				},
            },
            submitHandler: function (e) {
				$(e).ajaxSubmit({
					url: '<?php echo admin_url("OrganicWasteRecord/save");?>',
					type: 'post',
					beforeSubmit: function (formData, jqForm, options) {
						dtButtonHide('#submitBtn');
						dtButtonHide('#cancelBtn');
					},
					complete: function () {

					},
					dataType: 'json',
					clearForm: false,
					success: function (resObj, statusText) {
						if (resObj.success) {
							toastr.success(resObj.msg, 'Success', {
								closeButton: true,
								progressBar: true,
								positionClass: 'toast-top-right',
								timeOut: 1000,
								onHidden: function () {
                                    dtButtonShow('#submitBtn');
									dtButtonShow('#cancelBtn');
                                    window.location.href = '<?php echo admin_url('OrganicWasteRecord');?>';
                                }
							});

							// setTimeout(function () {
							// 	window.location.href = '<?php echo admin_url('OrganicWasteRecord');?>';
							// }, 1000);

						} else {
							dtButtonShow('#submitBtn');
							dtButtonShow('#cancelBtn');
							toastr.error(resObj.msg, 'Error', {
								closeButton: true,
								// progressBar: true,
								positionClass: 'toast-top-right',
								// timeOut: 1000
							});
						}
					}
				});
            }
        });
    });
	

	
</script>

<?= isset($select2_ajax) ? $select2_ajax : ""; ?>
