<div class="row">
	<div class="col-md-12">
		<div class="card mb-4">
			<div class="card-header d-flex align-items-center justify-content-between">
				<h5 class="mb-0"><?= lang('MenPowerAttendance.men_power_attendance_detail'); ?></h5>
			</div>
			<div class="card-body">
				<?php
				//create  form open tag
				$form_id = array(
					'id' => 'form_men_power_attendance',
				);
				echo form_open_multipart('', $form_id);
				$menPowerAttendanceId = (isset($men_power_attendance_data['men_power_attendance_id']) && ($men_power_attendance_data['men_power_attendance_id'] != '')) ? $men_power_attendance_data['men_power_attendance_id'] : '';
				?>
				<input type="hidden" id="men_power_attendance_id" name="men_power_attendance_id" value="<?= $menPowerAttendanceId ?>">

				<div class="row mb-3">
	                <label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('MenPowerAttendance.resource_type'); ?><span class="text-danger"> *</span></label>
	                <div class="col-sm-10">
		                <select id="resource_type_id" name="resource_type_id" class="select2 form-select form-select-lg dt-resource-type resourceTypeDd" data-allow-clear="true">
	                        <option></option>
	                        <?php if(isset($men_power_attendance_data['resource_type_id']) && $men_power_attendance_data['resource_type_id'] != 0){ ?>
	                        <option value="<?= isset($men_power_attendance_data['resource_type_id']) ? $men_power_attendance_data['resource_type_id'] : 0 ?>" selected> <?= isset($men_power_attendance_data['resource_type_name']) ? $men_power_attendance_data['resource_type_name'] : ''  ?> </option>
	                        <?php } ?>
	                </select>
		            </div>
	            </div>

				<div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('MenPowerAttendance.resource'); ?><span class="text-danger"> *</span></label>
					<div class="col-sm-10">
						<select id="resource_id" name="resource_id" class="select2 form-select form-select-lg resourceDd" data-allow-clear="true">
							<option></option>
							<?php if (isset($men_power_attendance_data['resource_id']) && $men_power_attendance_data['resource_id'] != 0) { ?>
								<option value="<?= isset($men_power_attendance_data['resource_id']) ? $men_power_attendance_data['resource_id'] : 0 ?>" selected> <?= isset($men_power_attendance_data['resource_name']) ? $men_power_attendance_data['resource_name'] : ''  ?> </option>
							<?php } ?>
						</select>
					</div>
				</div>

				<div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('MenPowerAttendance.men_power_attendance_date'); ?><span class="text-danger"> *</span></label>
					<div class="col-sm-10">
						<input type="text" class="form-control" name="men_power_attendance_date" id="men_power_attendance_date" placeholder="Enter <?= lang('MenPowerAttendance.men_power_attendance_date'); ?>" value="<?= (isset($men_power_attendance_data['men_power_attendance_date']) && isValidDate($men_power_attendance_data['men_power_attendance_date'])) ? siteDateFormat($men_power_attendance_data['men_power_attendance_date']) : ''; ?>" />
					</div>
				</div>
				<div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('MenPowerAttendance.in_time'); ?><span class="text-danger"> *</span></label>
					<div class="col-sm-10">
						<input type="time" class="form-control" name="in_time" id="in_time" placeholder="Enter <?= lang('MenPowerAttendance.in_time'); ?>" value="<?= (isset($men_power_attendance_data['in_time']) && ($men_power_attendance_data['in_time'] != '')) ? ($men_power_attendance_data['in_time']) : '';  ?>" />
					</div>
				</div>
				<div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('MenPowerAttendance.out_time'); ?><span class="text-danger"> *</span></label>
					<div class="col-sm-10">
						<input type="time" class="form-control" name="out_time" id="out_time" placeholder="Enter <?= lang('MenPowerAttendance.out_time'); ?>" value="<?= (isset($men_power_attendance_data['out_time']) && ($men_power_attendance_data['out_time'] != '')) ? ($men_power_attendance_data['out_time']) : '';  ?>" />
					</div>
				</div>
				<div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('CommonMessage.common_active'); ?></label>
					<div class="col-sm-10">
						<label class="switch switch-sm"><span class="switch-label"></span>
							<input type="checkbox" class="switch-input form-add-switchery" name="is_active" id="is_active" <?php echo (!isset($men_power_attendance_data['is_active']) || $men_power_attendance_data['is_active'] == 1) ? 'checked="checked"' : ''; ?>>
							<span class="switch-toggle-slider">
								<span class="switch-on"></span>
								<span class="switch-off"></span>
							</span>

						</label>
					</div>
				</div>

				<div class="pt-4">
					<button type="submit" id="submitBtn" class="btn btn-primary me-sm-3 me-1 submit">Submit</button>
					<button type="button" id="cancelBtn" onclick="window.location.href='<?php echo admin_url('MenPowerAttendance'); ?>'" class="btn btn-label-secondary">Cancel</button>
				</div>
				<?php echo form_close(); ?>
			</div>
		</div>
	</div>
</div>

<script>
	function inTime() {
		$('#in_time').flatpickr({
			enableTime: true,
			noCalendar: true,
            dateFormat: "h:i K"
		});
	}

	function outTime() {
		$('#out_time').flatpickr({
			enableTime: true,
			noCalendar: true,
            dateFormat: "h:i K"
		});
	}
	$(document).ready(function() {
		numberInit();
		resourceDd();
		resourceTypeDd();
		switcheryKeyGen("datatable-list-switchery");
		// Initialize
		var validator = $("#form_men_power_attendance").validate({
			ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
			errorClass: 'validation-invalid-label',
			successClass: 'validation-valid-label',
			validClass: 'validation-valid-label',
			highlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			unhighlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			success: function(label) {
				label.addClass('validation-valid-label').text('Success.'); // remove to hide Success message
			},
			// Different components require proper error label placement
			errorPlacement: function(error, element) {

				// Unstyled checkboxes, radios
				if (element.parents().hasClass('form-check')) {
					error.appendTo(element.parents('.form-check').parent());
				}

				// Input with icons and Select2
				else if (element.parents().hasClass('form-group row-feedback') || element.hasClass('select2-hidden-accessible')) {
					error.appendTo(element.parent());
				}

				// Input group, styled file input
				else if (element.parent().is('.uniform-uploader, .uniform-select') || element.parents().hasClass('input-group')) {
					error.appendTo(element.parent().parent());
				}

				// Other elements
				else {
					error.insertAfter(element);
				}
			},
			rules: {
				resource_id: {
					required: true,
				},
				resource_type_id: {
					required: true,
				},
				men_power_attendance_date: {
					required: true,
				},
				in_time: {
					required: true,
				},
				out_time: {
					required: true,
				},
			},
			messages: {
				resource_id: {
					required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('MenPowerAttendance.resource'); ?>"
				},
				resource_type_id: {
					required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('MenPowerAttendance.resource_type'); ?>"
				},
				men_power_attendance_date: {
					required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('MenPowerAttendance.men_power_attendance_date'); ?>"
				},
				in_time: {
					required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('MenPowerAttendance.in_time'); ?>"
				},
				out_time: {
					required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('MenPowerAttendance.out_time'); ?>"
				},
			},
			submitHandler: function(e) {
				$(e).ajaxSubmit({
					url: '<?php echo admin_url("MenPowerAttendance/save"); ?>',
					type: 'post',
					beforeSubmit: function(formData, jqForm, options) {
						dtButtonHide('#submitBtn');
						dtButtonHide('#cancelBtn');
					},
					complete: function() {

					},
					dataType: 'json',
					clearForm: false,
					success: function (resObj, statusText) {
						if (resObj.success) {
							toastr.success(resObj.msg, 'Success', {
								closeButton: true,
								progressBar: true,
								positionClass: 'toast-top-right',
								timeOut: 1000,
								onHidden: function () {
                                    dtButtonShow('#submitBtn');
									dtButtonShow('#cancelBtn');
                                    window.location.href = '<?php echo admin_url('MenPowerAttendance');?>';
                                }
							});
							// setTimeout(function () {
							// 	window.location.href = '<?php echo admin_url('MenPowerAttendance');?>';
							// }, 1000);
						} else {
							dtButtonShow('#submitBtn');
							dtButtonShow('#cancelBtn');
							toastr.error(resObj.msg, 'Error', {
								closeButton: true,
								// progressBar: true,
								positionClass: 'toast-top-right',
								// timeOut: 1000
							});
						}
					}
				});
			}
		});

		inTime();
		outTime();

		$("#men_power_attendance_date").flatpickr({
			monthSelectorType: 'static',
			// enableTime: true,
			dateFormat: "d-m-Y",
		});
	});
</script>

<?= isset($select2_ajax) ? $select2_ajax : ""; ?>