<?php
if (!empty($mediaIdArray)) {
    foreach ($mediaIdArray as $ikey => $mediaId) {
        // printArray($ikey);
        $mediaTitle = array_key_exists($ikey, $mediaTitleArray) ? $mediaTitleArray[$ikey] : 0;
        $mediaSortOrder = array_key_exists($ikey, $mediaSortOrderArray) ? $mediaSortOrderArray[$ikey] : 0;
        $mediaType = array_key_exists($ikey, $mediaTypeArray) ? $mediaTypeArray[$ikey] : 0;
        $mediaFor = isset($mediaFor) ? $mediaFor : '';
        $mediaForId = isset($mediaForId) ? $mediaForId : '';
        $commonMedia =  array_key_exists($ikey, $commonMediaArray) ? $commonMediaArray[$ikey] : '';

        if ($mediaId == '') {
            if (array_key_exists($ikey, $mediaResult)) {
                $mediaInsertArray[$ikey] = array(
                    'media_for' => $mediaFor,
                    'media_for_id' => $mediaForId,
                    'media_title' => $mediaTitle,
                    'media_file' => array_key_exists($ikey, $mediaResult) ? $mediaResult[$ikey]['file_name'] : 0,
                    'media_type' => $mediaType,
                    'media_sort_order' => $mediaSortOrder,
                    'created_by' => $this->data['userId'],
                    'updated_by' => $this->data['userId'],
                    'created_at' => date("Y-m-d H:i:s"),
                    'updated_at' => date("Y-m-d H:i:s"),
                );
            }
        } else {
            $mediaUpdateArray[$ikey] = array(
                'media_id' => $mediaId,
                'media_for' => $mediaFor,
                'media_for_id' => $mediaForId,
                'media_title' => $mediaTitle,
                'media_type' => $mediaType,
                'media_sort_order' => $mediaSortOrder,
                'updated_by' => $this->data['userId'],
                'updated_at' => date("Y-m-d H:i:s"),
            );
            if (array_key_exists($ikey, $mediaResult)) {
                $mediaResponse = $this->media_model->getMediaData(array("media_id" => $mediaId));
                $imageUrl = '';
                if (isset($mediaResponse['media_file']) && $mediaResponse['media_file'] != '') {
                    $imageUrl = MEDIA_IMAGE_PATH . $mediaResponse['media_file'];
                }
                if (file_exists($imageUrl)) {
                    unlink($imageUrl);
                }
                $mediaUpdateArray[$ikey]['media_file'] = $mediaResult[$ikey]['file_name'];
            }   else {
                $mediaUpdateArray[$ikey]['media_file'] = $commonMedia;
            }
        }
    }
    if (!empty($mediaInsertArray)) {
        $this->media_model->batchInsert($mediaInsertArray, 'tbl_media');
    }
    if (!empty($mediaUpdateArray)) {
        $this->media_model->batchUpdate($mediaUpdateArray, "media_id", 'tbl_media');
    }
}
?>