<?php
$html = '';
if (isset($media_data) && !empty($media_data)) {
    foreach ($media_data as $key => $value) {
        $data["row_number"] = $key + 1;
        $data["mediaData"] = $value;
        $html .= view('Admin/Media/MediaTableRowView', $data,);
    }
}
?>
<div class="table-responsive text-nowrap">
    <table id="media_table" class="table table-xs table-bordered">
        <thead>
        <tr class="text-nowrap">
            <th><?= lang("CommonMessage.common_sr_no"); ?></th>
            <th><?= lang('Media.media_type'); ?></th>
            <th><?= lang('Media.media_title'); ?></th>
            <th><?= lang('Media.sort_order'); ?></th>
            <th><?= lang('Media.media_file'); ?></th>
            <th><?= lang('CommonMessage.common_action'); ?></th>
        </tr>
        </thead>
        <tbody class="table-border-bottom-0">
        <?php
        if (isset($media_data) && !empty($media_data)) {
            echo $html;
        } else { ?>
            <?php
            $data["row_number"] = 1;
            echo view('Admin/Media/MediaTableRowView', $data); ?>
        <?php } ?>
        </tbody>
    </table>
</div>

<script>
    var rowNumber;

    function addMediaItem() {
        var lastIndex = ($("#media_table tbody tr:last").length >= 1) ? $("#media_table tbody tr:last").attr("data-id").split("_").pop() : 0;
        rowNumber = parseInt(lastIndex) + 1;
        $.ajax({
            type: "post",
            url: "<?= admin_url('Notice/addMediaRow'); ?>",
            dataType: "html",
            async: false,
            data: {
                row_number: rowNumber,
            },
            success: function (data) {
                if (data) {
                    $('table#media_table tbody').append(data);
                    numberInit();
                }
                // select2Init();
                $('.dt-media-type').select2();
                customToolTip();
                addSerialNumber('media_table');
            }
        });
    }

    $(document).on('click', '.dt-delete-media-row', function () {
        var trField = $(this).closest('tr');
        var id = $(this).closest('tr').find(".media_id").val();
        if (id != '') {
            Swal.fire({
					title: "<?= ucwords(lang('CommonMessage.common_sweet_alert_delete')); ?>",
					text: "<?= lang('CommonMessage.delete_warning'); ?>",
					icon: 'warning',
					showCancelButton: true,
					confirmButtonText: 'OK',
					customClass: {
						confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
						cancelButton: 'btn btn-label-secondary waves-effect waves-light'
					},
					buttonsStyling: false

			}).then(function (result) {
                if (result.value) {
                    $.ajax({
                        type: "POST",
                        url: "<?php echo admin_url('Notice/deleteMediaRow');?>",
                        dataType: "json",
                        data: {row_id: id},
                        success: function (resObj) {
                            addSerialNumber('media_table');
                            if (resObj.success) {
                                $(trField).remove();
                                Swal.fire({
									title: 'Success',
									text: resObj['msg'],
									icon: 'success',
									customClass: {
										confirmButton: 'btn btn-primary waves-effect waves-light'
									},
									buttonsStyling: false
								}).then(function () {
                                    if ($('#media_table tbody > tr').length == 0) {
                                        addMediaItem();
                                    }
                                });
                            } else {
                                Swal.fire({
									title: 'Error!',
									text: resObj['msg'],
									icon: 'error',
									customClass: {
										confirmButton: 'btn btn-primary waves-effect waves-light'
									},
									buttonsStyling: false
								});
                            }
                        }
                    });
                }
            });
        } else {
            $(trField).remove();
            addSerialNumber('media_table');
            if ($('#media_table tbody > tr').length == 0) {
                addMediaItem();
            }
        }
    });
</script>
