<?php
$assets = base_url() . 'assets/';
$materialData = !empty($material_data) && is_array($material_data) ? $material_data : array(); ?>
<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
	<meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<title><?= $name; ?></title>
	<link href="https://fonts.googleapis.com/css?family=Roboto:400,300,100,500,700,900" rel="stylesheet"
		  type="text/css">

	<link href="<?= $assets ?>css/pdf_bootstrap.css" rel="stylesheet" type="text/css">
	<link href="<?= $assets ?>css/pdf_style_sheet.css" rel="stylesheet" type="text/css">

</head>

<body style='font-family:chelvetica;font-size: 9px'>
<div class="row">
	<div class="col-xs-12">
		<h3 style="color: red;text-align: center;"><?= lang('Material.material_detail'); ?></h3>
		<table class="table" width="100%" cellspacing="0" cellpadding="0">
			<tbody>
			<tr>
				<td>
					<table class="table" border="1" cellpadding="1" cellspacing="1" width="100%">
						<tbody>
						<tr>
							<td rowspan="2" style="vertical-align:middle">
								<center><strong><?= isset($materialData["document_number"]) ? $materialData["document_number"] : ""; ?></center>
							</td>
							<td>
								<center><strong>
									<?php
									if (isset($materialData['society_name']) && $materialData['society_name'] != '') {
										echo $materialData['society_name'];
									} ?>
								</strong></center>
							</td>
						</tr>
						<tr>
							<td><center><strong><?= isset($materialData["financial_year_prefix"]) ? ($materialData["financial_year_prefix"]) : ""; ?></strong></center></td>
						</tr>
						<tr>
							<td><strong><?= lang("Material.material_date"); ?> </strong></td>
							<td class="text-left"><?= isset($materialData["material_date"]) ? siteDateFormat($materialData["material_date"]) : ""; ?></td>
						</tr>
						<tr>
							<td><strong><?= lang("Material.common_area"); ?> </strong></td>
							<td class="text-left"><?= isset($materialData["common_area_name"]) ? $materialData["common_area_name"] : ""; ?></td>
						</tr>
						<tr>
							<td><strong><?= lang("Material.material_type"); ?> </strong></td>
							<td class="text-left"><?= isset($materialData["material_type"]) ? underscoreToUcWord($materialData["material_type"]) : ""; ?></td>
						</tr>
						<?php if(isset($materialData["material_type"]) && $materialData["material_type"] == 'inwards') { ?>
							<tr>
								<td><strong><?= lang("Material.material_for"); ?></strong></td>
								<td class="text-left"><?= isset($materialData["material_for"]) ? underscoreToUcWord($materialData["material_for"]) : ""; ?></td>
							</tr>
						<?php }?>
						<?php if(isset($material_reference_data) && !empty($material_reference_data)) { ?>
							<tr>
								<td><strong><?= lang("Material.material_return"); ?></strong></td>
								<td><?php
									echo implode(' , ', array_column($material_reference_data, 'material_return_number'));
									?>
								</td>
							</tr>
						<?php }?>
						</tbody>
					</table>
				</td>
			</tr>
			</tbody>
		</table>


		<?php if (isset($material_item_data) && !empty($material_item_data)) { ?>
			<h3 style="color: red;text-align: center;"><?= lang('Material.material_items_detail') ?></h3>
			<table class="table" width="100%" border="1">
				<thead>
				<tr>
					<td class="text-bold" style="width: 10%">
						<?= lang('CommonMessage.common_sn'); ?>
					</td>
					<?php
					if ((isset($material_item_data[0]['material_return_number'])) && !empty($material_item_data[0]['material_return_number'])) {
						?>
						<td class="text-bold">
							<?= lang('Material.material_return'); ?>
						</td>
					<?php }?>
					<td class="text-bold">
						<?= lang('Material.item'); ?>
					</td>
					<td class="text-bold">
						<?= lang('Material.quantity'); ?>
					</td>
				</tr>
				</thead>
				<tbody>
				<?php
				if (is_array($material_item_data) && !empty($material_item_data)) {
					foreach ($material_item_data as $key => $value) {
						?>
						<tr>
							<td>
								<?= ++$key; ?>
							</td>
							<?php if(isset($value['material_return_number']) && !empty($value['material_return_number'])){ ?>
								<td>
									<?= isset($value['material_return_number']) ? $value['material_return_number'] : ''; ?>
								</td>
							<?php }?>
							<td>
								<?= isset($value['item_name']) ? $value['item_name'] : ''; ?>
							</td>
							<td>
								<?= isset($value['quantity']) ? $value['quantity'] : ''; ?>
							</td>
						</tr>
						<?php
					}
				} else {
					echo "<tr><td colspan='9' class='text-center'>" . lang("CommonMessage.common_no_data_found") . "</td></tr>";
				} ?>
				</tbody>
			</table>
		<?php } ?>
	</div>
</div>
</body>
</html>
