<?php $dtCIAcl = new \App\Libraries\Dt_ci_acl(); ?>
<?= isset($advance_filter) ? $advance_filter : ""; ?>
<a style="display: none;" href="" class="dt-export-anchor" target="_blank"></a>
<!-- DataTable with Buttons -->
<div class="card">
	<div class="card-datatable text-nowrap table-responsive">
		<table id="material_table" class="table dt-datatable dt-scrollableTable">
			<thead class="border-top">
			<tr>
				<th><input class="form-check-input datatable-select-all-second" type="checkbox"  /></th>
				<th class="font-weight-bold"><?= lang("Material.material_number"); ?></th>
				<th class="font-weight-bold"><?= lang("Material.material_date"); ?></th>
				<th class="font-weight-bold"><?= lang("Material.common_area"); ?></th>
				<th class="font-weight-bold"><?= lang("Material.material_type"); ?></th>
				<th class="font-weight-bold"><?= lang("Material.material_for"); ?></th>
				<th class="font-weight-bold"><?= lang("CommonMessage.common_form_submit"); ?></th>
				<th class="font-weight-bold"><?= lang('CommonMessage.common_updated_by'); ?></th>
				<th class="font-weight-bold"><?= lang('CommonMessage.common_updated_at'); ?></th>
                <th class="font-weight-bold"><?= lang("CommonMessage.common_action"); ?></th>
			</tr>
			</thead>
		</table>
	</div>
</div>
<script type="text/javascript">
	var dt_DataTable;
	$(document).ready(function () {

        commonAreaDd();
		dt_DataTable = $('#material_table').DataTable( {
			dom:'<"card-header d-flex border-top rounded-0 flex-wrap py-0"' +
				'<"me-5 ms-n2 pe-5"f>' +
				'<"d-flex justify-content-start justify-content-md-end align-items-baseline"<"dt-action-buttons d-flex flex-column align-items-start align-items-md-center justify-content-sm-center mb-3 mb-md-0 pt-0 gap-4 gap-sm-0 flex-sm-row"lB>>' +
				'>t' +
				'<"row mx-2"' +
				'<"col-sm-12 col-md-6"i>' +
				'<"col-sm-12 col-md-6"p>' +
				'>',

			//dom: '<"row"<"col-sm-12 col-md-6"l><"col-sm-12 col-md-6 d-flex justify-content-center justify-content-md-end"f>>t<"row"<"col-sm-12 col-md-6"i><"col-sm-12 col-md-6"p>>',
			processing: true,
			serverSide: true,
			displayLength: 10,
			// Scroll options
			// scrollY: '300px',
      		scrollX: true,
			language: {
				sLengthMenu: 'Show _MENU_',
				search: '',
				searchPlaceholder: 'Search <?= lang('Material.material');?>',
				info: 'Displaying _START_ to _END_ of _TOTAL_ entries'
			},
			buttons: [
			{
					extend: 'collection',
					className: 'btn btn-label-secondary px-2 dropdown-toggle me-2 waves-effect waves-light',
					text: '<i class="ti ti-download me-1 ti-xs"></i>Export',
					buttons: [
						{
							text: '<i class="ti ti-file me-2" ></i>Excel',
							className: 'dropdown-item dt-excel-export'
						},
						// {
						// 	extend: 'pdf',
						// 	text: '<i class="ti ti-file-text me-2"></i>Pdf',
						// 	className: 'dropdown-item',
						//
						// }
					]
				},
				<?php if ($dtCIAcl->checkAccess("Material|manage")) { ?>
				{
					text: '<i class="ti ti-plus me-0 me-sm-1 ti-xs"></i><span class="d-none d-sm-inline-block"><?= lang('Material.add_material');?></span>',
					className: 'add-new btn btn-primary px-1 me-2',
					action: function () {
						window.location.href = '<?= admin_url("Material/manage");?>';
					}
				},
				<?php } ?>
				<?php if ($dtCIAcl->checkAccess("Material|delete")) { ?>
				{
					text: '<i class="ti ti-trash me-0 me-sm-1 ti-xs"></i><span class="d-none d-sm-inline-block"><?= lang('Material.delete_material');?></span>',
					className: 'btn btn-danger  px-1 dt-delete-record',
				},
				<?php } ?>
			],
			"ajax": {
				"url": "<?php echo admin_url('Material/getMaterialListing'); ?>",
				"type": "POST",
				"data": function(d) {
                    var params = {};
                    params["<?= csrf_token(); ?>"] = "<?= csrf_hash() ?>";
                    var filterData = $("#advanceFilter").serializeArray();
                    $.each(filterData, function(i, val) {
                        var name = val.name;
                        if (typeof params[name] == 'undefined') {
                            params[name] = val.value;
                        } else if ($.isArray(params[name])) {
                            params[name].push(val.value);
                        } else {
                            params[name] = [params[name]];
                            params[name].push(val.value);
                        }
                    });

                    return $.extend({}, d, params);
                }
			},
			"order": [[ 0, "desc" ]],
			"columns": [
				{
					"data": "material_id",
					"render": function (data, type, row) {
						return '<input class="form-check-input datatable-checkbox" type="checkbox" id="ids_' + row['material_id'] + '" name="ids[]" value="' + row['material_id'] + '"/>';
					},
					"class": "no_click_allowed",
					"sortable": false,
					"searchable": false
				},
				{"data": "document_number","class":"dt-series" },
				{"data": "material_date", },
				{"data": "common_area_name" },
				{"data": "material_type" },
				{"data": "material_for" },
                {
                	"data": "form_submit",
                	"sortable": true,
                	"class": "no_click_allowed",
                	"searchable": true,
                	"render": function (data, type, row) {
                		return row['approved_button'];
                	}
                },
				{"data": "updated_by"},
				{"data": "updated_at"},
				{
					"data": "action_button",
					"class" : "text-center no_click_allowed",
					"sortable": false,
					"searchable": false
				},
			],
			createdRow: function (row, data, dataIndex) {
				$(row).find("td:not(.no_click_allowed,.own_detail_model_view)").addClass('dt-detail-model-view');
				$(row).find("td:not(.no_click_allowed,.own_detail_model_view)").attr('data-dt_view_id', data['material_id']);
				$(row).find("td:not(.no_click_allowed,.own_detail_model_view)").attr('data-dt_view_url', '<?= admin_url("Material/view"); ?>');
			},
			"fnDrawCallback": function (oSettings, json) {
				customToolTip();
				$('.dataTables_length').addClass('mt-2 mt-sm-0 mt-md-3 me-2');
				$('.dt-buttons').addClass('d-flex flex-wrap');
				$('.dataTables_filter .form-control').removeClass('form-control-sm');
				$('.dataTables_length .form-select').removeClass('form-select-sm');
				//checkBoxRefresh("datatable-checkbox");
				switcheryKeyGen("datatable-list-switchery");

			}
		});
		dtDataTableSearch();
	});


	//Delete Record
    $(document).on('click', '.dt-delete-record', function () {
        var id = $(this).attr("data-id");
        var deleteId = [];
        if(id != undefined){
            $('.datatable-select-all-second').prop('checked', false);
            $('.datatable-checkbox').prop('checked', false);
            $("#ids_" + id).prop("checked", true);
            deleteId.push(id);
        }
        else{
            var deleteElement =$('#material_table tbody .datatable-checkbox:checked');
            var selectedLength = deleteElement.length;
            if (selectedLength == 0) {
                Swal.fire({
                    title: "<?= ucwords(lang('CommonMessage.common_sweet_alert_info')); ?>",
                    text: "<?= lang('CommonMessage.delete_info'); ?>",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonText: 'OK',
                    customClass: {
                        confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
                        cancelButton: 'btn btn-label-secondary waves-effect waves-light'
                    },
                    buttonsStyling: false
                }).then(function () {
                    return false;
                });
            } else {
                $.each(deleteElement, function (i, ele) {
                    deleteId.push($(ele).val());
                });
            }
        }
        if (deleteId.length > 0) {
            Swal.fire({
                title: "<?= ucwords(lang('CommonMessage.common_sweet_alert_delete')); ?>",
                text: "<?= lang('CommonMessage.delete_warning'); ?>",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'OK',
                customClass: {
                    confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
                    cancelButton: 'btn btn-label-secondary waves-effect waves-light'
                },
                buttonsStyling: false
            }).then(function(result) {
                if (result.value) {
                    $.ajax({
                        type: "post",
                        url: "<?= admin_url("Material/delete")?>",
                        dataType: "json",
                        data: {material_id: deleteId},
                        success: function (data) {
                            if (data['success']) {
                                Swal.fire({
                                    title: 'Success',
                                    text: data['msg'],
                                    icon: 'success',
                                    customClass: {
                                        confirmButton: 'btn btn-primary waves-effect waves-light'
                                    },
                                    buttonsStyling: false
                                }).then(function() {
                                    dt_DataTable.ajax.reload();
                                });
                            } else {
                                Swal.fire({
                                    title: 'Error!',
                                    text: data['msg'],
                                    icon: 'error',
                                    customClass: {
                                        confirmButton: 'btn btn-primary waves-effect waves-light'
                                    },
                                    buttonsStyling: false
                                }).then(function() {
                                    dt_DataTable.ajax.reload();
                                });
                            }
                        }
                    });
                }
                else {
                    $('.datatable-checkbox').prop('checked', false);
                }
            });
        }
    });


	$(document).on('click', '.dt-excel-export', function() {
		$(this).removeClass(".dt-excel-export");
		var dataTableParams = dt_DataTable.ajax.params();
		url = '<?= admin_url('Material/excelExportMaterial/') . ""  ?>';
		var recursiveEncoded = $.param(dataTableParams);
		$('.dt-export-anchor').attr('href', url + "?" + recursiveEncoded);
		$('.dt-export-anchor')[0].click();
	});

    $(document).on('click', '.form-status', function () {
        var materialId = $(this).attr('id').split("_").pop();
        var series = $(this).closest("tr").find(".dt-series").text();
        var status = $(this).attr('data-value');
        bootbox.confirm("<?= lang('CommonMessage.common_permanently_submit'); ?> " + series + "?", function (result) {
            if (result) {
                $.ajax({
                    type: "post",
                    url: "<?= admin_url("Material/submitForm")?>",
                    dataType: "json",
                    data: {material_id: materialId, form_status: status},
                    beforeSend: function (formData, jqForm, options) {
                        Swal.fire({
                            text: '<?= lang('CommonMessage.ajax_data_loading_message');?>',
                            showConfirmButton: false,
                            allowOutsideClick: false
                        });
                    },
                    complete: function () {
                        //bootbox.hideAll();
                    },
                    success: function (data) {
                        if (data['success']) {
                            Swal.fire({
                                title: 'Success',
                                text: data['msg'],
                                icon: 'success',
                                customClass: {
                                    confirmButton: 'btn btn-primary waves-effect waves-light'
                                },
                                buttonsStyling: false
                            }).then(function() {
                                dt_DataTable.ajax.reload(null,false);
                            });
                        } else {
                            Swal.fire({
                                title: 'Error!',
                                text: data['msg'],
                                icon: 'error',
                                customClass: {
                                    confirmButton: 'btn btn-danger waves-effect waves-light'
                                },
                                buttonsStyling: false
                            });
                        }
                    }
                });
            }
        });
    });

    $(document).on('click', '.filter_data', function() {
		dt_DataTable.draw();
	});

    $(document).on('click', '.clear_filter', function() {
		$('form#advanceFilter  #filter_common_area_id').val('').trigger('change');
        $('form#advanceFilter  #filter_material_type').val('').trigger('change');
        $('form#advanceFilter  #filter_form_submit').val('').trigger('change');
		$("#filter_material_date").val('');
		$("#filter_created_at").val('');
		$("#filter_updated_at").val('');
        dateRangePicker();
		dt_DataTable.draw();
	});


</script>
<?= isset($select2_ajax) ? $select2_ajax : ""; ?>
