

<?php
$html = '';
if (isset($material_item_data) && !empty($material_item_data)) {
	foreach ($material_item_data as $key => $value) {
		$data["row_number"] = $key + 1;
		$data["material_item_data"] = $value;
		$html .= view('Admin/Material/MaterialItemRowView', $data);
	}
}
?>
<!-- Responsive Table -->
	<div class="table-responsive text-nowrap">
		<table id="material_item_table" class="table table-bordered">
			<thead>
			<tr class="text-nowrap">
				<th><?= lang('CommonMessage.common_sr_no'); ?></th>
				<th><?= lang('Material.item'); ?><span class="text-danger"> *</span></th>
				<th><?= lang('Material.quantity'); ?><span class="text-danger"> *</span></th>
				<th><?= lang('CommonMessage.common_action'); ?></th>
			</tr>
			</thead>
			<tbody class="table-border-bottom-0">
			<?php
			if (isset($material_item_data) && !empty($material_item_data)) {
				echo $html;
			}else { ?>
				<?php
				$data["row_number"] =  1;
				echo view('Admin/Material/MaterialItemRowView',$data); ?>
			<?php } ?>

			</tbody>
		</table>
	</div>
<!--/ Responsive Table -->
<script>
	var rowNumber;

	function addMaterialItem() {
		var lastIndex = ($("#material_item_table tbody tr:last").length >= 1) ? $("#material_item_table tbody tr:last").attr("data-id").split("_").pop() : 0;
		rowNumber = parseInt(lastIndex) + 1;
		$.ajax({
			type: "post",
			url: "<?= admin_url('Material/addMaterialItemRow'); ?>",
			dataType: "html",
			async: false,
			data: {
				row_number: rowNumber,
			},
			success: function (data) {
				if (data) {
					$('table#material_item_table tbody').append(data);
					addSerialNumber('material_item_table');
                    itemDd();
					numberInit();
                    materialItem();
					customToolTip();
				}
			}
		});
	}


	$(document).on('click', '.dt-delete-item-row', function () {
		var trField = $(this).closest('tr');
		var id = $(this).closest('tr').find(".material_item_id").val();
		var materialId = $("#material_id").val();

		if (id != '') {
				Swal.fire({
					title: "<?= ucwords(lang('CommonMessage.common_sweet_alert_delete')); ?>",
					text: "<?= lang('CommonMessage.delete_warning'); ?>",
					icon: 'warning',
					showCancelButton: true,
					confirmButtonText: 'OK',
					customClass: {
						confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
						cancelButton: 'btn btn-label-secondary waves-effect waves-light'
					},
					buttonsStyling: false

			}).then(function (result) {
				if (result.value) {
					var deleteId = [];
					deleteId.push(id);
					$.ajax({
						type: "POST",
						url: "<?php echo admin_url('Material/deleteMaterialItemRow');?>",
						dataType: "json",
						async:false,
						data: {
                            material_item_id: deleteId,
                            material_id: materialId
						},
						success: function (resObj) {
							if (resObj.success) {
								$(trField).remove();
								addSerialNumber('material_item_table');
								Swal.fire({
									title: 'Success',
									text: resObj['msg'],
									icon: 'success',
									customClass: {
										confirmButton: 'btn btn-primary waves-effect waves-light'
									},
									buttonsStyling: false
								}).then(function() {
									if ($('#material_item_table tbody > tr').length == 0) {
                                        addMaterialItem();
									}
								});
							} else {
								Swal.fire({
									title: 'Error!',
									text: resObj['msg'],
									icon: 'error',
									customClass: {
										confirmButton: 'btn btn-primary waves-effect waves-light'
									},
									buttonsStyling: false
								});
							}
						}
					});
				}
			});
		} else {
			$(trField).remove();
			addSerialNumber('material_item_table');
			if ($('#material_item_table tbody > tr').length == 0) {
                addMaterialItem();
			}
		}
	});


</script>
