<!-- Add New Common Area Modal -->
<div class="modal fade" id="make_modal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-simple modal-add-new-address">
        <div class="modal-content p-3 p-md-5">
            <div class="modal-body">
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                <div class="text-center mb-4">
                    <h3 class="address-title mb-2"><?= lang('Make.make_form')?></h3>
                </div>
                <?php
                $form_id = array(
                    'id' => 'form_make',
                    'method' => 'post',
                    'class' => 'row g-3',
                    'autocomplete' => 'off'
                );
                echo form_open_multipart('',$form_id);
                ?>
                <input type="hidden" name="make_id" id="make_id">
                <div class="col-12">
                    <label class="form-label" for=""><?= lang('Make.make_name'); ?><span class="text-danger"> *</span></label>
                    <input
                            type="text"
                            id="make_name"
                            name="make_name"
                            class="form-control"
                            placeholder="Enter <?= lang('Make.make_name'); ?>"/>
                </div>

                <div class="col-12">

                    <label class="switch switch-sm">
                        <input type="checkbox" class="switch-input form-add-switchery "  name="is_active" id="is_active"/>
                        <span class="switch-toggle-slider">
                              <span class="switch-on"></span>
                              <span class="switch-off"></span>
                            </span>
                        <span class="switch-label"><?= lang('CommonMessage.common_active'); ?></span>
                    </label>
                </div>
                <div class="col-12 text-center">
                    <button type="submit" id="submitBtn" class="btn btn-primary me-sm-3 me-1 submit"><?= lang('CommonMessage.common_submit'); ?></button>
                    <button
                            type="reset"
                            class="btn btn-label-secondary"
                            data-bs-dismiss="modal"
                            aria-label="Close">
                        <?= lang('CommonMessage.common_cancel'); ?>
                    </button>
                </div>
                <?= form_close(); ?>
            </div>
        </div>
    </div>
</div>
<!--/ Add New Address Modal -->


<!--  add,update and delete model code here-->
<script type="text/javascript">
    //var laddaSubmitBtn = Ladda.create(document.querySelector('#submit'));
    $(document).ready(function () {

        //validation
        var validator = $("#form_make").validate({
            ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
            errorClass: 'validation-invalid-label',
            successClass: 'validation-valid-label',
            validClass: 'validation-valid-label',
            highlight: function (element, errorClass) {
                $(element).removeClass(errorClass);
            },
            unhighlight: function (element, errorClass) {
                $(element).removeClass(errorClass);
            },
            success: function (label) {
                label.addClass('validation-valid-label'); // remove to hide Success message
            },
            // Different components require proper error label placement
            errorPlacement: function (error, element) {
                // Unstyled checkboxes, radios
                if (element.parents().hasClass('form-check')) {
                    error.appendTo(element.parents('.form-check').parent());
                }

                // Input with icons and Select2
                else if (element.parents().hasClass('form-group-feedback') || element.hasClass('select2-hidden-accessible')) {
                    error.appendTo(element.parent());
                }

                // Input group, styled file input
                else if (element.parent().is('.uniform-uploader, .uniform-select') || element.parents().hasClass('input-group')) {
                    error.appendTo(element.parent().parent());
                }

                // Other elements
                else {
                    error.insertAfter(element);
                }
            },
            rules: {
                make_name: {
                    required: true
                }
            },
            messages: {
                make_name: {
                    required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang("Make.make_name"); ?>",
                },
            },
            submitHandler: function (e) {
                $(e).ajaxSubmit({
                    url: '<?php echo admin_url("Make/addEdit");?>',
                    type: 'post',
                    beforeSubmit: function (formData, jqForm, options) {
                        dtButtonHide('#submitBtn');
                    },
                    complete: function () {
                        //laddaStop();
                    },
                    dataType: 'json',
                    clearForm: false,
                    success: function (resObj, statusText) {
						if (resObj.success) {
							toastr.success(resObj.msg, 'Success', {
								closeButton: true,
								progressBar: true,
								positionClass: 'toast-top-right',
								timeOut: 1000,
                                onHidden: function () {
                                    dtButtonShow('#submitBtn');
                                    $('#make_modal').modal('hide');
                                    dt_DataTable.ajax.reload(null,false);
                                }
							});
							// setTimeout(function () {
							// 	$('#make_modal').modal('hide');
							// 	dt_DataTable.ajax.reload(null,false);
							// }, 1000);

						} else {
                            dtButtonShow('#submitBtn');
							toastr.error(resObj.msg, 'Error', {
								closeButton: true,
								// progressBar: true,
								positionClass: 'toast-top-right',
								// timeOut: 1000
							});
						}
					}
                });
            }
        });
    });
</script>
