<?php
$dtCIAcl = new \App\Libraries\Dt_ci_acl();
?>
<div class="row">
	<div class="col-md-12">
		<div class="card mb-4">
			<div class="card-header d-flex align-items-center justify-content-between">
				<h5 class="mb-0"><?= lang('LetterHead.letter_head_detail');?></h5>
			</div>
			<div class="card-body">
				<?php
				//create  form open tag
				$form_id = array(
					'id'=>'form_letter_head',
				);
				echo form_open_multipart('',$form_id);
				$letterHeadId = (isset($letter_head_data['letter_head_id']) && ($letter_head_data['letter_head_id'] != '')) ? $letter_head_data['letter_head_id'] : '';
				// printArray($letter_head_data['notified_to'],1);
				?>
				<input type="hidden" id="letter_head_id" name="letter_head_id" value="<?= $letterHeadId ?>">
				<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('LetterHead.letter_head_title');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">	
							<input type="text" class="form-control" name="letter_head_title" id="letter_head_title" placeholder="Enter <?= lang('LetterHead.letter_head_title');?>" value="<?= (isset($letter_head_data['letter_head_title']) && ($letter_head_data['letter_head_title'] != '')) ? $letter_head_data['letter_head_title'] : '';  ?>" />
						</div>
				</div>
               
				<div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('LetterHead.letter_head_date');?><span class="text-danger"> *</span></label>
					<div class="col-sm-10">
						<td>
							<input type="text"  name="letter_head_date" id="letter_head_date" class="form-control dt-letter-head-date" placeholder="Select <?= lang('LetterHead.letter_head_date'); ?>" value="<?= isset($letter_head_data['letter_head_date']) ? YMDToDMY($letter_head_data['letter_head_date']): ""; ?>"/>
						</td>
					</div>
				</div>
				<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('LetterHead.description');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">
							<textarea name="description"  id="description" placeholder="Enter <?= lang('LetterHead.description'); ?>" rows="3" cols="5"  class="form-control"><?= (isset($letter_head_data['description']) && ($letter_head_data['description'] != '')) ? $letter_head_data['description'] : ''; ?></textarea>
						</div>
					
                </div>

				<div class="pt-4">
					<button type="submit" id="submitBtn" class="btn btn-primary me-sm-3 me-1 submit"><?= lang('CommonMessage.common_submit'); ?></button>
					<button type="button" id="cancelBtn" onclick="window.location.href='<?php echo admin_url('LetterHead'); ?>'" class="btn btn-label-secondary"> <?= lang('CommonMessage.common_cancel'); ?></button>
				</div>
				<?php echo form_close(); ?>
			</div>
		</div>
	</div>
</div>

<script>
    $(document).ready(function() {
    	numberInit();
 
		ckEditorInit('description');

		var letterHeadDate = $(".dt-letter-head-date").flatpickr({
			//monthSelectorType: 'static',
			dateFormat: 'd-m-Y',
		});
        // Initialize
		var validator = $("#form_letter_head").validate({
			ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
			errorClass: 'validation-invalid-label',
			successClass: 'validation-valid-label',
			validClass: 'validation-valid-label',
			highlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			unhighlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			success: function(label) {
				label.addClass('validation-valid-label').text('Success.'); // remove to hide Success message
			},
			// Different components require proper error label placement
			errorPlacement: function(error, element) {

				// Unstyled checkboxes, radios
				if (element.parents().hasClass('form-check')) {
					error.appendTo( element.parents('.form-check').parent() );
				}

				// Input with icons and Select2
				else if (element.parents().hasClass('form-group row-feedback') || element.hasClass('select2-hidden-accessible')) {
					error.appendTo( element.parent() );
				}

				// Input group, styled file input
				else if (element.parent().is('.uniform-uploader, .uniform-select') || element.parents().hasClass('input-group')) {
					error.appendTo( element.parent().parent() );
				}

				// Other elements
				else {
					error.insertAfter(element);
				}
			},
            rules: {
				letter_head_title: {
					required: true
				},
				letter_head_date: {
					required: true
				},
				description: {
					required: true
				},
            },
            messages: {
				letter_head_title: {
					required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('LetterHead.letter_head_title');?>"
				},
				letter_head_date: {
					required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('LetterHead.letter_head_date');?>"
				},
				description: {
					required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('LetterHead.description');?>"
				},
            },
            submitHandler: function (e) {
				$(e).ajaxSubmit({
					url: '<?php echo admin_url("LetterHead/save");?>',
					type: 'post',
					beforeSubmit: function (formData, jqForm, options) {
						dtButtonHide('#submitBtn');
						dtButtonHide('#cancelBtn');
					},
					complete: function () {

					},
					dataType: 'json',
					clearForm: false,
					success: function (resObj, statusText) {
						if (resObj.success) {
							toastr.success(resObj.msg, 'Success', {
								closeButton: true,
								progressBar: true,
								positionClass: 'toast-top-right',
								timeOut: 1000,
								onHidden: function () {
                                    dtButtonShow('#submitBtn');
									dtButtonShow('#cancelBtn');
                                    window.location.href = '<?php echo admin_url('LetterHead');?>';
                                }
							});


						} else {
							dtButtonShow("#submitBtn");
							dtButtonShow('#cancelBtn');
							toastr.error(resObj.msg, 'Error', {
								closeButton: true,
								// progressBar: true,
								positionClass: 'toast-top-right',
								// timeOut: 1000
							});
						}
					}
				});
            }
        });
    });
</script>

<?= isset($select2_ajax) ? $select2_ajax : ""; ?>
