<?php
$dtCIAcl = new \App\Libraries\Dt_ci_acl();
?>
<div class="row">
	<div class="col-md-12">
		<div class="card mb-4">
			<div class="card-header d-flex align-items-center justify-content-between">
				<h5 class="mb-0"><?= lang('Ledger.ledger_detail');?></h5>
			</div>
			<div class="card-body">
				<?php
				//create  form open tag
				$form_id = array(
					'id'=>'form_ledger',
				);
				echo form_open_multipart('',$form_id);
				$ledgerId = (isset($ledger_data['ledger_id']) && ($ledger_data['ledger_id'] != '')) ? $ledger_data['ledger_id'] : '';
				?>
				<input type="hidden" id="ledger_id" name="ledger_id" value="<?= $ledgerId ?>">
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Ledger.ledger_code');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">	
							<input type="text" class="form-control" name="ledger_code" id="ledger_code" placeholder="Enter <?= lang('Ledger.ledger_code');?>" value="<?= (isset($ledger_data['ledger_code']) && ($ledger_data['ledger_code'] != '')) ? $ledger_data['ledger_code'] : '';  ?>" />
						</div>
					</div>
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Ledger.ledger_name');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">	
							<input type="text" class="form-control" name="ledger_name" id="ledger_name" placeholder="Enter <?= lang('Ledger.ledger_name');?>" value="<?= (isset($ledger_data['ledger_name']) && ($ledger_data['ledger_name'] != '')) ? $ledger_data['ledger_name'] : '';  ?>" />
						</div>
					</div>
					<div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Ledger.ledger_type');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">
                        <?php
                        	$ledgerType = ledgerType();
	                    ?>
	                    <select data-placeholder="Select  <?= lang('Ledger.ledger_type'); ?>" name="ledger_type" id="ledger_type" class="form-control select dt-ledger-type">
	                        <option value=""> </option>
	                        <?php
	                        $selectedLedgerFor = isset($ledger_data['ledger_type']) ? $ledger_data['ledger_type'] : "";
	                        foreach ($ledgerType as $typeKey => $type) { ?>
	                            <option <?= ($selectedLedgerFor == $typeKey) ? "selected" : ""; ?>
	                                value="<?= $typeKey; ?>"> <?= $type; ?> </option>
	                        <?php } ?>
	                    </select>
                    </div>
                </div>
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Ledger.sub_ledger');?><span class="text-danger"> </span></label>
						<div class="col-sm-10">
							<select data-placeholder="Select  <?= lang('Ledger.sub_ledger'); ?>" name="sub_ledger_id[]"
								id="sub_ledger_id" class="form-control subLedgerDd" multiple>
							
							<?php
							if(isset($ledger_sub_data) && !empty($ledger_sub_data)) {
								foreach ($ledger_sub_data as  $ledgerElement){ ?>
									<option  value="<?= isset($ledgerElement['sub_ledger_id']) ? $ledgerElement['sub_ledger_id'] : ""; ?>" selected> <?= $ledgerElement['sub_ledger_code_name']; ?> </option>
								<?php  }
							} ?>
							</select>
						</div>
					</div>
					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('CommonMessage.common_active');?></label>
							<div class="col-sm-10">
							<label class="switch switch-sm"><span class="switch-label"></span>
								<input type="checkbox" class="switch-input form-add-switchery"  name="is_active" id="is_active" <?php echo (!isset($ledger_data['is_active']) || $ledger_data['is_active'] == 1) ? 'checked="checked"' : ''; ?>/>
								<span class="switch-toggle-slider">
		                              <span class="switch-on"></span>
		                              <span class="switch-off"></span>
		                            </span>
								
							</label>						
						</div>
					</div>

					<div class="pt-4">
						<button type="submit" class="btn btn-primary me-sm-3 me-1">Submit</button>
						<button type="button" onclick="window.location.href='<?php echo admin_url('Ledger'); ?>'" class="btn btn-label-secondary">Cancel</button>
					</div>
				<?php echo form_close(); ?>
			</div>
		</div>
	</div>
</div>

<script>
    $(document).ready(function() {
    	numberInit();
    	documentDd();
		subLedgerDd();
		$('.dt-ledger-type').select2();
		switcheryKeyGen("datatable-list-switchery");
        // Initialize
		var validator = $("#form_ledger").validate({
			ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
			errorClass: 'validation-invalid-label',
			successClass: 'validation-valid-label',
			validClass: 'validation-valid-label',
			highlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			unhighlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			success: function(label) {
				label.addClass('validation-valid-label').text('Success.'); // remove to hide Success message
			},
			// Different components require proper error label placement
			errorPlacement: function(error, element) {

				// Unstyled checkboxes, radios
				if (element.parents().hasClass('form-check')) {
					error.appendTo( element.parents('.form-check').parent() );
				}

				// Input with icons and Select2
				else if (element.parents().hasClass('form-group row-feedback') || element.hasClass('select2-hidden-accessible')) {
					error.appendTo( element.parent() );
				}

				// Input group, styled file input
				else if (element.parent().is('.uniform-uploader, .uniform-select') || element.parents().hasClass('input-group')) {
					error.appendTo( element.parent().parent() );
				}

				// Other elements
				else {
					error.insertAfter(element);
				}
			},
            rules: {
				ledger_name: {
					required: true,
				},
				ledger_code: {
					required: true,
				},
				ledger_type: {
					required: true,
				},
				// "sub_ledger_id[]" : {
                //     required: true,
                // },
            },
            messages: {
				ledger_name: {
					required: '<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("Ledger.ledger_name"); ?>',
				},
				ledger_code : {
					required: '<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("Ledger.ledger_code"); ?>',
				},
				ledger_type : {
					required: '<?= lang("CommonMessage.common_please_select"); ?> <?= lang("Ledger.ledger_type"); ?>',
				},
				// "sub_ledger_id[]": {
				// 	required: '<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("Ledger.sub_ledger"); ?>',
				// },
            },
            submitHandler: function (e) {
				$(e).ajaxSubmit({
					url: '<?php echo admin_url("Ledger/save");?>',
					type: 'post',
					beforeSubmit: function (formData, jqForm, options) {

					},
					complete: function () {

					},
					dataType: 'json',
					clearForm: false,
					success: function (resObj, statusText) {
						if (resObj.success) {
							toastr.success(resObj.msg, 'Success', {
								closeButton: true,
								progressBar: true,
								positionClass: 'toast-top-right',
								timeOut: 1000,
								onHidden: function () {
                                    dtButtonShow('#submitBtn');
									dtButtonShow('#cancelBtn');
                                    window.location.href = '<?php echo admin_url('Ledger');?>';
                                }
							});

							// setTimeout(function () {
							// 	window.location.href = '<?php echo admin_url('Ledger');?>';
							// }, 1000);

						} else {
							toastr.error(resObj.msg, 'Error', {
								closeButton: true,
								// progressBar: true,
								positionClass: 'toast-top-right',
								// timeOut: 1000
							});
						}
					}
				});
            }
        });
    });

</script>

<?= isset($select2_ajax) ? $select2_ajax : ""; ?>
