<?php
$keyIssueView = isset($key_issue_data['view']) ? $key_issue_data['view'] : 0;
?>
<div class="row">
	<div class="col-md-12">
		<div class="card mb-4">
			<div class="card-header d-flex align-items-center justify-content-between">
				<h5 class="mb-0"><?= lang('KeyIssue.key_issue_detail');?></h5>
			</div>
			<div class="card-body">
				<?php
				//create  form open tag
				$form_id = array(
					'id'=>'form_key_issue',
				);
				echo form_open_multipart('',$form_id);
				$keyIssueId = (isset($key_issue_data['key_issue_id']) && ($key_issue_data['key_issue_id'] != '')) ? $key_issue_data['key_issue_id'] : '';
				?>
				<input type="hidden" id="key_issue_id" name="key_issue_id" value="<?= $keyIssueId ?>">

					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('KeyIssue.key_issue_date');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">
							<input type="text" class="form-control" name="key_issue_date" id="key_issue_date" placeholder="Enter <?= lang('KeyIssue.key_issue_date');?>" value="<?= (isset($key_issue_data['key_issue_date']) && isValidDate($key_issue_data['key_issue_date'])) ? siteDateFormat($key_issue_data['key_issue_date']) : ''; ?>" />
						</div>
					</div>

					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('KeyIssue.common_keys_id');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">
							<select id="common_keys_id" name="common_keys_id" class="select2 form-select form-select-lg commonKeysDd" data-allow-clear="true">
								<option></option>
								<?php if(isset($key_issue_data['common_keys_id']) && $key_issue_data['common_keys_id'] != 0){ ?>
								<option value="<?= isset($key_issue_data['common_keys_id']) ? $key_issue_data['common_keys_id'] : 0 ?>" selected> <?= isset($key_issue_data['description']) ? $key_issue_data['description'] : ''  ?> </option>
								<?php } ?>
							</select>
						</div>
					</div>

					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('KeyIssue.common_keys_availability_id');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">
							<select id="common_keys_availability_id" name="common_keys_availability_id" class="select2 form-select form-select-lg commonKeysAvailabilityDd" data-allow-clear="true">
								<option></option>
								<?php if(isset($key_issue_data['common_keys_availability_id']) && $key_issue_data['common_keys_availability_id'] != 0){ ?>
								<option value="<?= isset($key_issue_data['common_keys_availability_id']) ? $key_issue_data['common_keys_availability_id'] : 0 ?>" selected> <?= isset($key_issue_data['keys_name']) ? $key_issue_data['keys_name'] : ''  ?> </option>
								<?php } ?>
							</select>
						</div>
					</div>

					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('KeyIssue.key_issue');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">	
							<input type="text" class="form-control" name="key_issue" id="key_issue" placeholder="Enter <?= lang('KeyIssue.key_issue');?>" value="<?= (isset($key_issue_data['key_issue']) && ($key_issue_data['key_issue'] != '')) ? ($key_issue_data['key_issue']) : '';  ?>" />
						</div>
					</div>
                <?php if ($keyIssueView != 1) { ?>
					<div class="pt-4">
						<button type="submit" id="submitBtn" class="btn btn-primary me-sm-3 me-1 submit">Submit</button>
						<button type="button" id="cancelBtn" onclick="window.location.href='<?php echo admin_url('KeyIssue'); ?>'" class="btn btn-label-secondary">Cancel</button>
					</div>
                <?php } ?>
				<?php echo form_close(); ?>
			</div>
		</div>
	</div>
</div>

<script>
    var editable = <?= $keyIssueView ?>;
    if (editable == 1) {
        $("#form_key_issue :input").prop("disabled", true);

    }

    $(document).ready(function() {
    	numberInit();
		switcheryKeyGen("datatable-list-switchery");
		commonKeysDd();
		commonKeysAvailabilityDd();
        // Initialize
		var validator = $("#form_key_issue").validate({
			ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
			errorClass: 'validation-invalid-label',
			successClass: 'validation-valid-label',
			validClass: 'validation-valid-label',
			highlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			unhighlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			success: function(label) {
				label.addClass('validation-valid-label').text('Success.'); // remove to hide Success message
			},
			// Different components require proper error label placement
			errorPlacement: function(error, element) {

				// Unstyled checkboxes, radios
				if (element.parents().hasClass('form-check')) {
					error.appendTo( element.parents('.form-check').parent() );
				}

				// Input with icons and Select2
				else if (element.parents().hasClass('form-group row-feedback') || element.hasClass('select2-hidden-accessible')) {
					error.appendTo( element.parent() );
				}

				// Input group, styled file input
				else if (element.parent().is('.uniform-uploader, .uniform-select') || element.parents().hasClass('input-group')) {
					error.appendTo( element.parent().parent() );
				}

				// Other elements
				else {
					error.insertAfter(element);
				}
			},
            rules: {
				common_keys_id : {
					required : true,
				},
                common_keys_availability_id: {
                    required: true,
                },
                key_issue_date: {
                    required: true,
                },
                key_issue: {
                    required: true,
                },
				
            },
            messages: {
            	common_keys_id : {
					required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('KeyIssue.common_keys_id');?>"
				},
                common_keys_availability_id: {
                    required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('KeyIssue.common_keys_availability_id');?>"
                },
                key_issue_date: {
                    required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('KeyIssue.key_issue_date');?>"
                },
                key_issue: {
                    required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('KeyIssue.key_issue');?>"
                },
            },
            submitHandler: function (e) {
				$(e).ajaxSubmit({
					url: '<?php echo admin_url("KeyIssue/save");?>',
					type: 'post',
					beforeSubmit: function (formData, jqForm, options) {
						dtButtonHide('#submitBtn');
						dtButtonHide('#cancelBtn');
					},
					complete: function () {

					},
					dataType: 'json',
					clearForm: false,
					success: function (resObj, statusText) {
						if (resObj.success) {
							toastr.success(resObj.msg, 'Success', {
								closeButton: true,
								progressBar: true,
								positionClass: 'toast-top-right',
								timeOut: 1000,
                                onHidden: function () {
                                    dtButtonShow('#submitBtn');
									dtButtonShow('#cancelBtn');
                                    window.location.href = '<?php echo admin_url('KeyIssue');?>';
                                }
							});

							// setTimeout(function () {
							// 	window.location.href = '<?php echo admin_url('KeyIssue');?>';
							// }, 1000);

						} else {
							dtButtonShow('submitBtn');
							dtButtonShow('#cancelBtn');
							toastr.error(resObj.msg, 'Error', {
								closeButton: true,
								// progressBar: true,
								positionClass: 'toast-top-right',
								// timeOut: 1000
							});
						}
					}
				});
            }
        });
        $("#key_issue_date").flatpickr({
			// monthSelectorType: 'static',
			dateFormat: "d-m-Y",
			// dateFormat: 'd-m-Y',
            // minDate: "today",
            //maxDate:"15-07-2024"
		});
    });
</script>

<?= isset($select2_ajax) ? $select2_ajax : ""; ?>
