<?php
$dtCIAcl = new \App\Libraries\Dt_ci_acl();
?>
<div class="row">
    <div class="col-md-12">
        <div class="card mb-4">
            <div class="card-header d-flex align-items-center justify-content-between">
                <h5 class="mb-0"><?= lang('Item.item_detail'); ?></h5>
            </div>
            <div class="card-body">
                <?php
                //create  form open tag
                $form_id = array(
                    'id' => 'form_item',
                );
                echo form_open_multipart('', $form_id);
                $itemId = (isset($item_data['item_id']) && ($item_data['item_id'] != '')) ? $item_data['item_id'] : '';
                ?>
                <input type="hidden" id="item_id" name="item_id" value="<?= $itemId ?>">

                <div class="row mb-3">
                    <label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Item.item_name'); ?><span
                                class="text-danger"> *</span></label>
                    <div class="col-sm-10">
                        <input type="text" class="form-control" name="item_name" id="item_name"
                               placeholder="Enter <?= lang('Item.item_name'); ?>"
                               value="<?= (isset($item_data['item_name']) && ($item_data['item_name'] != '')) ? $item_data['item_name'] : ''; ?>"/>
                    </div>
                </div>
                <div class="row mb-3">
                    <label class="col-sm-2 col-form-label"
                           for="basic-default-name"><?= lang('Item.item_description'); ?><span
                                class="text-danger"> *</span></label>
                    <div class="col-sm-10">
                        <textarea name="item_description"  id="item_description" placeholder="Enter <?= lang('Item.item_description'); ?>" rows="3" cols="5"  class="form-control"><?= (isset($item_data['item_description']) && ($item_data['item_description'] != '')) ? $item_data['item_description'] : ''; ?></textarea>
                    </div>
                </div>

                <div class="row mb-3">
                    <label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Item.manufacturer'); ?><span
                                class="text-danger"> *</span></label>
                    <div class="col-sm-10">
                        <select id="manufacturer_id" name="manufacturer_id" class="select2 form-select form-select-lg manufacturerDd"
                                data-allow-clear="true">
                            <option></option>
                            <?php if (isset($item_data['manufacturer_id']) && $item_data['manufacturer_id'] != 0) { ?>
                                <option value="<?= isset($item_data['manufacturer_id']) ? $item_data['manufacturer_id'] : 0 ?>"
                                        selected> <?= isset($item_data['manufacturer_name']) ? $item_data['manufacturer_name'] : '' ?> </option>
                            <?php } ?>
                        </select>
                    </div>
                </div>

                <div class="row mb-3">
                    <label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Item.common_area'); ?>
                        <span class="text-danger"> *</span></label>
                    <div class="col-sm-10">
                        <select id="common_area_id" name="common_area_id" class="select2 form-select form-select-lg commonAreaDd"
                                data-allow-clear="true">
                            <option></option>
                            <?php if (isset($item_data['common_area_id']) && $item_data['common_area_id'] != 0) { ?>
                                <option value="<?= isset($item_data['common_area_id']) ? $item_data['common_area_id'] : 0 ?>"
                                        selected> <?= isset($item_data['common_area_name']) ? $item_data['common_area_name'] : '' ?> </option>
                            <?php } ?>
                        </select>
                    </div>
                </div>

                <div class="row mb-3">
                    <label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Item.batch_no'); ?><span
                                class="text-danger"> </span></label>
                    <div class="col-sm-10">
                        <input type="text" class="form-control" name="batch_no" id="batch_no"
                               placeholder="Enter <?= lang('Item.batch_no'); ?>"
                               value="<?= (isset($item_data['batch_no']) && ($item_data['batch_no'] != '')) ? $item_data['batch_no'] : ''; ?>"/>
                    </div>
                </div>
                <div class="row mb-3">
                    <label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Item.serial_no'); ?><span
                                class="text-danger"> </span></label>
                    <div class="col-sm-10">
                        <input type="text" class="form-control" name="serial_no" id="serial_no"
                               placeholder="Enter <?= lang('Item.serial_no'); ?>"
                               value="<?= (isset($item_data['serial_no']) && ($item_data['serial_no'] != '')) ? $item_data['serial_no'] : ''; ?>"/>
                    </div>
                </div>
                <div class="row mb-3">
                    <label class="col-sm-2 col-form-label"
                           for="basic-default-name"><?= lang('Item.warranty_period_from'); ?><span class="text-danger"> *</span></label>
                    <div class="col-sm-10">
                        <td>
                            <input type="text" name="warranty_period_from" id="warranty_period_from"
                                   class="form-control dt-warranty-period-from"
                                   placeholder="Select <?= lang('Item.warranty_period_from'); ?>"
                                   value="<?= isset($item_data['warranty_period_from']) ? YMDToDMY($item_data['warranty_period_from']) : ""; ?>"/>
                        </td>
                    </div>
                </div>

                <div class="row mb-3">
                    <label class="col-sm-2 col-form-label"
                           for="basic-default-name"><?= lang('Item.warranty_period_to'); ?><span
                                class="text-danger"> *</span></label>
                    <div class="col-sm-10">
                        <td>
                            <input type="text" name="warranty_period_to" id="warranty_period_to"
                                   class="form-control dt-warranty-period-to"
                                   placeholder="Select <?= lang('Item.warranty_period_to'); ?>"
                                   value="<?= isset($item_data['warranty_period_to']) ? YMDToDMY($item_data['warranty_period_to']) : ""; ?>"/>
                        </td>
                    </div>
                </div>

                <div class="row mb-3">
                    <label class="col-sm-2 col-form-label"
                           for="basic-default-name"><?= lang('Item.remarks'); ?><span
                                class="text-danger"> </span></label>
                    <div class="col-sm-10">
                        <textarea name="remarks"  id="remarks" placeholder="Enter <?= lang('Item.remarks'); ?>" rows="3" cols="5"  class="form-control"><?= (isset($item_data['remarks']) && ($item_data['remarks'] != '')) ? $item_data['remarks'] : ''; ?></textarea>
                    </div>
                </div>

                <div class="row mb-3">
                    <label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Item.item_image');?><span class="text-danger"> </span></label>
                    <div class="col-sm-10">
                        <input type="file" accept="image/*" class="form-control" name="item_image[]" multiple="multiple">
                        <span class="form-text text-muted"><?= FILE_UPLOAD_TYPE_MSG; ?></span> <br>
                        <?php 
                        if(isset($image_data) && is_array($image_data) && !empty($image_data)){
                            foreach($image_data as $image) { 
                                if(file_exists(ITEM_IMAGE_PATH . $image['item_image'])){
                                    $thumbnailPaths = site_url() . THUMBNAIL_ITEM_IMAGE_PATH . $image['item_image'];
                                    $paths = site_url() . ITEM_IMAGE_PATH . $image['item_image']; ?> &nbsp;&nbsp;&nbsp;
                                    <span class="document-image-<?= $image['item_image_id']; ?>">
                                        <a href="<?= $paths; ?>" target="_blank"> 
                                            <img src="<?= $thumbnailPaths; ?>" width="100" class="img-fluid" alt=""> 
                                            <?php if(!empty($itemId) && $dtCIAcl->checkAccess('Item|deleteImage')) {?>
                                                <a href="javascript:void(0);"  id="<?php echo $image['item_image_id']; ?>" class="btn btn-icon btn-outline-dribbble delete-image"> <i class="tf-icons ti ti-trash"></i> </a> 
                                            <?php }?>
                                        </a>
                                    </span>
                        <?php }} } ?>
                    </div>
                </div>

                <div class="row mb-3">
                    <label class="col-sm-2 col-form-label"
                           for="basic-default-name"><?= lang('CommonMessage.common_active'); ?></label>
                    <div class="col-sm-10">
                        <label class="switch switch-sm"><span class="switch-label"></span>
                            <input type="checkbox" class="switch-input form-add-switchery" name="is_active"
                                   id="is_active" <?php echo (!isset($item_data['is_active']) || $item_data['is_active'] == 1) ? 'checked="checked"' : ''; ?>/><span class="switch-toggle-slider">
		                              <span class="switch-on"></span>
		                              <span class="switch-off"></span>
		                            </span>

                        </label>
                    </div>
                </div>
                <div class="pt-4">
                    <button type="submit" id="submitBtn"
                            class="btn btn-primary me-sm-3 me-1 submit"><?= lang('CommonMessage.common_submit'); ?></button>
                    <button type="button" id="cancelBtn" onclick="window.location.href='<?php echo admin_url('Item'); ?>'"
                            class="btn btn-label-secondary"> <?= lang('CommonMessage.common_cancel'); ?></button>
                </div>
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
</div>

<script>

    let fromPeriod;
    let toPeriod;

    function fromAndToPeriod() {
        var fromPeriod = $(".dt-warranty-period-from").flatpickr({
            //monthSelectorType: 'static',
            dateFormat: 'd-m-Y',
            onChange: function (selectedDates, dateStr, instance) {
                toPeriod.set('minDate', dateStr)
            }
        });

        var toPeriod = $(".dt-warranty-period-to").flatpickr({
            //monthSelectorType: 'static',
            dateFormat: 'd-m-Y',
        });
    }

    $(document).ready(function () {

        fromAndToPeriod();
        manufacturerDd();
       commonAreaDd();
        switcheryKeyGen("datatable-list-switchery");
        // Initialize
        var validator = $("#form_item").validate({
            ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
            errorClass: 'validation-invalid-label',
            successClass: 'validation-valid-label',
            validClass: 'validation-valid-label',
            highlight: function (element, errorClass) {
                $(element).removeClass(errorClass);
            },
            unhighlight: function (element, errorClass) {
                $(element).removeClass(errorClass);
            },
            success: function (label) {
                label.addClass('validation-valid-label').text('Success.'); // remove to hide Success message
            },
            // Different components require proper error label placement
            errorPlacement: function (error, element) {

                // Unstyled checkboxes, radios
                if (element.parents().hasClass('form-check')) {
                    error.appendTo(element.parents('.form-check').parent());
                }

                // Input with icons and Select2
                else if (element.parents().hasClass('form-group row-feedback') || element.hasClass('select2-hidden-accessible')) {
                    error.appendTo(element.parent());
                }

                // Input group, styled file input
                else if (element.parent().is('.uniform-uploader, .uniform-select') || element.parents().hasClass('input-group')) {
                    error.appendTo(element.parent().parent());
                }

                // Other elements
                else {
                    error.insertAfter(element);
                }
            },
            rules: {
                item_name: {
                    required: true
                },
                item_description: {
                    required: true
                },
                manufacturer_id: {
                    required: true
                },
                common_area_id: {
                    required: true
                },
                warranty_period_from: {
                    required: true
                },
                warranty_period_to: {
                    required: true
                },
            },
            messages: {
                item_name: {
                    required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('Item.item_name');?>"
                },
                item_description: {
                    required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('Item.item_description');?>"
                },
                manufacturer_id: {
                    required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('Item.manufacturer');?>"
                },
                common_area_id: {
                    required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('Item.common_area');?>"
                },
                warranty_period_from: {
                    required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('Item.warranty_period_from');?>"
                },
                warranty_period_to: {
                    required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('Item.warranty_period_to');?>"
                },
            },
            submitHandler: function (e) {
                $(e).ajaxSubmit({
                    url: '<?php echo admin_url("Item/save");?>',
                    type: 'post',
                    beforeSubmit: function (formData, jqForm, options) {
                        dtButtonHide('#submitBtn');
						dtButtonHide('#cancelBtn');
                    },
                    complete: function () {

                    },
                    dataType: 'json',
                    clearForm: false,
                    success: function (resObj, statusText) {
						if (resObj.success) {
							toastr.success(resObj.msg, 'Success', {
								closeButton: true,
								progressBar: true,
								positionClass: 'toast-top-right',
								timeOut: 1000,
                                onHidden: function () {
                                    dtButtonShow('#submitBtn');
									dtButtonShow('#cancelBtn');
                                    window.location.href = '<?php echo admin_url('Item');?>';
                                }
							});

							// setTimeout(function () {
							// 	window.location.href = '<?php echo admin_url('Item');?>';
							// }, 1000);

						} else {
                            dtButtonShow('#submitBtn');
                            dtButtonShow('#cancelBtn');
							toastr.error(resObj.msg, 'Error', {
								closeButton: true,
								// progressBar: true,
								positionClass: 'toast-top-right',
								// timeOut: 1000
							});
						}
					}
                });
            }
        });
    });


    $(document).on('click', '.delete-image', function () {
        var deleteId = $(this).attr("id");
        var itemId = $("#item_id").val();
        Swal.fire({
            title: "<?= ucwords(lang('CommonMessage.common_delete')); ?>",
            text: "<?= lang('CommonMessage.delete_warning'); ?>",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'OK',
            customClass: {
                confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
                cancelButton: 'btn btn-label-secondary waves-effect waves-light'
            },
            buttonsStyling: false
        }).then(function(result) {
            if (result.value) {

                $("span.document-image-"+deleteId).remove();

                $.ajax({
                    type: "post",
                    url: "<?= admin_url("Item/deleteItemImage")?>",
                    dataType: "json",
                    data: {item_image_id: deleteId,item_id:itemId},
                    success: function (data) {
                        if (data['success']) {
                            $(".delete-image").click(function() {
                                $(this).parent().remove();
                            }); 
                            Swal.fire({
                                title: 'Success',
                                text: data['msg'],
                                icon: 'success',
                                customClass: {
                                    confirmButton: 'btn btn-primary waves-effect waves-light'
                                },
                                buttonsStyling: false
                            }).then(function() {
                                dt_DataTable.ajax.reload();
                            });
                        }
                        else{
                            Swal.fire({
                                title: 'Error!',
                                text: data['msg'],
                                icon: 'error',
                                customClass: {
                                    confirmButton: 'btn btn-primary waves-effect waves-light'
                                },
                                buttonsStyling: false
                            }).then(function() {
                                dt_DataTable.ajax.reload();
                            });
                        }
                    }
                });
            }
        });
    });
</script>

<?= isset($select2_ajax) ? $select2_ajax : ""; ?>
