<?php
$dtCIAcl = new \App\Libraries\Dt_ci_acl();
$session = \Config\Services::session();
$prefix = INVOICE_PREFIX;
$invoiceView = isset($invoice_data['view']) ? $invoice_data['view'] : 0;
?>
<div class="row">
    <div class="col-md-12">
        <div class="card mb-4">
            <div class="card-header d-flex align-items-center justify-content-between">
                <h5 class="mb-0"><?= lang('Invoice.invoice_detail'); ?></h5>
            </div>
            <div class="card-body">
                <?php
                //create  form open tag
                $form_id = array(
                    'id' => 'form_invoice',
                );
                echo form_open_multipart('', $form_id);
                $invoiceId = (isset($invoice_data['invoice_id']) && ($invoice_data['invoice_id'] != '')) ? $invoice_data['invoice_id'] : '';
                ?>
                <input type="hidden" id="invoice_id" name="invoice_id" value="<?= $invoiceId ?>">
                <input type="hidden" id="delete_amenities_unit_id" name="delete_amenities_unit_id" value="">
                <div class="row g-3">

                    <div class="col-md-3">
                        <label class="form-label"><?= lang('CommonMessage.common_prefix'); ?></label>
                        <input type="text" id="prefix" name="prefix" class="form-control customerWarehousePrefix"
                               placeholder="Enter <?= lang('CommonMessage.common_prefix'); ?>"
                               value="<?= isset($invoice_data['prefix']) ? $invoice_data['prefix'] : $prefix; ?>" readonly/>
                    </div>

                    <div class="col-md-3">
                        <label class="form-label"><?= lang('CommonMessage.common_series'); ?></label>
                        <input type="text" id="series" name="series" class="form-control series"
                               placeholder="Enter <?= lang('CommonMessage.common_series'); ?>"
                               value="<?= isset($invoice_data['series']) ? $invoice_data['series'] : ""; ?>" readonly/>
                    </div>

                    <div class="col-md-6">
                        <label class="form-label" for="basic-default-name"><?= lang('Invoice.invoice_date'); ?><span
                                    class="text-danger"> *</span></label>
                        <input type="text" class="form-control" name="invoice_date" id="invoice_date"
                               placeholder="Select <?= lang('Invoice.invoice_date'); ?>"
                               value="<?= (isset($invoice_data['invoice_date']) && isValidDate($invoice_data['invoice_date'])) ? siteDateFormat($invoice_data['invoice_date']) : date('d-m-Y'); ?>"
                        />

                    </div>

                    <div class="col-md-6">
                        <label class="form-label" for="basic-default-name"><?= lang('Invoice.due_date'); ?><span
                                    class="text-danger"> *</span></label>
                        <input type="text" class="form-control" name="due_date" id="due_date"
                               placeholder="Select <?= lang('Invoice.due_date'); ?>"
                               value="<?= (isset($invoice_data['due_date']) && isValidDate($invoice_data['due_date'])) ? siteDateFormat($invoice_data['due_date']) : date('d-m-Y'); ?>"
                        />
                    </div>

                    <div class="col-md-6">
                        <label class="form-label" for="basic-default-name"><?= lang('Invoice.flat_no'); ?><span
                                    class="text-danger"> *</span></label> <button type="button" class="btn btn-label-primary dt-view_flat-detail btn btn-xs" > View Flat Detail </button>
                        <select id="ownership_flat_id" name="ownership_flat_id" class="select2 form-select ownerflatDd dt-flat"  data-allow-clear="true">
                            <option></option>
                            <?php if(isset($invoice_data['ownership_flat_id']) && $invoice_data['ownership_flat_id'] != 0){ ?>
                                <option value="<?= isset($invoice_data['ownership_flat_id']) ? $invoice_data['ownership_flat_id'] : 0 ?>" selected> <?= isset($invoice_data['flat_no']) ? $invoice_data['flat_no'] : ''  ?> </option>
                            <?php } ?>
                        </select>
                    </div>

                    <div class="col-md-6">
                        <label class="form-label" for="basic-default-name"><?= lang('Invoice.name'); ?><span
                                    class="text-danger"> *</span></label>
                        <input type="text" class="form-control" name="name" id="name"
                               placeholder="Select <?= lang('Invoice.name'); ?>"
                               value="<?= (isset($invoice_data['name'])) ? $invoice_data['name'] : ""; ?>"
                        />
                    </div>

                    <div class="col-md-6">
                        <label class="form-label" for="basic-default-name"><?= lang('Invoice.contact'); ?><span
                                    class="text-danger"> *</span></label>
                        <input type="text" class="form-control" name="contact" id="contact"
                                placeholder="Select <?= lang('Invoice.contact'); ?>"
                                value="<?= (isset($invoice_data['contact'])) ? $invoice_data['contact'] : ""; ?>"
                        />
                    </div>

                    <div class="col-md-6">
                        <label class="form-label" for="basic-default-name"><?= lang('Invoice.bank_account'); ?><span
                                    class="text-danger"> *</span></label>
                        <select id="bank_account_id" name="bank_account_id" class="select2 form-select bankAccountDd"  data-allow-clear="true">
                            <option></option>
                            <?php if(isset($invoice_data['bank_account_id']) && $invoice_data['bank_account_id'] != 0){ ?>
                                <option value="<?= isset($invoice_data['bank_account_no']) ? $invoice_data['bank_account_no'] : 0 ?>" selected> <?= isset($invoice_data['bank_account_no']) ? $invoice_data['bank_account_no'] : ''  ?> </option>
                            <?php } ?>
                        </select>
                    </div>

                    <div class="col-md-6">
                        <label class="form-label" for="basic-default-name"><?= lang('Invoice.bank'); ?><span
                                    class="text-danger"> *</span></label>
                        <input type="text" class="form-control" name="bank" id="bank"
                               placeholder="Select <?= lang('Invoice.bank'); ?>"
                               value="<?= (isset($invoice_data['bank'])) ? $invoice_data['bank'] : ""; ?>"
                        />
                    </div>

                    <div class="col-md-6">
                        <label class="form-label" for="basic-default-name"><?= lang('Invoice.branch'); ?><span
                                    class="text-danger"> *</span></label>
                        <input type="text" class="form-control" name="branch" id="branch"
                                placeholder="Select <?= lang('Invoice.branch'); ?>"
                                value="<?= (isset($invoice_data['branch'])) ? $invoice_data['branch'] : ""; ?>"
                        />
                    </div>

                    <div class="col-md-6">
                        <label class="form-label" for="basic-default-name"><?= lang('Invoice.ifsc_code'); ?><span
                                    class="text-danger"> *</span></label>
                        <input type="text" class="form-control" name="ifsc_code" id="ifsc_code"
                                placeholder="Select <?= lang('Invoice.ifsc_code'); ?>"
                                value="<?= (isset($invoice_data['ifsc_code'])) ? $invoice_data['ifsc_code'] : ""; ?>"
                        />
                    </div>

                    <div class="col-md-6">
                        <label class="form-label" for="basic-default-name"><?= lang('Invoice.late_payment_charges'); ?><span
                                    class="text-danger"> *</span></label>
                        <input type="text" class="form-control" name="late_payment_charges" id="late_payment_charges"
                                placeholder="Select <?= lang('Invoice.late_payment_charges'); ?>"
                                value="<?= (isset($invoice_data['late_payment_charges'])) ? $invoice_data['late_payment_charges'] : ""; ?>"
                        />
                    </div>

                    <div class="col-md-6">
                        <label class="form-label" for="basic-default-name"><?= lang('Invoice.late_payment_charges_18'); ?><span
                                    class="text-danger"> *</span></label>
                        <input type="text" class="form-control" name="taxed_late_payment_charges" id="taxed_late_payment_charges"
                                placeholder="Select <?= lang('Invoice.late_payment_charges_18'); ?>"
                                value="<?= (isset($invoice_data['taxed_late_payment_charges'])) ? $invoice_data['taxed_late_payment_charges'] : ""; ?>"
                        readonly/>
                    </div>

                    <div class="col-md-6">
                        <label class="form-label" for="basic-default-name"><?= lang('Invoice.advances'); ?><span
                                    class="text-danger"> *</span></label>
                        <input type="text" class="form-control" name="advances" id="advances"
                                placeholder="Select <?= lang('Invoice.advances'); ?>"
                                value="<?= (isset($invoice_data['advances'])) ? $invoice_data['advances'] : ""; ?>"
                        />
                    </div>
                    
                    <div class="col-md-6">
                        <label class="form-label" for="basic-default-name"><?= lang('Invoice.advances_18'); ?><span
                                    class="text-danger"> *</span></label>
                        <input type="text" class="form-control" name="taxed_advances" id="taxed_advances"
                                placeholder="Select <?= lang('Invoice.advances_18'); ?>"
                                value="<?= (isset($invoice_data['taxed_advances'])) ? $invoice_data['taxed_advances'] : ""; ?>"
                        />
                    </div>
                    
                </div>
                    <hr class="my-4 mx-n4" />
                    <h6>2. <?= lang('Invoice.particular_information'); ?></h6>
                    <div class="row g-3">
                        <?= isset($invoice_particular_table) ? $invoice_particular_table : ""; ?>
                    </div>
                    <?php if ($dtCIAcl->checkAccess('Invoice|manage')) { ?>
                        <button type="button" class="btn btn-xs btn-primary" onclick="addInvoiceParticular()">
                            <i class="ti ti-plus me-1"></i>
                            <span class="align-middle"><?= lang('CommonMessage.common_add_row'); ?></span>
                        </button>
                    <?php } ?>

                    <hr class="my-4 mx-n4" />
                    <h6>3. <?= lang('Invoice.tax_information'); ?></h6>
                    <div class="collapse show" id="tax_information" style="">
                    <div class="col-sm-12">
                        <div class="form-group">
                            <div class="table-responsive table-bordered table-framed">
                                <table class="table table-bordered table-framed dt-invoice-tax-table">
                                    <thead>
                                    <tr>
                                        <th style="width: 10%"><?= lang('Invoice.tax_name'); ?></th>
                                        <th style="width: 10%"><?= lang('Invoice.tax_rate'); ?></th>
                                        <th style="width: 10%"><?= lang('Invoice.tax_amount'); ?></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    </tbody>
                                </table>
                            </div>

                        </div>
                    </div>
                </div>

                <hr class="my-4 mx-n4" />
                <div class="row g-3">
                    <div class="col-md-6">
                                <label class="form-label" for="basic-default-name"><?= lang('Invoice.sub_total'); ?><span
                                            class="text-danger"> *</span></label>
                                <input type="text" class="form-control" name="sub_total" id="sub_total"
                                        placeholder="Select <?= lang('Invoice.sub_total'); ?>"
                                        value="<?= (isset($invoice_data['sub_total'])) ? $invoice_data['sub_total'] : ""; ?>"
                                readonly/>
                            </div>
                            
                    <div class="col-md-6">
                        <label class="form-label" for="basic-default-name"><?= lang('Invoice.net_payable_amount'); ?><span
                                    class="text-danger"> *</span></label>
                        <input type="text" class="form-control" name="net_payable_amount" id="net_payable_amount"
                                placeholder="Select <?= lang('Invoice.net_payable_amount'); ?>"
                                value="<?= (isset($invoice_data['net_payable_amount'])) ? $invoice_data['net_payable_amount'] : ""; ?>"
                        readonly/>
                    </div>

                    <div class="col-md-6">
                        <label class="form-label" for="basic-default-name"><?= lang('Invoice.total_tax_amount'); ?><span
                                    class="text-danger"> *</span></label>
                        <input type="text" class="form-control" name="total_tax_amount" id="total_tax_amount"
                                placeholder="Select <?= lang('Invoice.total_tax_amount'); ?>"
                                value="<?= (isset($invoice_data['total_tax_amount'])) ? $invoice_data['total_tax_amount'] : ""; ?>"
                        readonly/>
                    </div>
                </div>

                <?php if($invoiceView != 1) { ?>
                    <div class="pt-4">
                        <button type="submit" id="submitBtn"
                                class="btn btn-primary me-sm-3 me-1 submit"><?= lang('CommonMessage.common_submit'); ?></button>
                        <button type="button" id="cancelBtn" onclick="window.location.href='<?php echo admin_url('Invoice'); ?>'"
                                class="btn btn-label-secondary"> <?= lang('CommonMessage.common_cancel'); ?></button>
                    </div>
                <?php } ?>
                <?php echo form_close(); ?>
                
            </div>
        </div>
    </div>
</div>

<script>
    var editable = <?= $invoiceView ?>;
    if(editable == 1)
    {
        $("#form_invoice :input").prop("disabled", true);
        $(".dt-delete-item-row").removeAttr("onclick");
        $(".dt-delete-item-row").remove();

    }

    $(document).ready(function () {
        numberInit();
        switcheryKeyGen("datatable-list-switchery");
        <?php if (!isset($invoice_data['invoice_id'])){ ?>
        getInvoicePrefix();
        <?php } ?>
        ownerflatDd();
        bankAccountDd();
        taxDd();
        addSerialNumber('invoice_particular_table');
        $(".dt-period_from").flatpickr({
			dateFormat: "d-m-Y",
		});
        $(".dt-period_to").flatpickr({
			dateFormat: "d-m-Y",
		});
        // $('#late_payment_charges').change();
        // taxTable();

        // Initialize
        var validator = $("#form_invoice").validate({
            ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
            errorClass: 'validation-invalid-label',
            successClass: 'validation-valid-label',
            validClass: 'validation-valid-label',
            highlight: function (element, errorClass) {
                $(element).removeClass(errorClass);
            },
            unhighlight: function (element, errorClass) {
                $(element).removeClass(errorClass);
            },
            success: function (label) {
                label.addClass('validation-valid-label').text('Success.'); // remove to hide Success message
            },
            // Different components require proper error label placement
            errorPlacement: function (error, element) {

                // Unstyled checkboxes, radios
                if (element.parents().hasClass('form-check')) {
                    error.appendTo(element.parents('.form-check').parent());
                }

                // Input with icons and Select2
                else if (element.parents().hasClass('form-group row-feedback') || element.hasClass('select2-hidden-accessible')) {
                    error.appendTo(element.parent());
                }

                // Input group, styled file input
                else if (element.parent().is('.uniform-uploader, .uniform-select') || element.parents().hasClass('input-group')) {
                    error.appendTo(element.parent().parent());
                }

                // Other elements
                else {
                    error.insertAfter(element);
                }
            },
            rules: {
                prefix: {
                    required: true
                },
                series: {
                    required: true
                },
                invoice_date : {
					required: true,
				},
                due_date : {
                    required: true,
                },
                ownership_flat_id : {
                    required: true,
                },

            },
            messages: {
                prefix: {
                    required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('Invoice.prefix');?>"
                },
                series: {
                    required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('Invoice.series');?>"
                },
                invoice_date: {
					required: '<?= lang("CommonMessage.common_please_select"); ?> <?= lang("Invoice.invoice_date"); ?>',
				},
				due_date: {
					required: '<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("Invoice.due_date"); ?>',
				},
                ownership_flat_id: {
                    required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('Invoice.flat_no');?>"
                },

            },
            submitHandler: function (e) {
                $(e).ajaxSubmit({
                    url: '<?php echo admin_url("Invoice/save");?>',
                    type: 'post',
                    beforeSubmit: function (formData, jqForm, options) {
                        dtButtonHide('#submitBtn');
						dtButtonHide('#cancelBtn');
                    },
                    complete: function () {

                    },
                    dataType: 'json',
                    clearForm: false,
                    success: function (resObj, statusText) {
						if (resObj.success) {
							toastr.success(resObj.msg, 'Success', {
								closeButton: true,
								progressBar: true,
								positionClass: 'toast-top-right',
								timeOut: 1000,
                                onHidden: function () {
                                    dtButtonShow('#submitBtn');
									dtButtonShow('#cancelBtn');
                                    window.location.href = '<?php echo admin_url('Invoice');?>';
                                }
							});

							// setTimeout(function () {
							// 	window.location.href = '<?php echo admin_url('Invoice');?>';
							// }, 1000);

						} else {
                            dtButtonShow('#submitBtn');
                            dtButtonShow('#cancelBtn');
							toastr.error(resObj.msg, 'Error', {
								closeButton: true,
								// progressBar: true,
								positionClass: 'toast-top-right',
								// timeOut: 1000
							});
						}
					}
                });
            }
        });
        $("#invoice_date").flatpickr({
            dateFormat: "d-m-Y",
        });

        $("#due_date").flatpickr({
            dateFormat: "d-m-Y",
        });

    });

    function getInvoicePrefix(prefix = '') {
        var tableType = "invoice";
        var societyId = "<?= $session->get('society_id') ?>";
        if (prefix != '') {
            var displayPrefix = prefix;
        } else {
            var displayPrefix = "<?= $prefix ?>";
        }
        getNextSeriesJS(tableType, displayPrefix, societyId);
    }

    $(document).on('change', '#ownership_flat_id', function () {
        var flatId    	= $(this).val();
        $.ajax({
            type: "POST",
            url: "<?php echo admin_url('Invoice/getFlatOwnerTableRow'); ?>",
            dataType: "json",
            data: {
                flat_id : flatId,
            },
            beforeSend: function (formData, jqForm, options) {
            },
            complete: function () {
            },
            success: function (resObj) {
                if (resObj.success) {
                    $("#name").val(resObj.data.name);
                    $("#contact").val(resObj.data.mobile_no);
                }
            }
        });
    });

    function taxTable() {
        var toFixedValue = '<?= ROUND_DECIMAL_POINT ?>';
        var taxWiseAmount = {};
        var taxArray = [];
        var dataTaxJson = [];
        var filterDataTaxJson = [];
        var filterExpenseDataTaxJson = [];
        $(".dt-tax-id").each(function () {
            var quantityTr = $(this).closest('tr');
            var productDataTaxJson = quantityTr.find(".dt-particular-tax-json").val();
            dataTaxJson = JSON.parse(productDataTaxJson);
            if (dataTaxJson) {
                dataTaxJson.forEach(function (d) {
                    filterDataTaxJson.push(d);
                });
            }
        });

        if (filterDataTaxJson) {
            filterDataTaxJson.forEach(function (d) {
                if (taxWiseAmount.hasOwnProperty(d.tax_name)) {
                    taxWiseAmount[d.tax_name] = taxWiseAmount[d.tax_name] + d.particular_tax_amount;
                } else {
                    taxWiseAmount[d.tax_name] = d.particular_tax_amount;
                    taxArray.push(d);
                }
            });
        }

        var html = '';
        if ($.isEmptyObject(taxArray) == false) {
            var TotalTaxAmount = 0;
            taxArray.forEach(function (value) {
                var formatJson = value;
                TotalTaxAmount += formatDecimal(taxWiseAmount[formatJson.tax_name], toFixedValue);
                var lastIndex = ($("#invoice_particular_table tbody tr:last").length >= 1) ? $("#invoice_particular_table tbody tr:last").attr("data-id").split("_").pop() : 1;
                index = parseInt(lastIndex) + 1;
                
                html += "<tr data-id='" + index + "'>";

                html += "<td>" +
                    "<input type='text' name='tax_name' id='tax_name'  class='form-control' value='" + formatJson.tax_name + "' readonly>" +
                    "</td>" +
                    "<td>" +
                    "<input type='text' name='tax_rate' id='tax_rate'  class='form-control' value='" + formatDecimal(formatJson.tax_rate, toFixedValue) + "' readonly>" +
                    "</td>" +
                    "<td>" +
                    "<input type='text' name='tax_amount'  id='tax_amount' class='form-control' value='" + formatDecimal(taxWiseAmount[formatJson.tax_name], toFixedValue) + "' readonly>" +
                    "</td>" +
                    "</tr>";
            });
        }
        $('table.dt-invoice-tax-table tbody').html('').append(html);
        $("#total_tax_amount").val(TotalTaxAmount);
    }

    $(document).on('change', '#late_payment_charges', function () {
        var value    	= $(this).val();
        $.ajax({
            type: "POST",
            url: "<?php echo admin_url('Invoice/getTaxData'); ?>",
            dataType: "json",
            data: {
                value : value,
            },
            beforeSend: function (formData, jqForm, options) {
            },
            complete: function () {
            },
            success: function (resObj) {
                if (resObj.success) {
                    $("#taxed_late_payment_charges").val(resObj.taxed_value);
                } else {
                    Swal.fire({
                    title: "<?= ucwords(lang('CommonMessage.common_sweet_alert_info')); ?>",
                    text: "Please Add 18% GST In Tax",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonText: 'OK',
                    customClass: {
                        confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
                        cancelButton: 'btn btn-label-secondary waves-effect waves-light'
                    },
                    buttonsStyling: false
                    }).then(function () {
                        return false;
                    });
                }
            }
        });
    });

    $(document).on('change', '#advances', function () {
        var value    	= $(this).val();
        $.ajax({
            type: "POST",
            url: "<?php echo admin_url('Invoice/getTaxData'); ?>",
            dataType: "json",
            data: {
                value : value,
            },
            beforeSend: function (formData, jqForm, options) {
            },
            complete: function () {
            },
            success: function (resObj) {
                if (resObj.success) {
                    $("#taxed_advances").val(resObj.taxed_value);
                } else {
                    Swal.fire({
                    title: "<?= ucwords(lang('CommonMessage.common_sweet_alert_info')); ?>",
                    text: "Please Add 18% Tax In Tax",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonText: 'OK',
                    customClass: {
                        confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
                        cancelButton: 'btn btn-label-secondary waves-effect waves-light'
                    },
                    buttonsStyling: false
                    }).then(function () {
                        return false;
                    });
                }
            }
        });
    });

    $(document).on("change", "#late_payment_charges,#advances,.dt-amount,.dt-tax-id", function() {
        var productId = $(this).val() || 0;
        var productTr = $(this).closest('tr');
        var taxId = productTr.find(".dt-tax-id").val();
		var particularAmount = parseInt(productTr.find(".dt-amount").val());
		var taxData = productTr.find(".dt-tax-id").select2('data');
		var totalTaxRate = 0;
		var paRticularTotalTaxAmount = 0;
		var taxItemObj = [];
		$(taxData).each(function (key,displayData) {
			totalTaxRate += parseInt(displayData.tax_rate);
			var taxItem = {}
            taxItem["tax_id"] = displayData.id;
            taxItem["tax_name"] = displayData.tax_name;
            taxItem["tax_rate"] = displayData.tax_rate;
			taxItem["particular_tax_amount"] = (parseInt(displayData.tax_rate) / 100) * particularAmount;
			taxItemObj.push(taxItem);
		});

		paRticularTotalTaxAmount = (totalTaxRate / 100) * particularAmount + particularAmount;
		productTr.find(".dt-total_amount").val(paRticularTotalTaxAmount);
		productTr.find(".dt-particular-tax-json").val(JSON.stringify(taxItemObj));
    	calculate();
		taxTable();
    });

	function calculate() {
        var productCount = 0;
        var toFixedValue = '<?= ROUND_DECIMAL_POINT ?>';
        var allProductTotal = 0;
        var rateTotal = 0;
		var productTotalAmount = 0;
        $("table#invoice_particular_table .dt-particular").each(function (index) {
            productCount = (index + 1);
            var productTotal = 0;
            var taxItemObj = [];
            var quantityTr = $(this).closest('tr');
            var amount = parseInt(quantityTr.find(".dt-amount").val());
            var dataTaxJson  = quantityTr.find(".dt-particular-tax-json").val();
            dataTaxJson = JSON.parse(dataTaxJson)
            var totalTaxAmount = 0;
            var totalTaxRate = 0;
            productTotalAmount += amount;
            $.each( dataTaxJson, function( key, value ) {
                var formatJson = value;
                productTotalAmount += parseInt(formatJson.particular_tax_amount);
            });
        });
		var latePaymentCharges = $("#taxed_late_payment_charges").val();
		var advances = $("#taxed_advances").val();
		var subTotal = parseInt(productTotalAmount);
		subTotal += parseInt(latePaymentCharges);
		$("#sub_total").val(productTotalAmount);
		subTotal -= parseInt(advances);
		$("#net_payable_amount").val(subTotal);
	}
</script>

<?= isset($select2_ajax) ? $select2_ajax : ""; ?>
