<div class="row">
	<div class="col-md-12">
		<div class="card mb-4">
			<div class="card-header d-flex align-items-center justify-content-between">
				<h5 class="mb-0"><?= lang('Investments.investments_detail');?></h5>
			</div>
			<div class="card-body">
				<?php
				//create  form open tag
				$form_id = array(
					'id'=>'form_investments',
				);
				echo form_open_multipart('',$form_id);
				$investmentsId = (isset($investments_data['investments_id']) && ($investments_data['investments_id'] != '')) ? $investments_data['investments_id'] : '';
				?>
				<input type="hidden" id="investments_id" name="investments_id" value="<?= $investmentsId ?>">
				<input type="hidden" id="tower_id" name="tower_id" class="dt-tower-flat-id" value="<?= (isset($investments_data['tower_id']) && ($investments_data['tower_id'] != '')) ? $investments_data['tower_id'] : ''; ?>">
				<div class="row g-3">

					<div class="col-md-6">
						<label class="form-label" for="basic-default-name"><?= lang('Investments.financial_year');?><span class="text-danger"> *</span></label>
						<select id="financial_year_id" name="financial_year_id" class="select2 form-select form-select-lg financialYearDd" data-allow-clear="true">
							<option></option>
							<?php if(isset($investments_data['financial_year_id']) && $investments_data['financial_year_id'] != 0){ ?>
							<option value="<?= isset($investments_data['financial_year_id']) ? $investments_data['financial_year_id'] : 0 ?>" selected> <?= isset($investments_data['financial_year_prefix']) ? $investments_data['financial_year_prefix'] : ''  ?> </option>
							<?php } ?>
						</select>
					</div>

					<div class="col-md-6">
						<label class="form-label" for="basic-default-name"><?= lang('Investments.start_date');?><span class="text-danger"> *</span></label>
						<input type="text" class="form-control" name="date" id="date" placeholder="Select <?= lang('Investments.start_date');?>" value="<?= (isset($investments_data['date']) && isValidDate($investments_data['date'])) ? siteDateFormat($investments_data['date']) : ''; ?>" />
						
					</div>

					<div class="col-md-6">
						<label class="form-label" for="basic-default-name"><?= lang('Investments.bank');?><span class="text-danger"> *</span></label>
						<select id="bank_id" name="bank_id" class="select2 form-select form-select-lg bankDd dt-bank" data-allow-clear="true">
							<option></option>
							<?php if(isset($investments_data['bank_id']) && $investments_data['bank_id'] != 0){ ?>
							<option value="<?= isset($investments_data['bank_id']) ? $investments_data['bank_id'] : 0 ?>" selected> <?= isset($investments_data['bank_name']) ? $investments_data['bank_name'] : ''  ?> </option>
							<?php } ?>
						</select>
					</div>

					<div class="col-md-6">
						<label class="form-label" for="basic-default-name"><?= lang('Investments.active');?></label>
						<label class="switch switch-sm"><span class="switch-label"></span>
							<input type="checkbox" class="switch-input form-add-switchery"  name="is_active" id="is_active" <?php echo (!isset($investments_data['is_active']) || $investments_data['is_active'] == 1) ? 'checked="checked"' : ''; ?>/>
							<span class="switch-toggle-slider">
	                            <span class="switch-on"></span>
	                            <span class="switch-off"></span>
                           </span>		
						</label>
					</div>
					
				</div>

				<hr class="my-4 mx-n4" />

				<h6>1. <?= lang('Investments.fdr_details'); ?></h6>
				<div class="row g-3">	

					<div class="col-md-6">
						<label class="form-label" for="basic-default-name"><?= lang('Investments.fdr_no');?><span class="text-danger"> *</span></label>
						
						<input type="text" class="form-control" name="fdr_no" id="fdr_no" placeholder="Enter <?= lang('Investments.fdr_no');?>" value="<?= (isset($investments_data['fdr_no']) && ($investments_data['fdr_no'] != '')) ? $investments_data['fdr_no'] : '';  ?>" />
					</div>
					

					<div class="col-md-6">
						<label class="form-label" for="basic-default-name"><?= lang('Investments.fdr_amount');?><span class="text-danger"> *</span></label>
						
						<input type="text" class="form-control numberInit" name="fdr_amount" id="fdr_amount" placeholder="Enter <?= lang('Investments.fdr_amount');?>" value="<?= (isset($investments_data['fdr_amount']) && ($investments_data['fdr_amount'] != '')) ? $investments_data['fdr_amount'] : '';  ?>" />
					</div>
					

					<div class="col-md-6">
						<label class="form-label" for="basic-default-name"><?= lang('Investments.term');?><span class="text-danger"> *</span></label>
						<input type="text" class="form-control" name="term" id="term" placeholder="Enter <?= lang('Investments.term');?>" value="<?= (isset($investments_data['term']) && ($investments_data['term'] != '')) ? $investments_data['term'] : '';  ?>" />
						</div>
					

					<div class="col-md-6">
						<label class="form-label" for="basic-default-name"><?= lang('Investments.rate');?><span class="text-danger"> *</span></label>
						<input type="text" class="form-control numberInit" name="rate" id="rate" placeholder="Enter <?= lang('Investments.rate');?>" value="<?= (isset($investments_data['rate']) && ($investments_data['rate'] != '')) ? $investments_data['rate'] : '';  ?>" />
					</div>
					

					<div class="col-md-6">
						<label class="form-label" for="basic-default-name"><?= lang('Investments.acrd_int');?><span class="text-danger"> *</span></label>
						<input type="text" class="form-control numberInit" name="acrd_int" id="acrd_int" placeholder="Enter <?= lang('Investments.acrd_int');?>" value="<?= (isset($investments_data['acrd_int']) && ($investments_data['acrd_int'] != '')) ? $investments_data['acrd_int'] : '';  ?>" />
					</div>
				</div>

				<hr class="my-4 mx-n4" />

				<h6>2. <?= lang('Investments.maturity_details'); ?></h6>
				<div class="row g-3">	
					<div class="col-md-6">
						<label class="form-label" for="basic-default-name"><?= lang('Investments.maturity_date');?><span class="text-danger"> *</span></label>
							<input type="text" class="form-control" name="maturity_date" id="maturity_date" placeholder="Select <?= lang('Investments.maturity_date');?>" value="<?= (isset($investments_data['maturity_date']) && isValidDate($investments_data['maturity_date'])) ? siteDateFormat($investments_data['maturity_date']) : ''; ?>" />
					</div>

					<div class="col-md-6">
						<label class="form-label" for="basic-default-name"><?= lang('Investments.maturity_amount');?><span class="text-danger"> *</span></label>
						<input type="text" class="form-control numberInit" name="maturity_amount" id="maturity_amount" placeholder="Enter <?= lang('Investments.maturity_amount');?>" value="<?= (isset($investments_data['maturity_amount']) && ($investments_data['maturity_amount'] != '')) ? $investments_data['maturity_amount'] : '';  ?>" />
						</div>
				</div>

					

					<div class="pt-4">
						<button type="submit" id="submitBtn" class="btn btn-primary me-sm-3 me-1 submit">Submit</button>
						<button type="button" id="cancelBtn" onclick="window.location.href='<?php echo admin_url('Investments'); ?>'" class="btn btn-label-secondary">Cancel</button>
					</div>
				<?php echo form_close(); ?>
			</div>
		</div>
	</div>
</div>

<script>
    $(document).ready(function() {
    	// bankAccountDd();
    	bankDd();
    	financialYearDd();
		switcheryKeyGen("datatable-list-switchery");
		numberInit();
        // Initialize
		var validator = $("#form_investments").validate({
			ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
			errorClass: 'validation-invalid-label',
			successClass: 'validation-valid-label',
			validClass: 'validation-valid-label',
			highlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			unhighlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			success: function(label) {
				label.addClass('validation-valid-label').text('Success.'); // remove to hide Success message
			},
			// Different components require proper error label placement
			errorPlacement: function(error, element) {

				// Unstyled checkboxes, radios
				if (element.parents().hasClass('form-check')) {
					error.appendTo( element.parents('.form-check').parent() );
				}

				// Input with icons and Select2
				else if (element.parents().hasClass('form-group row-feedback') || element.hasClass('select2-hidden-accessible')) {
					error.appendTo( element.parent() );
				}

				// Input group, styled file input
				else if (element.parent().is('.uniform-uploader, .uniform-select') || element.parents().hasClass('input-group')) {
					error.appendTo( element.parent().parent() );
				}

				// Other elements
				else {
					error.insertAfter(element);
				}
			},
            rules: {
				financial_year_id : {
					required : true,
				},
				date : {
					required : true,
				},
				bank_id: {
                    required: true,
                },
                fdr_no: {
                    required: true,
                },
                fdr_amount: {
                    required: true,
                },
                term : {
                	required : true,
                },
                rate : {
                	required : true,
					range: [0, 100],
                },
                acrd_int : {
                	required : true,
                },
                maturity_date : {
                	required : true,
                },
                maturity_amount : {
                	required : true,
                },
				
            },
            messages: {
				financial_year_id : {
					required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('Investments.financial_year');?>"
				},
				date : {
					required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('Investments.start_date');?>"
				},
				bank_id: {
                   required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('Investments.bank');?>"
                },
                fdr_no: {
                    required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('Investments.fdr_no');?>"
                },
                fdr_amount: {
                    required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('Investments.fdr_amount');?>"
                },
                term : {
                	required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('Investments.term');?>"
                },
                rate : {
                	required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('Investments.rate');?>"
                },
                acrd_int : {
                	required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('Investments.acrd_int');?>"
                },
                maturity_date : {
                	required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('Investments.maturity_date');?>"
                },
                maturity_amount : {
                	required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('Investments.maturity_amount');?>"
                },
            },
            submitHandler: function (e) {
				$(e).ajaxSubmit({
					url: '<?php echo admin_url("Investments/save");?>',
					type: 'post',
					beforeSubmit: function (formData, jqForm, options) {
						dtButtonHide('#submitBtn');
						dtButtonHide('#cancelBtn');
					},
					complete: function () {

					},
					dataType: 'json',
					clearForm: false,
					success: function (resObj, statusText) {
						if (resObj.success) {
							toastr.success(resObj.msg, 'Success', {
								closeButton: true,
								progressBar: true,
								positionClass: 'toast-top-right',
								timeOut: 1000,
                                onHidden: function () {
                                    dtButtonShow('#submitBtn');
									dtButtonShow('#cancelBtn');
                                    window.location.href = '<?php echo admin_url('Investments');?>';
                                }
							});

							// setTimeout(function () {
							// 	window.location.href = '<?php echo admin_url('Investments');?>';
							// }, 1000);

						} else {
							dtButtonShow('#submitBtn');
							dtButtonShow('#cancelBtn');
							toastr.error(resObj.msg, 'Error', {
								closeButton: true,
								// progressBar: true,
								positionClass: 'toast-top-right',
								// timeOut: 1000
							});
						}
					}
				});
            }
        });
        $("#date").flatpickr({
			//monthSelectorType: 'static',
			dateFormat: 'd-m-Y'
		});

		$("#maturity_date").flatpickr({
			//monthSelectorType: 'static',
			dateFormat: 'd-m-Y'
		});
    });
</script>

<?= isset($select2_ajax) ? $select2_ajax : ""; ?>
