<?php
$towerColspan = !empty($tower_data) ? count($tower_data) : 0;
$assets = base_url() . 'assets/';
$count = ($towerColspan * 2) + 1;
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $name; ?></title>
    <link href="https://fonts.googleapis.com/css?family=Roboto:400,300,100,500,700,900" rel="stylesheet"
          type="text/css">

    <link href="<?= $assets ?>css/pdf_bootstrap.css" rel="stylesheet" type="text/css">
    <link href="<?= $assets ?>css/pdf_style_sheet.css" rel="stylesheet" type="text/css">
</head>
<body style='font-family:chelvetica;font-size: 9px'>

<table class="table" border="1" cellpadding="1" cellspacing="1" width="100%">
    <tr>
        <td colspan="<?= $count ?>">
            <center><strong>INTERCOM / VDP </strong></center>
        </td>
        <td colspan="3">
            <center><strong><?= isset($society_data['society_name']) ? $society_data['society_name'] : ''; ?></strong>
            </center>
        </td>
    </tr>
    <tr>
        <td colspan="<?= $count ?>" id="flats-towers">
            <center><strong>FLATS & TOWERS </strong></center>
        </td>
        <td colspan="3">
            <center><strong>COMMON AREA</strong></center>
        </td>
    </tr>
    <tr>
        <td>
            <center><strong><?= lang("CommonMessage.common_sr_no"); ?></strong></center>
        </td>
        <?php
        // Add tower headers dynamically
        foreach ($tower_wise_flat_data as $towerData) { ?>
            <td>
                <center><strong><?= $towerData['flat_no']; ?> </strong></center>
            </td>
            <td>
                <center><strong><?= $towerData['tower_name']; ?> </strong></center>
            </td>
        <?php } ?>
        <td>
            <center><strong>Area Name</strong></center>
        </td>
        <td>
            <center><strong>Particulares</strong></center>
        </td>
        <td>
            <center><strong>Numbers</strong></center>
        </td>
    </tr>

    <?php
    // Add rows dynamically
    $maxFlats = 0;
    $flatsMaxCount = max(array_map(function ($towerData) {
        return count($towerData['flats']);
    }, $tower_wise_flat_data));

    $commonAreaMaxCount = count($common_area_data);

    if($flatsMaxCount > $commonAreaMaxCount){
        $maxFlats = $flatsMaxCount;
    } else {
        $maxFlats = $commonAreaMaxCount;
    }

    for ($i = 0; $i < $maxFlats; $i++) {
        echo '<tr>';
        echo '<td><center>' . ($i + 1) . '</center></td>'; // Serial number
        foreach ($tower_wise_flat_data as $towerData) {
            if (isset($towerData['flats'][$i])) {
                echo '<td><center>' . $towerData['flats'][$i]['flat_no'] . '</center></td>';
                echo '<td><center>' . $towerData['flats'][$i]['number'] . '</center></td>';
            } else {
                echo '<td></td><td></td>';
            }

        }
        if (isset($common_area_data[$i]['common_area_name'])) {
            echo '<td><center>' . $common_area_data[$i]['common_area_name'] . '</center></td>';
        } else {
            echo '<td></td>';
        }
        if (isset($common_area_data[$i]['particulares'])) {
            echo '<td><center>' . $common_area_data[$i]['particulares'] . '</center></td>';
        } else {
            echo '<td></td>';
        }
        if (isset($common_area_data[$i]['number'])) {
            echo '<td><center>' . $common_area_data[$i]['number'] . '</center></td>';
        } else {
            echo '<td></td>';
        }


        echo '</tr>';
    }
    ?>

</table>

</body>
</html>
