<ul class="nav nav-tabs" role="tablist">
	<li class="nav-item">
		<button type="button" class="nav-link active" role="tab" data-bs-toggle="tab" data-bs-target="#intercom_detail" aria-controls="intercom_detail" aria-selected="true">
			<?= lang('Intercom.intercom_detail'); ?>
		</button>
	</li>
</ul>
<div class="tab-content">
	<div class="tab-pane fade show active" id="intercom_detail" role="tabpanel">
		<div class="table-responsive text-nowrap">
			<table id="intercom_detail_table" class="table table-xs">
				<thead>
					<tr>
						<th><?= lang("CommonMessage.common_detail"); ?></th>
						<th><?= lang("CommonMessage.common_value"); ?></th>
					</tr>
				</thead>
				<tbody>
					<tr>
						<td><?= lang("Intercom.intercom_type"); ?></td>
						<td><?php
							echo (isset($intercom_data['intercom_type']) && $intercom_data['intercom_type'] != "") ? underscoreToUcWord($intercom_data['intercom_type']) : '-';
							?>
						</td>
					</tr>
					
					<?php 
					if($intercom_data['intercom_type'] == 'flat'){ ?>
						<tr>
							<td><?= lang("Intercom.flat"); ?></td>
							<td><?php
								echo (isset($intercom_data['tower_flat_name']) && $intercom_data['tower_flat_name'] != "") ? $intercom_data['tower_flat_name'] : '-';
								?>
							</td>
						</tr>
					<?php }
					else{ ?>
						<tr>
							<td><?= lang("Intercom.common_area"); ?></td>
							<td><?php
								echo (isset($intercom_data['common_area_name']) && $intercom_data['common_area_name'] != "") ? $intercom_data['common_area_name'] : '-';
								?>
							</td>
						</tr>
						<tr>
							<td><?= lang("Intercom.particulares"); ?></td>
							<td><?php
								echo (isset($intercom_data['particulares']) && $intercom_data['particulares'] != "") ? $intercom_data['particulares'] : '-';
								?>
							</td>
						</tr>
					<?php }
					?>
					<tr>
						<td><?= lang("Intercom.number"); ?></td>
						<td><?php
							echo (isset($intercom_data['number']) && $intercom_data['number'] != "") ? $intercom_data['number'] : '-';
							?>
						</td>
					</tr>					
					<tr>
						<td class="text-bold"><?= lang("Intercom.created_at"); ?></td>
						<td><?php
							echo (isset($intercom_data['created_at']) && isValidDate($intercom_data['created_at'])) ? siteDateFormat($intercom_data['created_at'], TRUE) : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_created_by"); ?></td>
						<td><?php
							echo (isset($intercom_data['created_by']) && $intercom_data['created_by'] != "") ? $intercom_data['created_by'] : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_updated_at"); ?></td>
						<td><?php
							echo (isset($intercom_data['updated_at']) && isValidDate($intercom_data['updated_at'])) ? siteDateFormat($intercom_data['updated_at'], TRUE) : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_updated_by"); ?></td>
						<td><?php
							echo (isset($intercom_data['updated_by']) && $intercom_data['updated_by'] != "") ? $intercom_data['updated_by'] : '-';
							?></td>
					</tr>
				</tbody>
			</table>
		</div>
	</div>
</div>