<div class="row">
	<div class="col-md-12">
		<div class="card mb-4">
			<div class="card-header d-flex align-items-center justify-content-between">
				<h5 class="mb-0"><?= lang('Intercom.intercom_detail');?></h5>
			</div>
			<div class="card-body">
				<?php
				//create  form open tag
				$form_id = array(
					'id'=>'form_intercom',
				);
				echo form_open_multipart('',$form_id);
				$intercomId = (isset($intercom_data['intercom_id']) && ($intercom_data['intercom_id'] != '')) ? $intercom_data['intercom_id'] : '';
				?>
				<input type="hidden" id="intercom_id" name="intercom_id" value="<?= $intercomId ?>">

					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Intercom.intercom_type');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">
							<?php
								$intercomTypes = intercomType();
							?>
							<select data-placeholder="Select  <?= lang('Intercom.intercom_type'); ?>" name="intercom_type"
								id="intercom_type" class="select2 form-select dt-intercom-type">
								<option value=""> </option>
								<?php
								$selectedIntercomType = isset($intercom_data['intercom_type']) ? $intercom_data['intercom_type'] : "";
								foreach ($intercomTypes as $intercomKey => $intercomType) { ?>
									<option <?= ($selectedIntercomType == $intercomKey) ? "selected" : ""; ?>
										value="<?= $intercomKey; ?>"> <?= $intercomType; ?> </option>
								<?php } ?>
							</select>
						</div>
					</div>

					<div class="row mb-3 dt-intercom-flat">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Intercom.flat');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">
							<select id="flat_id" name="flat_id" class="select2 form-select form-select-lg flatDd dt-tower-flat" data-allow-clear="true">
								<option></option>
								<?php if(isset($intercom_data['flat_id']) && $intercom_data['flat_id'] != 0){ ?>
								<option value="<?= isset($intercom_data['flat_id']) ? $intercom_data['flat_id'] : 0 ?>" selected> <?= isset($intercom_data['tower_flat_name']) ? $intercom_data['tower_flat_name'] : ''  ?> </option>
								<?php } ?>
							</select>
						</div>
					</div>

					<div class="row mb-3 dt-intercom-common_area">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Intercom.common_area');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">
							<select id="common_area_id" name="common_area_id" class="select2 form-select form-select-lg commonAreaDd" data-allow-clear="true">
								<option></option>
								<?php if(isset($intercom_data['common_area_id']) && $intercom_data['common_area_id'] != 0){ ?>
								<option value="<?= isset($intercom_data['common_area_id']) ? $intercom_data['common_area_id'] : 0 ?>" selected> <?= isset($intercom_data['common_area_name']) ? $intercom_data['common_area_name'] : ''  ?> </option>
								<?php } ?>
							</select>
						</div>
					</div>

					<div class="row mb-3 dt-intercom-common_area">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Intercom.particulares');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">	
							<input type="text" class="form-control" name="particulares" id="particulares" placeholder="Enter <?= lang('Intercom.particulares');?>" value="<?= (isset($intercom_data['particulares']) && ($intercom_data['particulares'] != '')) ? $intercom_data['particulares'] : '';  ?>" />
						</div>
					</div>

					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Intercom.number');?><span class="text-danger"> *</span></label>
						<div class="col-sm-10">	
							<input type="text" class="form-control numberInit" name="number" id="number" placeholder="Enter <?= lang('Intercom.number');?>" value="<?= (isset($intercom_data['number']) && ($intercom_data['number'] != '')) ? $intercom_data['number'] : '';  ?>" />
						</div>
					</div>

					<div class="row mb-3">
						<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Intercom.active');?></label>
							<div class="col-sm-10">
							<label class="switch switch-sm"><span class="switch-label"></span>
								<input type="checkbox" class="switch-input form-add-switchery"  name="is_active" id="is_active" <?php echo (!isset($intercom_data['is_active']) || $intercom_data['is_active'] == 1) ? 'checked="checked"' : ''; ?>/>
								<span class="switch-toggle-slider">
		                              <span class="switch-on"></span>
		                              <span class="switch-off"></span>
		                            </span>
								
							</label>
						</div>
					</div>

					<div class="pt-4">
						<button type="submit" id="submitBtn" class="btn btn-primary me-sm-3 me-1 submit">Submit</button>
						<button type="button" id="cancelBtn" onclick="window.location.href='<?php echo admin_url('Intercom'); ?>'" class="btn btn-label-secondary">Cancel</button>
					</div>
				<?php echo form_close(); ?>
			</div>
		</div>
	</div>
</div>

<script>
    $(document).ready(function() {
    	flatDd();
    	commonAreaDd();
		numberInit();
    	$(".dt-intercom-type").select2();
		switcheryKeyGen("datatable-list-switchery");
        // Initialize
		var validator = $("#form_intercom").validate({
			ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
			errorClass: 'validation-invalid-label',
			successClass: 'validation-valid-label',
			validClass: 'validation-valid-label',
			highlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			unhighlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			success: function(label) {
				label.addClass('validation-valid-label').text('Success.'); // remove to hide Success message
			},
			// Different components require proper error label placement
			errorPlacement: function(error, element) {

				// Unstyled checkboxes, radios
				if (element.parents().hasClass('form-check')) {
					error.appendTo( element.parents('.form-check').parent() );
				}

				// Input with icons and Select2
				else if (element.parents().hasClass('form-group row-feedback') || element.hasClass('select2-hidden-accessible')) {
					error.appendTo( element.parent() );
				}

				// Input group, styled file input
				else if (element.parent().is('.uniform-uploader, .uniform-select') || element.parents().hasClass('input-group')) {
					error.appendTo( element.parent().parent() );
				}

				// Other elements
				else {
					error.insertAfter(element);
				}
			},
            rules: {
				intercom_type : {
					required : true,
				},
				number : {
					required : true,
				},
				particulares: {
                    required: "#particulares:visible",
                },
                flat_id: {
                    required: "#flat_id:visible",
                },
                common_area_id: {
                    required: "#common_area_id:visible",
                },
				
            },
            messages: {
				intercom_type: {
					required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('Intercom.intercom_type');?>"
				},
				number: {
					required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('Intercom.number');?>"
				},
				particulares: {
					required: "<?= lang('CommonMessage.common_please_enter'); ?> <?= lang('Intercom.particulares');?>"
				},
				flat_id: {
					required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('Intercom.flat');?>"
				},
				common_area_id: {
					required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('Intercom.common_area');?>"
				},
            },
            submitHandler: function (e) {
				$(e).ajaxSubmit({
					url: '<?php echo admin_url("Intercom/save");?>',
					type: 'post',
					beforeSubmit: function (formData, jqForm, options) {
						dtButtonHide('#submitBtn');
						dtButtonHide('#cancelBtn');
					},
					complete: function () {

					},
					dataType: 'json',
					clearForm: false,
					success: function (resObj, statusText) {
						if (resObj.success) {
							toastr.success(resObj.msg, 'Success', {
								closeButton: true,
								progressBar: true,
								positionClass: 'toast-top-right',
								timeOut: 1000,
                                onHidden: function () {
                                    dtButtonShow('#submitBtn');
									dtButtonShow('#cancelBtn');
                                    window.location.href = '<?php echo admin_url('Intercom');?>';
                                }
							});

							// setTimeout(function () {
							// 	window.location.href = '<?php echo admin_url('Intercom');?>';
							// }, 1000);

						} else {
							dtButtonShow('#submitBtn');
							dtButtonShow('#cancelBtn');
							toastr.error(resObj.msg, 'Error', {
								closeButton: true,
								// progressBar: true,
								positionClass: 'toast-top-right',
								// timeOut: 1000
							});
						}
					}
				});
            }
        });
    });

    $(document).ready(function(){
        $("div.dt-intercom-common_area").hide();
        $("div.dt-intercom-flat").hide();
        $('#intercom_type').on('change', function(){
            var intercomValue = $(this).val();
            console.log(intercomValue);
            if(intercomValue == "flat"){
            	<?php 
            		if(empty($intercomId)){ ?>
            			$("#flat_id").val('').trigger('change.select2');
            		<?php }
            	?>
                $("div.dt-intercom-flat").show();
        		$("div.dt-intercom-common_area").hide();
        		
            }
            else if(intercomValue == "common_area"){ 
            	<?php 
            		if(empty($intercomId)){ ?>
            			$("#common_area_id").val('').trigger('change.select2');
            		<?php }
            	?>
            	$("div.dt-intercom-common_area").show();
                $("div.dt-intercom-flat").hide();
                
            }
              
        });
        $('#intercom_type').change();              
});
</script>
        
<?= isset($select2_ajax) ? $select2_ajax : ""; ?>
