<div class="row">
	<div class="col-md-12">
		<div class="card mb-4">
			<div class="card-header d-flex align-items-center justify-content-between">
				<h5 class="mb-0"><?= lang('GeneratorReading.generator_reading_detail'); ?></h5>
			</div>
			<div class="card-body">
				<?php
				//create  form open tag
				$form_id = array(
					'id' => 'form_generator_reading',
				);
				echo form_open_multipart('', $form_id);
				$menPowerAttendanceId = (isset($generator_reading_data['generator_reading_id']) && ($generator_reading_data['generator_reading_id'] != '')) ? $generator_reading_data['generator_reading_id'] : '';
				?>
				<input type="hidden" id="generator_reading_id" name="generator_reading_id" value="<?= $menPowerAttendanceId ?>">

				<div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('GeneratorReading.generator'); ?><span class="text-danger"> *</span></label>
					<div class="col-sm-10">
						<select id="generator_id" name="generator_id" class="select2 form-select form-select-lg generatorDd" data-allow-clear="true">
							<option></option>
							<?php if (isset($generator_reading_data['generator_id']) && $generator_reading_data['generator_id'] != 0) { ?>
								<option value="<?= isset($generator_reading_data['generator_id']) ? $generator_reading_data['generator_id'] : 0 ?>" selected> <?= isset($generator_reading_data['generator_name']) ? $generator_reading_data['generator_name'] : ''  ?> </option>
							<?php } ?>
						</select>
					</div>
				</div>

				<div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('GeneratorReading.generator_start_date'); ?><span class="text-danger"> *</span></label>
					<div class="col-sm-10">
						<input type="text" class="form-control" name="generator_start_date" id="generator_start_date" placeholder="Enter <?= lang('GeneratorReading.generator_start_date'); ?>" value="<?= (isset($generator_reading_data['generator_start_date']) && isValidDate($generator_reading_data['generator_start_date'])) ? siteDateFormat($generator_reading_data['generator_start_date']) : ''; ?>" />
					</div>
				</div>
				<div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('GeneratorReading.generator_start_time'); ?><span class="text-danger"> </span></label>
					<div class="col-sm-10">
						<input type="time" class="form-control" name="generator_start_time" id="generator_start_time" placeholder="Enter <?= lang('GeneratorReading.generator_start_time'); ?>" value="<?= (isset($generator_reading_data['generator_start_time']) && ($generator_reading_data['generator_start_time'] != '')) ? ($generator_reading_data['generator_start_time']) : '';  ?>" />
					</div>
				</div>
				<div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('GeneratorReading.generator_end_time'); ?><span class="text-danger"> </span></label>
					<div class="col-sm-10">
						<input type="time" class="form-control" name="generator_end_time" id="generator_end_time" placeholder="Enter <?= lang('GeneratorReading.generator_end_time'); ?>" value="<?= (isset($generator_reading_data['generator_end_time']) && ($generator_reading_data['generator_end_time'] != '')) ? ($generator_reading_data['generator_end_time']) : '';  ?>" />
					</div>
				</div>

                <div class="row mb-3">
                    <label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('GeneratorReading.generator_usage_hours'); ?><span class="text-danger"> </span></label>
                    <div class="col-sm-10">
                        <input type="text" class="form-control" name="generator_usage_hours" id="generator_usage_hours" placeholder="Enter <?= lang('GeneratorReading.generator_usage_hours'); ?>" value="<?= (isset($generator_reading_data['generator_usage_hours']) && ($generator_reading_data['generator_usage_hours'] != '')) ? ($generator_reading_data['generator_usage_hours']) : '';  ?>" readonly />
                    </div>
                </div>

                <div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('GeneratorReading.reading_type');?><span class="text-danger"> </span></label>
					<div class="col-sm-10">
						<?php
							$readingTypes = readingType();
						?>
						<select data-placeholder="Select  <?= lang('GeneratorReading.reading_type'); ?>" name="reading_type"
							id="reading_type" class="select2 form-select dt-reading-type">
							<option value=""> </option>
							<?php
							$selectedReadingType = isset($generator_reading_data['reading_type']) ? $generator_reading_data['reading_type'] : "";
							foreach ($readingTypes as $readingKey => $reading) { ?>
								<option <?= ($selectedReadingType == $readingKey) ? "selected" : ""; ?>
									value="<?= $readingKey; ?>"> <?= $reading; ?> </option>
							<?php } ?>
						</select>
					</div>
				</div>

                <div class="row mb-3 myDiv" id="show_filled">
					<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('GeneratorReading.filled_liter'); ?><span class="text-danger"> </span></label>
					<div class="col-sm-10">
						<input type="text" class="form-control" name="filled_liter" id="filled_liter" placeholder="Enter <?= lang('GeneratorReading.filled_liter'); ?>" value="<?= (isset($generator_reading_data['filled_liter']) && ($generator_reading_data['filled_liter'] != '')) ? ($generator_reading_data['filled_liter']) : '';  ?>" />
					</div>
				</div>

                <div class="row mb-3 myDiv" id="show_available">
					<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('GeneratorReading.available_liter'); ?><span class="text-danger"> </span></label>
					<div class="col-sm-10">
						<input type="text" class="form-control" name="available_liter" id="available_liter" placeholder="Enter <?= lang('GeneratorReading.available_liter'); ?>" value="<?= (isset($generator_reading_data['available_liter']) && ($generator_reading_data['available_liter'] != '')) ? ($generator_reading_data['available_liter']) : '';  ?>" />
					</div>
				</div>

				<div class="pt-4">
					<button type="submit" id="submitBtn" class="btn btn-primary me-sm-3 me-1 submit">Submit</button>
					<button type="button" id="cancelBtn" onclick="window.location.href='<?php echo admin_url('GeneratorReading'); ?>'" class="btn btn-label-secondary">Cancel</button>
				</div>
				<?php echo form_close(); ?>
			</div>
		</div>
	</div>
</div>

<script>
	function startTime() {
		$('#generator_start_time').flatpickr({
			enableTime: true,
			noCalendar: true,
            dateFormat: "h:i K"
		});
	}

	function endTime() {
		$('#generator_end_time').flatpickr({
			enableTime: true,
			noCalendar: true,
            dateFormat: "h:i K"
		});
	}
	$(document).ready(function() {
		numberInit();
		generatorDd();
		switcheryKeyGen("datatable-list-switchery");
		$(".dt-reading-type").select2();
		// Initialize
		var validator = $("#form_generator_reading").validate({
			ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
			errorClass: 'validation-invalid-label',
			successClass: 'validation-valid-label',
			validClass: 'validation-valid-label',
			highlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			unhighlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			success: function(label) {
				label.addClass('validation-valid-label').text('Success.'); // remove to hide Success message
			},
			// Different components require proper error label placement
			errorPlacement: function(error, element) {

				// Unstyled checkboxes, radios
				if (element.parents().hasClass('form-check')) {
					error.appendTo(element.parents('.form-check').parent());
				}

				// Input with icons and Select2
				else if (element.parents().hasClass('form-group row-feedback') || element.hasClass('select2-hidden-accessible')) {
					error.appendTo(element.parent());
				}

				// Input group, styled file input
				else if (element.parent().is('.uniform-uploader, .uniform-select') || element.parents().hasClass('input-group')) {
					error.appendTo(element.parent().parent());
				}

				// Other elements
				else {
					error.insertAfter(element);
				}
			},
			rules: {
				generator_id: {
					required: true,
				},
				generator_start_date: {
					required: true,
				}
			},
			messages: {
				generator_id: {
					required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('GeneratorReading.generator'); ?>"
				},
				generator_start_date: {
					required: "<?= lang('CommonMessage.common_please_select'); ?> <?= lang('GeneratorReading.generator_start_date'); ?>"
				},
			},
			submitHandler: function(e) {
				$(e).ajaxSubmit({
					url: '<?php echo admin_url("GeneratorReading/save"); ?>',
					type: 'post',
					beforeSubmit: function(formData, jqForm, options) {
						dtButtonHide('#submitBtn');
						dtButtonHide('#cancelBtn');
					},
					complete: function() {

					},
					dataType: 'json',
					clearForm: false,
					success: function (resObj, statusText) {
						if (resObj.success) {
							toastr.success(resObj.msg, 'Success', {
								closeButton: true,
								progressBar: true,
								positionClass: 'toast-top-right',
								timeOut: 1000,
								onHidden: function () {
                                    dtButtonShow('#submitBtn');
									dtButtonShow('#cancelBtn');
                                    window.location.href = '<?php echo admin_url('GeneratorReading');?>';
                                }
							});
							// setTimeout(function () {
							// 	window.location.href = '<?php echo admin_url('GeneratorReading');?>';
							// }, 1000);

						} else {
							dtButtonShow('#submitBtn');
							dtButtonShow('#cancelBtn');
							toastr.error(resObj.msg, 'Error', {
								closeButton: true,
								// progressBar: true,
								positionClass: 'toast-top-right',
								// timeOut: 1000
							});
						}
					}
				});
			}
		});

		startTime();
		endTime();

		$("#generator_start_date").flatpickr({
			monthSelectorType: 'static',
			// enableTime: true,
			dateFormat: "d-m-Y",
			maxDate : "<?= TODAY_DATE ?>",
		});
	});

	$(document).on('change', '#generator_start_date, #generator_start_time, #generator_end_time', calculateUsageHours);

    function calculateUsageHours() {
	    var startDate = $('#generator_start_date').val();
	    var startTime = $('#generator_start_time').val();
	    var endTime = $('#generator_end_time').val();
	    if (startDate !== '' && startTime !== '' && endTime !== '') {
	        var [day, month, year] = startDate.split("-");
	        var formattedDate = `${year}-${month}-${day}`;
	        var start = new Date(`${formattedDate} ${startTime}`);
	        var end = new Date(`${formattedDate} ${endTime}`);
	        var diffMs = end - start;
			var diffHrs = diffMs / (1000 * 60 * 60);
	        if (diffHrs < 0) {
	            diffHrs += 24;
	        }
			$('#generator_usage_hours').val(diffHrs.toFixed(2));
	    }
	}


	$(document).ready(function(){
        $("div.myDiv").hide();
        $('.dt-reading-type').on('change', function(){
        	$("div.myDiv").hide();
            var readingTypeValue = $(this).val();
            if(readingTypeValue == 'usage'){
                $("#show_filled").show();
                $("#show_available").hide();
            }
            else if(readingTypeValue == 'refilled'){
                $("#show_filled").show();
                $("#show_available").show();
            } 
        });
        $('.dt-reading-type').change();              
	});

</script>

<?= isset($select2_ajax) ? $select2_ajax : ""; ?>