<?php
$dtCIAcl = new \App\Libraries\Dt_ci_acl();
?>
<?= isset($advance_filter) ? $advance_filter : ""; ?>
<a style="display: none;" href="" class="dt-export-anchor" target="_blank"></a>
<div class="card">
    <div class="card-datatable text-nowrap table-responsive">
        <table id="forum_table" class="table dt-datatable dt-scrollableTable">
            <thead class="border-top">
            <tr>
                <th><input class="form-check-input datatable-select-all-second" type="checkbox"  /></th>
                <th class="font-weight-bold"><?= lang("Forum.title"); ?></th>
                <th class="font-weight-bold"><?= lang("Forum.description"); ?></th>
                <th class="font-weight-bold"><?= lang("Forum.type"); ?></th>
                <th class="font-weight-bold"><?= lang("Forum.type_id"); ?></th>
                <th class="font-weight-bold"><?= lang("Forum.forum_date"); ?></th>
                <th class="font-weight-bold"><?= lang("Forum.total_comment"); ?></th>
                <th class="font-weight-bold"><?= lang('CommonMessage.common_updated_at'); ?></th>
				<th class="font-weight-bold"><?= lang('CommonMessage.common_updated_by'); ?></th>
                <th class="font-weight-bold"><?= lang("CommonMessage.common_active"); ?></th>
				<th class="font-weight-bold"><?= lang("CommonMessage.common_action"); ?></th>
            </tr>
            </thead>
        </table>
    </div>
    <!--	</div>-->
</div>
<script type="text/javascript">
    var dt_DataTable;

    $(document).ready(function () {
        dt_DataTable = $('#forum_table').DataTable( {
            dom:'<"card-header d-flex border-top rounded-0 flex-wrap py-0"' +
                '<"me-5 ms-n2 pe-5"f>' +
                '<"d-flex justify-content-start justify-content-md-end align-items-baseline"<"dt-action-buttons d-flex flex-column align-items-start align-items-md-center justify-content-sm-center mb-3 mb-md-0 pt-0 gap-4 gap-sm-0 flex-sm-row"lB>>' +
                '>t' +
                '<"row mx-2"' +
                '<"col-sm-12 col-md-6"i>' +
                '<"col-sm-12 col-md-6"p>' +
                '>',
            processing: true,
            serverSide: true,
            displayLength: 10,
            scrollX: true,
            // language: {
            // 	sLengthMenu: 'Show _MENU_',
            // 	search: '',
            // 	searchPlaceholder: 'Search Forum'
            // },
            language: {
                sLengthMenu: 'Show _MENU_',
                search: '',
                searchPlaceholder: 'Search Forum',
                info: 'Displaying _START_ to _END_ of _TOTAL_ entries'
            },
            buttons: [
				{
					extend: 'collection',
					className: 'btn btn-label-secondary px-2 dropdown-toggle me-2 waves-effect waves-light',
					text: '<i class="ti ti-download me-1 ti-xs"></i>Export',
					buttons: [
                        {
							text: '<i class="ti ti-file me-2" ></i>Excel',
							className: 'dropdown-item dt-excel-export'
						},
					]
				},
				<?php if ($dtCIAcl->checkAccess("Forum|manage")) { ?>
				{
					text: '<i class="ti ti-plus me-0 me-sm-1 ti-xs"></i><span class="d-none d-sm-inline-block"><?= lang('Forum.add_forum');?></span>',
					className: 'add-new btn btn-primary px-1 me-2',
					action: function () {
						window.location.href = '<?= admin_url("Forum/manage");?>';
					}
				},
				<?php } ?>
				<?php if ($dtCIAcl->checkAccess("Forum|delete")) { ?>
				{
					text: '<i class="ti ti-trash me-0 me-sm-1 ti-xs"></i><span class="d-none d-sm-inline-block"><?= lang('Forum.delete_forum');?></span>',
					className: 'btn btn-danger  px-1 dt-delete-record',
				},
				<?php } ?>
			],
            "ajax": {
                "url": "<?php echo admin_url('Forum/getForumListing'); ?>",
                "type": "POST",
                "data": function(d) {
                    var params = {};
                    params["<?= csrf_token(); ?>"] = "<?= csrf_hash() ?>";
                    var filterData = $("#advanceFilter").serializeArray();
                    $.each(filterData, function(i, val) {
                        var name = val.name;
                        if (typeof params[name] == 'undefined') {
                            params[name] = val.value;
                        } else if ($.isArray(params[name])) {
                            params[name].push(val.value);
                        } else {
                            params[name] = [params[name]];
                            params[name].push(val.value);
                        }
                    });

                    return $.extend({}, d, params);
                }
            },
            "order": [[ 0, "desc" ]],
            "columns": [
                {
					"data": "forum_id",
					"render": function (data, type, row) {
						return '<input class="form-check-input datatable-checkbox" type="checkbox" id="ids_' + row['forum_id'] + '" name="ids[]" value="' + row['forum_id'] + '"/>';
					},
					"class": "no_click_allowed",
					"sortable": false,
					"searchable": false
				},
                {"data": "title"},
                {"data": "description" },
                {"data": "type" },
                {"data": "member_name",},
                {"data": "forum_date"},
                {"data": "total_comment","class": "no_click_allowed",},
                {"data": "updated_at"},
                {"data": "updated_by"},
                {
					"data": "is_active",
					"class": "no_click_allowed",
					"sortable": false,
					"searchable": false,
					"render": function (data, type, row) {
						var checked = (data == 1) ? "checked" : "";
						return '<label class="switch switch-primary switch-sm">' +
							'<input type="checkbox" class="switch-input  dt-active-status" ' + checked + '  data-id="' + row['forum_id'] + '" value="1" />' +
							'<span class="switch-toggle-slider">' +
							'<span class="switch-on"></span>' +
							'<span class="switch-off"></span>' +
							'</span>';
						'</label>';
					}
				},
				{
					"data": "action_button",
					"class" : "text-center no_click_allowed",
					"sortable": false,
					"searchable": false
				},
            ],
            "columnDefs": [
                {
                    "targets": 0,
                    "width": "10%",
                    "render": function (data, type, row) {
                        return '<label><input type="checkbox" class="dt-checkbox styled" id="ids_' + row['forum_id'] + '" name="ids[]" value="' + row['forum_id'] + '"/><span class="lbl"></span></label>';
                    },
                    "sortable": false,
                    "searchable": false
                },
                {
                    "targets": 2, // Description column
                    "render": function (data, type, row) {
                        if (typeof data === "string" && data.length > 10) {
                            return `<span data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title="${data}">${data.substr(0, 10)}...</span>`;
                        }
                        return data;
                    }
                },
                {
                    "targets": 6,
                    "render": function (data, type, row) {
                        return '<a target="_blank" data-bs-toggle = "tooltip" data-bs-placement = "top" data-bs-custom-class="custom-tooltip" title="<?= lang('Forum.view_comment') ?>" href="<?= admin_url('Comment?forum_id='); ?>'+row['forum_id']+'">'+data+'</a>';
                    },
                    // "sortable": false,
//                    "searchable": false
                },
            ],
            createdRow: function (row, data, dataIndex) {
				$(row).find("td:not(.no_click_allowed,.own_detail_model_view)").addClass('dt-detail-model-view');
				$(row).find("td:not(.no_click_allowed,.own_detail_model_view)").attr('data-dt_view_id', data['forum_id']);
				$(row).find("td:not(.no_click_allowed,.own_detail_model_view)").attr('data-dt_view_url', '<?= admin_url("Forum/view"); ?>');
			},
            "fnDrawCallback": function (oSettings, json) {
                $('.dataTables_length').addClass('mt-2 mt-sm-0 mt-md-3 me-2');
                $('.dt-buttons').addClass('d-flex flex-wrap');
                $('.dataTables_filter .form-control').removeClass('form-control-sm');
                $('.dataTables_length .form-select').removeClass('form-select-sm');
                customToolTip();
            }
        });
        dtDataTableSearch();

    });

    // $(document).on('click', '.filter_data', function() {
	// 	dt_DataTable.draw();
	// });

    // $(document).on('click', '.clear_filter', function() {
	// 	$('form#advanceFilter  #filter_common_area_id').val('').trigger('change');
	// 	$('form#advanceFilter  #filter_financial_year_id').val('').trigger('change');
	// 	$('form#advanceFilter  #filter_transaction_type').val('').trigger('change');
    //     $('form#advanceFilter  #filter_item_id').val('').trigger('change');
	// 	dt_DataTable.draw();
	// });
    $(document).on('click', '.dt-active-status', function () {
		var id = $(this).attr('data-id');
		var isActive = $(this).is(":checked") ? 1 : 0;
		$.ajax({
			type: 'post',
			url: '<?php echo admin_url('Forum/changeStatus'); ?>',
			data: {forum_id:id, status: isActive},
			dataType: 'json',
			success: function (data) {
				if (data) {
					Swal.fire({
						title: 'Success',
						text: data.msg,
						icon: 'success',
						customClass: {
							confirmButton: 'btn btn-primary waves-effect waves-light'
						},
						buttonsStyling: false
					}).then(function() {
						dt_DataTable.ajax.reload(null,false);
					});
				} else {
					Swal.fire({
						title: 'Error!',
						text: data.msg,
						icon: 'error',
						customClass: {
							confirmButton: 'btn btn-primary waves-effect waves-light'
						},
						buttonsStyling: false
					});
				}
			}
		});
	});

	$(document).on('click', '.dt-delete-record', function () {
        var id = $(this).attr("data-id");
        var deleteId = [];
        if(id != undefined){
            $('.datatable-select-all-second').prop('checked', false);
            $('.datatable-checkbox').prop('checked', false);
            $("#ids_" + id).prop("checked", true);
            deleteId.push(id);
        }
        else{
            var deleteElement =$('#forum_table tbody .datatable-checkbox:checked');
            var selectedLength = deleteElement.length;
            if (selectedLength == 0) {
                Swal.fire({
                    title: "<?= ucwords(lang('CommonMessage.common_sweet_alert_info')); ?>",
                    text: "<?= lang('CommonMessage.delete_info'); ?>",
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonText: 'OK',
                    customClass: {
                        confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
                        cancelButton: 'btn btn-label-secondary waves-effect waves-light'
                    },
                    buttonsStyling: false
                }).then(function () {
                    return false;
                });
            } else {
                $.each(deleteElement, function (i, ele) {
                    deleteId.push($(ele).val());
                });
            }
        }
        if (deleteId.length > 0) {
            Swal.fire({
                title: "<?= ucwords(lang('CommonMessage.common_sweet_alert_delete')); ?>",
                text: "<?= lang('CommonMessage.delete_warning'); ?>",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonText: 'OK',
                customClass: {
                    confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
                    cancelButton: 'btn btn-label-secondary waves-effect waves-light'
                },
                buttonsStyling: false
            }).then(function(result) {
                if (result.value) {
                    $.ajax({
                        type: "post",
                        url: "<?= admin_url("Forum/delete")?>",
                        dataType: "json",
                        data: {forum_id: deleteId},
                        success: function (data) {
                            if (data['success']) {
                                Swal.fire({
                                    title: 'Success',
                                    text: data['msg'],
                                    icon: 'success',
                                    customClass: {
                                        confirmButton: 'btn btn-primary waves-effect waves-light'
                                    },
                                    buttonsStyling: false
                                }).then(function() {
                                    dt_DataTable.ajax.reload();
                                });
                            } else {
                                Swal.fire({
                                    title: 'Error!',
                                    text: data['msg'],
                                    icon: 'error',
                                    customClass: {
                                        confirmButton: 'btn btn-primary waves-effect waves-light'
                                    },
                                    buttonsStyling: false
                                }).then(function() {
                                    dt_DataTable.ajax.reload();
                                });
                            }
                        }
                    });
                }
                else {
                    $('.datatable-checkbox').prop('checked', false);
                }
            });
        }
    });

    $(document).on('click', '.dt-excel-export', function() {
        $(this).removeClass(".dt-excel-export");
        var dataTableParams = dt_DataTable.ajax.params();
        url = '<?= admin_url('Forum/excelExportForum/') . ""  ?>';
        var recursiveEncoded = $.param(dataTableParams);
        $('.dt-export-anchor').attr('href', url + "?" + recursiveEncoded);
        $('.dt-export-anchor')[0].click();
    });
</script>
<?= isset($select2_ajax) ? $select2_ajax : ""; ?>
