<ul class="nav nav-tabs" role="tablist">
	<li class="nav-item">
		<button type="button" class="nav-link active" role="tab" data-bs-toggle="tab" data-bs-target="#forum_detail" aria-controls="forum_detail" aria-selected="true">
			<?= lang('Forum.forum_detail'); ?>
		</button>
	</li>
</ul>

<div class="tab-content">
	<div class="tab-pane fade show active" id="forum_detail" role="tabpanel">
		<div class="table-responsive text-nowrap">
			<table id="forum_detail_table" class="table table-xs">
				<thead>
					<tr>
						<th><?= lang("CommonMessage.common_detail"); ?></th>
						<th><?= lang("CommonMessage.common_value"); ?></th>
					</tr>
				</thead>
				<tbody>
					<tr>
						<td><?= lang("Forum.title"); ?></td>
						<td><?php
							echo (isset($forum_data['title']) && $forum_data['title'] != "") ? $forum_data['title'] : '-';
							?>
						</td>
					</tr>					
					<tr>
						<td><?= lang("Forum.description"); ?></td>
						<td><?php
							echo (isset($forum_data['description']) && $forum_data['description'] != "") ? $forum_data['description'] : '-';
							?>
						</td>
					</tr>					
					<tr>
						<td><?= lang("Forum.member_name"); ?></td>
						<td><?php
							echo (isset($forum_data['member_name']) && $forum_data['member_name'] != "") ? $forum_data['member_name'] : '-';
							?>
						</td>
					</tr>					
					<tr>
						<td><?= lang("Forum.forum_date"); ?></td>
						<td><?php
							echo (isValidDate($forum_data['forum_date']) && $forum_data['forum_date'] != "") ? siteDateFormat($forum_data['forum_date']) : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang("Forum.forum_image"); ?></td>
						<td>
							<?php 
		                    if(isset($image_data) && is_array($image_data) && !empty($image_data)){
		                        foreach($image_data as $image) { 
		                        	if(file_exists(DOCUMENT_IMAGE_PATH . $image['document_image'])){
				                        $paths = site_url() . DOCUMENT_IMAGE_PATH . $image['document_image']; ?> 
				                 		<span class="document-image-<?= $image['document_image_id']; ?>">
				                 			<a href="<?= $paths; ?>" target="_blank"> <img src="<?= $paths; ?>" width="100" class="img-fluid" alt=""> </a>
				        				</span>
		            		<?php }} } ?>
						</td>
					</tr>										
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_created_at"); ?></td>
						<td><?php
							echo (isset($forum_data['created_at']) && isValidDate($forum_data['created_at'])) ? siteDateFormat($forum_data['created_at'], TRUE) : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_created_by"); ?></td>
						<td><?php
							echo (isset($forum_data['created_by']) && $forum_data['created_by'] != "") ? $forum_data['created_by'] : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_updated_at"); ?></td>
						<td><?php
							echo (isset($forum_data['updated_at']) && isValidDate($forum_data['updated_at'])) ? siteDateFormat($forum_data['updated_at'], TRUE) : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_updated_by"); ?></td>
						<td><?php
							echo (isset($forum_data['updated_by']) && $forum_data['updated_by'] != "") ? $forum_data['updated_by'] : '-';
							?></td>
					</tr>
				</tbody>
			</table>
		</div>
	</div>
</div>