<?php
$dtCIAcl = new \App\Libraries\Dt_ci_acl();
$forumView = isset($forum_data['view']) ? $forum_data['view'] : 0;
?>
<div class="row">
	<div class="col-md-12">
		<div class="card mb-4">
			<div class="card-header d-flex align-items-center justify-content-between">
				<h5 class="mb-0"><?= lang('Forum.forum_form');?></h5>
			</div>
			<div class="card-body">
				<?php
				//create  form open tag
				$form_id = array(
					'id'=>'form_forum',
				);
				echo form_open_multipart('',$form_id);
				$forumId = (isset($forum_data['forum_id']) && ($forum_data['forum_id'] != '')) ? $forum_data['forum_id'] : '';
				$forumDate = (isset($forum_data['forum_date']) && ($forum_data['forum_date'] != '')) ? YMDToDMY($forum_data['forum_date']) : '';
				?>
				<input type="hidden" id="forum_id" name="forum_id" value="<?= $forumId ?>">
				<div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Forum.title');?><span class="text-danger"> *</span></label>
					<div class="col-sm-10">
						<input type="text" class="form-control" name="title" id="title" placeholder="Enter <?= lang('Forum.title');?>" value="<?= (isset($forum_data['title']) && ($forum_data['title'] != '')) ? $forum_data['title'] : '';  ?>" />
					</div>
				</div>
				<div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Forum.forum_date');?><span class="text-danger"> *</span></label>
					<div class="col-sm-10">
						<td>
							<input type="text"  name="forum_date" id="forum_date" class="form-control dt-start-date" placeholder="Select <?= lang('Forum.forum_date'); ?>" value="<?= isset($forum_data['forum_date']) ? YMDToDMY($forum_data['forum_date']): ""; ?>"/>
						</td>
					</div>
				</div>
				<div class="row mb-3">
                    <label class="col-sm-2 col-form-label"
                           for="basic-default-name"><?= lang('Forum.description'); ?><span
                                class="text-danger"> *</span></label>
                    <div class="col-sm-10">
                        <textarea name="description"  id="description" placeholder="Enter <?= lang('Forum.description'); ?>" rows="3" cols="5"  class="form-control"><?= (isset($forum_data['description']) && ($forum_data['description'] != '')) ? $forum_data['description'] : ''; ?></textarea>
                    </div>
                </div>
				<div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('Forum.forum_image');?><span class="text-danger"> </span></label>
					<div class="col-sm-10">
						<input type="file" accept="image/*" class="form-control" name="forum_image[]" multiple="multiple">
						<span class="form-text text-muted"><?= FILE_UPLOAD_TYPE_MSG; ?></span><br>
						<?php 
	                    if(isset($image_data) && is_array($image_data) && !empty($image_data)){
	                        foreach($image_data as $image) { 
	                        	if(file_exists(DOCUMENT_IMAGE_PATH . $image['document_image'])){
	                        		$thumbnailPaths = site_url() . THUMBNAIL_DOCUMENT_IMAGE_PATH . $image['document_image'];
			                        $paths = site_url() . DOCUMENT_IMAGE_PATH . $image['document_image']; ?> &nbsp;&nbsp;&nbsp;
			                 		<span class="document-image-<?= $image['document_image_id']; ?>">
			                 			<a href="<?= $paths; ?>" target="_blank"> 
											<img src="<?= $thumbnailPaths; ?>" width="100" class="img-fluid" alt=""> 
											<?php if ($forumView != 1) {?>
												<?php if(!empty($forumId) && $dtCIAcl->checkAccess('Forum|deleteImage')) {?>
													<a href="javascript:void(0);"  id="<?php echo $image['document_image_id']; ?>" class="btn btn-icon btn-outline-dribbble delete-image"> <i class="tf-icons ti ti-trash"></i> </a> 
												<?php }?>
											<?php }?>
										</a>
			        				</span>
	            		<?php }} } ?>
					</div>
				</div>

				<div class="row mb-3">
					<label class="col-sm-2 col-form-label" for="basic-default-name"><?= lang('CommonMessage.common_active');?></label>
					<div class="col-sm-10">
						<label class="switch switch-sm"><span class="switch-label"></span>
							<input type="checkbox" class="switch-input form-add-switchery"  name="is_active" id="is_active" <?php echo (!isset($forum_data['is_active']) || $forum_data['is_active'] == 1) ? 'checked="checked"' : ''; ?>/>
							<span class="switch-toggle-slider">
		                              <span class="switch-on"></span>
		                              <span class="switch-off"></span>
		                            </span>
						</label>
					</div>
				</div>

				<?php if ($forumView != 1) { ?>

                <div class="pt-4">
                    <button type="submit" id="submitBtn"
                            class="btn btn-primary me-sm-3 me-1 submit"><?= lang('CommonMessage.common_submit'); ?></button>
                    <button type="button" id="cancelBtn" onclick="window.location.href='<?php echo admin_url('Forum'); ?>'"
                            class="btn btn-label-secondary"><?= lang('CommonMessage.common_cancel'); ?></button>
                </div>
                <?php } ?>
                <?php echo form_close(); ?>
			</div>
		</div>
	</div>
</div>

<script>
     var editable = <?= $forumView ?>;
        if (editable == 1) {
            $("#form_forum :input").prop("disabled", true);
        }
        <?php 
        if(!empty($forumId)){
        	$minDate = $forumDate;
        }
        else{
        	$minDate = DATERANGEPICKER_MIN_DATE;
        }
        ?>
        $(".dt-start-date").flatpickr({
			//monthSelectorType: 'static',
			dateFormat: 'd-m-Y',
			minDate: '<?= $minDate;?>',
		});

	$(document).ready(function() {
		numberInit();
		switcheryKeyGen("datatable-list-switchery");
		// Initialize
		var validator = $("#form_forum").validate({
			ignore: 'input[type=hidden], .select2-search__field', // ignore hidden fields
			errorClass: 'validation-invalid-label',
			successClass: 'validation-valid-label',
			validClass: 'validation-valid-label',
			highlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			unhighlight: function(element, errorClass) {
				$(element).removeClass(errorClass);
			},
			success: function(label) {
				label.addClass('validation-valid-label').text('Success.'); // remove to hide Success message
			},
			// Different components require proper error label placement
			errorPlacement: function(error, element) {

				// Unstyled checkboxes, radios
				if (element.parents().hasClass('form-check')) {
					error.appendTo( element.parents('.form-check').parent() );
				}

				// Input with icons and Select2
				else if (element.parents().hasClass('form-group row-feedback') || element.hasClass('select2-hidden-accessible')) {
					error.appendTo( element.parent() );
				}

				// Input group, styled file input
				else if (element.parent().is('.uniform-uploader, .uniform-select') || element.parents().hasClass('input-group')) {
					error.appendTo( element.parent().parent() );
				}

				// Other elements
				else {
					error.insertAfter(element);
				}
			},
			rules: {
				title: {
					required: true,
				},
				forum_date: {
					required: true,
				},
				sort_order: {
					required: true,
					digits : true,
				},
				description: {
					required: true,
				}
			},
			messages: {
				forum_title: {
					required: '<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("Forum.forum_title"); ?>',
				},
				forum_date: {
					required: '<?= lang("CommonMessage.common_please_select"); ?> <?= lang("Forum.forum_date"); ?>',
				},
				sort_order: {
					required: '<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("Forum.sort_order"); ?>',
				},
				description: {
					required: '<?= lang("CommonMessage.common_please_enter"); ?> <?= lang("Forum.description"); ?>',
				}
			},
			submitHandler: function (e) {
				$(e).ajaxSubmit({
					url: '<?php echo admin_url("Forum/save");?>',
					type: 'post',
					beforeSubmit: function (formData, jqForm, options) {
						dtButtonHide('#submitBtn');
						dtButtonHide('#cancelBtn');
					},
					complete: function () {

					},
					dataType: 'json',
					clearForm: false,
					success: function (resObj, statusText) {
						if (resObj.success) {
							toastr.success(resObj.msg, 'Success', {
								closeButton: true,
								progressBar: true,
								positionClass: 'toast-top-right',
								timeOut: 1000,
								onHidden: function () {
                                    dtButtonShow('#submitBtn');
									dtButtonShow('#cancelBtn');
                                    window.location.href = '<?php echo admin_url('Forum');?>';
                                }
							});

							// setTimeout(function () {
							// 	window.location.href = '<?php echo admin_url('Forum');?>';
							// }, 1000);

						} else {
							dtButtonShow('#submitBtn');
							dtButtonShow('#cancelBtn');
							toastr.error(resObj.msg, 'Error', {
								closeButton: true,
								// progressBar: true,
								positionClass: 'toast-top-right',
								// timeOut: 1000
							});
						}
					}
				});
			}
		});
	});

	$(document).on('click', '.delete-image', function () {
        var deleteId = $(this).attr("id");
		var forumId = $("#forum_id").val();
        Swal.fire({
			title: "<?= ucwords(lang('CommonMessage.common_delete')); ?>",
			text: "<?= lang('CommonMessage.delete_warning'); ?>",
			icon: 'warning',
			showCancelButton: true,
			confirmButtonText: 'OK',
			customClass: {
				confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
				cancelButton: 'btn btn-label-secondary waves-effect waves-light'
			},
			buttonsStyling: false
		}).then(function(result) {
			if (result.value) {

				$("span.document-image-"+deleteId).remove();

		        $.ajax({
		            type: "post",
		            url: "<?= admin_url("Forum/deleteForumImage")?>",
		            dataType: "json",
		            data: {document_image_id: deleteId,document_type_id:forumId,document_type:'forum'},
		            success: function (data) {
		                if (data['success']) {
		                    $(".delete-image").click(function() {
		                        $(this).parent().remove();
		                    }); 
			                Swal.fire({
								title: 'Success',
								text: data['msg'],
								icon: 'success',
								customClass: {
									confirmButton: 'btn btn-primary waves-effect waves-light'
								},
								buttonsStyling: false
							}).then(function() {
								dt_DataTable.ajax.reload();
							});
		                }
		                else{
		                    Swal.fire({
								title: 'Error!',
								text: data['msg'],
								icon: 'error',
								customClass: {
									confirmButton: 'btn btn-primary waves-effect waves-light'
								},
								buttonsStyling: false
							}).then(function() {
								dt_DataTable.ajax.reload();
							});
		                }
		            }
		        });
		    }
		});
    });
</script>