<ul class="nav nav-tabs" role="tablist">
	<li class="nav-item">
		<button type="button" class="nav-link active" role="tab" data-bs-toggle="tab" data-bs-target="#flat_detail" aria-controls="flat_detail" aria-selected="true">
			<?= lang('Flat.flat_detail'); ?>
		</button>
	</li>
	
</ul>

<div class="tab-content">
	<div class="tab-pane fade show active" id="flat_detail" role="tabpanel">
		<div class="table-responsive text-nowrap">
			<table id="flat_detail_table" class="table table-xs">
				<thead>
					<tr>
						<th><?= lang("CommonMessage.common_detail"); ?></th>
						<th><?= lang("CommonMessage.common_value"); ?></th>
					</tr>
				</thead>
				<tbody>
					<tr>
						<td><?= lang("Flat.tower"); ?></td>
						<td><?php
							echo (isset($flat_data['tower_name']) && $flat_data['tower_name'] != "") ? $flat_data['tower_name'] : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang("Flat.flat_no"); ?></td>
						<td><?php
							echo (isset($flat_data['tower_flat_name']) && $flat_data['tower_flat_name'] != "") ? $flat_data['tower_flat_name'] : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang("Flat.bhk"); ?></td>
						<td><?php
							echo (isset($flat_data['bhk']) && $flat_data['bhk'] != "") ? roundNumber($flat_data['bhk']) : '-';
							?></td>
					</tr>
					<tr>
						<td><?= lang("Flat.sqr_ft"); ?></td>
						<td><?php
							echo (isset($flat_data['sqr_ft']) && $flat_data['sqr_ft'] != "") ? roundNumber($flat_data['sqr_ft']) : '-';
							?>
						</td>
					</tr>	
					<tr>
						<td><?= lang("Flat.carpet_area"); ?></td>
						<td><?php
							echo (isset($flat_data['carpet_area']) && $flat_data['carpet_area'] != "") ? roundNumber($flat_data['carpet_area']) : '-';
							?>
						</td>
					</tr>
					<tr>
						<td><?= lang("Flat.floor"); ?></td>
						<td><?php
							echo isset($flat_data['floor']) ? ($flat_data['floor']) : '-';
							?>
						</td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_created_at"); ?></td>
						<td><?php
							echo (isset($flat_data['created_at']) && isValidDate($flat_data['created_at'])) ? siteDateFormat($flat_data['created_at'], TRUE) : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_created_by"); ?></td>
						<td><?php
							echo (isset($flat_data['created_by']) && $flat_data['created_by'] != "") ? $flat_data['created_by'] : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_updated_at"); ?></td>
						<td><?php
							echo (isset($flat_data['updated_at']) && isValidDate($flat_data['updated_at'])) ? siteDateFormat($flat_data['updated_at'], TRUE) : '-';
							?></td>
					</tr>
					<tr>
						<td class="text-bold"><?= lang("CommonMessage.common_updated_by"); ?></td>
						<td><?php
							echo (isset($flat_data['updated_by']) && $flat_data['updated_by'] != "") ? $flat_data['updated_by'] : '-';
							?></td>
					</tr>
				</tbody>
			</table>
		</div>
	</div>
	
</div>