<?php
$dtCIAcl = new \App\Libraries\Dt_ci_acl();
?>
<?= isset($advance_filter) ? $advance_filter : ""; ?>
<a style="display: none;" href="" class="dt-export-anchor" target="_blank"></a>
<div class="card">
	<div class="card-datatable table-responsive  text-nowrap">
		<table id="event-booking-table" class="table dt-datatable">
			<thead class="border-top">
			<tr>
				<th><input class="form-check-input datatable-select-all-second" type="checkbox" /></th>
				<th class="font-weight-bold"><?= lang("EventBooking.event_name"); ?></th>
				<th class="font-weight-bold"><?= lang("EventBooking.event_type"); ?></th>
				<th class="font-weight-bold"><?= lang("EventBooking.start_date"); ?></th>
				<th class="font-weight-bold"><?= lang("EventBooking.end_date"); ?></th>
				<th class="font-weight-bold"><?= lang("EventBooking.total_adult"); ?></th>
				<th class="font-weight-bold"><?= lang("EventBooking.total_child"); ?></th>
				<th class="font-weight-bold"><?= lang("EventBooking.total_guest"); ?></th>
				<th class="font-weight-bold"><?= lang("EventBooking.total_payment"); ?></th>
				<th class="font-weight-bold"><?= lang("EventBooking.booked_by"); ?></th>
				<th class="font-weight-bold"><?= lang("EventBooking.is_cancel"); ?></th>
				<th class="font-weight-bold"><?= lang('CommonMessage.common_updated_by'); ?></th>
				<th class="font-weight-bold"><?= lang('CommonMessage.common_updated_at'); ?></th>
				<th class="font-weight-bold"><?= lang("CommonMessage.common_action"); ?></th>
			</tr>
			</thead>
		</table>
	</div>
</div>
<script type="text/javascript">
	var dt_DataTable;
	$(document).ready(function () {
		dt_DataTable = $('#event-booking-table').DataTable( {
			dom:'<"card-header d-flex border-top rounded-0 flex-wrap py-0"' +
				'<"me-5 ms-n2 pe-5"f>' +
				'<"d-flex justify-content-start justify-content-md-end align-items-baseline"<"dt-action-buttons d-flex flex-column align-items-start align-items-md-center justify-content-sm-center mb-3 mb-md-0 pt-0 gap-4 gap-sm-0 flex-sm-row"lB>>' +
				'>t' +
				'<"row mx-2"' +
				'<"col-sm-12 col-md-6"i>' +
				'<"col-sm-12 col-md-6"p>' +
				'>',
			processing: true,
			serverSide: true,
			displayLength: 10,
			// language: {
			// 	sLengthMenu: 'Show _MENU_',
			// 	search: '',
			// 	searchPlaceholder: 'Search <?= lang('event');?>',
			// 	info: 'Displaying _START_ to _END_ of _TOTAL_ entries'
			// },
			language: {
                sLengthMenu: 'Show _MENU_',
                search: '',
                searchPlaceholder: 'Search Event Booking',
                info: 'Displaying _START_ to _END_ of _TOTAL_ entries'
            },
			scrollX: true,
			buttons: [
			// {
			// 		extend: 'collection',
			// 		className: 'btn btn-label-secondary px-2 dropdown-toggle me-2 waves-effect waves-light',
			// 		text: '<i class="ti ti-download me-1 ti-xs"></i>Export',
			// 		buttons: [
			// 			// {
			// 			// 	text: '<i class="ti ti-file me-2" ></i>Excel',
			// 			// 	className: 'dropdown-item dt-excel-export'
			// 			// },
			// 			// {
			// 			// 	extend: 'pdf',
			// 			// 	text: '<i class="ti ti-file-text me-2"></i>Pdf',
			// 			// 	className: 'dropdown-item',
			// 			//
			// 			// }
			// 		]
			// 	},
				<?php
				if ($dtCIAcl->checkAccess("EventBooking|cancelBooking")) { ?>
				{
					text: '<span class="d-none d-sm-inline-block"><?= lang('EventBooking.cancel_booking');?></span>',
					className: 'add-new btn btn-success px-1 me-2 dt-cancel-event-booking',
	
				},
				<?php } ?>
				<?php if ($dtCIAcl->checkAccess("EventBooking|manage")) { ?>
				{
					text: '<i class="ti ti-plus me-0 me-sm-1 ti-xs"></i><span class="d-none d-sm-inline-block"><?= lang('EventBooking.add_event_booking');?></span>',
					className: 'add-new btn btn-primary px-1 me-2',
					action: function () {
						window.location.href = '<?= admin_url("EventBooking/manage");?>';
					}
				},
				<?php } ?>
				<?php /* if ($dtCIAcl->checkAccess("EventBooking|delete")) { ?>
				{
					text: '<i class="ti ti-trash me-0 me-sm-1 ti-xs"></i><span class="d-none d-sm-inline-block"><?= lang('EventBooking.delete_event');?></span>',
					className: 'btn btn-danger  px-1 dt-delete-record',
				},
				<?php } */?>
			],
			"ajax": {
				"url": "<?php echo admin_url('EventBooking/getEventBookingListing'); ?>",
				"type": "POST",
				"data": function(d) {
                    // var params = {};
                    // params["<?= csrf_token(); ?>"] = "<?= csrf_hash() ?>";
                    // var filterData = $("#advanceFilter").serializeArray();
                    // $.each(filterData, function(i, val) {
                    //     var name = val.name;
                    //     if (typeof params[name] == 'undefined') {
                    //         params[name] = val.value;
                    //     } else if ($.isArray(params[name])) {
                    //         params[name].push(val.value);
                    //     } else {
                    //         params[name] = [params[name]];
                    //         params[name].push(val.value);
                    //     }
                    // });

                    // return $.extend({}, d, params);
                }
			},
			"order": [[ 0, "desc" ]],
			"columns": [
				{
					"data": "event_booking_id",
					"render": function (data, type, row) {
						return '<input class="form-check-input datatable-checkbox" type="checkbox" id="ids_' + row['event_booking_id'] + '" name="ids[]" value="' + row['event_booking_id'] + '"/>';
					},
					"class": "no_click_allowed",
					"sortable": false,
					"searchable": false
				},
				{"data": "event_name" },
				{"data": "event_type" },
				{"data": "start_date" },
				{"data": "end_date" },
				{"data": "total_adult" },
				{"data": "total_child" },
				{"data": "total_guest" },
				{"data": "total_payment" },
				{"data": "name" },
				{"data": "is_cancel" },
				{"data": "updated_by"},
				{"data": "updated_at"},
				{
					"data": "action_button",
					"class" : "text-center no_click_allowed",
					"sortable": false,
					"searchable": false
				},
			],
			// createdRow: function (row, data, dataIndex) {
			// 	$(row).find("td:not(.no_click_allowed,.own_detail_model_view)").addClass('dt-detail-model-view');
			// 	$(row).find("td:not(.no_click_allowed,.own_detail_model_view)").attr('data-dt_view_id', data['event_id']);
			// 	$(row).find("td:not(.no_click_allowed,.own_detail_model_view)").attr('data-dt_view_url', '<?= admin_url("EventBooking/view"); ?>');
			// },
			"fnDrawCallback": function (oSettings, json) {
				customToolTip();
				$('.dataTables_length').addClass('mt-2 mt-sm-0 mt-md-3 me-2');
				$('.dt-buttons').addClass('d-flex flex-wrap');
				$('.dataTables_filter .form-control').removeClass('form-control-sm');
				$('.dataTables_length .form-select').removeClass('form-select-sm');
				//checkBoxRefresh("datatable-checkbox");
				switcheryKeyGen("datatable-list-switchery");

			}
		});
		dtDataTableSearch();
	});

	//Event Booking status change
	$(document).on('click', '.dt-cancel-event-booking', function () {
		var eventBookingId =$('#event-booking-table tbody .datatable-checkbox:checked');
		var selectedLength = eventBookingId.length;
		if (selectedLength == 0) {
			Swal.fire({
				title: "<?= ucwords(lang('CommonMessage.common_sweet_alert_info')); ?>",
				text: "Kindly select record to cancel Booking",
				icon: 'info',
				showCancelButton: true,
				confirmButtonText: 'OK',
				customClass: {
					confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
					cancelButton: 'btn btn-label-secondary waves-effect waves-light'
				},
				buttonsStyling: false
			}).then(function () {
				return false;
			});
		} else {
			var eventBookingIdArray = [];
			$.each(eventBookingId, function (i, ele) {
				eventBookingIdArray.push($(ele).val());
			});
			Swal.fire({
				title: "Assign",
				text: "Are you sure you want to cancel Booking",
				icon: "<?= lang('warning'); ?>",
				showCancelButton: true,
				
				confirmButtonColor: 'OK',
				customClass: {
					confirmButton: 'btn btn-primary me-3 waves-effect waves-light',
					cancelButton: 'btn btn-label-secondary waves-effect waves-light'
				},
				buttonsStyling: false
			}).then(function (result) {
				if (result.value) {
					dtFormClear('form_cancel_event_booking_modal');
					$("#modal_event_booking_id").val(eventBookingIdArray);
					$('#cancel_event_booking_modal').modal('show');
				}
			});
		}
	});

</script>
<?= isset($cancel_event_booking_modal) ? $cancel_event_booking_modal : ""; ?>
<?= isset($select2_ajax) ? $select2_ajax : ""; ?>