<?php
// printArray($event_data['rate_type'],1);

?>
<ul class="nav nav-tabs" role="tablist">
    <li class="nav-item">
        <button type="button" class="nav-link active" role="tab" data-bs-toggle="tab" data-bs-target="#event_detail" aria-controls="event_detail" aria-selected="true">
            <?= lang('Event.event_details'); ?>
        </button>
    </li>
    <?php if(($event_data['is_booking_required']) && ($event_data['is_booking_required'] == 1)){
                    ?>  
    <li class="nav-item">
        <button type="button" class="nav-link" role="tab" data-bs-toggle="tab" data-bs-target="#event_rate_detail" aria-controls="event_rate_detail" aria-selected="false">
            <?= lang('Event.event_rate'); ?>
        </button>
    </li>
    <?php } ?>
</ul>

<div class="tab-content">
    <div class="tab-pane fade show active" id="event_detail" role="tabpanel">
        <div class="table-responsive text-nowrap">
            <table id="event_detail_table" class="table table-xs">
                <thead>
                    <tr>
                        <th><?= lang("CommonMessage.common_detail"); ?></th>
                        <th><?= lang("CommonMessage.common_value"); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td><?= lang("Event.event_name"); ?></td>
                        <td><?php

                            echo (isset($event_data['event_name']) && $event_data['event_name'] != "") ? ($event_data['event_name']) : '-';

                            ?>
                        </td>
                    </tr>
                    <tr>
                    
                        <td><?= lang("Event.category"); ?></td>
                        <td><?php
							    if(isset($event_category_data) && !empty($event_category_data)) {
							    echo implode(' , ', array_column($event_category_data, 'category_name'));
						    }?>
                        </td>
                    </tr>
                    <tr>
                        <td><?= lang("Event.start_date"); ?></td>
                        <td><?php
                            echo (isset($event_data['start_date']) && isValidDate($event_data['start_date'])) ? siteDateFormat($event_data['start_date'], true) : '';
                            ?>
                        </td>
                    </tr>
                    <tr>
                        <td><?= lang("Event.end_date"); ?></td>
                        <td><?php
                            echo (isset($event_data['end_date']) && isValidDate($event_data['end_date'])) ? siteDateFormat($event_data['end_date'], true) : '';
                            ?>
                        </td>
                    </tr>
                    <tr>
                        <td><?= lang("Event.description"); ?></td>
                        <td><?php
                            echo (isset($event_data['description']) && ($event_data['description'] != '')) ? $event_data['description'] : '-';
                            ?>
                        </td>
                    </tr>
                    <tr>
                        <td><?= lang("Event.event_venue"); ?></td>
                        <td><?php
                            echo (isset($event_data['common_area_name']) && ($event_data['common_area_name'] != '')) ? $event_data['common_area_name'] : '-';
                            ?>
                        </td>
                    </tr>
                    <tr>
                        <td><?= lang("Event.terms_and_condition"); ?></td>
                        <td><?php
                            echo (isset($event_data['terms_and_condition']) && ($event_data['terms_and_condition'] != '')) ? $event_data['terms_and_condition'] : '-';
                            ?>
                        </td>
                    </tr>
                    <tr>
                    <tr>
                        <td><?= lang("Event.form_submit"); ?></td>
                        <?php
                        $formSubmit = isset($event_data['form_submit']) ? $event_data['form_submit'] : '';

                            $color = '';
                            if(strtolower($formSubmit) == 'saved'){
                                $color = 'danger';
                            }
                            else if(strtolower($formSubmit) == 'approved'){
                                $color = 'success';
                            }
                        ?>


                        <td>
                            <span class="badge bg-label-<?= $color; ?>"> <?= underscoreToUcWord($formSubmit);?></span>
                        </td>
                    </tr>
                    <tr>
                        <td class="text-bold"><?= lang("Event.event_thumbnail_image"); ?></td>
                        <td>
                            <?php
                            $thumbailImage = site_url('uploads/no_image.png');
                            if (isset($event_data['event_thumbnail_image']) && $event_data['event_thumbnail_image'] != '') { ?>
                                <?php
                                if (file_exists(THUMBNAIL_EVENT_IMAGE_PATH . $event_data['event_thumbnail_image'])) {
                                    $thumbailImage = site_url() . THUMBNAIL_EVENT_IMAGE_PATH . $event_data['event_thumbnail_image'];
                                } ?>
                            <?php } ?>
                            <a href="<?= $thumbailImage; ?>" target="_blank"><img src="<?= $thumbailImage; ?>" width="100" class="img-fluid" alt=""></a>
                        </td>
                    </tr>
                    <tr>
                        <td class="text-bold"><?= lang("Event.event_image"); ?></td>
                        <td><?php
                            if (isset($image_data) && is_array($image_data) && !empty($image_data)) {
                                foreach ($image_data as $image) {
                                    if (file_exists(EVENT_IMAGE_PATH . $image['event_image'])) {
                                        $paths = site_url() . EVENT_IMAGE_PATH . $image['event_image']; ?> &nbsp;&nbsp;&nbsp;

                                        <a href="<?= $paths; ?>" target="_blank">
                                            <img src="<?= $paths; ?>" width="100" class="img-fluid" alt="">
                                        </a>
                            <?php
                                    }
                                }
                            }
                            ?>
                        </td>
                    </tr>
                    <?php if(($event_data['is_booking_required']) && ($event_data['is_booking_required'] == 1)){
                    ?>         
                    <tr>
                        <td class="text-bold"><?= lang("Event.is_booking_required"); ?></td>
                        <td><?php
                            echo isset($event_data['is_booking_required']) && $event_data['is_booking_required'] == 1 ? 'Yes' : 'No';
                            ?></td>
                    </tr>

                    <tr>
                        <td class="text-bold"><?= lang("Event.is_guest_allowed"); ?></td>
                        <td>
                            <?php
                            echo isset($event_data['is_guest_allowed']) && $event_data['is_guest_allowed'] == 1 ? 'Yes' : 'No';
                            ?>
                        </td>
                    </tr>

                    <tr>
                        <td class="text-bold"><?= lang("Event.is_cash_payment_allowed"); ?></td>
                        <td>
                            <?php
                            echo isset($event_data['is_cash_payment_allowed']) && $event_data['is_cash_payment_allowed'] == 1 ? 'Yes' : 'No';
                            ?>
                        </td>
                    </tr>

                    <tr>
                        <td class="text-bold"><?= lang("Event.is_cancellation_allowed"); ?></td>
                        <td>
                            <?php
                            echo isset($event_data['is_cancellation_allowed']) && $event_data['is_cancellation_allowed'] == 1 ? 'Yes' : 'No';
                            ?>
                        </td>
                    </tr>
                    <?php if(($event_data['is_cancellation_allowed']) && ($event_data['is_cancellation_allowed'] == 1)){
                    ?>
                    <tr>
                        <td class="text-bold"><?= lang("Event.before_minutes"); ?></td>
                        <td><?php
                            echo (isset($event_data['before_minutes']) && ($event_data['before_minutes'] != '')) ? $event_data['before_minutes'] : '-';
                            ?></td>
                    </tr>
                    <?php } ?>
                    <tr>
                        <td class="text-bold"><?= lang("Event.rate_type"); ?></td>

                        <td><?php
                            $eventTypes = eventType();
                            $selectedEventTypes = isset($event_data['rate_type']) ? $event_data['rate_type'] : "";
                            foreach ($eventTypes as $eventKey => $event) {
                                echo ($selectedEventTypes == $eventKey) ? $event : '';
                            }
                            ?></td>
                    </tr>

                    <tr>
                        <td class="text-bold"><?= lang("Event.booking_type"); ?></td>
                        <td><?php
                            $eventTypes = eventType();
                            $selectedEventTypes = isset($event_data['booking_type']) ? $event_data['booking_type'] : "";
                            foreach ($eventTypes as $eventKey => $event) {
                                echo ($selectedEventTypes == $eventKey) ? $event : '';
                            }
                            ?></td>
                    </tr>

                    <tr>
                        <td class="text-bold"><?= lang("Event.max_guest_allowed"); ?></td>
                        <td>
                            <?php
                            echo (isset($event_data['max_guest_allowed']) && ($event_data['max_guest_allowed'] != '')) ? $event_data['max_guest_allowed'] : '-';
                            ?>
                        </td>
                    </tr>
                    <tr>
                        <td class="text-bold"><?= lang("CommonMessage.common_created_at"); ?></td>
                        <td><?php
                            echo (isset($event_data['created_at']) && isValidDate($event_data['created_at'])) ? siteDateFormat($event_data['created_at'], TRUE) : '-';
                            ?></td>
                    </tr>
                    <tr>
                        <td class="text-bold"><?= lang("CommonMessage.common_created_by"); ?></td>
                        <td><?php
                            echo (isset($event_data['created_by']) && $event_data['created_by'] != "") ? $event_data['created_by'] : '-';
                            ?></td>
                    </tr>
                    <tr>
                        <td class="text-bold"><?= lang("CommonMessage.common_updated_at"); ?></td>
                        <td><?php
                            echo (isset($event_data['updated_at']) && isValidDate($event_data['updated_at'])) ? siteDateFormat($event_data['updated_at'], TRUE) : '-';
                            ?></td>
                    </tr>
                    <tr>
                        <td class="text-bold"><?= lang("CommonMessage.common_updated_by"); ?></td>
                        <td><?php
                            echo (isset($event_data['updated_by']) && $event_data['updated_by'] != "") ? $event_data['updated_by'] : '-';
                            ?></td>
                    </tr>
                <?php } ?>
                    <tr>
                        <td class="text-bold"><?= lang("Event.is_active"); ?></td>
                        <td><?php
                            echo (isset($event_data['is_active']) && $event_data['is_active']  == 1) ? 'Yes' : 'No';
                            ?></td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
    <?php if(($event_data['is_booking_required']) && ($event_data['is_booking_required'] == 1)){
    ?>
    <div class="tab-pane fade" id="event_rate_detail" role="tabpanel">
        <div class="table-responsive text-nowrap">
            <table id="event_rate_detail" class="table table-bordered">
                <thead>
                    <tr>
                        <th class="text-center" style="width: 5%"><?= lang("CommonMessage.common_sr_no"); ?></th>
                        <th style="width: 10%"><?= lang("Event.date"); ?></th>
                        <th style="width: 10%"><?= lang("Event.adult_rate"); ?></th>
                        <th style="width: 10%"><?= lang("Event.child_rate"); ?></th>
                        <th style="width: 10%"><?= lang("Event.guest_rate"); ?></th>
                    </tr>
                </thead>
                <tbody class="">
                    <?php if ($event_rate_data != '' && array_filter($event_rate_data)) {
                        $sr = 1;
                        foreach ($event_rate_data as $key => $value) { ?>
                            <tr>
                                <td class="text-center"><?= $sr; ?></td>
                                <td colspan="1"><?php
                                                   echo (isset($event_data['rate_type']) && $event_data['rate_type'] != 'date_wise') ?  'Full Event' : siteDateFormat($value['date'], false);
                                                ?> 
                                </td>
                                <td colspan="1"><?= $value['adult_rate']; ?> </td>
                                <td colspan="1"><?= $value['child_rate']; ?> </td>
                                <td colspan="1"><?= $value['guest_rate']; ?> </td>
                            </tr>
                        <?php $sr++;
                        }
                    } else {   ?>
                        <tr>
                            <td colspan="5" align="center"> <?= lang('CommonMessage.no_data_found'); ?></td>
                        </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
    </div>
 <?php } ?>

</div>